# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

import pprint
import re  # noqa: F401

import six


class DeviceCredentials(object):
    """NOTE: This class is auto generated by the swagger code generator program.    
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created_time': 'int',
        'credentials_id': 'str',
        'credentials_type': 'str',
        'credentials_value': 'str',
        'device_id': 'DeviceId',
        'id': 'DeviceCredentialsId'
    }

    attribute_map = {
        'created_time': 'createdTime',
        'credentials_id': 'credentialsId',
        'credentials_type': 'credentialsType',
        'credentials_value': 'credentialsValue',
        'device_id': 'deviceId',
        'id': 'id'
    }

    def __init__(self, created_time=None, credentials_id=None, credentials_type=None, credentials_value=None, device_id=None, id=None):  # noqa: E501
        """DeviceCredentials - a model defined in Swagger"""  # noqa: E501

        self._created_time = None
        self._credentials_id = None
        self._credentials_type = None
        self._credentials_value = None
        self._device_id = None
        self._id = None
        self.discriminator = None

        if created_time is not None:
            self.created_time = created_time
        if credentials_id is not None:
            self.credentials_id = credentials_id
        if credentials_type is not None:
            self.credentials_type = credentials_type
        if credentials_value is not None:
            self.credentials_value = credentials_value
        if device_id is not None:
            self.device_id = device_id
        if id is not None:
            self.id = id

    @property
    def created_time(self):
        """Gets the created_time of this DeviceCredentials.  # noqa: E501


        :return: The created_time of this DeviceCredentials.  # noqa: E501
        :rtype: int
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """Sets the created_time of this DeviceCredentials.


        :param created_time: The created_time of this DeviceCredentials.  # noqa: E501
        :type: int
        """

        self._created_time = created_time

    @property
    def credentials_id(self):
        """Gets the credentials_id of this DeviceCredentials.  # noqa: E501


        :return: The credentials_id of this DeviceCredentials.  # noqa: E501
        :rtype: str
        """
        return self._credentials_id

    @credentials_id.setter
    def credentials_id(self, credentials_id):
        """Sets the credentials_id of this DeviceCredentials.


        :param credentials_id: The credentials_id of this DeviceCredentials.  # noqa: E501
        :type: str
        """

        self._credentials_id = credentials_id

    @property
    def credentials_type(self):
        """Gets the credentials_type of this DeviceCredentials.  # noqa: E501


        :return: The credentials_type of this DeviceCredentials.  # noqa: E501
        :rtype: str
        """
        return self._credentials_type

    @credentials_type.setter
    def credentials_type(self, credentials_type):
        """Sets the credentials_type of this DeviceCredentials.


        :param credentials_type: The credentials_type of this DeviceCredentials.  # noqa: E501
        :type: str
        """
        allowed_values = ["ACCESS_TOKEN", "X509_CERTIFICATE"]  # noqa: E501
        if credentials_type not in allowed_values:
            raise ValueError(
                "Invalid value for `credentials_type` ({0}), must be one of {1}"  # noqa: E501
                .format(credentials_type, allowed_values)
            )

        self._credentials_type = credentials_type

    @property
    def credentials_value(self):
        """Gets the credentials_value of this DeviceCredentials.  # noqa: E501


        :return: The credentials_value of this DeviceCredentials.  # noqa: E501
        :rtype: str
        """
        return self._credentials_value

    @credentials_value.setter
    def credentials_value(self, credentials_value):
        """Sets the credentials_value of this DeviceCredentials.


        :param credentials_value: The credentials_value of this DeviceCredentials.  # noqa: E501
        :type: str
        """

        self._credentials_value = credentials_value

    @property
    def device_id(self):
        """Gets the device_id of this DeviceCredentials.  # noqa: E501


        :return: The device_id of this DeviceCredentials.  # noqa: E501
        :rtype: DeviceId
        """
        return self._device_id

    @device_id.setter
    def device_id(self, device_id):
        """Sets the device_id of this DeviceCredentials.


        :param device_id: The device_id of this DeviceCredentials.  # noqa: E501
        :type: DeviceId
        """

        self._device_id = device_id

    @property
    def id(self):
        """Gets the id of this DeviceCredentials.  # noqa: E501


        :return: The id of this DeviceCredentials.  # noqa: E501
        :rtype: DeviceCredentialsId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DeviceCredentials.


        :param id: The id of this DeviceCredentials.  # noqa: E501
        :type: DeviceCredentialsId
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DeviceCredentials, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeviceCredentials):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
