# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client.api_client import ApiClient


class GroupPermissionControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_group_permission_using_delete(self, group_permission_id, **kwargs):  # noqa: E501
        """deleteGroupPermission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.delete_group_permission_using_delete(group_permission_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_permission_id: groupPermissionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_group_permission_using_delete_with_http_info(group_permission_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_group_permission_using_delete_with_http_info(group_permission_id, **kwargs)  # noqa: E501
            return data

    def delete_group_permission_using_delete_with_http_info(self, group_permission_id, **kwargs):  # noqa: E501
        """deleteGroupPermission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.delete_group_permission_using_delete_with_http_info(group_permission_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_permission_id: groupPermissionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_permission_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_permission_id' is set
        if ('group_permission_id' not in params or
                params['group_permission_id'] is None):
            raise ValueError("Missing the required parameter `group_permission_id` when calling `delete_group_permission_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_permission_id' in params:
            path_params['groupPermissionId'] = params['group_permission_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/groupPermission/{groupPermissionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entity_group_permissions_using_get(self, entity_group_id, **kwargs):  # noqa: E501
        """getEntityGroupPermissions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_group_permissions_using_get(entity_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :return: list[GroupPermissionInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entity_group_permissions_using_get_with_http_info(entity_group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entity_group_permissions_using_get_with_http_info(entity_group_id, **kwargs)  # noqa: E501
            return data

    def get_entity_group_permissions_using_get_with_http_info(self, entity_group_id, **kwargs):  # noqa: E501
        """getEntityGroupPermissions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_group_permissions_using_get_with_http_info(entity_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :return: list[GroupPermissionInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group_id' is set
        if ('entity_group_id' not in params or
                params['entity_group_id'] is None):
            raise ValueError("Missing the required parameter `entity_group_id` when calling `get_entity_group_permissions_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_group_id' in params:
            path_params['entityGroupId'] = params['entity_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/{entityGroupId}/groupPermissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupPermissionInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_group_permission_by_id_using_get(self, group_permission_id, **kwargs):  # noqa: E501
        """getGroupPermissionById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_group_permission_by_id_using_get(group_permission_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_permission_id: groupPermissionId (required)
        :return: GroupPermission
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_group_permission_by_id_using_get_with_http_info(group_permission_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_group_permission_by_id_using_get_with_http_info(group_permission_id, **kwargs)  # noqa: E501
            return data

    def get_group_permission_by_id_using_get_with_http_info(self, group_permission_id, **kwargs):  # noqa: E501
        """getGroupPermissionById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_group_permission_by_id_using_get_with_http_info(group_permission_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_permission_id: groupPermissionId (required)
        :return: GroupPermission
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_permission_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_permission_id' is set
        if ('group_permission_id' not in params or
                params['group_permission_id'] is None):
            raise ValueError("Missing the required parameter `group_permission_id` when calling `get_group_permission_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_permission_id' in params:
            path_params['groupPermissionId'] = params['group_permission_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/groupPermission/{groupPermissionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupPermission',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_group_permission_info_by_id_using_get(self, group_permission_id, is_user_group, **kwargs):  # noqa: E501
        """getGroupPermissionInfoById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_group_permission_info_by_id_using_get(group_permission_id, is_user_group, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_permission_id: groupPermissionId (required)
        :param bool is_user_group: isUserGroup (required)
        :return: GroupPermissionInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_group_permission_info_by_id_using_get_with_http_info(group_permission_id, is_user_group, **kwargs)  # noqa: E501
        else:
            (data) = self.get_group_permission_info_by_id_using_get_with_http_info(group_permission_id, is_user_group, **kwargs)  # noqa: E501
            return data

    def get_group_permission_info_by_id_using_get_with_http_info(self, group_permission_id, is_user_group, **kwargs):  # noqa: E501
        """getGroupPermissionInfoById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_group_permission_info_by_id_using_get_with_http_info(group_permission_id, is_user_group, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_permission_id: groupPermissionId (required)
        :param bool is_user_group: isUserGroup (required)
        :return: GroupPermissionInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_permission_id', 'is_user_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_permission_id' is set
        if ('group_permission_id' not in params or
                params['group_permission_id'] is None):
            raise ValueError("Missing the required parameter `group_permission_id` when calling `get_group_permission_info_by_id_using_get`")  # noqa: E501
        # verify the required parameter 'is_user_group' is set
        if ('is_user_group' not in params or
                params['is_user_group'] is None):
            raise ValueError("Missing the required parameter `is_user_group` when calling `get_group_permission_info_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_permission_id' in params:
            path_params['groupPermissionId'] = params['group_permission_id']  # noqa: E501

        query_params = []
        if 'is_user_group' in params:
            query_params.append(('isUserGroup', params['is_user_group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/groupPermission/info/{groupPermissionId}{?isUserGroup}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupPermissionInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_group_permissions_using_get(self, user_group_id, **kwargs):  # noqa: E501
        """getUserGroupPermissions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_user_group_permissions_using_get(user_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_group_id: userGroupId (required)
        :return: list[GroupPermissionInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_group_permissions_using_get_with_http_info(user_group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_group_permissions_using_get_with_http_info(user_group_id, **kwargs)  # noqa: E501
            return data

    def get_user_group_permissions_using_get_with_http_info(self, user_group_id, **kwargs):  # noqa: E501
        """getUserGroupPermissions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_user_group_permissions_using_get_with_http_info(user_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_group_id: userGroupId (required)
        :return: list[GroupPermissionInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_group_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_group_id' is set
        if ('user_group_id' not in params or
                params['user_group_id'] is None):
            raise ValueError("Missing the required parameter `user_group_id` when calling `get_user_group_permissions_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_group_id' in params:
            path_params['userGroupId'] = params['user_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/userGroup/{userGroupId}/groupPermissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupPermissionInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def load_user_group_permission_infos_using_post(self, permissions, **kwargs):  # noqa: E501
        """loadUserGroupPermissionInfos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.load_user_group_permission_infos_using_post(permissions, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[GroupPermission] permissions: permissions (required)
        :return: list[GroupPermissionInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.load_user_group_permission_infos_using_post_with_http_info(permissions, **kwargs)  # noqa: E501
        else:
            (data) = self.load_user_group_permission_infos_using_post_with_http_info(permissions, **kwargs)  # noqa: E501
            return data

    def load_user_group_permission_infos_using_post_with_http_info(self, permissions, **kwargs):  # noqa: E501
        """loadUserGroupPermissionInfos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.load_user_group_permission_infos_using_post_with_http_info(permissions, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[GroupPermission] permissions: permissions (required)
        :return: list[GroupPermissionInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['permissions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'permissions' is set
        if ('permissions' not in params or
                params['permissions'] is None):
            raise ValueError("Missing the required parameter `permissions` when calling `load_user_group_permission_infos_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'permissions' in params:
            body_params = params['permissions']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/userGroup/groupPermissions/info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupPermissionInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_group_permission_using_post(self, group_permission, **kwargs):  # noqa: E501
        """saveGroupPermission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.save_group_permission_using_post(group_permission, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupPermission group_permission: groupPermission (required)
        :return: GroupPermission
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_group_permission_using_post_with_http_info(group_permission, **kwargs)  # noqa: E501
        else:
            (data) = self.save_group_permission_using_post_with_http_info(group_permission, **kwargs)  # noqa: E501
            return data

    def save_group_permission_using_post_with_http_info(self, group_permission, **kwargs):  # noqa: E501
        """saveGroupPermission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.save_group_permission_using_post_with_http_info(group_permission, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupPermission group_permission: groupPermission (required)
        :return: GroupPermission
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_permission']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_permission' is set
        if ('group_permission' not in params or
                params['group_permission'] is None):
            raise ValueError("Missing the required parameter `group_permission` when calling `save_group_permission_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'group_permission' in params:
            body_params = params['group_permission']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/groupPermission', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupPermission',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
