# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client.api_client import ApiClient


class EntityGroupControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.    
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_entities_to_entity_group_using_post(self, entity_group_id, str_entity_ids, **kwargs):  # noqa: E501
        """addEntitiesToEntityGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.add_entities_to_entity_group_using_post(entity_group_id, str_entity_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :param list[str] str_entity_ids: strEntityIds (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_entities_to_entity_group_using_post_with_http_info(entity_group_id, str_entity_ids, **kwargs)  # noqa: E501
        else:
            (data) = self.add_entities_to_entity_group_using_post_with_http_info(entity_group_id, str_entity_ids, **kwargs)  # noqa: E501
            return data

    def add_entities_to_entity_group_using_post_with_http_info(self, entity_group_id, str_entity_ids, **kwargs):  # noqa: E501
        """addEntitiesToEntityGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.add_entities_to_entity_group_using_post_with_http_info(entity_group_id, str_entity_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :param list[str] str_entity_ids: strEntityIds (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group_id', 'str_entity_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group_id' is set
        if ('entity_group_id' not in params or
                params['entity_group_id'] is None):
            raise ValueError("Missing the required parameter `entity_group_id` when calling `add_entities_to_entity_group_using_post`")  # noqa: E501
        # verify the required parameter 'str_entity_ids' is set
        if ('str_entity_ids' not in params or
                params['str_entity_ids'] is None):
            raise ValueError("Missing the required parameter `str_entity_ids` when calling `add_entities_to_entity_group_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_group_id' in params:
            path_params['entityGroupId'] = params['entity_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'str_entity_ids' in params:
            body_params = params['str_entity_ids']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/{entityGroupId}/addEntities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_entity_group_using_delete(self, entity_group_id, **kwargs):  # noqa: E501
        """deleteEntityGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.delete_entity_group_using_delete(entity_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_entity_group_using_delete_with_http_info(entity_group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_entity_group_using_delete_with_http_info(entity_group_id, **kwargs)  # noqa: E501
            return data

    def delete_entity_group_using_delete_with_http_info(self, entity_group_id, **kwargs):  # noqa: E501
        """deleteEntityGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.delete_entity_group_using_delete_with_http_info(entity_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group_id' is set
        if ('entity_group_id' not in params or
                params['entity_group_id'] is None):
            raise ValueError("Missing the required parameter `entity_group_id` when calling `delete_entity_group_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_group_id' in params:
            path_params['entityGroupId'] = params['entity_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/{entityGroupId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_enitity_group_by_owner_and_name_and_type_using_get(self, owner_type, owner_id, group_type, group_name, **kwargs):  # noqa: E501
        """getEnitityGroupByOwnerAndNameAndType  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_enitity_group_by_owner_and_name_and_type_using_get(owner_type, owner_id, group_type, group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner_type: ownerType (required)
        :param str owner_id: ownerId (required)
        :param str group_type: EntityGroup type (required)
        :param str group_name: groupName (required)
        :return: EntityGroupInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_enitity_group_by_owner_and_name_and_type_using_get_with_http_info(owner_type, owner_id, group_type, group_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_enitity_group_by_owner_and_name_and_type_using_get_with_http_info(owner_type, owner_id, group_type, group_name, **kwargs)  # noqa: E501
            return data

    def get_enitity_group_by_owner_and_name_and_type_using_get_with_http_info(self, owner_type, owner_id, group_type, group_name, **kwargs):  # noqa: E501
        """getEnitityGroupByOwnerAndNameAndType  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_enitity_group_by_owner_and_name_and_type_using_get_with_http_info(owner_type, owner_id, group_type, group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner_type: ownerType (required)
        :param str owner_id: ownerId (required)
        :param str group_type: EntityGroup type (required)
        :param str group_name: groupName (required)
        :return: EntityGroupInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner_type', 'owner_id', 'group_type', 'group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner_type' is set
        if ('owner_type' not in params or
                params['owner_type'] is None):
            raise ValueError("Missing the required parameter `owner_type` when calling `get_enitity_group_by_owner_and_name_and_type_using_get`")  # noqa: E501
        # verify the required parameter 'owner_id' is set
        if ('owner_id' not in params or
                params['owner_id'] is None):
            raise ValueError("Missing the required parameter `owner_id` when calling `get_enitity_group_by_owner_and_name_and_type_using_get`")  # noqa: E501
        # verify the required parameter 'group_type' is set
        if ('group_type' not in params or
                params['group_type'] is None):
            raise ValueError("Missing the required parameter `group_type` when calling `get_enitity_group_by_owner_and_name_and_type_using_get`")  # noqa: E501
        # verify the required parameter 'group_name' is set
        if ('group_name' not in params or
                params['group_name'] is None):
            raise ValueError("Missing the required parameter `group_name` when calling `get_enitity_group_by_owner_and_name_and_type_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner_type' in params:
            path_params['ownerType'] = params['owner_type']  # noqa: E501
        if 'owner_id' in params:
            path_params['ownerId'] = params['owner_id']  # noqa: E501
        if 'group_type' in params:
            path_params['groupType'] = params['group_type']  # noqa: E501
        if 'group_name' in params:
            path_params['groupName'] = params['group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/{ownerType}/{ownerId}/{groupType}/{groupName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityGroupInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entities_using_get(self, entity_group_id, page_size, page, **kwargs):  # noqa: E501
        """getEntities  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entities_using_get(entity_group_id, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :param str page_size: Page size (required)
        :param str page: Page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataShortEntityView
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entities_using_get_with_http_info(entity_group_id, page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entities_using_get_with_http_info(entity_group_id, page_size, page, **kwargs)  # noqa: E501
            return data

    def get_entities_using_get_with_http_info(self, entity_group_id, page_size, page, **kwargs):  # noqa: E501
        """getEntities  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entities_using_get_with_http_info(entity_group_id, page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :param str page_size: Page size (required)
        :param str page: Page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataShortEntityView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group_id', 'page_size', 'page', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group_id' is set
        if ('entity_group_id' not in params or
                params['entity_group_id'] is None):
            raise ValueError("Missing the required parameter `entity_group_id` when calling `get_entities_using_get`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_entities_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_entities_using_get`")  # noqa: E501

        if 'page_size' in params and params['page_size'] < 1.0:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_entities_using_get`, must be a value greater than or equal to `1.0`")  # noqa: E501
        if 'page' in params and params['page'] < 0.0:  # noqa: E501
            raise ValueError("Invalid value for parameter `page` when calling `get_entities_using_get`, must be a value greater than or equal to `0.0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_group_id' in params:
            path_params['entityGroupId'] = params['entity_group_id']  # noqa: E501

        query_params = []
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/{entityGroupId}/entities{?textSearch,sortProperty,sortOrder,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataShortEntityView',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entity_group_all_by_owner_and_type_using_get(self, owner_type, owner_id, group_type, **kwargs):  # noqa: E501
        """getEntityGroupAllByOwnerAndType  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_group_all_by_owner_and_type_using_get(owner_type, owner_id, group_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner_type: ownerType (required)
        :param str owner_id: ownerId (required)
        :param str group_type: EntityGroup type (required)
        :return: EntityGroupInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entity_group_all_by_owner_and_type_using_get_with_http_info(owner_type, owner_id, group_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entity_group_all_by_owner_and_type_using_get_with_http_info(owner_type, owner_id, group_type, **kwargs)  # noqa: E501
            return data

    def get_entity_group_all_by_owner_and_type_using_get_with_http_info(self, owner_type, owner_id, group_type, **kwargs):  # noqa: E501
        """getEntityGroupAllByOwnerAndType  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_group_all_by_owner_and_type_using_get_with_http_info(owner_type, owner_id, group_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner_type: ownerType (required)
        :param str owner_id: ownerId (required)
        :param str group_type: EntityGroup type (required)
        :return: EntityGroupInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner_type', 'owner_id', 'group_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner_type' is set
        if ('owner_type' not in params or
                params['owner_type'] is None):
            raise ValueError("Missing the required parameter `owner_type` when calling `get_entity_group_all_by_owner_and_type_using_get`")  # noqa: E501
        # verify the required parameter 'owner_id' is set
        if ('owner_id' not in params or
                params['owner_id'] is None):
            raise ValueError("Missing the required parameter `owner_id` when calling `get_entity_group_all_by_owner_and_type_using_get`")  # noqa: E501
        # verify the required parameter 'group_type' is set
        if ('group_type' not in params or
                params['group_type'] is None):
            raise ValueError("Missing the required parameter `group_type` when calling `get_entity_group_all_by_owner_and_type_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner_type' in params:
            path_params['ownerType'] = params['owner_type']  # noqa: E501
        if 'owner_id' in params:
            path_params['ownerId'] = params['owner_id']  # noqa: E501
        if 'group_type' in params:
            path_params['groupType'] = params['group_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/all/{ownerType}/{ownerId}/{groupType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityGroupInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entity_group_by_id_using_get(self, entity_group_id, **kwargs):  # noqa: E501
        """getEntityGroupById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_group_by_id_using_get(entity_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :return: EntityGroupInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entity_group_by_id_using_get_with_http_info(entity_group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entity_group_by_id_using_get_with_http_info(entity_group_id, **kwargs)  # noqa: E501
            return data

    def get_entity_group_by_id_using_get_with_http_info(self, entity_group_id, **kwargs):  # noqa: E501
        """getEntityGroupById  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_group_by_id_using_get_with_http_info(entity_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :return: EntityGroupInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group_id' is set
        if ('entity_group_id' not in params or
                params['entity_group_id'] is None):
            raise ValueError("Missing the required parameter `entity_group_id` when calling `get_entity_group_by_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_group_id' in params:
            path_params['entityGroupId'] = params['entity_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/{entityGroupId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityGroupInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entity_groups_by_ids_using_get(self, entity_group_ids, **kwargs):  # noqa: E501
        """getEntityGroupsByIds  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_groups_by_ids_using_get(entity_group_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_ids: entityGroupIds (required)
        :return: list[EntityGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entity_groups_by_ids_using_get_with_http_info(entity_group_ids, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entity_groups_by_ids_using_get_with_http_info(entity_group_ids, **kwargs)  # noqa: E501
            return data

    def get_entity_groups_by_ids_using_get_with_http_info(self, entity_group_ids, **kwargs):  # noqa: E501
        """getEntityGroupsByIds  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_groups_by_ids_using_get_with_http_info(entity_group_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_ids: entityGroupIds (required)
        :return: list[EntityGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group_ids' is set
        if ('entity_group_ids' not in params or
                params['entity_group_ids'] is None):
            raise ValueError("Missing the required parameter `entity_group_ids` when calling `get_entity_groups_by_ids_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'entity_group_ids' in params:
            query_params.append(('entityGroupIds', params['entity_group_ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroups{?entityGroupIds}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityGroup]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entity_groups_by_owner_and_type_using_get(self, owner_type, owner_id, group_type, **kwargs):  # noqa: E501
        """getEntityGroupsByOwnerAndType  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_groups_by_owner_and_type_using_get(owner_type, owner_id, group_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner_type: ownerType (required)
        :param str owner_id: ownerId (required)
        :param str group_type: EntityGroup type (required)
        :return: list[EntityGroupInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entity_groups_by_owner_and_type_using_get_with_http_info(owner_type, owner_id, group_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entity_groups_by_owner_and_type_using_get_with_http_info(owner_type, owner_id, group_type, **kwargs)  # noqa: E501
            return data

    def get_entity_groups_by_owner_and_type_using_get_with_http_info(self, owner_type, owner_id, group_type, **kwargs):  # noqa: E501
        """getEntityGroupsByOwnerAndType  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_groups_by_owner_and_type_using_get_with_http_info(owner_type, owner_id, group_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner_type: ownerType (required)
        :param str owner_id: ownerId (required)
        :param str group_type: EntityGroup type (required)
        :return: list[EntityGroupInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner_type', 'owner_id', 'group_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner_type' is set
        if ('owner_type' not in params or
                params['owner_type'] is None):
            raise ValueError("Missing the required parameter `owner_type` when calling `get_entity_groups_by_owner_and_type_using_get`")  # noqa: E501
        # verify the required parameter 'owner_id' is set
        if ('owner_id' not in params or
                params['owner_id'] is None):
            raise ValueError("Missing the required parameter `owner_id` when calling `get_entity_groups_by_owner_and_type_using_get`")  # noqa: E501
        # verify the required parameter 'group_type' is set
        if ('group_type' not in params or
                params['group_type'] is None):
            raise ValueError("Missing the required parameter `group_type` when calling `get_entity_groups_by_owner_and_type_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner_type' in params:
            path_params['ownerType'] = params['owner_type']  # noqa: E501
        if 'owner_id' in params:
            path_params['ownerId'] = params['owner_id']  # noqa: E501
        if 'group_type' in params:
            path_params['groupType'] = params['group_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroups/{ownerType}/{ownerId}/{groupType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityGroupInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entity_groups_by_type_using_get(self, group_type, **kwargs):  # noqa: E501
        """getEntityGroupsByType  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_groups_by_type_using_get(group_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_type: EntityGroup type (required)
        :return: list[EntityGroupInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entity_groups_by_type_using_get_with_http_info(group_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entity_groups_by_type_using_get_with_http_info(group_type, **kwargs)  # noqa: E501
            return data

    def get_entity_groups_by_type_using_get_with_http_info(self, group_type, **kwargs):  # noqa: E501
        """getEntityGroupsByType  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_groups_by_type_using_get_with_http_info(group_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_type: EntityGroup type (required)
        :return: list[EntityGroupInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_type' is set
        if ('group_type' not in params or
                params['group_type'] is None):
            raise ValueError("Missing the required parameter `group_type` when calling `get_entity_groups_by_type_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_type' in params:
            path_params['groupType'] = params['group_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroups/{groupType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityGroupInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entity_groups_for_entity_using_get(self, entity_type, entity_id, **kwargs):  # noqa: E501
        """getEntityGroupsForEntity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_groups_for_entity_using_get(entity_type, entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param str entity_id: entityId (required)
        :return: list[EntityGroupId]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entity_groups_for_entity_using_get_with_http_info(entity_type, entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entity_groups_for_entity_using_get_with_http_info(entity_type, entity_id, **kwargs)  # noqa: E501
            return data

    def get_entity_groups_for_entity_using_get_with_http_info(self, entity_type, entity_id, **kwargs):  # noqa: E501
        """getEntityGroupsForEntity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_entity_groups_for_entity_using_get_with_http_info(entity_type, entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: Entity type (required)
        :param str entity_id: entityId (required)
        :return: list[EntityGroupId]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `get_entity_groups_for_entity_using_get`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `get_entity_groups_for_entity_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entityType'] = params['entity_type']  # noqa: E501
        if 'entity_id' in params:
            path_params['entityId'] = params['entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroups/{entityType}/{entityId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EntityGroupId]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_group_entity_using_get(self, entity_group_id, entity_id, **kwargs):  # noqa: E501
        """getGroupEntity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_group_entity_using_get(entity_group_id, entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :param str entity_id: entityId (required)
        :return: ShortEntityView
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_group_entity_using_get_with_http_info(entity_group_id, entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_group_entity_using_get_with_http_info(entity_group_id, entity_id, **kwargs)  # noqa: E501
            return data

    def get_group_entity_using_get_with_http_info(self, entity_group_id, entity_id, **kwargs):  # noqa: E501
        """getGroupEntity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_group_entity_using_get_with_http_info(entity_group_id, entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :param str entity_id: entityId (required)
        :return: ShortEntityView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group_id', 'entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group_id' is set
        if ('entity_group_id' not in params or
                params['entity_group_id'] is None):
            raise ValueError("Missing the required parameter `entity_group_id` when calling `get_group_entity_using_get`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `get_group_entity_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_group_id' in params:
            path_params['entityGroupId'] = params['entity_group_id']  # noqa: E501
        if 'entity_id' in params:
            path_params['entityId'] = params['entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/{entityGroupId}/{entityId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShortEntityView',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_owners_using_get(self, page_size, page, **kwargs):  # noqa: E501
        """getOwners  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_owners_using_get(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataContactBasedobject
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_owners_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
        else:
            (data) = self.get_owners_using_get_with_http_info(page_size, page, **kwargs)  # noqa: E501
            return data

    def get_owners_using_get_with_http_info(self, page_size, page, **kwargs):  # noqa: E501
        """getOwners  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_owners_using_get_with_http_info(page_size, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size: pageSize (required)
        :param str page: page (required)
        :param str text_search: textSearch
        :param str sort_property: sortProperty
        :param str sort_order: sortOrder
        :return: PageDataContactBasedobject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page', 'text_search', 'sort_property', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_owners_using_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_owners_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'text_search' in params:
            query_params.append(('textSearch', params['text_search']))  # noqa: E501
        if 'sort_property' in params:
            query_params.append(('sortProperty', params['sort_property']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/owners{?textSearch,sortProperty,sortOrder,pageSize,page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDataContactBasedobject',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def make_entity_group_private_using_post(self, entity_group_id, **kwargs):  # noqa: E501
        """makeEntityGroupPrivate  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.make_entity_group_private_using_post(entity_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.make_entity_group_private_using_post_with_http_info(entity_group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.make_entity_group_private_using_post_with_http_info(entity_group_id, **kwargs)  # noqa: E501
            return data

    def make_entity_group_private_using_post_with_http_info(self, entity_group_id, **kwargs):  # noqa: E501
        """makeEntityGroupPrivate  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.make_entity_group_private_using_post_with_http_info(entity_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group_id' is set
        if ('entity_group_id' not in params or
                params['entity_group_id'] is None):
            raise ValueError("Missing the required parameter `entity_group_id` when calling `make_entity_group_private_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_group_id' in params:
            path_params['entityGroupId'] = params['entity_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/{entityGroupId}/makePrivate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def make_entity_group_public_using_post(self, entity_group_id, **kwargs):  # noqa: E501
        """makeEntityGroupPublic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.make_entity_group_public_using_post(entity_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.make_entity_group_public_using_post_with_http_info(entity_group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.make_entity_group_public_using_post_with_http_info(entity_group_id, **kwargs)  # noqa: E501
            return data

    def make_entity_group_public_using_post_with_http_info(self, entity_group_id, **kwargs):  # noqa: E501
        """makeEntityGroupPublic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.make_entity_group_public_using_post_with_http_info(entity_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group_id' is set
        if ('entity_group_id' not in params or
                params['entity_group_id'] is None):
            raise ValueError("Missing the required parameter `entity_group_id` when calling `make_entity_group_public_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_group_id' in params:
            path_params['entityGroupId'] = params['entity_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/{entityGroupId}/makePublic', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_entities_from_entity_group_using_post(self, entity_group_id, str_entity_ids, **kwargs):  # noqa: E501
        """removeEntitiesFromEntityGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.remove_entities_from_entity_group_using_post(entity_group_id, str_entity_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :param list[str] str_entity_ids: strEntityIds (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_entities_from_entity_group_using_post_with_http_info(entity_group_id, str_entity_ids, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_entities_from_entity_group_using_post_with_http_info(entity_group_id, str_entity_ids, **kwargs)  # noqa: E501
            return data

    def remove_entities_from_entity_group_using_post_with_http_info(self, entity_group_id, str_entity_ids, **kwargs):  # noqa: E501
        """removeEntitiesFromEntityGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.remove_entities_from_entity_group_using_post_with_http_info(entity_group_id, str_entity_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :param list[str] str_entity_ids: strEntityIds (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group_id', 'str_entity_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group_id' is set
        if ('entity_group_id' not in params or
                params['entity_group_id'] is None):
            raise ValueError("Missing the required parameter `entity_group_id` when calling `remove_entities_from_entity_group_using_post`")  # noqa: E501
        # verify the required parameter 'str_entity_ids' is set
        if ('str_entity_ids' not in params or
                params['str_entity_ids'] is None):
            raise ValueError("Missing the required parameter `str_entity_ids` when calling `remove_entities_from_entity_group_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_group_id' in params:
            path_params['entityGroupId'] = params['entity_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'str_entity_ids' in params:
            body_params = params['str_entity_ids']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/{entityGroupId}/deleteEntities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_entity_group_using_post(self, entity_group, **kwargs):  # noqa: E501
        """saveEntityGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.save_entity_group_using_post(entity_group, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EntityGroup entity_group: entityGroup (required)
        :return: EntityGroupInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.save_entity_group_using_post_with_http_info(entity_group, **kwargs)  # noqa: E501
        else:
            (data) = self.save_entity_group_using_post_with_http_info(entity_group, **kwargs)  # noqa: E501
            return data

    def save_entity_group_using_post_with_http_info(self, entity_group, **kwargs):  # noqa: E501
        """saveEntityGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.save_entity_group_using_post_with_http_info(entity_group, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EntityGroup entity_group: entityGroup (required)
        :return: EntityGroupInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group' is set
        if ('entity_group' not in params or
                params['entity_group'] is None):
            raise ValueError("Missing the required parameter `entity_group` when calling `save_entity_group_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'entity_group' in params:
            body_params = params['entity_group']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityGroupInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def share_entity_group_to_child_owner_user_group_using_post(self, entity_group_id, user_group_id, role_id, **kwargs):  # noqa: E501
        """shareEntityGroupToChildOwnerUserGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.share_entity_group_to_child_owner_user_group_using_post(entity_group_id, user_group_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :param str user_group_id: userGroupId (required)
        :param str role_id: roleId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.share_entity_group_to_child_owner_user_group_using_post_with_http_info(entity_group_id, user_group_id, role_id, **kwargs)  # noqa: E501
        else:
            (data) = self.share_entity_group_to_child_owner_user_group_using_post_with_http_info(entity_group_id, user_group_id, role_id, **kwargs)  # noqa: E501
            return data

    def share_entity_group_to_child_owner_user_group_using_post_with_http_info(self, entity_group_id, user_group_id, role_id, **kwargs):  # noqa: E501
        """shareEntityGroupToChildOwnerUserGroup  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.share_entity_group_to_child_owner_user_group_using_post_with_http_info(entity_group_id, user_group_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_group_id: entityGroupId (required)
        :param str user_group_id: userGroupId (required)
        :param str role_id: roleId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_group_id', 'user_group_id', 'role_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_group_id' is set
        if ('entity_group_id' not in params or
                params['entity_group_id'] is None):
            raise ValueError("Missing the required parameter `entity_group_id` when calling `share_entity_group_to_child_owner_user_group_using_post`")  # noqa: E501
        # verify the required parameter 'user_group_id' is set
        if ('user_group_id' not in params or
                params['user_group_id'] is None):
            raise ValueError("Missing the required parameter `user_group_id` when calling `share_entity_group_to_child_owner_user_group_using_post`")  # noqa: E501
        # verify the required parameter 'role_id' is set
        if ('role_id' not in params or
                params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `share_entity_group_to_child_owner_user_group_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_group_id' in params:
            path_params['entityGroupId'] = params['entity_group_id']  # noqa: E501
        if 'user_group_id' in params:
            path_params['userGroupId'] = params['user_group_id']  # noqa: E501
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/entityGroup/{entityGroupId}/{userGroupId}/{roleId}/share', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
