# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client.api_client import ApiClient


class AuditLogControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.    
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_audit_logs_by_customer_id_using_get(self, customer_id, limit, **kwargs):  # noqa: E501
        """getAuditLogsByCustomerId  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_audit_logs_by_customer_id_using_get(customer_id, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: customerId (required)
        :param str limit: limit (required)
        :param int start_time: startTime
        :param int end_time: endTime
        :param bool asc_order: ascOrder
        :param str offset: offset
        :param str action_types: actionTypes
        :return: TimePageDataAuditLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_logs_by_customer_id_using_get_with_http_info(customer_id, limit, **kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_logs_by_customer_id_using_get_with_http_info(customer_id, limit, **kwargs)  # noqa: E501
            return data

    def get_audit_logs_by_customer_id_using_get_with_http_info(self, customer_id, limit, **kwargs):  # noqa: E501
        """getAuditLogsByCustomerId  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_audit_logs_by_customer_id_using_get_with_http_info(customer_id, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: customerId (required)
        :param str limit: limit (required)
        :param int start_time: startTime
        :param int end_time: endTime
        :param bool asc_order: ascOrder
        :param str offset: offset
        :param str action_types: actionTypes
        :return: TimePageDataAuditLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'limit', 'start_time', 'end_time', 'asc_order', 'offset', 'action_types']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_audit_logs_by_customer_id_using_get`")  # noqa: E501
        # verify the required parameter 'limit' is set
        if ('limit' not in params or
                params['limit'] is None):
            raise ValueError("Missing the required parameter `limit` when calling `get_audit_logs_by_customer_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'start_time' in params:
            query_params.append(('startTime', params['start_time']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('endTime', params['end_time']))  # noqa: E501
        if 'asc_order' in params:
            query_params.append(('ascOrder', params['asc_order']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'action_types' in params:
            query_params.append(('actionTypes', params['action_types']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/audit/logs/customer/{customerId}{?startTime,endTime,ascOrder,offset,actionTypes,limit}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimePageDataAuditLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_logs_by_entity_id_using_get(self, entity_type, entity_id, limit, **kwargs):  # noqa: E501
        """getAuditLogsByEntityId  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_audit_logs_by_entity_id_using_get(entity_type, entity_id, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: entityType (required)
        :param str entity_id: entityId (required)
        :param str limit: limit (required)
        :param int start_time: startTime
        :param int end_time: endTime
        :param bool asc_order: ascOrder
        :param str offset: offset
        :param str action_types: actionTypes
        :return: TimePageDataAuditLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_logs_by_entity_id_using_get_with_http_info(entity_type, entity_id, limit, **kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_logs_by_entity_id_using_get_with_http_info(entity_type, entity_id, limit, **kwargs)  # noqa: E501
            return data

    def get_audit_logs_by_entity_id_using_get_with_http_info(self, entity_type, entity_id, limit, **kwargs):  # noqa: E501
        """getAuditLogsByEntityId  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_audit_logs_by_entity_id_using_get_with_http_info(entity_type, entity_id, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str entity_type: entityType (required)
        :param str entity_id: entityId (required)
        :param str limit: limit (required)
        :param int start_time: startTime
        :param int end_time: endTime
        :param bool asc_order: ascOrder
        :param str offset: offset
        :param str action_types: actionTypes
        :return: TimePageDataAuditLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_type', 'entity_id', 'limit', 'start_time', 'end_time', 'asc_order', 'offset', 'action_types']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entity_type' is set
        if ('entity_type' not in params or
                params['entity_type'] is None):
            raise ValueError("Missing the required parameter `entity_type` when calling `get_audit_logs_by_entity_id_using_get`")  # noqa: E501
        # verify the required parameter 'entity_id' is set
        if ('entity_id' not in params or
                params['entity_id'] is None):
            raise ValueError("Missing the required parameter `entity_id` when calling `get_audit_logs_by_entity_id_using_get`")  # noqa: E501
        # verify the required parameter 'limit' is set
        if ('limit' not in params or
                params['limit'] is None):
            raise ValueError("Missing the required parameter `limit` when calling `get_audit_logs_by_entity_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entity_type' in params:
            path_params['entityType'] = params['entity_type']  # noqa: E501
        if 'entity_id' in params:
            path_params['entityId'] = params['entity_id']  # noqa: E501

        query_params = []
        if 'start_time' in params:
            query_params.append(('startTime', params['start_time']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('endTime', params['end_time']))  # noqa: E501
        if 'asc_order' in params:
            query_params.append(('ascOrder', params['asc_order']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'action_types' in params:
            query_params.append(('actionTypes', params['action_types']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/audit/logs/entity/{entityType}/{entityId}{?startTime,endTime,ascOrder,offset,actionTypes,limit}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimePageDataAuditLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_logs_by_user_id_using_get(self, user_id, limit, **kwargs):  # noqa: E501
        """getAuditLogsByUserId  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_audit_logs_by_user_id_using_get(user_id, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: userId (required)
        :param str limit: limit (required)
        :param int start_time: startTime
        :param int end_time: endTime
        :param bool asc_order: ascOrder
        :param str offset: offset
        :param str action_types: actionTypes
        :return: TimePageDataAuditLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_logs_by_user_id_using_get_with_http_info(user_id, limit, **kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_logs_by_user_id_using_get_with_http_info(user_id, limit, **kwargs)  # noqa: E501
            return data

    def get_audit_logs_by_user_id_using_get_with_http_info(self, user_id, limit, **kwargs):  # noqa: E501
        """getAuditLogsByUserId  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_audit_logs_by_user_id_using_get_with_http_info(user_id, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: userId (required)
        :param str limit: limit (required)
        :param int start_time: startTime
        :param int end_time: endTime
        :param bool asc_order: ascOrder
        :param str offset: offset
        :param str action_types: actionTypes
        :return: TimePageDataAuditLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'limit', 'start_time', 'end_time', 'asc_order', 'offset', 'action_types']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_audit_logs_by_user_id_using_get`")  # noqa: E501
        # verify the required parameter 'limit' is set
        if ('limit' not in params or
                params['limit'] is None):
            raise ValueError("Missing the required parameter `limit` when calling `get_audit_logs_by_user_id_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']  # noqa: E501

        query_params = []
        if 'start_time' in params:
            query_params.append(('startTime', params['start_time']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('endTime', params['end_time']))  # noqa: E501
        if 'asc_order' in params:
            query_params.append(('ascOrder', params['asc_order']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'action_types' in params:
            query_params.append(('actionTypes', params['action_types']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/audit/logs/user/{userId}{?startTime,endTime,ascOrder,offset,actionTypes,limit}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimePageDataAuditLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_logs_using_get(self, limit, **kwargs):  # noqa: E501
        """getAuditLogs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_audit_logs_using_get(limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str limit: limit (required)
        :param int start_time: startTime
        :param int end_time: endTime
        :param bool asc_order: ascOrder
        :param str offset: offset
        :param str action_types: actionTypes
        :return: TimePageDataAuditLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_logs_using_get_with_http_info(limit, **kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_logs_using_get_with_http_info(limit, **kwargs)  # noqa: E501
            return data

    def get_audit_logs_using_get_with_http_info(self, limit, **kwargs):  # noqa: E501
        """getAuditLogs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api_pe.get_audit_logs_using_get_with_http_info(limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str limit: limit (required)
        :param int start_time: startTime
        :param int end_time: endTime
        :param bool asc_order: ascOrder
        :param str offset: offset
        :param str action_types: actionTypes
        :return: TimePageDataAuditLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'start_time', 'end_time', 'asc_order', 'offset', 'action_types']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'limit' is set
        if ('limit' not in params or
                params['limit'] is None):
            raise ValueError("Missing the required parameter `limit` when calling `get_audit_logs_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_time' in params:
            query_params.append(('startTime', params['start_time']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('endTime', params['end_time']))  # noqa: E501
        if 'asc_order' in params:
            query_params.append(('ascOrder', params['asc_order']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'action_types' in params:
            query_params.append(('actionTypes', params['action_types']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/audit/logs{?startTime,endTime,ascOrder,offset,actionTypes,limit}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimePageDataAuditLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
