import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type JFrog::Vpc::MultiAz::MODULE
 *
 * @schema CfnMultiAzModuleProps
 */
export interface CfnMultiAzModuleProps {
    /**
     * @schema CfnMultiAzModuleProps#Parameters
     */
    readonly parameters?: CfnMultiAzModulePropsParameters;
    /**
     * @schema CfnMultiAzModuleProps#Resources
     */
    readonly resources?: CfnMultiAzModulePropsResources;
}
/**
 * Converts an object of type 'CfnMultiAzModuleProps' to JSON representation.
 */
export declare function toJson_CfnMultiAzModuleProps(obj: CfnMultiAzModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsParameters
 */
export interface CfnMultiAzModulePropsParameters {
    /**
     * Availability Zone 1 to use for the subnets in the VPC. Two Availability Zones are used for this deployment.
     *
     * @schema CfnMultiAzModulePropsParameters#AvailabilityZone1
     */
    readonly availabilityZone1?: CfnMultiAzModulePropsParametersAvailabilityZone1;
    /**
     * Availability Zone 2 to use for the subnets in the VPC. Two Availability Zones are used for this deployment.
     *
     * @schema CfnMultiAzModulePropsParameters#AvailabilityZone2
     */
    readonly availabilityZone2?: CfnMultiAzModulePropsParametersAvailabilityZone2;
    /**
     * Set to false when creating only private subnets. If True, both CreatePublicSubnets and CreatePrivateSubnets must also be true.
     *
     * @schema CfnMultiAzModulePropsParameters#CreateNATGateways
     */
    readonly createNatGateways?: CfnMultiAzModulePropsParametersCreateNatGateways;
    /**
     * Set to false to create only private subnets. If false, CreatePrivateSubnets must be True and the CIDR parameters for ALL public subnets will be ignored
     *
     * @schema CfnMultiAzModulePropsParameters#CreatePublicSubnets
     */
    readonly createPublicSubnets?: CfnMultiAzModulePropsParametersCreatePublicSubnets;
    /**
     * Set to false to create only public subnets. If false, the CIDR parameters for ALL private subnets will be ignored.
     *
     * @schema CfnMultiAzModulePropsParameters#CreatePrivateSubnets
     */
    readonly createPrivateSubnets?: CfnMultiAzModulePropsParametersCreatePrivateSubnets;
    /**
     * CIDR block for private subnet 1A located in Availability Zone 1
     *
     * @schema CfnMultiAzModulePropsParameters#PrivateSubnet1ACIDR
     */
    readonly privateSubnet1Acidr?: CfnMultiAzModulePropsParametersPrivateSubnet1Acidr;
    /**
     * CIDR block for private subnet 2A located in Availability Zone 2
     *
     * @schema CfnMultiAzModulePropsParameters#PrivateSubnet2ACIDR
     */
    readonly privateSubnet2Acidr?: CfnMultiAzModulePropsParametersPrivateSubnet2Acidr;
    /**
     * tag to add to private subnets A, in format Key=Value (Optional)
     *
     * @schema CfnMultiAzModulePropsParameters#PrivateSubnetATag1
     */
    readonly privateSubnetATag1?: CfnMultiAzModulePropsParametersPrivateSubnetATag1;
    /**
     * tag to add to private subnets A, in format Key=Value (Optional)
     *
     * @schema CfnMultiAzModulePropsParameters#PrivateSubnetATag2
     */
    readonly privateSubnetATag2?: CfnMultiAzModulePropsParametersPrivateSubnetATag2;
    /**
     * CIDR block for the public DMZ subnet 1 located in Availability Zone 1
     *
     * @schema CfnMultiAzModulePropsParameters#PublicSubnet1CIDR
     */
    readonly publicSubnet1Cidr?: CfnMultiAzModulePropsParametersPublicSubnet1Cidr;
    /**
     * CIDR block for the public DMZ subnet 2 located in Availability Zone 2
     *
     * @schema CfnMultiAzModulePropsParameters#PublicSubnet2CIDR
     */
    readonly publicSubnet2Cidr?: CfnMultiAzModulePropsParametersPublicSubnet2Cidr;
    /**
     * tag to add to public subnets, in format Key=Value (Optional)
     *
     * @schema CfnMultiAzModulePropsParameters#PublicSubnetTag1
     */
    readonly publicSubnetTag1?: CfnMultiAzModulePropsParametersPublicSubnetTag1;
    /**
     * tag to add to public subnets, in format Key=Value (Optional)
     *
     * @schema CfnMultiAzModulePropsParameters#PublicSubnetTag2
     */
    readonly publicSubnetTag2?: CfnMultiAzModulePropsParametersPublicSubnetTag2;
    /**
     * CIDR block for the VPC
     *
     * @schema CfnMultiAzModulePropsParameters#VPCCIDR
     */
    readonly vpccidr?: CfnMultiAzModulePropsParametersVpccidr;
    /**
     * The allowed tenancy of instances launched into the VPC
     *
     * @schema CfnMultiAzModulePropsParameters#VPCTenancy
     */
    readonly vpcTenancy?: CfnMultiAzModulePropsParametersVpcTenancy;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParameters(obj: CfnMultiAzModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResources
 */
export interface CfnMultiAzModulePropsResources {
    /**
     * @schema CfnMultiAzModulePropsResources#DHCPOptions
     */
    readonly dhcpOptions?: CfnMultiAzModulePropsResourcesDhcpOptions;
    /**
     * @schema CfnMultiAzModulePropsResources#VPC
     */
    readonly vpc?: CfnMultiAzModulePropsResourcesVpc;
    /**
     * @schema CfnMultiAzModulePropsResources#VPCDHCPOptionsAssociation
     */
    readonly vpcdhcpOptionsAssociation?: CfnMultiAzModulePropsResourcesVpcdhcpOptionsAssociation;
    /**
     * @schema CfnMultiAzModulePropsResources#InternetGateway
     */
    readonly internetGateway?: CfnMultiAzModulePropsResourcesInternetGateway;
    /**
     * @schema CfnMultiAzModulePropsResources#VPCGatewayAttachment
     */
    readonly vpcGatewayAttachment?: CfnMultiAzModulePropsResourcesVpcGatewayAttachment;
    /**
     * @schema CfnMultiAzModulePropsResources#PrivateSubnet1A
     */
    readonly privateSubnet1A?: CfnMultiAzModulePropsResourcesPrivateSubnet1A;
    /**
     * @schema CfnMultiAzModulePropsResources#PrivateSubnet2A
     */
    readonly privateSubnet2A?: CfnMultiAzModulePropsResourcesPrivateSubnet2A;
    /**
     * @schema CfnMultiAzModulePropsResources#PublicSubnet1
     */
    readonly publicSubnet1?: CfnMultiAzModulePropsResourcesPublicSubnet1;
    /**
     * @schema CfnMultiAzModulePropsResources#PublicSubnet2
     */
    readonly publicSubnet2?: CfnMultiAzModulePropsResourcesPublicSubnet2;
    /**
     * @schema CfnMultiAzModulePropsResources#PrivateSubnet1ARouteTable
     */
    readonly privateSubnet1ARouteTable?: CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTable;
    /**
     * @schema CfnMultiAzModulePropsResources#PrivateSubnet1ARoute
     */
    readonly privateSubnet1ARoute?: CfnMultiAzModulePropsResourcesPrivateSubnet1ARoute;
    /**
     * @schema CfnMultiAzModulePropsResources#PrivateSubnet1ARouteTableAssociation
     */
    readonly privateSubnet1ARouteTableAssociation?: CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTableAssociation;
    /**
     * @schema CfnMultiAzModulePropsResources#PrivateSubnet2ARouteTable
     */
    readonly privateSubnet2ARouteTable?: CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTable;
    /**
     * @schema CfnMultiAzModulePropsResources#PrivateSubnet2ARoute
     */
    readonly privateSubnet2ARoute?: CfnMultiAzModulePropsResourcesPrivateSubnet2ARoute;
    /**
     * @schema CfnMultiAzModulePropsResources#PrivateSubnet2ARouteTableAssociation
     */
    readonly privateSubnet2ARouteTableAssociation?: CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTableAssociation;
    /**
     * @schema CfnMultiAzModulePropsResources#PublicSubnetRouteTable
     */
    readonly publicSubnetRouteTable?: CfnMultiAzModulePropsResourcesPublicSubnetRouteTable;
    /**
     * @schema CfnMultiAzModulePropsResources#PublicSubnetRoute
     */
    readonly publicSubnetRoute?: CfnMultiAzModulePropsResourcesPublicSubnetRoute;
    /**
     * @schema CfnMultiAzModulePropsResources#PublicSubnet1RouteTableAssociation
     */
    readonly publicSubnet1RouteTableAssociation?: CfnMultiAzModulePropsResourcesPublicSubnet1RouteTableAssociation;
    /**
     * @schema CfnMultiAzModulePropsResources#PublicSubnet2RouteTableAssociation
     */
    readonly publicSubnet2RouteTableAssociation?: CfnMultiAzModulePropsResourcesPublicSubnet2RouteTableAssociation;
    /**
     * @schema CfnMultiAzModulePropsResources#NAT1EIP
     */
    readonly nat1Eip?: CfnMultiAzModulePropsResourcesNat1Eip;
    /**
     * @schema CfnMultiAzModulePropsResources#NAT2EIP
     */
    readonly nat2Eip?: CfnMultiAzModulePropsResourcesNat2Eip;
    /**
     * @schema CfnMultiAzModulePropsResources#NATGateway1
     */
    readonly natGateway1?: CfnMultiAzModulePropsResourcesNatGateway1;
    /**
     * @schema CfnMultiAzModulePropsResources#NATGateway2
     */
    readonly natGateway2?: CfnMultiAzModulePropsResourcesNatGateway2;
    /**
     * @schema CfnMultiAzModulePropsResources#S3VPCEndpoint
     */
    readonly s3VpcEndpoint?: CfnMultiAzModulePropsResourcesS3VpcEndpoint;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResources(obj: CfnMultiAzModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * Availability Zone 1 to use for the subnets in the VPC. Two Availability Zones are used for this deployment.
 *
 * @schema CfnMultiAzModulePropsParametersAvailabilityZone1
 */
export interface CfnMultiAzModulePropsParametersAvailabilityZone1 {
    /**
     * @schema CfnMultiAzModulePropsParametersAvailabilityZone1#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersAvailabilityZone1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersAvailabilityZone1' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersAvailabilityZone1(obj: CfnMultiAzModulePropsParametersAvailabilityZone1 | undefined): Record<string, any> | undefined;
/**
 * Availability Zone 2 to use for the subnets in the VPC. Two Availability Zones are used for this deployment.
 *
 * @schema CfnMultiAzModulePropsParametersAvailabilityZone2
 */
export interface CfnMultiAzModulePropsParametersAvailabilityZone2 {
    /**
     * @schema CfnMultiAzModulePropsParametersAvailabilityZone2#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersAvailabilityZone2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersAvailabilityZone2' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersAvailabilityZone2(obj: CfnMultiAzModulePropsParametersAvailabilityZone2 | undefined): Record<string, any> | undefined;
/**
 * Set to false when creating only private subnets. If True, both CreatePublicSubnets and CreatePrivateSubnets must also be true.
 *
 * @schema CfnMultiAzModulePropsParametersCreateNatGateways
 */
export interface CfnMultiAzModulePropsParametersCreateNatGateways {
    /**
     * @schema CfnMultiAzModulePropsParametersCreateNatGateways#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersCreateNatGateways#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersCreateNatGateways' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersCreateNatGateways(obj: CfnMultiAzModulePropsParametersCreateNatGateways | undefined): Record<string, any> | undefined;
/**
 * Set to false to create only private subnets. If false, CreatePrivateSubnets must be True and the CIDR parameters for ALL public subnets will be ignored
 *
 * @schema CfnMultiAzModulePropsParametersCreatePublicSubnets
 */
export interface CfnMultiAzModulePropsParametersCreatePublicSubnets {
    /**
     * @schema CfnMultiAzModulePropsParametersCreatePublicSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersCreatePublicSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersCreatePublicSubnets' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersCreatePublicSubnets(obj: CfnMultiAzModulePropsParametersCreatePublicSubnets | undefined): Record<string, any> | undefined;
/**
 * Set to false to create only public subnets. If false, the CIDR parameters for ALL private subnets will be ignored.
 *
 * @schema CfnMultiAzModulePropsParametersCreatePrivateSubnets
 */
export interface CfnMultiAzModulePropsParametersCreatePrivateSubnets {
    /**
     * @schema CfnMultiAzModulePropsParametersCreatePrivateSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersCreatePrivateSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersCreatePrivateSubnets' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersCreatePrivateSubnets(obj: CfnMultiAzModulePropsParametersCreatePrivateSubnets | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 1A located in Availability Zone 1
 *
 * @schema CfnMultiAzModulePropsParametersPrivateSubnet1Acidr
 */
export interface CfnMultiAzModulePropsParametersPrivateSubnet1Acidr {
    /**
     * @schema CfnMultiAzModulePropsParametersPrivateSubnet1Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersPrivateSubnet1Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersPrivateSubnet1Acidr' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersPrivateSubnet1Acidr(obj: CfnMultiAzModulePropsParametersPrivateSubnet1Acidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for private subnet 2A located in Availability Zone 2
 *
 * @schema CfnMultiAzModulePropsParametersPrivateSubnet2Acidr
 */
export interface CfnMultiAzModulePropsParametersPrivateSubnet2Acidr {
    /**
     * @schema CfnMultiAzModulePropsParametersPrivateSubnet2Acidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersPrivateSubnet2Acidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersPrivateSubnet2Acidr' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersPrivateSubnet2Acidr(obj: CfnMultiAzModulePropsParametersPrivateSubnet2Acidr | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets A, in format Key=Value (Optional)
 *
 * @schema CfnMultiAzModulePropsParametersPrivateSubnetATag1
 */
export interface CfnMultiAzModulePropsParametersPrivateSubnetATag1 {
    /**
     * @schema CfnMultiAzModulePropsParametersPrivateSubnetATag1#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersPrivateSubnetATag1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersPrivateSubnetATag1' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersPrivateSubnetATag1(obj: CfnMultiAzModulePropsParametersPrivateSubnetATag1 | undefined): Record<string, any> | undefined;
/**
 * tag to add to private subnets A, in format Key=Value (Optional)
 *
 * @schema CfnMultiAzModulePropsParametersPrivateSubnetATag2
 */
export interface CfnMultiAzModulePropsParametersPrivateSubnetATag2 {
    /**
     * @schema CfnMultiAzModulePropsParametersPrivateSubnetATag2#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersPrivateSubnetATag2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersPrivateSubnetATag2' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersPrivateSubnetATag2(obj: CfnMultiAzModulePropsParametersPrivateSubnetATag2 | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 1 located in Availability Zone 1
 *
 * @schema CfnMultiAzModulePropsParametersPublicSubnet1Cidr
 */
export interface CfnMultiAzModulePropsParametersPublicSubnet1Cidr {
    /**
     * @schema CfnMultiAzModulePropsParametersPublicSubnet1Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersPublicSubnet1Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersPublicSubnet1Cidr' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersPublicSubnet1Cidr(obj: CfnMultiAzModulePropsParametersPublicSubnet1Cidr | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the public DMZ subnet 2 located in Availability Zone 2
 *
 * @schema CfnMultiAzModulePropsParametersPublicSubnet2Cidr
 */
export interface CfnMultiAzModulePropsParametersPublicSubnet2Cidr {
    /**
     * @schema CfnMultiAzModulePropsParametersPublicSubnet2Cidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersPublicSubnet2Cidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersPublicSubnet2Cidr' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersPublicSubnet2Cidr(obj: CfnMultiAzModulePropsParametersPublicSubnet2Cidr | undefined): Record<string, any> | undefined;
/**
 * tag to add to public subnets, in format Key=Value (Optional)
 *
 * @schema CfnMultiAzModulePropsParametersPublicSubnetTag1
 */
export interface CfnMultiAzModulePropsParametersPublicSubnetTag1 {
    /**
     * @schema CfnMultiAzModulePropsParametersPublicSubnetTag1#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersPublicSubnetTag1#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersPublicSubnetTag1' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersPublicSubnetTag1(obj: CfnMultiAzModulePropsParametersPublicSubnetTag1 | undefined): Record<string, any> | undefined;
/**
 * tag to add to public subnets, in format Key=Value (Optional)
 *
 * @schema CfnMultiAzModulePropsParametersPublicSubnetTag2
 */
export interface CfnMultiAzModulePropsParametersPublicSubnetTag2 {
    /**
     * @schema CfnMultiAzModulePropsParametersPublicSubnetTag2#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersPublicSubnetTag2#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersPublicSubnetTag2' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersPublicSubnetTag2(obj: CfnMultiAzModulePropsParametersPublicSubnetTag2 | undefined): Record<string, any> | undefined;
/**
 * CIDR block for the VPC
 *
 * @schema CfnMultiAzModulePropsParametersVpccidr
 */
export interface CfnMultiAzModulePropsParametersVpccidr {
    /**
     * @schema CfnMultiAzModulePropsParametersVpccidr#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersVpccidr#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersVpccidr' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersVpccidr(obj: CfnMultiAzModulePropsParametersVpccidr | undefined): Record<string, any> | undefined;
/**
 * The allowed tenancy of instances launched into the VPC
 *
 * @schema CfnMultiAzModulePropsParametersVpcTenancy
 */
export interface CfnMultiAzModulePropsParametersVpcTenancy {
    /**
     * @schema CfnMultiAzModulePropsParametersVpcTenancy#Type
     */
    readonly type: string;
    /**
     * @schema CfnMultiAzModulePropsParametersVpcTenancy#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsParametersVpcTenancy' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsParametersVpcTenancy(obj: CfnMultiAzModulePropsParametersVpcTenancy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesDhcpOptions
 */
export interface CfnMultiAzModulePropsResourcesDhcpOptions {
    /**
     * @schema CfnMultiAzModulePropsResourcesDhcpOptions#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesDhcpOptions#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesDhcpOptions' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesDhcpOptions(obj: CfnMultiAzModulePropsResourcesDhcpOptions | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesVpc
 */
export interface CfnMultiAzModulePropsResourcesVpc {
    /**
     * @schema CfnMultiAzModulePropsResourcesVpc#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesVpc#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesVpc' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesVpc(obj: CfnMultiAzModulePropsResourcesVpc | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesVpcdhcpOptionsAssociation
 */
export interface CfnMultiAzModulePropsResourcesVpcdhcpOptionsAssociation {
    /**
     * @schema CfnMultiAzModulePropsResourcesVpcdhcpOptionsAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesVpcdhcpOptionsAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesVpcdhcpOptionsAssociation' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesVpcdhcpOptionsAssociation(obj: CfnMultiAzModulePropsResourcesVpcdhcpOptionsAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesInternetGateway
 */
export interface CfnMultiAzModulePropsResourcesInternetGateway {
    /**
     * @schema CfnMultiAzModulePropsResourcesInternetGateway#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesInternetGateway#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesInternetGateway' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesInternetGateway(obj: CfnMultiAzModulePropsResourcesInternetGateway | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesVpcGatewayAttachment
 */
export interface CfnMultiAzModulePropsResourcesVpcGatewayAttachment {
    /**
     * @schema CfnMultiAzModulePropsResourcesVpcGatewayAttachment#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesVpcGatewayAttachment#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesVpcGatewayAttachment' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesVpcGatewayAttachment(obj: CfnMultiAzModulePropsResourcesVpcGatewayAttachment | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1A
 */
export interface CfnMultiAzModulePropsResourcesPrivateSubnet1A {
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPrivateSubnet1A' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPrivateSubnet1A(obj: CfnMultiAzModulePropsResourcesPrivateSubnet1A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2A
 */
export interface CfnMultiAzModulePropsResourcesPrivateSubnet2A {
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2A#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2A#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPrivateSubnet2A' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPrivateSubnet2A(obj: CfnMultiAzModulePropsResourcesPrivateSubnet2A | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPublicSubnet1
 */
export interface CfnMultiAzModulePropsResourcesPublicSubnet1 {
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnet1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnet1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPublicSubnet1' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPublicSubnet1(obj: CfnMultiAzModulePropsResourcesPublicSubnet1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPublicSubnet2
 */
export interface CfnMultiAzModulePropsResourcesPublicSubnet2 {
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnet2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnet2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPublicSubnet2' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPublicSubnet2(obj: CfnMultiAzModulePropsResourcesPublicSubnet2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTable
 */
export interface CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTable {
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTable' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTable(obj: CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1ARoute
 */
export interface CfnMultiAzModulePropsResourcesPrivateSubnet1ARoute {
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPrivateSubnet1ARoute' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPrivateSubnet1ARoute(obj: CfnMultiAzModulePropsResourcesPrivateSubnet1ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTableAssociation
 */
export interface CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTableAssociation {
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTableAssociation(obj: CfnMultiAzModulePropsResourcesPrivateSubnet1ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTable
 */
export interface CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTable {
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTable' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTable(obj: CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2ARoute
 */
export interface CfnMultiAzModulePropsResourcesPrivateSubnet2ARoute {
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2ARoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2ARoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPrivateSubnet2ARoute' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPrivateSubnet2ARoute(obj: CfnMultiAzModulePropsResourcesPrivateSubnet2ARoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTableAssociation
 */
export interface CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTableAssociation {
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTableAssociation(obj: CfnMultiAzModulePropsResourcesPrivateSubnet2ARouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPublicSubnetRouteTable
 */
export interface CfnMultiAzModulePropsResourcesPublicSubnetRouteTable {
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnetRouteTable#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnetRouteTable#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPublicSubnetRouteTable' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPublicSubnetRouteTable(obj: CfnMultiAzModulePropsResourcesPublicSubnetRouteTable | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPublicSubnetRoute
 */
export interface CfnMultiAzModulePropsResourcesPublicSubnetRoute {
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnetRoute#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnetRoute#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPublicSubnetRoute' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPublicSubnetRoute(obj: CfnMultiAzModulePropsResourcesPublicSubnetRoute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPublicSubnet1RouteTableAssociation
 */
export interface CfnMultiAzModulePropsResourcesPublicSubnet1RouteTableAssociation {
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnet1RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnet1RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPublicSubnet1RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPublicSubnet1RouteTableAssociation(obj: CfnMultiAzModulePropsResourcesPublicSubnet1RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesPublicSubnet2RouteTableAssociation
 */
export interface CfnMultiAzModulePropsResourcesPublicSubnet2RouteTableAssociation {
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnet2RouteTableAssociation#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesPublicSubnet2RouteTableAssociation#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesPublicSubnet2RouteTableAssociation' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesPublicSubnet2RouteTableAssociation(obj: CfnMultiAzModulePropsResourcesPublicSubnet2RouteTableAssociation | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesNat1Eip
 */
export interface CfnMultiAzModulePropsResourcesNat1Eip {
    /**
     * @schema CfnMultiAzModulePropsResourcesNat1Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesNat1Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesNat1Eip' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesNat1Eip(obj: CfnMultiAzModulePropsResourcesNat1Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesNat2Eip
 */
export interface CfnMultiAzModulePropsResourcesNat2Eip {
    /**
     * @schema CfnMultiAzModulePropsResourcesNat2Eip#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesNat2Eip#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesNat2Eip' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesNat2Eip(obj: CfnMultiAzModulePropsResourcesNat2Eip | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesNatGateway1
 */
export interface CfnMultiAzModulePropsResourcesNatGateway1 {
    /**
     * @schema CfnMultiAzModulePropsResourcesNatGateway1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesNatGateway1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesNatGateway1' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesNatGateway1(obj: CfnMultiAzModulePropsResourcesNatGateway1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesNatGateway2
 */
export interface CfnMultiAzModulePropsResourcesNatGateway2 {
    /**
     * @schema CfnMultiAzModulePropsResourcesNatGateway2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesNatGateway2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesNatGateway2' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesNatGateway2(obj: CfnMultiAzModulePropsResourcesNatGateway2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnMultiAzModulePropsResourcesS3VpcEndpoint
 */
export interface CfnMultiAzModulePropsResourcesS3VpcEndpoint {
    /**
     * @schema CfnMultiAzModulePropsResourcesS3VpcEndpoint#Type
     */
    readonly type?: string;
    /**
     * @schema CfnMultiAzModulePropsResourcesS3VpcEndpoint#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnMultiAzModulePropsResourcesS3VpcEndpoint' to JSON representation.
 */
export declare function toJson_CfnMultiAzModulePropsResourcesS3VpcEndpoint(obj: CfnMultiAzModulePropsResourcesS3VpcEndpoint | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `JFrog::Vpc::MultiAz::MODULE`
 *
 * @cloudformationResource JFrog::Vpc::MultiAz::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnMultiAzModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "JFrog::Vpc::MultiAz::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnMultiAzModuleProps;
    /**
     * Create a new `JFrog::Vpc::MultiAz::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnMultiAzModuleProps);
}
