# AUTOGENERATED! DO NOT EDIT! File to edit: 00_lp.ipynb (unless otherwise specified).

__all__ = ['LP']

# Cell
# export
import shutil
import tempfile
from pathlib import Path
from nbdev.showdoc import *

# Cell
class LP:
    """ListPaths this is a container for paths filled by a glob-pattern.

      * It provides __getitem__ access to the content
      * it can also be used with an iterator (provides the __iter__-method)

    """

    base_filters = {
            "file": Path.is_file,
            "dir": Path.is_dir,
        }

    def __init__(self, basepath, pat='*', t='file'):

        self.t = t
        base_filter = self.base_filters.get(self.t, None)
        self.basepath = Path(basepath)
        self.content = basepath.glob(pat)
        self.content = filter(base_filter, self.content)
        self.content = list(self.content)

    @property
    def parent(self):
        return self.basepath.parent

    @property
    def exists(self):
        return self.basepath.exists()

    def __getitem__(self, nr):
        return self.content[nr]

    def __iter__(self):
        return self.content.__iter__()

    def __repr__(self):
        c = [f"  * {nr} {p.name}" for nr, p in enumerate(self.content)]
        info = [f"{self.parent} ({len(self.content)} {self.t}s)"]
        return "\n".join(info + c)