# Generated by Django 3.0.8 on 2020-07-18 12:33

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models

import impersonate_permissions.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="PermissionWindow",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "window_starts_at",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="When the permission window begins.",
                    ),
                ),
                (
                    "window_ends_at",
                    models.DateTimeField(
                        default=impersonate_permissions.models.default_expiry,
                        help_text="When the permission window ends.",
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        default=True, help_text="Kill switch for permission window."
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="When the database record was created.",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="permission_windows",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
    ]
