import * as iot from '@aws-cdk/aws-iot-alpha';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { CommonActionProps } from './common-action-props';
/**
 * (experimental) Configuration properties of an action for s3.
 *
 * @experimental
 */
export interface S3PutObjectActionProps extends CommonActionProps {
    /**
     * (experimental) The Amazon S3 canned ACL that controls access to the object identified by the object key.
     *
     * @default None
     * @see https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl
     * @experimental
     */
    readonly accessControl?: s3.BucketAccessControl;
    /**
     * (experimental) The path to the file where the data is written.
     *
     * Supports substitution templates.
     *
     * @default '${topic()}/${timestamp()}'
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     * @experimental
     */
    readonly key?: string;
}
/**
 * (experimental) The action to write the data from an MQTT message to an Amazon S3 bucket.
 *
 * @experimental
 */
export declare class S3PutObjectAction implements iot.IAction {
    private readonly bucket;
    private readonly accessControl?;
    private readonly key?;
    private readonly role?;
    /**
     * @param bucket The Amazon S3 bucket to which to write data.
     * @param props Optional properties to not use default.
     * @experimental
     */
    constructor(bucket: s3.IBucket, props?: S3PutObjectActionProps);
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
