# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['Config', 'URLs', 'download_data', 'file_extract', 'download_url', 'untar_data']

# Cell
import os
import shutil
import requests
from pathlib import Path
from fastprogress import progress_bar
import zipfile, tarfile

# Cell
class Config:
    config_path = Path('~/.aiadv').expanduser()
    def __init__(self):
        self.config_path.mkdir(parents=True, exist_ok=True)

#export
class URLs:
    GDRIVE = "https://docs.google.com/uc?export=download&id="

    # Datasets
    YELP_REIVEWS      = {'url': f'{GDRIVE}1Lmv4rsJiCWVs1nzs4ywA9YI-ADsTf6WB', 'fname': 'yelp_reveiw.csv'}
    ENG_FRA_SAMPLE    = {'url': f'{GDRIVE}1jLx6dZllBQ3LXZkCjZ4VciMQkZUInU10', 'fname': 'eng_fra_sample.csv'}
    ENG_FRA           = {'url': f'{GDRIVE}1o2ac0EliUod63sYUdpow_Dh-OqS3hF5Z', 'fname': 'eng_fra.txt'}
    SURNAMES          = {'url': f'{GDRIVE}1T1la2tYO1O7XkMRawG8VcFcvtjbxDqU-', 'fname': 'surnames.csv'}
    CHD_49            = {'url': f'{GDRIVE}11yU-64VW4b9_tw-yWPUcnQ0A3-Uh-dd9', 'fname': 'chd_49.zip'}

    ADV_SHERLOCK      = {'url': 'https://norvig.com/big.txt', 'fname': 'adv_sherlock.txt'}
    HUMAN_NUMBERS     = {'url': 'http://files.fast.ai/data/examples/human_numbers.tgz', 'fname': 'human_numbers.tgz'}
    MOVIELENS_SMALL   = {'url': 'http://files.grouplens.org/datasets/movielens/ml-latest-small.zip', 'fname': 'ml-latest-small.zip'}

    def path(ds=None):
        fname = ds['fname']
        path = Config().config_path/fname
        return path

    def stem(path):
        if str(path).endswith('gz') or str(path).endswith('zip'):
            parent = path.parent
            return parent/path.stem
        else: return path

# Cell
def download_data(ds, force_download=False):
    "Download `url` to `fname`."
    dest = URLs.path(ds)
    if not dest.exists() or force_download:
        download_url(ds['url'], dest, overwrite=force_download)
    return dest

def file_extract(fname, dest=None):
    "Extract `fname` using `tarfile` or `zipfile"
    fname_str = str(fname)
    if dest is None: dest = Path(fname).parent

    if fname_str.endswith('gz'   ): tarfile.open(fname, 'r:gz').extractall(dest)
    elif fname_str.endswith('zip'): zipfile.ZipFile(fname     ).extractall(dest)
    else: raise Exception(f'Unrecognized archive: {fname}')

    # cleaning up
    os.remove(fname)

def download_url(url, dest, overwrite=False, pbar=None, show_progress=True, chunk_size=1024*1024,
                 timeout=4, retries=5):
    "Download `url` to `dest` unless it exists and not `overwrite`"
    if os.path.exists(dest) and not overwrite: return

    s = requests.Session()
    s.mount('http://',requests.adapters.HTTPAdapter(max_retries=retries))
    # additional line to identify as a firefox browser, see fastai/#2438
    s.headers.update({'User-Agent': 'Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:71.0) Gecko/20100101 Firefox/71.0'})
    u = s.get(url, stream=True, timeout=timeout)
    try: file_size = int(u.headers["Content-Length"])
    except: show_progress = False

    with open(dest, 'wb') as f:
        nbytes = 0
        if show_progress: pbar = progress_bar(range(file_size), leave=False, parent=pbar)
        try:
            if show_progress: pbar.update(0)
            for chunk in u.iter_content(chunk_size=chunk_size):
                nbytes += len(chunk)
                if show_progress: pbar.update(nbytes)
                f.write(chunk)
        except requests.exceptions.ConnectionError as e:
            print('Connection Error, please check your internet')

# Cell
def untar_data(ds, force_download=False, extract_func=file_extract):
    dest = URLs.path(ds)
    stem = URLs.stem(dest)
    fname = ds['fname']
    if force_download:
        if stem.exists():
            try: os.remove(stem)
            except: shutil.rmtree(stem)
    if not stem.exists():
        download_data(ds)
        if str(fname).endswith('zip') or str(fname).endswith('gz'):
            extract_func(dest)
    return stem