#!/usr/bin/env python

import os
import re

from setuptools import find_packages, setup

with open("README.rst") as readme_file:
    readme = readme_file.read()

requirements = [
    "Click>=7.0,<8",
    "iso8601",
    "simpletail",
    "enhydris-api-client>=2,<3",
]

setup_requirements = []

test_requirements = ["pyfakefs"]


def get_version():
    scriptdir = os.path.dirname(os.path.abspath(__file__))
    init_py_path = os.path.join(scriptdir, "loggertodb", "__init__.py")
    with open(init_py_path) as f:
        return re.search(r'^__version__ = "(.*?)"$', f.read(), re.MULTILINE).group(1)


setup(
    author="Antonis Christofides",
    author_email="antonis@antonischristofides.com",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Natural Language :: English",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
    ],
    description="Insert meteorological station data to Enhydris",
    entry_points={"console_scripts": ["loggertodb=loggertodb.cli:main"]},
    install_requires=requirements,
    license="GNU General Public License v3",
    long_description=readme,
    long_description_content_type="text/x-rst",
    include_package_data=True,
    keywords="loggertodb",
    name="loggertodb",
    packages=find_packages(include=["loggertodb"]),
    setup_requires=setup_requirements,
    test_suite="tests",
    tests_require=test_requirements,
    url="https://github.com/aptiko/loggertodb",
    version=get_version(),
    zip_safe=False,
)
