# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['condacolab']
setup_kwargs = {
    'name': 'condacolab',
    'version': '0.1.3',
    'description': 'Install Conda and friends on Google Colab, easily',
    'long_description': '# condacolab\n\n[![Downloads](https://pepy.tech/badge/condacolab/week)](https://pypi.org/project/condacolab)\n[![Downloads](https://pepy.tech/badge/condacolab/month)](https://pypi.org/project/condacolab)\n[![Downloads](https://pepy.tech/badge/condacolab)](https://pypi.org/project/condacolab)\n\nInstall Conda and friends on Google Colab, easily.\n\n![CondaColab](https://github.com/jaimergp/condacolab/raw/main/condacolab.png)\n\n## Usage\n\n> **TLDR**: Check the [example notebook here](https://colab.research.google.com/drive/1c_RGCgQeLHVXlF44LyOFjfUW32CmG6BP)!\n\nOn your Colab notebook, run the following code as the _first executable cell_:\n\n```python\n!pip install -q condacolab\nimport condacolab\ncondacolab.install()\n```\n\nAfter the kernel restart, you can optionally add a new cell to check that everything is in place:\n\n```python\nimport condacolab\ncondacolab.check()\n```\n\n> It is important that you perform the installation first thing in the notebook because it will require a kernel restart, thus resetting the variables set up to that point.\n\nThe default `condacolab.install()` provides Mambaforge, but there are other `conda` distributions to choose from:\n\n- `install_anaconda()`: This will install the Anaconda 2020.02 distribution, the last version that was built for Python 3.7. This contains [plenty of data science packages](https://docs.anaconda.com/anaconda/packages/old-pkg-lists/2020.02/py3.7_linux-64/), but they might be outdated by now.\n- `install_miniconda()`: This will install the Miniconda 4.9.2 distribution, using a version built for Python 3.7. Unlike Anaconda, this distribution only contains `python` and `conda`.\n- `install_miniforge()`: Like Miniconda, but built off `conda-forge` packages. The Miniforge distribution is officially provided by [conda-forge](https://github.com/conda-forge/miniforge) but I [forked and patched it](https://github.com/jaimergp/miniforge) so it\'s built for Python 3.7.\n- `install_mambaforge()`: Like Miniforge, but with `mamba` included. The Mambaforge distribution is officially provided by [conda-forge](https://github.com/conda-forge/miniforge) but I [forked and patched it](https://github.com/jaimergp/miniforge) so it\'s built for Python 3.7.\n\nFor advanced users, `install_from_url()` is also available. It expects a URL pointing to a [`constructor`-like installer](https://github.com/conda/constructor), so you can prebuild a Python 3.7 distribution that fulfills your own needs.\n\n> If you want to build your own `constructor`-based installer, check the FAQ below!\n\nOnce the installation is done, you can use `conda` and/or `mamba` to install the needed packages:\n\n```bash\n!conda install openmm\n\n# or, faster:\n!mamba install openmm\n```\n\nIf you have a environment file (e.g. `environment.yml`), you can use it like this:\n\n```bash\n!conda env update -n base -f environment.yml\n\n# or, faster:\n!mamba env update -n base -f environment.yml\n```\n\n\n## Shortcomings\n\n- The Python kernel needs to be restarted for changes to be applied. This happens automatically. If you are wondering why you are seeing a message saying _"Your session crashed for an unknown reason"_, this is why. You can safely ignore this message!\n- You can only use the `base` environment, so do not try to create more environments with `conda create`.\n\n## FAQ\n\n### How does it work\n\nGoogle Colab runs on Python 3.7. We install the Miniconda distribution on top of the existing one at `/usr/local`, add a few configuration files so we stay with Python 3.7 (`conda` auto updates by default) and the newly installed packages are available. Finally, we wrap the Python executable to redirect and inject some environment variables needed to load the new libraries. Since we need to re-read `LD_LIBRARY_PATH`, a kernel restart is needed.\n\n### How can I cache my installation? I don\'t want to wait every time I start Colab.\n\nThe recommended approach is to build your own `constructor`-based installer. We have provided an example in `constructor-example/construct.yaml`.\n\n> You can generate a `constructor` installer on Colab too! Follow [this tutorial](https://colab.research.google.com/github/jaimergp/condacolab/blob/main/constructor-example/condacolab_constructor_tutorial.ipynb).\n\nLocally, follow these steps:\n\n1. In your local computer:\n\n```bash\nconda create -n constructor -c conda-forge constructor\nconda activate constructor\nmkdir my-installer\ncd my-installer\ncurl -sLO https://raw.githubusercontent.com/jaimergp/condacolab/main/constructor-example/construct.yaml\ncurl -sLO https://raw.githubusercontent.com/jaimergp/condacolab/main/constructor-example/pip-dependencies.sh\n```\n\n2. Add your `conda` packages to `construct.yaml` in the `specs` section. Read the comments to respect the constrains already present! You can also adapt the metadata to your liking.\n3. If you _do_ need to install `pip` requirements, uncomment the `post_install` line and edit `pip-dependencies.sh`.\n4. Run `constructor --platform linux-64 .`\n5. Upload the resulting `.sh` to an online location with a permanent URL. GitHub Releases is great for this!\n6. In Colab, run:\n\n```python\n!pip install -q condacolab\nimport condacolab\ncondacolab.install_from_url(URL_TO_YOUR_CUSTOM_CONSTRUCTOR_INSTALLER)\n```\n',
    'author': 'Jaime Rodríguez-Guerra',
    'author_email': 'jaimergp@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jaimergp/condacolab',
    'py_modules': modules,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
