"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Queue = exports.QueueProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const mns_generated_1 = require("./mns.generated");
Object.defineProperty(exports, "QueueProperty", { enumerable: true, get: function () { return mns_generated_1.RosQueue; } });
/**
 * A ROS resource type:  `ALIYUN::MNS::Queue`
 */
class Queue extends ros.Resource {
    /**
     * Create a new `ALIYUN::MNS::Queue`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosQueue = new mns_generated_1.RosQueue(this, id, {
            delaySeconds: props.delaySeconds === undefined || props.delaySeconds === null ? 0 : props.delaySeconds,
            pollingWaitSeconds: props.pollingWaitSeconds === undefined || props.pollingWaitSeconds === null ? 0 : props.pollingWaitSeconds,
            messageRetentionPeriod: props.messageRetentionPeriod === undefined || props.messageRetentionPeriod === null ? 345600 : props.messageRetentionPeriod,
            maximumMessageSize: props.maximumMessageSize === undefined || props.maximumMessageSize === null ? 65536 : props.maximumMessageSize,
            visibilityTimeout: props.visibilityTimeout === undefined || props.visibilityTimeout === null ? 30 : props.visibilityTimeout,
            queueName: props.queueName,
            loggingEnabled: props.loggingEnabled === undefined || props.loggingEnabled === null ? false : props.loggingEnabled,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosQueue;
        this.attrArnWithSlash = rosQueue.attrArnWithSlash;
        this.attrQueueName = rosQueue.attrQueueName;
        this.attrQueueUrl = rosQueue.attrQueueUrl;
    }
}
exports.Queue = Queue;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicXVldWUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJxdWV1ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQTJDO0FBRXRCLDhGQUZaLHdCQUFRLE9BRWlCO0FBaURsQzs7R0FFRztBQUNILE1BQWEsS0FBTSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBc0JuQzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQWlCLEVBQUUsbUNBQTJDLElBQUk7UUFDNUcsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLFFBQVEsR0FBRyxJQUFJLHdCQUFRLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUNyQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVksS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLFlBQVksS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFlBQVk7WUFDdEcsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsa0JBQWtCLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxrQkFBa0I7WUFDOUgsc0JBQXNCLEVBQUUsS0FBSyxDQUFDLHNCQUFzQixLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsc0JBQXNCLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxzQkFBc0I7WUFDbkosa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsa0JBQWtCLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxrQkFBa0I7WUFDbEksaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsaUJBQWlCLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxpQkFBaUI7WUFDM0gsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYyxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsY0FBYyxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsY0FBYztTQUNySCxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztRQUN6QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsUUFBUSxDQUFDLGdCQUFnQixDQUFDO1FBQ2xELElBQUksQ0FBQyxhQUFhLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQztRQUM1QyxJQUFJLENBQUMsWUFBWSxHQUFHLFFBQVEsQ0FBQyxZQUFZLENBQUM7SUFDOUMsQ0FBQztDQUNKO0FBOUNELHNCQThDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc1F1ZXVlIH0gZnJvbSAnLi9tbnMuZ2VuZXJhdGVkJztcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuZXhwb3J0IHsgUm9zUXVldWUgYXMgUXVldWVQcm9wZXJ0eSB9O1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6TU5TOjpRdWV1ZWBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBRdWV1ZVByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHF1ZXVlTmFtZTogUXVldWUgbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHF1ZXVlTmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGVsYXlTZWNvbmRzOiBJdCBpcyBtZWFzdXJlZCBpbiBzZWNvbmRzLiBBbGwgbWVzc2FnZXMgc2VudCB0byB0aGUgcXVldWUgY2FuIGJlIGNvbnN1bWVkIHVudGlsIHRoZSBEZWxheVNlY29uZHMgZXhwaXJlcy5cbiAgICAgKiBBbiBpbnRlZ2VyIGJldHdlZW4gMCBhbmQgNjA0ODAwICg3IGRheXMpLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyAwXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVsYXlTZWNvbmRzPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgbG9nZ2luZ0VuYWJsZWQ6IFdoZXRoZXIgdG8gZW5hYmxlIGxvZyBtYW5hZ2VtZW50LiBcInRydWVcIiBpbmRpY2F0ZXMgdGhhdCBsb2cgbWFuYWdlbWVudCBpcyBlbmFibGVkLCB3aGVyZWFzIFwiZmFsc2VcIiBpbmRpY2F0ZXMgdGhhdCBsb2cgbWFuYWdlbWVudCBpcyBkaXNhYmxlZC4gXG4gICAgICogVGhlIGRlZmF1bHQgdmFsdWUgaXMgZmFsc2VcbiAgICAgKi9cbiAgICByZWFkb25seSBsb2dnaW5nRW5hYmxlZD86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBtYXhpbXVtTWVzc2FnZVNpemU6IE1heGltdW0gYm9keSBsZW5ndGggb2YgYSBtZXNzYWdlIHNlbnQgdG8gdGhlIHF1ZXVlLCBtZWFzdXJlZCBpbiBieXRlcy5cbiAgICAgKiBBbiBpbnRlZ2VyIGJldHdlZW4gMTAyNCAoMUspIGFuZCA2NTUzNiAoNjRLKS4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgNjU1MzYgKDY0SykuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWF4aW11bU1lc3NhZ2VTaXplPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgbWVzc2FnZVJldGVudGlvblBlcmlvZDogTWF4aW11bSBsaWZldGltZSBvZiB0aGUgbWVzc2FnZSBpbiB0aGUgcXVldWUsIG1lYXN1cmVkIGluIHNlY29uZHMuIEFmdGVyIHRoZSB0aW1lIHNwZWNpZmllZCBieSB0aGlzIHBhcmFtZXRlciBleHBpcmVzLCB0aGUgbWVzc2FnZSB3aWxsIGJlIGRlbGV0ZWQgbm8gbWF0dGVyIHdoZXRoZXIgaXQgaGFzIGJlZW4gY29uc3VtZWQgb3Igbm90LlxuICAgICAqIEFuIGludGVnZXIgYmV0d2VlbiA2MCAoMSBtaW51dGUpIGFuZCAxMjk2MDAwICgxNSBkYXlzKS4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgMzQ1NjAwICg0IGRheXMpXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWVzc2FnZVJldGVudGlvblBlcmlvZD86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHBvbGxpbmdXYWl0U2Vjb25kczogSXQgaXMgdGhlIG1heGltdW0gdGltZSB0aGF0IGEgUmVjZWl2ZU1lc3NhZ2UgcmVxdWVzdCBjb3VsZCBiZSB3YWl0aW5nIGZvciBhbnkgaW5jb21pbmcgbWVzc2FnZXMsIHdoaWxlIHRoZXJlIGFyZSBubyBtZXNzYWdlIGluIHRoZSBxdWV1ZS4gTWVhc3VyZWQgaW4gc2Vjb25kcy5cbiAgICAgKiBBbiBpbnRlZ2VyIGJldHdlZW4gMCBhbmQgMzAgc2Vjb25kcy4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgMCAoc2Vjb25kcylcbiAgICAgKi9cbiAgICByZWFkb25seSBwb2xsaW5nV2FpdFNlY29uZHM/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2aXNpYmlsaXR5VGltZW91dDogRHVyYXRpb24gaW4gd2hpY2ggYSBtZXNzYWdlIHN0YXlzIGluIEluYWN0aXZlIHN0YXR1cyBhZnRlciBpdCBpcyBjb25zdW1lZCBmcm9tIHRoZSBxdWV1ZS4gTWVhc3VyZWQgaW4gc2Vjb25kcy5cbiAgICAgKiBBbiBpbnRlZ2VyIGJldHdlZW4gMSBhbmQgNDMyMDAgKDEyIGhvdXJzKS4gVGhlIGRlZmF1bHQgdmFsdWUgaXMgMzAgKHNlY29uZHMpXG4gICAgICovXG4gICAgcmVhZG9ubHkgdmlzaWJpbGl0eVRpbWVvdXQ/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogQSBST1MgcmVzb3VyY2UgdHlwZTogIGBBTElZVU46Ok1OUzo6UXVldWVgXG4gKi9cbmV4cG9ydCBjbGFzcyBRdWV1ZSBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgcHJvcGVydGllcyBvZiB0aGlzIFJPUyByZXNvdXJjZSwgd2hpY2ggd2lsbCBiZSBhc3NpZ25lZCB0byBST1MgcmVzb3VyY2UuXG4gICAgICovXG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgQVJOLldpdGhTbGFzaDogVGhlIEFSTjogYWNzOm1uczokcmVnaW9uOiRhY2NvdW50aWQ6L3F1ZXVlcy8kcXVldWVOYW1lXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJBcm5XaXRoU2xhc2g6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBRdWV1ZU5hbWU6IFF1ZXVlIG5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clF1ZXVlTmFtZTogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFF1ZXVlVXJsOiBVUkwgb2YgY3JlYXRlZCBxdWV1ZVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyUXVldWVVcmw6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpNTlM6OlF1ZXVlYC5cbiAgICAgKlxuICAgICAqIFBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogUGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogUGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBRdWV1ZVByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgICAgIGNvbnN0IHJvc1F1ZXVlID0gbmV3IFJvc1F1ZXVlKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgZGVsYXlTZWNvbmRzOiBwcm9wcy5kZWxheVNlY29uZHMgPT09IHVuZGVmaW5lZCB8fCBwcm9wcy5kZWxheVNlY29uZHMgPT09IG51bGwgPyAwIDogcHJvcHMuZGVsYXlTZWNvbmRzLFxuICAgICAgICAgICAgcG9sbGluZ1dhaXRTZWNvbmRzOiBwcm9wcy5wb2xsaW5nV2FpdFNlY29uZHMgPT09IHVuZGVmaW5lZCB8fCBwcm9wcy5wb2xsaW5nV2FpdFNlY29uZHMgPT09IG51bGwgPyAwIDogcHJvcHMucG9sbGluZ1dhaXRTZWNvbmRzLFxuICAgICAgICAgICAgbWVzc2FnZVJldGVudGlvblBlcmlvZDogcHJvcHMubWVzc2FnZVJldGVudGlvblBlcmlvZCA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLm1lc3NhZ2VSZXRlbnRpb25QZXJpb2QgPT09IG51bGwgPyAzNDU2MDAgOiBwcm9wcy5tZXNzYWdlUmV0ZW50aW9uUGVyaW9kLFxuICAgICAgICAgICAgbWF4aW11bU1lc3NhZ2VTaXplOiBwcm9wcy5tYXhpbXVtTWVzc2FnZVNpemUgPT09IHVuZGVmaW5lZCB8fCBwcm9wcy5tYXhpbXVtTWVzc2FnZVNpemUgPT09IG51bGwgPyA2NTUzNiA6IHByb3BzLm1heGltdW1NZXNzYWdlU2l6ZSxcbiAgICAgICAgICAgIHZpc2liaWxpdHlUaW1lb3V0OiBwcm9wcy52aXNpYmlsaXR5VGltZW91dCA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLnZpc2liaWxpdHlUaW1lb3V0ID09PSBudWxsID8gMzAgOiBwcm9wcy52aXNpYmlsaXR5VGltZW91dCxcbiAgICAgICAgICAgIHF1ZXVlTmFtZTogcHJvcHMucXVldWVOYW1lLFxuICAgICAgICAgICAgbG9nZ2luZ0VuYWJsZWQ6IHByb3BzLmxvZ2dpbmdFbmFibGVkID09PSB1bmRlZmluZWQgfHwgcHJvcHMubG9nZ2luZ0VuYWJsZWQgPT09IG51bGwgPyBmYWxzZSA6IHByb3BzLmxvZ2dpbmdFbmFibGVkLFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc1F1ZXVlO1xuICAgICAgICB0aGlzLmF0dHJBcm5XaXRoU2xhc2ggPSByb3NRdWV1ZS5hdHRyQXJuV2l0aFNsYXNoO1xuICAgICAgICB0aGlzLmF0dHJRdWV1ZU5hbWUgPSByb3NRdWV1ZS5hdHRyUXVldWVOYW1lO1xuICAgICAgICB0aGlzLmF0dHJRdWV1ZVVybCA9IHJvc1F1ZXVlLmF0dHJRdWV1ZVVybDtcbiAgICB9XG59XG4iXX0=