# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, Any


class AddAttendeeHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class AddAttendeeHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: AddAttendeeHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = AddAttendeeHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class AddAttendeeShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class AddAttendeeRequestAttendeesToAdd(TeaModel):
    def __init__(
        self,
        id: str = None,
        is_optional: bool = None,
    ):
        self.id = id
        self.is_optional = is_optional

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.is_optional is not None:
            result['isOptional'] = self.is_optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('isOptional') is not None:
            self.is_optional = m.get('isOptional')
        return self


class AddAttendeeRequest(TeaModel):
    def __init__(
        self,
        attendees_to_add: List[AddAttendeeRequestAttendeesToAdd] = None,
        calendar_id: str = None,
        event_id: str = None,
        chat_notification: bool = None,
        push_notification: bool = None,
    ):
        self.attendees_to_add = attendees_to_add
        self.calendar_id = calendar_id
        self.event_id = event_id
        self.chat_notification = chat_notification
        self.push_notification = push_notification

    def validate(self):
        if self.attendees_to_add:
            for k in self.attendees_to_add:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttendeesToAdd'] = []
        if self.attendees_to_add is not None:
            for k in self.attendees_to_add:
                result['AttendeesToAdd'].append(k.to_map() if k else None)
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.chat_notification is not None:
            result['chatNotification'] = self.chat_notification
        if self.push_notification is not None:
            result['pushNotification'] = self.push_notification
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attendees_to_add = []
        if m.get('AttendeesToAdd') is not None:
            for k in m.get('AttendeesToAdd'):
                temp_model = AddAttendeeRequestAttendeesToAdd()
                self.attendees_to_add.append(temp_model.from_map(k))
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('chatNotification') is not None:
            self.chat_notification = m.get('chatNotification')
        if m.get('pushNotification') is not None:
            self.push_notification = m.get('pushNotification')
        return self


class AddAttendeeShrinkRequest(TeaModel):
    def __init__(
        self,
        attendees_to_add_shrink: str = None,
        calendar_id: str = None,
        event_id: str = None,
        chat_notification: bool = None,
        push_notification: bool = None,
    ):
        self.attendees_to_add_shrink = attendees_to_add_shrink
        self.calendar_id = calendar_id
        self.event_id = event_id
        self.chat_notification = chat_notification
        self.push_notification = push_notification

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attendees_to_add_shrink is not None:
            result['AttendeesToAdd'] = self.attendees_to_add_shrink
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.chat_notification is not None:
            result['chatNotification'] = self.chat_notification
        if self.push_notification is not None:
            result['pushNotification'] = self.push_notification
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttendeesToAdd') is not None:
            self.attendees_to_add_shrink = m.get('AttendeesToAdd')
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('chatNotification') is not None:
            self.chat_notification = m.get('chatNotification')
        if m.get('pushNotification') is not None:
            self.push_notification = m.get('pushNotification')
        return self


class AddAttendeeResponseBodyContent(TeaModel):
    def __init__(
        self,
        data: Any = None,
    ):
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class AddAttendeeResponseBody(TeaModel):
    def __init__(
        self,
        content: AddAttendeeResponseBodyContent = None,
        error_code: str = None,
        error_ctx: Dict[str, Any] = None,
        error_msg: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.content = content
        self.error_code = error_code
        self.error_ctx = error_ctx
        self.error_msg = error_msg
        self.http_status_code = http_status_code
        # RequestId
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_ctx is not None:
            result['ErrorCtx'] = self.error_ctx
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = AddAttendeeResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorCtx') is not None:
            self.error_ctx = m.get('ErrorCtx')
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddAttendeeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddAttendeeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAttendeeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMeetingRoomsHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class AddMeetingRoomsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: AddMeetingRoomsHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = AddMeetingRoomsHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class AddMeetingRoomsShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class AddMeetingRoomsRequestMeetingRoomsToAdd(TeaModel):
    def __init__(
        self,
        room_id: str = None,
    ):
        self.room_id = room_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class AddMeetingRoomsRequest(TeaModel):
    def __init__(
        self,
        calendar_id: str = None,
        event_id: str = None,
        meeting_rooms_to_add: List[AddMeetingRoomsRequestMeetingRoomsToAdd] = None,
    ):
        self.calendar_id = calendar_id
        self.event_id = event_id
        self.meeting_rooms_to_add = meeting_rooms_to_add

    def validate(self):
        if self.meeting_rooms_to_add:
            for k in self.meeting_rooms_to_add:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        result['MeetingRoomsToAdd'] = []
        if self.meeting_rooms_to_add is not None:
            for k in self.meeting_rooms_to_add:
                result['MeetingRoomsToAdd'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        self.meeting_rooms_to_add = []
        if m.get('MeetingRoomsToAdd') is not None:
            for k in m.get('MeetingRoomsToAdd'):
                temp_model = AddMeetingRoomsRequestMeetingRoomsToAdd()
                self.meeting_rooms_to_add.append(temp_model.from_map(k))
        return self


class AddMeetingRoomsShrinkRequest(TeaModel):
    def __init__(
        self,
        calendar_id: str = None,
        event_id: str = None,
        meeting_rooms_to_add_shrink: str = None,
    ):
        self.calendar_id = calendar_id
        self.event_id = event_id
        self.meeting_rooms_to_add_shrink = meeting_rooms_to_add_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.meeting_rooms_to_add_shrink is not None:
            result['MeetingRoomsToAdd'] = self.meeting_rooms_to_add_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('MeetingRoomsToAdd') is not None:
            self.meeting_rooms_to_add_shrink = m.get('MeetingRoomsToAdd')
        return self


class AddMeetingRoomsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: bool = None,
    ):
        # requestId
        self.request_id = request_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class AddMeetingRoomsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddMeetingRoomsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMeetingRoomsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddScenegroupMemberHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class AddScenegroupMemberHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: AddScenegroupMemberHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = AddScenegroupMemberHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class AddScenegroupMemberShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class AddScenegroupMemberRequest(TeaModel):
    def __init__(
        self,
        open_conversation_id: str = None,
        user_ids: str = None,
    ):
        self.open_conversation_id = open_conversation_id
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.open_conversation_id is not None:
            result['OpenConversationId'] = self.open_conversation_id
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OpenConversationId') is not None:
            self.open_conversation_id = m.get('OpenConversationId')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class AddScenegroupMemberResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # requestId
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddScenegroupMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddScenegroupMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddScenegroupMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddWorkspaceHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class AddWorkspaceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: AddWorkspaceHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = AddWorkspaceHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class AddWorkspaceShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class AddWorkspaceRequestOption(TeaModel):
    def __init__(
        self,
        description: str = None,
        team_id: str = None,
    ):
        self.description = description
        self.team_id = team_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.team_id is not None:
            result['TeamId'] = self.team_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('TeamId') is not None:
            self.team_id = m.get('TeamId')
        return self


class AddWorkspaceRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class AddWorkspaceRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        option: AddWorkspaceRequestOption = None,
        tenant_context: AddWorkspaceRequestTenantContext = None,
    ):
        self.name = name
        self.option = option
        self.tenant_context = tenant_context

    def validate(self):
        if self.option:
            self.option.validate()
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.option is not None:
            result['Option'] = self.option.to_map()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Option') is not None:
            temp_model = AddWorkspaceRequestOption()
            self.option = temp_model.from_map(m['Option'])
        if m.get('TenantContext') is not None:
            temp_model = AddWorkspaceRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class AddWorkspaceShrinkRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        option_shrink: str = None,
        tenant_context_shrink: str = None,
    ):
        self.name = name
        self.option_shrink = option_shrink
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.option_shrink is not None:
            result['Option'] = self.option_shrink
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Option') is not None:
            self.option_shrink = m.get('Option')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class AddWorkspaceResponseBodyWorkspaceIcon(TeaModel):
    def __init__(
        self,
        type: str = None,
        value: str = None,
    ):
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddWorkspaceResponseBodyWorkspace(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        cover: str = None,
        create_time: str = None,
        creator_id: str = None,
        description: str = None,
        icon: AddWorkspaceResponseBodyWorkspaceIcon = None,
        modified_time: str = None,
        modifier_id: str = None,
        name: str = None,
        permission_role: str = None,
        root_node_id: str = None,
        team_id: str = None,
        type: str = None,
        url: str = None,
        workspace_id: str = None,
    ):
        self.corp_id = corp_id
        self.cover = cover
        self.create_time = create_time
        self.creator_id = creator_id
        self.description = description
        self.icon = icon
        self.modified_time = modified_time
        self.modifier_id = modifier_id
        self.name = name
        self.permission_role = permission_role
        self.root_node_id = root_node_id
        self.team_id = team_id
        self.type = type
        self.url = url
        self.workspace_id = workspace_id

    def validate(self):
        if self.icon:
            self.icon.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.cover is not None:
            result['Cover'] = self.cover
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.description is not None:
            result['Description'] = self.description
        if self.icon is not None:
            result['Icon'] = self.icon.to_map()
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.modifier_id is not None:
            result['ModifierId'] = self.modifier_id
        if self.name is not None:
            result['Name'] = self.name
        if self.permission_role is not None:
            result['PermissionRole'] = self.permission_role
        if self.root_node_id is not None:
            result['RootNodeId'] = self.root_node_id
        if self.team_id is not None:
            result['TeamId'] = self.team_id
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('Cover') is not None:
            self.cover = m.get('Cover')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Icon') is not None:
            temp_model = AddWorkspaceResponseBodyWorkspaceIcon()
            self.icon = temp_model.from_map(m['Icon'])
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ModifierId') is not None:
            self.modifier_id = m.get('ModifierId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PermissionRole') is not None:
            self.permission_role = m.get('PermissionRole')
        if m.get('RootNodeId') is not None:
            self.root_node_id = m.get('RootNodeId')
        if m.get('TeamId') is not None:
            self.team_id = m.get('TeamId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AddWorkspaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        workspace: AddWorkspaceResponseBodyWorkspace = None,
    ):
        # requestId
        self.request_id = request_id
        self.workspace = workspace

    def validate(self):
        if self.workspace:
            self.workspace.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.workspace is not None:
            result['workspace'] = self.workspace.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('workspace') is not None:
            temp_model = AddWorkspaceResponseBodyWorkspace()
            self.workspace = temp_model.from_map(m['workspace'])
        return self


class AddWorkspaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddWorkspaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddWorkspaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddWorkspaceDocMembersHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class AddWorkspaceDocMembersHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: AddWorkspaceDocMembersHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = AddWorkspaceDocMembersHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class AddWorkspaceDocMembersShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class AddWorkspaceDocMembersRequestMembers(TeaModel):
    def __init__(
        self,
        member_id: str = None,
        member_type: str = None,
        role_type: str = None,
    ):
        self.member_id = member_id
        self.member_type = member_type
        self.role_type = role_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_type is not None:
            result['MemberType'] = self.member_type
        if self.role_type is not None:
            result['RoleType'] = self.role_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberType') is not None:
            self.member_type = m.get('MemberType')
        if m.get('RoleType') is not None:
            self.role_type = m.get('RoleType')
        return self


class AddWorkspaceDocMembersRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class AddWorkspaceDocMembersRequest(TeaModel):
    def __init__(
        self,
        members: List[AddWorkspaceDocMembersRequestMembers] = None,
        node_id: str = None,
        tenant_context: AddWorkspaceDocMembersRequestTenantContext = None,
        workspace_id: str = None,
    ):
        self.members = members
        self.node_id = node_id
        self.tenant_context = tenant_context
        self.workspace_id = workspace_id

    def validate(self):
        if self.members:
            for k in self.members:
                if k:
                    k.validate()
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Members'] = []
        if self.members is not None:
            for k in self.members:
                result['Members'].append(k.to_map() if k else None)
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.members = []
        if m.get('Members') is not None:
            for k in m.get('Members'):
                temp_model = AddWorkspaceDocMembersRequestMembers()
                self.members.append(temp_model.from_map(k))
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TenantContext') is not None:
            temp_model = AddWorkspaceDocMembersRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AddWorkspaceDocMembersShrinkRequest(TeaModel):
    def __init__(
        self,
        members_shrink: str = None,
        node_id: str = None,
        tenant_context_shrink: str = None,
        workspace_id: str = None,
    ):
        self.members_shrink = members_shrink
        self.node_id = node_id
        self.tenant_context_shrink = tenant_context_shrink
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.members_shrink is not None:
            result['Members'] = self.members_shrink
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Members') is not None:
            self.members_shrink = m.get('Members')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AddWorkspaceDocMembersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class AddWorkspaceDocMembersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddWorkspaceDocMembersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddWorkspaceDocMembersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddWorkspaceMembersHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class AddWorkspaceMembersHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: AddWorkspaceMembersHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = AddWorkspaceMembersHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class AddWorkspaceMembersShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class AddWorkspaceMembersRequestMembers(TeaModel):
    def __init__(
        self,
        member_id: str = None,
        member_type: str = None,
        role_type: str = None,
    ):
        self.member_id = member_id
        self.member_type = member_type
        self.role_type = role_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_type is not None:
            result['MemberType'] = self.member_type
        if self.role_type is not None:
            result['RoleType'] = self.role_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberType') is not None:
            self.member_type = m.get('MemberType')
        if m.get('RoleType') is not None:
            self.role_type = m.get('RoleType')
        return self


class AddWorkspaceMembersRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class AddWorkspaceMembersRequest(TeaModel):
    def __init__(
        self,
        members: List[AddWorkspaceMembersRequestMembers] = None,
        tenant_context: AddWorkspaceMembersRequestTenantContext = None,
        workspace_id: str = None,
    ):
        self.members = members
        self.tenant_context = tenant_context
        self.workspace_id = workspace_id

    def validate(self):
        if self.members:
            for k in self.members:
                if k:
                    k.validate()
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Members'] = []
        if self.members is not None:
            for k in self.members:
                result['Members'].append(k.to_map() if k else None)
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.members = []
        if m.get('Members') is not None:
            for k in m.get('Members'):
                temp_model = AddWorkspaceMembersRequestMembers()
                self.members.append(temp_model.from_map(k))
        if m.get('TenantContext') is not None:
            temp_model = AddWorkspaceMembersRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AddWorkspaceMembersShrinkRequest(TeaModel):
    def __init__(
        self,
        members_shrink: str = None,
        tenant_context_shrink: str = None,
        workspace_id: str = None,
    ):
        self.members_shrink = members_shrink
        self.tenant_context_shrink = tenant_context_shrink
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.members_shrink is not None:
            result['Members'] = self.members_shrink
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Members') is not None:
            self.members_shrink = m.get('Members')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class AddWorkspaceMembersResponseBody(TeaModel):
    def __init__(
        self,
        not_in_org_list: List[str] = None,
        request_id: str = None,
    ):
        self.not_in_org_list = not_in_org_list
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.not_in_org_list is not None:
            result['NotInOrgList'] = self.not_in_org_list
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NotInOrgList') is not None:
            self.not_in_org_list = m.get('NotInOrgList')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class AddWorkspaceMembersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddWorkspaceMembersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddWorkspaceMembersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetFormDataByIdListHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class BatchGetFormDataByIdListHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: BatchGetFormDataByIdListHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = BatchGetFormDataByIdListHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class BatchGetFormDataByIdListShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class BatchGetFormDataByIdListRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        form_instance_id_list: List[str] = None,
        form_uuid: str = None,
        need_form_instance_value: bool = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.form_instance_id_list = form_instance_id_list
        self.form_uuid = form_uuid
        self.need_form_instance_value = need_form_instance_value
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.form_instance_id_list is not None:
            result['FormInstanceIdList'] = self.form_instance_id_list
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.need_form_instance_value is not None:
            result['NeedFormInstanceValue'] = self.need_form_instance_value
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FormInstanceIdList') is not None:
            self.form_instance_id_list = m.get('FormInstanceIdList')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('NeedFormInstanceValue') is not None:
            self.need_form_instance_value = m.get('NeedFormInstanceValue')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class BatchGetFormDataByIdListShrinkRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        form_instance_id_list_shrink: str = None,
        form_uuid: str = None,
        need_form_instance_value: bool = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.form_instance_id_list_shrink = form_instance_id_list_shrink
        self.form_uuid = form_uuid
        self.need_form_instance_value = need_form_instance_value
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.form_instance_id_list_shrink is not None:
            result['FormInstanceIdList'] = self.form_instance_id_list_shrink
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.need_form_instance_value is not None:
            result['NeedFormInstanceValue'] = self.need_form_instance_value
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FormInstanceIdList') is not None:
            self.form_instance_id_list_shrink = m.get('FormInstanceIdList')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('NeedFormInstanceValue') is not None:
            self.need_form_instance_value = m.get('NeedFormInstanceValue')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class BatchGetFormDataByIdListResponseBodyResultModifyUserName(TeaModel):
    def __init__(
        self,
        name_in_chinese: str = None,
        name_in_english: str = None,
    ):
        self.name_in_chinese = name_in_chinese
        self.name_in_english = name_in_english

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_in_chinese is not None:
            result['NameInChinese'] = self.name_in_chinese
        if self.name_in_english is not None:
            result['NameInEnglish'] = self.name_in_english
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameInChinese') is not None:
            self.name_in_chinese = m.get('NameInChinese')
        if m.get('NameInEnglish') is not None:
            self.name_in_english = m.get('NameInEnglish')
        return self


class BatchGetFormDataByIdListResponseBodyResultModifyUser(TeaModel):
    def __init__(
        self,
        name: BatchGetFormDataByIdListResponseBodyResultModifyUserName = None,
        user_id: str = None,
    ):
        self.name = name
        self.user_id = user_id

    def validate(self):
        if self.name:
            self.name.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name.to_map()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            temp_model = BatchGetFormDataByIdListResponseBodyResultModifyUserName()
            self.name = temp_model.from_map(m['Name'])
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BatchGetFormDataByIdListResponseBodyResultOriginatorName(TeaModel):
    def __init__(
        self,
        name_in_chinese: str = None,
        name_in_english: str = None,
    ):
        self.name_in_chinese = name_in_chinese
        self.name_in_english = name_in_english

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_in_chinese is not None:
            result['NameInChinese'] = self.name_in_chinese
        if self.name_in_english is not None:
            result['NameInEnglish'] = self.name_in_english
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameInChinese') is not None:
            self.name_in_chinese = m.get('NameInChinese')
        if m.get('NameInEnglish') is not None:
            self.name_in_english = m.get('NameInEnglish')
        return self


class BatchGetFormDataByIdListResponseBodyResultOriginator(TeaModel):
    def __init__(
        self,
        name: BatchGetFormDataByIdListResponseBodyResultOriginatorName = None,
        user_id: str = None,
    ):
        self.name = name
        self.user_id = user_id

    def validate(self):
        if self.name:
            self.name.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name.to_map()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            temp_model = BatchGetFormDataByIdListResponseBodyResultOriginatorName()
            self.name = temp_model.from_map(m['Name'])
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class BatchGetFormDataByIdListResponseBodyResult(TeaModel):
    def __init__(
        self,
        create_time_gmt: str = None,
        creator_user_id: str = None,
        form_data: Dict[str, Any] = None,
        form_instance_id: str = None,
        form_uuid: str = None,
        id: int = None,
        instance_value: str = None,
        modified_time_gmt: str = None,
        modifier: str = None,
        modify_user: BatchGetFormDataByIdListResponseBodyResultModifyUser = None,
        originator: BatchGetFormDataByIdListResponseBodyResultOriginator = None,
        sequence: str = None,
        serial_number: str = None,
        title: str = None,
        version: int = None,
    ):
        self.create_time_gmt = create_time_gmt
        self.creator_user_id = creator_user_id
        self.form_data = form_data
        self.form_instance_id = form_instance_id
        self.form_uuid = form_uuid
        self.id = id
        self.instance_value = instance_value
        self.modified_time_gmt = modified_time_gmt
        self.modifier = modifier
        self.modify_user = modify_user
        self.originator = originator
        self.sequence = sequence
        self.serial_number = serial_number
        self.title = title
        self.version = version

    def validate(self):
        if self.modify_user:
            self.modify_user.validate()
        if self.originator:
            self.originator.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_gmt is not None:
            result['CreateTimeGMT'] = self.create_time_gmt
        if self.creator_user_id is not None:
            result['CreatorUserId'] = self.creator_user_id
        if self.form_data is not None:
            result['FormData'] = self.form_data
        if self.form_instance_id is not None:
            result['FormInstanceId'] = self.form_instance_id
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_value is not None:
            result['InstanceValue'] = self.instance_value
        if self.modified_time_gmt is not None:
            result['ModifiedTimeGMT'] = self.modified_time_gmt
        if self.modifier is not None:
            result['Modifier'] = self.modifier
        if self.modify_user is not None:
            result['ModifyUser'] = self.modify_user.to_map()
        if self.originator is not None:
            result['Originator'] = self.originator.to_map()
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.title is not None:
            result['Title'] = self.title
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimeGMT') is not None:
            self.create_time_gmt = m.get('CreateTimeGMT')
        if m.get('CreatorUserId') is not None:
            self.creator_user_id = m.get('CreatorUserId')
        if m.get('FormData') is not None:
            self.form_data = m.get('FormData')
        if m.get('FormInstanceId') is not None:
            self.form_instance_id = m.get('FormInstanceId')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceValue') is not None:
            self.instance_value = m.get('InstanceValue')
        if m.get('ModifiedTimeGMT') is not None:
            self.modified_time_gmt = m.get('ModifiedTimeGMT')
        if m.get('Modifier') is not None:
            self.modifier = m.get('Modifier')
        if m.get('ModifyUser') is not None:
            temp_model = BatchGetFormDataByIdListResponseBodyResultModifyUser()
            self.modify_user = temp_model.from_map(m['ModifyUser'])
        if m.get('Originator') is not None:
            temp_model = BatchGetFormDataByIdListResponseBodyResultOriginator()
            self.originator = temp_model.from_map(m['Originator'])
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class BatchGetFormDataByIdListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: List[BatchGetFormDataByIdListResponseBodyResult] = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.request_id = request_id
        self.result = result
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = BatchGetFormDataByIdListResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class BatchGetFormDataByIdListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchGetFormDataByIdListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetFormDataByIdListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchRemovalByFormInstanceIdListHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class BatchRemovalByFormInstanceIdListHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: BatchRemovalByFormInstanceIdListHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = BatchRemovalByFormInstanceIdListHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class BatchRemovalByFormInstanceIdListShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class BatchRemovalByFormInstanceIdListRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        asynchronous_execution: bool = None,
        execute_expression: bool = None,
        form_instance_id_list: List[str] = None,
        form_uuid: str = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.asynchronous_execution = asynchronous_execution
        self.execute_expression = execute_expression
        self.form_instance_id_list = form_instance_id_list
        self.form_uuid = form_uuid
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.asynchronous_execution is not None:
            result['AsynchronousExecution'] = self.asynchronous_execution
        if self.execute_expression is not None:
            result['ExecuteExpression'] = self.execute_expression
        if self.form_instance_id_list is not None:
            result['FormInstanceIdList'] = self.form_instance_id_list
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('AsynchronousExecution') is not None:
            self.asynchronous_execution = m.get('AsynchronousExecution')
        if m.get('ExecuteExpression') is not None:
            self.execute_expression = m.get('ExecuteExpression')
        if m.get('FormInstanceIdList') is not None:
            self.form_instance_id_list = m.get('FormInstanceIdList')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class BatchRemovalByFormInstanceIdListShrinkRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        asynchronous_execution: bool = None,
        execute_expression: bool = None,
        form_instance_id_list_shrink: str = None,
        form_uuid: str = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.asynchronous_execution = asynchronous_execution
        self.execute_expression = execute_expression
        self.form_instance_id_list_shrink = form_instance_id_list_shrink
        self.form_uuid = form_uuid
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.asynchronous_execution is not None:
            result['AsynchronousExecution'] = self.asynchronous_execution
        if self.execute_expression is not None:
            result['ExecuteExpression'] = self.execute_expression
        if self.form_instance_id_list_shrink is not None:
            result['FormInstanceIdList'] = self.form_instance_id_list_shrink
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('AsynchronousExecution') is not None:
            self.asynchronous_execution = m.get('AsynchronousExecution')
        if m.get('ExecuteExpression') is not None:
            self.execute_expression = m.get('ExecuteExpression')
        if m.get('FormInstanceIdList') is not None:
            self.form_instance_id_list_shrink = m.get('FormInstanceIdList')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class BatchRemovalByFormInstanceIdListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.request_id = request_id
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class BatchRemovalByFormInstanceIdListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchRemovalByFormInstanceIdListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchRemovalByFormInstanceIdListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSaveFormDataHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class BatchSaveFormDataHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: BatchSaveFormDataHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = BatchSaveFormDataHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class BatchSaveFormDataShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class BatchSaveFormDataRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        asynchronous_execution: bool = None,
        form_data_json_list: List[str] = None,
        form_uuid: str = None,
        keep_running_after_exception: bool = None,
        no_execute_expression: bool = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.asynchronous_execution = asynchronous_execution
        self.form_data_json_list = form_data_json_list
        self.form_uuid = form_uuid
        self.keep_running_after_exception = keep_running_after_exception
        self.no_execute_expression = no_execute_expression
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.asynchronous_execution is not None:
            result['AsynchronousExecution'] = self.asynchronous_execution
        if self.form_data_json_list is not None:
            result['FormDataJsonList'] = self.form_data_json_list
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.keep_running_after_exception is not None:
            result['KeepRunningAfterException'] = self.keep_running_after_exception
        if self.no_execute_expression is not None:
            result['NoExecuteExpression'] = self.no_execute_expression
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('AsynchronousExecution') is not None:
            self.asynchronous_execution = m.get('AsynchronousExecution')
        if m.get('FormDataJsonList') is not None:
            self.form_data_json_list = m.get('FormDataJsonList')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('KeepRunningAfterException') is not None:
            self.keep_running_after_exception = m.get('KeepRunningAfterException')
        if m.get('NoExecuteExpression') is not None:
            self.no_execute_expression = m.get('NoExecuteExpression')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class BatchSaveFormDataShrinkRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        asynchronous_execution: bool = None,
        form_data_json_list_shrink: str = None,
        form_uuid: str = None,
        keep_running_after_exception: bool = None,
        no_execute_expression: bool = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.asynchronous_execution = asynchronous_execution
        self.form_data_json_list_shrink = form_data_json_list_shrink
        self.form_uuid = form_uuid
        self.keep_running_after_exception = keep_running_after_exception
        self.no_execute_expression = no_execute_expression
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.asynchronous_execution is not None:
            result['AsynchronousExecution'] = self.asynchronous_execution
        if self.form_data_json_list_shrink is not None:
            result['FormDataJsonList'] = self.form_data_json_list_shrink
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.keep_running_after_exception is not None:
            result['KeepRunningAfterException'] = self.keep_running_after_exception
        if self.no_execute_expression is not None:
            result['NoExecuteExpression'] = self.no_execute_expression
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('AsynchronousExecution') is not None:
            self.asynchronous_execution = m.get('AsynchronousExecution')
        if m.get('FormDataJsonList') is not None:
            self.form_data_json_list_shrink = m.get('FormDataJsonList')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('KeepRunningAfterException') is not None:
            self.keep_running_after_exception = m.get('KeepRunningAfterException')
        if m.get('NoExecuteExpression') is not None:
            self.no_execute_expression = m.get('NoExecuteExpression')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class BatchSaveFormDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: List[str] = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.request_id = request_id
        self.result = result
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class BatchSaveFormDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchSaveFormDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchSaveFormDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUpdateFormDataByInstanceIdHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class BatchUpdateFormDataByInstanceIdHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: BatchUpdateFormDataByInstanceIdHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = BatchUpdateFormDataByInstanceIdHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class BatchUpdateFormDataByInstanceIdShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class BatchUpdateFormDataByInstanceIdRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        asynchronous_execution: bool = None,
        form_instance_id_list: List[str] = None,
        form_uuid: str = None,
        ignore_empty: bool = None,
        no_execute_expression: bool = None,
        system_token: str = None,
        update_form_data_json: str = None,
        use_latest_form_schema_version: bool = None,
    ):
        self.app_type = app_type
        self.asynchronous_execution = asynchronous_execution
        self.form_instance_id_list = form_instance_id_list
        self.form_uuid = form_uuid
        self.ignore_empty = ignore_empty
        self.no_execute_expression = no_execute_expression
        self.system_token = system_token
        self.update_form_data_json = update_form_data_json
        self.use_latest_form_schema_version = use_latest_form_schema_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.asynchronous_execution is not None:
            result['AsynchronousExecution'] = self.asynchronous_execution
        if self.form_instance_id_list is not None:
            result['FormInstanceIdList'] = self.form_instance_id_list
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.ignore_empty is not None:
            result['IgnoreEmpty'] = self.ignore_empty
        if self.no_execute_expression is not None:
            result['NoExecuteExpression'] = self.no_execute_expression
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        if self.update_form_data_json is not None:
            result['UpdateFormDataJson'] = self.update_form_data_json
        if self.use_latest_form_schema_version is not None:
            result['UseLatestFormSchemaVersion'] = self.use_latest_form_schema_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('AsynchronousExecution') is not None:
            self.asynchronous_execution = m.get('AsynchronousExecution')
        if m.get('FormInstanceIdList') is not None:
            self.form_instance_id_list = m.get('FormInstanceIdList')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('IgnoreEmpty') is not None:
            self.ignore_empty = m.get('IgnoreEmpty')
        if m.get('NoExecuteExpression') is not None:
            self.no_execute_expression = m.get('NoExecuteExpression')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        if m.get('UpdateFormDataJson') is not None:
            self.update_form_data_json = m.get('UpdateFormDataJson')
        if m.get('UseLatestFormSchemaVersion') is not None:
            self.use_latest_form_schema_version = m.get('UseLatestFormSchemaVersion')
        return self


class BatchUpdateFormDataByInstanceIdShrinkRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        asynchronous_execution: bool = None,
        form_instance_id_list_shrink: str = None,
        form_uuid: str = None,
        ignore_empty: bool = None,
        no_execute_expression: bool = None,
        system_token: str = None,
        update_form_data_json: str = None,
        use_latest_form_schema_version: bool = None,
    ):
        self.app_type = app_type
        self.asynchronous_execution = asynchronous_execution
        self.form_instance_id_list_shrink = form_instance_id_list_shrink
        self.form_uuid = form_uuid
        self.ignore_empty = ignore_empty
        self.no_execute_expression = no_execute_expression
        self.system_token = system_token
        self.update_form_data_json = update_form_data_json
        self.use_latest_form_schema_version = use_latest_form_schema_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.asynchronous_execution is not None:
            result['AsynchronousExecution'] = self.asynchronous_execution
        if self.form_instance_id_list_shrink is not None:
            result['FormInstanceIdList'] = self.form_instance_id_list_shrink
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.ignore_empty is not None:
            result['IgnoreEmpty'] = self.ignore_empty
        if self.no_execute_expression is not None:
            result['NoExecuteExpression'] = self.no_execute_expression
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        if self.update_form_data_json is not None:
            result['UpdateFormDataJson'] = self.update_form_data_json
        if self.use_latest_form_schema_version is not None:
            result['UseLatestFormSchemaVersion'] = self.use_latest_form_schema_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('AsynchronousExecution') is not None:
            self.asynchronous_execution = m.get('AsynchronousExecution')
        if m.get('FormInstanceIdList') is not None:
            self.form_instance_id_list_shrink = m.get('FormInstanceIdList')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('IgnoreEmpty') is not None:
            self.ignore_empty = m.get('IgnoreEmpty')
        if m.get('NoExecuteExpression') is not None:
            self.no_execute_expression = m.get('NoExecuteExpression')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        if m.get('UpdateFormDataJson') is not None:
            self.update_form_data_json = m.get('UpdateFormDataJson')
        if m.get('UseLatestFormSchemaVersion') is not None:
            self.use_latest_form_schema_version = m.get('UseLatestFormSchemaVersion')
        return self


class BatchUpdateFormDataByInstanceIdResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: List[str] = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.request_id = request_id
        self.result = result
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class BatchUpdateFormDataByInstanceIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchUpdateFormDataByInstanceIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchUpdateFormDataByInstanceIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUpdateFormDataByInstanceMapHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class BatchUpdateFormDataByInstanceMapHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: BatchUpdateFormDataByInstanceMapHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = BatchUpdateFormDataByInstanceMapHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class BatchUpdateFormDataByInstanceMapShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class BatchUpdateFormDataByInstanceMapRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        asynchronous_execution: bool = None,
        form_uuid: str = None,
        ignore_empty: bool = None,
        no_execute_expression: bool = None,
        system_token: str = None,
        update_form_data_json_map: Dict[str, Any] = None,
        use_latest_form_schema_version: bool = None,
    ):
        self.app_type = app_type
        self.asynchronous_execution = asynchronous_execution
        self.form_uuid = form_uuid
        self.ignore_empty = ignore_empty
        self.no_execute_expression = no_execute_expression
        self.system_token = system_token
        self.update_form_data_json_map = update_form_data_json_map
        self.use_latest_form_schema_version = use_latest_form_schema_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.asynchronous_execution is not None:
            result['AsynchronousExecution'] = self.asynchronous_execution
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.ignore_empty is not None:
            result['IgnoreEmpty'] = self.ignore_empty
        if self.no_execute_expression is not None:
            result['NoExecuteExpression'] = self.no_execute_expression
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        if self.update_form_data_json_map is not None:
            result['UpdateFormDataJsonMap'] = self.update_form_data_json_map
        if self.use_latest_form_schema_version is not None:
            result['UseLatestFormSchemaVersion'] = self.use_latest_form_schema_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('AsynchronousExecution') is not None:
            self.asynchronous_execution = m.get('AsynchronousExecution')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('IgnoreEmpty') is not None:
            self.ignore_empty = m.get('IgnoreEmpty')
        if m.get('NoExecuteExpression') is not None:
            self.no_execute_expression = m.get('NoExecuteExpression')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        if m.get('UpdateFormDataJsonMap') is not None:
            self.update_form_data_json_map = m.get('UpdateFormDataJsonMap')
        if m.get('UseLatestFormSchemaVersion') is not None:
            self.use_latest_form_schema_version = m.get('UseLatestFormSchemaVersion')
        return self


class BatchUpdateFormDataByInstanceMapShrinkRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        asynchronous_execution: bool = None,
        form_uuid: str = None,
        ignore_empty: bool = None,
        no_execute_expression: bool = None,
        system_token: str = None,
        update_form_data_json_map_shrink: str = None,
        use_latest_form_schema_version: bool = None,
    ):
        self.app_type = app_type
        self.asynchronous_execution = asynchronous_execution
        self.form_uuid = form_uuid
        self.ignore_empty = ignore_empty
        self.no_execute_expression = no_execute_expression
        self.system_token = system_token
        self.update_form_data_json_map_shrink = update_form_data_json_map_shrink
        self.use_latest_form_schema_version = use_latest_form_schema_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.asynchronous_execution is not None:
            result['AsynchronousExecution'] = self.asynchronous_execution
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.ignore_empty is not None:
            result['IgnoreEmpty'] = self.ignore_empty
        if self.no_execute_expression is not None:
            result['NoExecuteExpression'] = self.no_execute_expression
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        if self.update_form_data_json_map_shrink is not None:
            result['UpdateFormDataJsonMap'] = self.update_form_data_json_map_shrink
        if self.use_latest_form_schema_version is not None:
            result['UseLatestFormSchemaVersion'] = self.use_latest_form_schema_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('AsynchronousExecution') is not None:
            self.asynchronous_execution = m.get('AsynchronousExecution')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('IgnoreEmpty') is not None:
            self.ignore_empty = m.get('IgnoreEmpty')
        if m.get('NoExecuteExpression') is not None:
            self.no_execute_expression = m.get('NoExecuteExpression')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        if m.get('UpdateFormDataJsonMap') is not None:
            self.update_form_data_json_map_shrink = m.get('UpdateFormDataJsonMap')
        if m.get('UseLatestFormSchemaVersion') is not None:
            self.use_latest_form_schema_version = m.get('UseLatestFormSchemaVersion')
        return self


class BatchUpdateFormDataByInstanceMapResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: List[str] = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.request_id = request_id
        self.result = result
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class BatchUpdateFormDataByInstanceMapResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchUpdateFormDataByInstanceMapResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchUpdateFormDataByInstanceMapResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelScheduleConferenceHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CancelScheduleConferenceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CancelScheduleConferenceHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CancelScheduleConferenceHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CancelScheduleConferenceShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CancelScheduleConferenceRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CancelScheduleConferenceRequest(TeaModel):
    def __init__(
        self,
        schedule_conference_id: str = None,
        tenant_context: CancelScheduleConferenceRequestTenantContext = None,
    ):
        self.schedule_conference_id = schedule_conference_id
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_conference_id is not None:
            result['ScheduleConferenceId'] = self.schedule_conference_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleConferenceId') is not None:
            self.schedule_conference_id = m.get('ScheduleConferenceId')
        if m.get('TenantContext') is not None:
            temp_model = CancelScheduleConferenceRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class CancelScheduleConferenceShrinkRequest(TeaModel):
    def __init__(
        self,
        schedule_conference_id: str = None,
        tenant_context_shrink: str = None,
    ):
        self.schedule_conference_id = schedule_conference_id
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_conference_id is not None:
            result['ScheduleConferenceId'] = self.schedule_conference_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleConferenceId') is not None:
            self.schedule_conference_id = m.get('ScheduleConferenceId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class CancelScheduleConferenceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # requestId
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CancelScheduleConferenceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelScheduleConferenceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelScheduleConferenceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class ClearHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: ClearHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = ClearHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class ClearShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class ClearRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class ClearRequest(TeaModel):
    def __init__(
        self,
        range_address: str = None,
        sheet_id: str = None,
        tenant_context: ClearRequestTenantContext = None,
        workbook_id: str = None,
    ):
        self.range_address = range_address
        self.sheet_id = sheet_id
        self.tenant_context = tenant_context
        self.workbook_id = workbook_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.range_address is not None:
            result['RangeAddress'] = self.range_address
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RangeAddress') is not None:
            self.range_address = m.get('RangeAddress')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            temp_model = ClearRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class ClearShrinkRequest(TeaModel):
    def __init__(
        self,
        range_address: str = None,
        sheet_id: str = None,
        tenant_context_shrink: str = None,
        workbook_id: str = None,
    ):
        self.range_address = range_address
        self.sheet_id = sheet_id
        self.tenant_context_shrink = tenant_context_shrink
        self.workbook_id = workbook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.range_address is not None:
            result['RangeAddress'] = self.range_address
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RangeAddress') is not None:
            self.range_address = m.get('RangeAddress')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class ClearResponseBody(TeaModel):
    def __init__(
        self,
        a_1notation: str = None,
        request_id: str = None,
    ):
        self.a_1notation = a_1notation
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.a_1notation is not None:
            result['a1Notation'] = self.a_1notation
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('a1Notation') is not None:
            self.a_1notation = m.get('a1Notation')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class ClearResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ClearResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ClearResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearDataHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class ClearDataHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: ClearDataHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = ClearDataHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class ClearDataShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class ClearDataRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class ClearDataRequest(TeaModel):
    def __init__(
        self,
        range_address: str = None,
        sheet_id: str = None,
        tenant_context: ClearDataRequestTenantContext = None,
        workbook_id: str = None,
    ):
        self.range_address = range_address
        self.sheet_id = sheet_id
        self.tenant_context = tenant_context
        self.workbook_id = workbook_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.range_address is not None:
            result['RangeAddress'] = self.range_address
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RangeAddress') is not None:
            self.range_address = m.get('RangeAddress')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            temp_model = ClearDataRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class ClearDataShrinkRequest(TeaModel):
    def __init__(
        self,
        range_address: str = None,
        sheet_id: str = None,
        tenant_context_shrink: str = None,
        workbook_id: str = None,
    ):
        self.range_address = range_address
        self.sheet_id = sheet_id
        self.tenant_context_shrink = tenant_context_shrink
        self.workbook_id = workbook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.range_address is not None:
            result['RangeAddress'] = self.range_address
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RangeAddress') is not None:
            self.range_address = m.get('RangeAddress')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class ClearDataResponseBody(TeaModel):
    def __init__(
        self,
        a_1notation: str = None,
        request_id: str = None,
    ):
        self.a_1notation = a_1notation
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.a_1notation is not None:
            result['a1Notation'] = self.a_1notation
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('a1Notation') is not None:
            self.a_1notation = m.get('a1Notation')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class ClearDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ClearDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ClearDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommentListReportHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CommentListReportHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CommentListReportHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CommentListReportHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CommentListReportShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CommentListReportRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CommentListReportRequest(TeaModel):
    def __init__(
        self,
        offset: int = None,
        report_id: str = None,
        size: int = None,
        tenant_context: CommentListReportRequestTenantContext = None,
    ):
        self.offset = offset
        self.report_id = report_id
        self.size = size
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.size is not None:
            result['Size'] = self.size
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('TenantContext') is not None:
            temp_model = CommentListReportRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class CommentListReportShrinkRequest(TeaModel):
    def __init__(
        self,
        offset: int = None,
        report_id: str = None,
        size: int = None,
        tenant_context_shrink: str = None,
    ):
        self.offset = offset
        self.report_id = report_id
        self.size = size
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.size is not None:
            result['Size'] = self.size
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class CommentListReportResponseBodyComments(TeaModel):
    def __init__(
        self,
        content: str = None,
        create_time: str = None,
        userid: str = None,
    ):
        self.content = content
        self.create_time = create_time
        self.userid = userid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.userid is not None:
            result['Userid'] = self.userid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Userid') is not None:
            self.userid = m.get('Userid')
        return self


class CommentListReportResponseBody(TeaModel):
    def __init__(
        self,
        comments: List[CommentListReportResponseBodyComments] = None,
        has_more: bool = None,
        next_cursor: int = None,
        request_id: str = None,
    ):
        self.comments = comments
        self.has_more = has_more
        self.next_cursor = next_cursor
        # requestId
        self.request_id = request_id

    def validate(self):
        if self.comments:
            for k in self.comments:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['comments'] = []
        if self.comments is not None:
            for k in self.comments:
                result['comments'].append(k.to_map() if k else None)
        if self.has_more is not None:
            result['hasMore'] = self.has_more
        if self.next_cursor is not None:
            result['nextCursor'] = self.next_cursor
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.comments = []
        if m.get('comments') is not None:
            for k in m.get('comments'):
                temp_model = CommentListReportResponseBodyComments()
                self.comments.append(temp_model.from_map(k))
        if m.get('hasMore') is not None:
            self.has_more = m.get('hasMore')
        if m.get('nextCursor') is not None:
            self.next_cursor = m.get('nextCursor')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class CommentListReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CommentListReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CommentListReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEventHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateEventHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateEventHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateEventHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateEventShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateEventRequestAttendees(TeaModel):
    def __init__(
        self,
        id: str = None,
        is_optional: bool = None,
    ):
        self.id = id
        self.is_optional = is_optional

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.is_optional is not None:
            result['isOptional'] = self.is_optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('isOptional') is not None:
            self.is_optional = m.get('isOptional')
        return self


class CreateEventRequestEnd(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['date'] = self.date
        if self.date_time is not None:
            result['dateTime'] = self.date_time
        if self.time_zone is not None:
            result['timeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('dateTime') is not None:
            self.date_time = m.get('dateTime')
        if m.get('timeZone') is not None:
            self.time_zone = m.get('timeZone')
        return self


class CreateEventRequestLocation(TeaModel):
    def __init__(
        self,
        display_name: str = None,
    ):
        self.display_name = display_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['displayName'] = self.display_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('displayName') is not None:
            self.display_name = m.get('displayName')
        return self


class CreateEventRequestOnlineMeetingInfo(TeaModel):
    def __init__(
        self,
        type: str = None,
    ):
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CreateEventRequestRecurrencePattern(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        days_of_week: str = None,
        index: str = None,
        interval: int = None,
        type: str = None,
    ):
        self.day_of_month = day_of_month
        self.days_of_week = days_of_week
        self.index = index
        self.interval = interval
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.days_of_week is not None:
            result['daysOfWeek'] = self.days_of_week
        if self.index is not None:
            result['index'] = self.index
        if self.interval is not None:
            result['interval'] = self.interval
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('daysOfWeek') is not None:
            self.days_of_week = m.get('daysOfWeek')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('interval') is not None:
            self.interval = m.get('interval')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CreateEventRequestRecurrenceRange(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        number_of_occurrences: int = None,
        type: str = None,
    ):
        self.end_date = end_date
        self.number_of_occurrences = number_of_occurrences
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['endDate'] = self.end_date
        if self.number_of_occurrences is not None:
            result['numberOfOccurrences'] = self.number_of_occurrences
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endDate') is not None:
            self.end_date = m.get('endDate')
        if m.get('numberOfOccurrences') is not None:
            self.number_of_occurrences = m.get('numberOfOccurrences')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CreateEventRequestRecurrence(TeaModel):
    def __init__(
        self,
        pattern: CreateEventRequestRecurrencePattern = None,
        range: CreateEventRequestRecurrenceRange = None,
    ):
        self.pattern = pattern
        self.range = range

    def validate(self):
        if self.pattern:
            self.pattern.validate()
        if self.range:
            self.range.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pattern is not None:
            result['pattern'] = self.pattern.to_map()
        if self.range is not None:
            result['range'] = self.range.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pattern') is not None:
            temp_model = CreateEventRequestRecurrencePattern()
            self.pattern = temp_model.from_map(m['pattern'])
        if m.get('range') is not None:
            temp_model = CreateEventRequestRecurrenceRange()
            self.range = temp_model.from_map(m['range'])
        return self


class CreateEventRequestReminders(TeaModel):
    def __init__(
        self,
        method: str = None,
        minutes: int = None,
    ):
        self.method = method
        self.minutes = minutes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method is not None:
            result['method'] = self.method
        if self.minutes is not None:
            result['minutes'] = self.minutes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('method') is not None:
            self.method = m.get('method')
        if m.get('minutes') is not None:
            self.minutes = m.get('minutes')
        return self


class CreateEventRequestUiConfigs(TeaModel):
    def __init__(
        self,
        ui_name: str = None,
        ui_status: str = None,
    ):
        self.ui_name = ui_name
        self.ui_status = ui_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ui_name is not None:
            result['uiName'] = self.ui_name
        if self.ui_status is not None:
            result['uiStatus'] = self.ui_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('uiName') is not None:
            self.ui_name = m.get('uiName')
        if m.get('uiStatus') is not None:
            self.ui_status = m.get('uiStatus')
        return self


class CreateEventRequestStart(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['date'] = self.date
        if self.date_time is not None:
            result['dateTime'] = self.date_time
        if self.time_zone is not None:
            result['timeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('dateTime') is not None:
            self.date_time = m.get('dateTime')
        if m.get('timeZone') is not None:
            self.time_zone = m.get('timeZone')
        return self


class CreateEventRequest(TeaModel):
    def __init__(
        self,
        attendees: List[CreateEventRequestAttendees] = None,
        description: str = None,
        end: CreateEventRequestEnd = None,
        extra: Dict[str, str] = None,
        is_all_day: bool = None,
        location: CreateEventRequestLocation = None,
        online_meeting_info: CreateEventRequestOnlineMeetingInfo = None,
        recurrence: CreateEventRequestRecurrence = None,
        reminders: List[CreateEventRequestReminders] = None,
        summary: str = None,
        ui_configs: List[CreateEventRequestUiConfigs] = None,
        calendar_id: str = None,
        start: CreateEventRequestStart = None,
    ):
        self.attendees = attendees
        self.description = description
        self.end = end
        self.extra = extra
        self.is_all_day = is_all_day
        self.location = location
        self.online_meeting_info = online_meeting_info
        self.recurrence = recurrence
        self.reminders = reminders
        self.summary = summary
        self.ui_configs = ui_configs
        self.calendar_id = calendar_id
        self.start = start

    def validate(self):
        if self.attendees:
            for k in self.attendees:
                if k:
                    k.validate()
        if self.end:
            self.end.validate()
        if self.location:
            self.location.validate()
        if self.online_meeting_info:
            self.online_meeting_info.validate()
        if self.recurrence:
            self.recurrence.validate()
        if self.reminders:
            for k in self.reminders:
                if k:
                    k.validate()
        if self.ui_configs:
            for k in self.ui_configs:
                if k:
                    k.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attendees'] = []
        if self.attendees is not None:
            for k in self.attendees:
                result['Attendees'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.end is not None:
            result['End'] = self.end.to_map()
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.is_all_day is not None:
            result['IsAllDay'] = self.is_all_day
        if self.location is not None:
            result['Location'] = self.location.to_map()
        if self.online_meeting_info is not None:
            result['OnlineMeetingInfo'] = self.online_meeting_info.to_map()
        if self.recurrence is not None:
            result['Recurrence'] = self.recurrence.to_map()
        result['Reminders'] = []
        if self.reminders is not None:
            for k in self.reminders:
                result['Reminders'].append(k.to_map() if k else None)
        if self.summary is not None:
            result['Summary'] = self.summary
        result['UiConfigs'] = []
        if self.ui_configs is not None:
            for k in self.ui_configs:
                result['UiConfigs'].append(k.to_map() if k else None)
        if self.calendar_id is not None:
            result['calendarId'] = self.calendar_id
        if self.start is not None:
            result['start'] = self.start.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attendees = []
        if m.get('Attendees') is not None:
            for k in m.get('Attendees'):
                temp_model = CreateEventRequestAttendees()
                self.attendees.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('End') is not None:
            temp_model = CreateEventRequestEnd()
            self.end = temp_model.from_map(m['End'])
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('IsAllDay') is not None:
            self.is_all_day = m.get('IsAllDay')
        if m.get('Location') is not None:
            temp_model = CreateEventRequestLocation()
            self.location = temp_model.from_map(m['Location'])
        if m.get('OnlineMeetingInfo') is not None:
            temp_model = CreateEventRequestOnlineMeetingInfo()
            self.online_meeting_info = temp_model.from_map(m['OnlineMeetingInfo'])
        if m.get('Recurrence') is not None:
            temp_model = CreateEventRequestRecurrence()
            self.recurrence = temp_model.from_map(m['Recurrence'])
        self.reminders = []
        if m.get('Reminders') is not None:
            for k in m.get('Reminders'):
                temp_model = CreateEventRequestReminders()
                self.reminders.append(temp_model.from_map(k))
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        self.ui_configs = []
        if m.get('UiConfigs') is not None:
            for k in m.get('UiConfigs'):
                temp_model = CreateEventRequestUiConfigs()
                self.ui_configs.append(temp_model.from_map(k))
        if m.get('calendarId') is not None:
            self.calendar_id = m.get('calendarId')
        if m.get('start') is not None:
            temp_model = CreateEventRequestStart()
            self.start = temp_model.from_map(m['start'])
        return self


class CreateEventShrinkRequest(TeaModel):
    def __init__(
        self,
        attendees_shrink: str = None,
        description: str = None,
        end_shrink: str = None,
        extra_shrink: str = None,
        is_all_day: bool = None,
        location_shrink: str = None,
        online_meeting_info_shrink: str = None,
        recurrence_shrink: str = None,
        reminders_shrink: str = None,
        summary: str = None,
        ui_configs_shrink: str = None,
        calendar_id: str = None,
        start_shrink: str = None,
    ):
        self.attendees_shrink = attendees_shrink
        self.description = description
        self.end_shrink = end_shrink
        self.extra_shrink = extra_shrink
        self.is_all_day = is_all_day
        self.location_shrink = location_shrink
        self.online_meeting_info_shrink = online_meeting_info_shrink
        self.recurrence_shrink = recurrence_shrink
        self.reminders_shrink = reminders_shrink
        self.summary = summary
        self.ui_configs_shrink = ui_configs_shrink
        self.calendar_id = calendar_id
        self.start_shrink = start_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attendees_shrink is not None:
            result['Attendees'] = self.attendees_shrink
        if self.description is not None:
            result['Description'] = self.description
        if self.end_shrink is not None:
            result['End'] = self.end_shrink
        if self.extra_shrink is not None:
            result['Extra'] = self.extra_shrink
        if self.is_all_day is not None:
            result['IsAllDay'] = self.is_all_day
        if self.location_shrink is not None:
            result['Location'] = self.location_shrink
        if self.online_meeting_info_shrink is not None:
            result['OnlineMeetingInfo'] = self.online_meeting_info_shrink
        if self.recurrence_shrink is not None:
            result['Recurrence'] = self.recurrence_shrink
        if self.reminders_shrink is not None:
            result['Reminders'] = self.reminders_shrink
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.ui_configs_shrink is not None:
            result['UiConfigs'] = self.ui_configs_shrink
        if self.calendar_id is not None:
            result['calendarId'] = self.calendar_id
        if self.start_shrink is not None:
            result['start'] = self.start_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Attendees') is not None:
            self.attendees_shrink = m.get('Attendees')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('End') is not None:
            self.end_shrink = m.get('End')
        if m.get('Extra') is not None:
            self.extra_shrink = m.get('Extra')
        if m.get('IsAllDay') is not None:
            self.is_all_day = m.get('IsAllDay')
        if m.get('Location') is not None:
            self.location_shrink = m.get('Location')
        if m.get('OnlineMeetingInfo') is not None:
            self.online_meeting_info_shrink = m.get('OnlineMeetingInfo')
        if m.get('Recurrence') is not None:
            self.recurrence_shrink = m.get('Recurrence')
        if m.get('Reminders') is not None:
            self.reminders_shrink = m.get('Reminders')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('UiConfigs') is not None:
            self.ui_configs_shrink = m.get('UiConfigs')
        if m.get('calendarId') is not None:
            self.calendar_id = m.get('calendarId')
        if m.get('start') is not None:
            self.start_shrink = m.get('start')
        return self


class CreateEventResponseBodyAttendees(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        is_optional: bool = None,
        response_status: str = None,
        self_: bool = None,
    ):
        self.display_name = display_name
        self.is_optional = is_optional
        self.response_status = response_status
        self.self_ = self_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.is_optional is not None:
            result['IsOptional'] = self.is_optional
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.self_ is not None:
            result['Self'] = self.self_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('IsOptional') is not None:
            self.is_optional = m.get('IsOptional')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('Self') is not None:
            self.self_ = m.get('Self')
        return self


class CreateEventResponseBodyEnd(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class CreateEventResponseBodyLocation(TeaModel):
    def __init__(
        self,
        display_name: str = None,
    ):
        self.display_name = display_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        return self


class CreateEventResponseBodyOnlineMeetingInfo(TeaModel):
    def __init__(
        self,
        conference_id: str = None,
        extra_info: Dict[str, Any] = None,
        type: str = None,
        url: str = None,
    ):
        self.conference_id = conference_id
        self.extra_info = extra_info
        self.type = type
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conference_id is not None:
            result['ConferenceId'] = self.conference_id
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConferenceId') is not None:
            self.conference_id = m.get('ConferenceId')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class CreateEventResponseBodyOrganizer(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        id: str = None,
        response_status: str = None,
        self_: bool = None,
    ):
        self.display_name = display_name
        self.id = id
        self.response_status = response_status
        self.self_ = self_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.id is not None:
            result['Id'] = self.id
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.self_ is not None:
            result['Self'] = self.self_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('Self') is not None:
            self.self_ = m.get('Self')
        return self


class CreateEventResponseBodyRecurrencePattern(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        days_of_week: str = None,
        index: str = None,
        interval: int = None,
        type: str = None,
    ):
        self.day_of_month = day_of_month
        self.days_of_week = days_of_week
        self.index = index
        self.interval = interval
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['DayOfMonth'] = self.day_of_month
        if self.days_of_week is not None:
            result['DaysOfWeek'] = self.days_of_week
        if self.index is not None:
            result['Index'] = self.index
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DayOfMonth') is not None:
            self.day_of_month = m.get('DayOfMonth')
        if m.get('DaysOfWeek') is not None:
            self.days_of_week = m.get('DaysOfWeek')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEventResponseBodyRecurrenceRange(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        number_of_occurrences: int = None,
        type: str = None,
    ):
        self.end_date = end_date
        self.number_of_occurrences = number_of_occurrences
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.number_of_occurrences is not None:
            result['NumberOfOccurrences'] = self.number_of_occurrences
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('NumberOfOccurrences') is not None:
            self.number_of_occurrences = m.get('NumberOfOccurrences')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEventResponseBodyRecurrence(TeaModel):
    def __init__(
        self,
        pattern: CreateEventResponseBodyRecurrencePattern = None,
        range: CreateEventResponseBodyRecurrenceRange = None,
    ):
        self.pattern = pattern
        self.range = range

    def validate(self):
        if self.pattern:
            self.pattern.validate()
        if self.range:
            self.range.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pattern is not None:
            result['Pattern'] = self.pattern.to_map()
        if self.range is not None:
            result['Range'] = self.range.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pattern') is not None:
            temp_model = CreateEventResponseBodyRecurrencePattern()
            self.pattern = temp_model.from_map(m['Pattern'])
        if m.get('Range') is not None:
            temp_model = CreateEventResponseBodyRecurrenceRange()
            self.range = temp_model.from_map(m['Range'])
        return self


class CreateEventResponseBodyReminders(TeaModel):
    def __init__(
        self,
        method: str = None,
        minutes: str = None,
    ):
        self.method = method
        self.minutes = minutes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method is not None:
            result['Method'] = self.method
        if self.minutes is not None:
            result['Minutes'] = self.minutes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Minutes') is not None:
            self.minutes = m.get('Minutes')
        return self


class CreateEventResponseBodyStart(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class CreateEventResponseBodyUiConfigs(TeaModel):
    def __init__(
        self,
        ui_name: str = None,
        ui_status: str = None,
    ):
        self.ui_name = ui_name
        self.ui_status = ui_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ui_name is not None:
            result['UiName'] = self.ui_name
        if self.ui_status is not None:
            result['UiStatus'] = self.ui_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UiName') is not None:
            self.ui_name = m.get('UiName')
        if m.get('UiStatus') is not None:
            self.ui_status = m.get('UiStatus')
        return self


class CreateEventResponseBody(TeaModel):
    def __init__(
        self,
        attendees: List[CreateEventResponseBodyAttendees] = None,
        create_time: str = None,
        description: str = None,
        end: CreateEventResponseBodyEnd = None,
        id: str = None,
        is_all_day: bool = None,
        location: CreateEventResponseBodyLocation = None,
        online_meeting_info: CreateEventResponseBodyOnlineMeetingInfo = None,
        organizer: CreateEventResponseBodyOrganizer = None,
        recurrence: CreateEventResponseBodyRecurrence = None,
        reminders: List[CreateEventResponseBodyReminders] = None,
        request_id: str = None,
        start: CreateEventResponseBodyStart = None,
        summary: str = None,
        ui_configs: List[CreateEventResponseBodyUiConfigs] = None,
        update_time: str = None,
    ):
        self.attendees = attendees
        self.create_time = create_time
        self.description = description
        self.end = end
        self.id = id
        self.is_all_day = is_all_day
        self.location = location
        self.online_meeting_info = online_meeting_info
        self.organizer = organizer
        self.recurrence = recurrence
        self.reminders = reminders
        # requestId
        self.request_id = request_id
        self.start = start
        self.summary = summary
        self.ui_configs = ui_configs
        self.update_time = update_time

    def validate(self):
        if self.attendees:
            for k in self.attendees:
                if k:
                    k.validate()
        if self.end:
            self.end.validate()
        if self.location:
            self.location.validate()
        if self.online_meeting_info:
            self.online_meeting_info.validate()
        if self.organizer:
            self.organizer.validate()
        if self.recurrence:
            self.recurrence.validate()
        if self.reminders:
            for k in self.reminders:
                if k:
                    k.validate()
        if self.start:
            self.start.validate()
        if self.ui_configs:
            for k in self.ui_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['attendees'] = []
        if self.attendees is not None:
            for k in self.attendees:
                result['attendees'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.description is not None:
            result['description'] = self.description
        if self.end is not None:
            result['end'] = self.end.to_map()
        if self.id is not None:
            result['id'] = self.id
        if self.is_all_day is not None:
            result['isAllDay'] = self.is_all_day
        if self.location is not None:
            result['location'] = self.location.to_map()
        if self.online_meeting_info is not None:
            result['onlineMeetingInfo'] = self.online_meeting_info.to_map()
        if self.organizer is not None:
            result['organizer'] = self.organizer.to_map()
        if self.recurrence is not None:
            result['recurrence'] = self.recurrence.to_map()
        result['reminders'] = []
        if self.reminders is not None:
            for k in self.reminders:
                result['reminders'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.start is not None:
            result['start'] = self.start.to_map()
        if self.summary is not None:
            result['summary'] = self.summary
        result['uiConfigs'] = []
        if self.ui_configs is not None:
            for k in self.ui_configs:
                result['uiConfigs'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attendees = []
        if m.get('attendees') is not None:
            for k in m.get('attendees'):
                temp_model = CreateEventResponseBodyAttendees()
                self.attendees.append(temp_model.from_map(k))
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('end') is not None:
            temp_model = CreateEventResponseBodyEnd()
            self.end = temp_model.from_map(m['end'])
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('isAllDay') is not None:
            self.is_all_day = m.get('isAllDay')
        if m.get('location') is not None:
            temp_model = CreateEventResponseBodyLocation()
            self.location = temp_model.from_map(m['location'])
        if m.get('onlineMeetingInfo') is not None:
            temp_model = CreateEventResponseBodyOnlineMeetingInfo()
            self.online_meeting_info = temp_model.from_map(m['onlineMeetingInfo'])
        if m.get('organizer') is not None:
            temp_model = CreateEventResponseBodyOrganizer()
            self.organizer = temp_model.from_map(m['organizer'])
        if m.get('recurrence') is not None:
            temp_model = CreateEventResponseBodyRecurrence()
            self.recurrence = temp_model.from_map(m['recurrence'])
        self.reminders = []
        if m.get('reminders') is not None:
            for k in m.get('reminders'):
                temp_model = CreateEventResponseBodyReminders()
                self.reminders.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('start') is not None:
            temp_model = CreateEventResponseBodyStart()
            self.start = temp_model.from_map(m['start'])
        if m.get('summary') is not None:
            self.summary = m.get('summary')
        self.ui_configs = []
        if m.get('uiConfigs') is not None:
            for k in m.get('uiConfigs'):
                temp_model = CreateEventResponseBodyUiConfigs()
                self.ui_configs.append(temp_model.from_map(k))
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class CreateEventResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEventResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEventResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateLiveHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateLiveHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateLiveHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateLiveShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateLiveRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CreateLiveRequest(TeaModel):
    def __init__(
        self,
        cover_url: str = None,
        introduction: str = None,
        pre_end_time: int = None,
        pre_start_time: int = None,
        public_type: int = None,
        tenant_context: CreateLiveRequestTenantContext = None,
        title: str = None,
    ):
        self.cover_url = cover_url
        self.introduction = introduction
        self.pre_end_time = pre_end_time
        self.pre_start_time = pre_start_time
        self.public_type = public_type
        self.tenant_context = tenant_context
        self.title = title

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cover_url is not None:
            result['CoverUrl'] = self.cover_url
        if self.introduction is not None:
            result['Introduction'] = self.introduction
        if self.pre_end_time is not None:
            result['PreEndTime'] = self.pre_end_time
        if self.pre_start_time is not None:
            result['PreStartTime'] = self.pre_start_time
        if self.public_type is not None:
            result['PublicType'] = self.public_type
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoverUrl') is not None:
            self.cover_url = m.get('CoverUrl')
        if m.get('Introduction') is not None:
            self.introduction = m.get('Introduction')
        if m.get('PreEndTime') is not None:
            self.pre_end_time = m.get('PreEndTime')
        if m.get('PreStartTime') is not None:
            self.pre_start_time = m.get('PreStartTime')
        if m.get('PublicType') is not None:
            self.public_type = m.get('PublicType')
        if m.get('TenantContext') is not None:
            temp_model = CreateLiveRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class CreateLiveShrinkRequest(TeaModel):
    def __init__(
        self,
        cover_url: str = None,
        introduction: str = None,
        pre_end_time: int = None,
        pre_start_time: int = None,
        public_type: int = None,
        tenant_context_shrink: str = None,
        title: str = None,
    ):
        self.cover_url = cover_url
        self.introduction = introduction
        self.pre_end_time = pre_end_time
        self.pre_start_time = pre_start_time
        self.public_type = public_type
        self.tenant_context_shrink = tenant_context_shrink
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cover_url is not None:
            result['CoverUrl'] = self.cover_url
        if self.introduction is not None:
            result['Introduction'] = self.introduction
        if self.pre_end_time is not None:
            result['PreEndTime'] = self.pre_end_time
        if self.pre_start_time is not None:
            result['PreStartTime'] = self.pre_start_time
        if self.public_type is not None:
            result['PublicType'] = self.public_type
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoverUrl') is not None:
            self.cover_url = m.get('CoverUrl')
        if m.get('Introduction') is not None:
            self.introduction = m.get('Introduction')
        if m.get('PreEndTime') is not None:
            self.pre_end_time = m.get('PreEndTime')
        if m.get('PreStartTime') is not None:
            self.pre_start_time = m.get('PreStartTime')
        if m.get('PublicType') is not None:
            self.public_type = m.get('PublicType')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class CreateLiveResponseBody(TeaModel):
    def __init__(
        self,
        live_id: str = None,
        request_id: str = None,
    ):
        self.live_id = live_id
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_id is not None:
            result['liveId'] = self.live_id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('liveId') is not None:
            self.live_id = m.get('liveId')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class CreateLiveResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMeetingRoomHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateMeetingRoomHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateMeetingRoomHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateMeetingRoomHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateMeetingRoomShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateMeetingRoomRequestRoomLocation(TeaModel):
    def __init__(
        self,
        desc: str = None,
        title: str = None,
    ):
        self.desc = desc
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class CreateMeetingRoomRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CreateMeetingRoomRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        isv_room_id: str = None,
        room_capacity: int = None,
        room_label_ids: List[int] = None,
        room_location: CreateMeetingRoomRequestRoomLocation = None,
        room_name: str = None,
        room_picture: str = None,
        room_status: int = None,
        tenant_context: CreateMeetingRoomRequestTenantContext = None,
    ):
        self.group_id = group_id
        self.isv_room_id = isv_room_id
        self.room_capacity = room_capacity
        self.room_label_ids = room_label_ids
        self.room_location = room_location
        self.room_name = room_name
        self.room_picture = room_picture
        self.room_status = room_status
        self.tenant_context = tenant_context

    def validate(self):
        if self.room_location:
            self.room_location.validate()
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.isv_room_id is not None:
            result['IsvRoomId'] = self.isv_room_id
        if self.room_capacity is not None:
            result['RoomCapacity'] = self.room_capacity
        if self.room_label_ids is not None:
            result['RoomLabelIds'] = self.room_label_ids
        if self.room_location is not None:
            result['RoomLocation'] = self.room_location.to_map()
        if self.room_name is not None:
            result['RoomName'] = self.room_name
        if self.room_picture is not None:
            result['RoomPicture'] = self.room_picture
        if self.room_status is not None:
            result['RoomStatus'] = self.room_status
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IsvRoomId') is not None:
            self.isv_room_id = m.get('IsvRoomId')
        if m.get('RoomCapacity') is not None:
            self.room_capacity = m.get('RoomCapacity')
        if m.get('RoomLabelIds') is not None:
            self.room_label_ids = m.get('RoomLabelIds')
        if m.get('RoomLocation') is not None:
            temp_model = CreateMeetingRoomRequestRoomLocation()
            self.room_location = temp_model.from_map(m['RoomLocation'])
        if m.get('RoomName') is not None:
            self.room_name = m.get('RoomName')
        if m.get('RoomPicture') is not None:
            self.room_picture = m.get('RoomPicture')
        if m.get('RoomStatus') is not None:
            self.room_status = m.get('RoomStatus')
        if m.get('TenantContext') is not None:
            temp_model = CreateMeetingRoomRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class CreateMeetingRoomShrinkRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        isv_room_id: str = None,
        room_capacity: int = None,
        room_label_ids_shrink: str = None,
        room_location_shrink: str = None,
        room_name: str = None,
        room_picture: str = None,
        room_status: int = None,
        tenant_context_shrink: str = None,
    ):
        self.group_id = group_id
        self.isv_room_id = isv_room_id
        self.room_capacity = room_capacity
        self.room_label_ids_shrink = room_label_ids_shrink
        self.room_location_shrink = room_location_shrink
        self.room_name = room_name
        self.room_picture = room_picture
        self.room_status = room_status
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.isv_room_id is not None:
            result['IsvRoomId'] = self.isv_room_id
        if self.room_capacity is not None:
            result['RoomCapacity'] = self.room_capacity
        if self.room_label_ids_shrink is not None:
            result['RoomLabelIds'] = self.room_label_ids_shrink
        if self.room_location_shrink is not None:
            result['RoomLocation'] = self.room_location_shrink
        if self.room_name is not None:
            result['RoomName'] = self.room_name
        if self.room_picture is not None:
            result['RoomPicture'] = self.room_picture
        if self.room_status is not None:
            result['RoomStatus'] = self.room_status
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IsvRoomId') is not None:
            self.isv_room_id = m.get('IsvRoomId')
        if m.get('RoomCapacity') is not None:
            self.room_capacity = m.get('RoomCapacity')
        if m.get('RoomLabelIds') is not None:
            self.room_label_ids_shrink = m.get('RoomLabelIds')
        if m.get('RoomLocation') is not None:
            self.room_location_shrink = m.get('RoomLocation')
        if m.get('RoomName') is not None:
            self.room_name = m.get('RoomName')
        if m.get('RoomPicture') is not None:
            self.room_picture = m.get('RoomPicture')
        if m.get('RoomStatus') is not None:
            self.room_status = m.get('RoomStatus')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class CreateMeetingRoomResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: str = None,
    ):
        # requestId
        self.request_id = request_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class CreateMeetingRoomResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMeetingRoomResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMeetingRoomResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMeetingRoomGroupHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateMeetingRoomGroupHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateMeetingRoomGroupHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateMeetingRoomGroupHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateMeetingRoomGroupShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateMeetingRoomGroupRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CreateMeetingRoomGroupRequest(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        parent_group_id: int = None,
        tenant_context: CreateMeetingRoomGroupRequestTenantContext = None,
    ):
        self.group_name = group_name
        self.parent_group_id = parent_group_id
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.parent_group_id is not None:
            result['ParentGroupId'] = self.parent_group_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('ParentGroupId') is not None:
            self.parent_group_id = m.get('ParentGroupId')
        if m.get('TenantContext') is not None:
            temp_model = CreateMeetingRoomGroupRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class CreateMeetingRoomGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        parent_group_id: int = None,
        tenant_context_shrink: str = None,
    ):
        self.group_name = group_name
        self.parent_group_id = parent_group_id
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.parent_group_id is not None:
            result['ParentGroupId'] = self.parent_group_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('ParentGroupId') is not None:
            self.parent_group_id = m.get('ParentGroupId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class CreateMeetingRoomGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: int = None,
    ):
        # requestId
        self.request_id = request_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class CreateMeetingRoomGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMeetingRoomGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMeetingRoomGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateFormDataHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateOrUpdateFormDataHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateOrUpdateFormDataHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateOrUpdateFormDataHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateOrUpdateFormDataShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateOrUpdateFormDataRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        form_data_json: str = None,
        form_uuid: str = None,
        no_execute_expression: bool = None,
        search_condition: str = None,
        system_token: str = None,
        user_id: str = None,
    ):
        self.app_type = app_type
        self.form_data_json = form_data_json
        self.form_uuid = form_uuid
        self.no_execute_expression = no_execute_expression
        self.search_condition = search_condition
        self.system_token = system_token
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.form_data_json is not None:
            result['FormDataJson'] = self.form_data_json
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.no_execute_expression is not None:
            result['NoExecuteExpression'] = self.no_execute_expression
        if self.search_condition is not None:
            result['SearchCondition'] = self.search_condition
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FormDataJson') is not None:
            self.form_data_json = m.get('FormDataJson')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('NoExecuteExpression') is not None:
            self.no_execute_expression = m.get('NoExecuteExpression')
        if m.get('SearchCondition') is not None:
            self.search_condition = m.get('SearchCondition')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CreateOrUpdateFormDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: List[str] = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.request_id = request_id
        self.result = result
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class CreateOrUpdateFormDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOrUpdateFormDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateFormDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrgHonorTemplateHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateOrgHonorTemplateHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateOrgHonorTemplateHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateOrgHonorTemplateHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateOrgHonorTemplateShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateOrgHonorTemplateRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CreateOrgHonorTemplateRequest(TeaModel):
    def __init__(
        self,
        tenant_context: CreateOrgHonorTemplateRequestTenantContext = None,
        avatar_frame_media_id: str = None,
        default_bg_color: str = None,
        medal_desc: str = None,
        medal_media_id: str = None,
        medal_name: str = None,
        org_id: int = None,
        user_id: str = None,
    ):
        self.tenant_context = tenant_context
        self.avatar_frame_media_id = avatar_frame_media_id
        self.default_bg_color = default_bg_color
        self.medal_desc = medal_desc
        self.medal_media_id = medal_media_id
        self.medal_name = medal_name
        self.org_id = org_id
        self.user_id = user_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.avatar_frame_media_id is not None:
            result['avatarFrameMediaId'] = self.avatar_frame_media_id
        if self.default_bg_color is not None:
            result['defaultBgColor'] = self.default_bg_color
        if self.medal_desc is not None:
            result['medalDesc'] = self.medal_desc
        if self.medal_media_id is not None:
            result['medalMediaId'] = self.medal_media_id
        if self.medal_name is not None:
            result['medalName'] = self.medal_name
        if self.org_id is not None:
            result['orgId'] = self.org_id
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            temp_model = CreateOrgHonorTemplateRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('avatarFrameMediaId') is not None:
            self.avatar_frame_media_id = m.get('avatarFrameMediaId')
        if m.get('defaultBgColor') is not None:
            self.default_bg_color = m.get('defaultBgColor')
        if m.get('medalDesc') is not None:
            self.medal_desc = m.get('medalDesc')
        if m.get('medalMediaId') is not None:
            self.medal_media_id = m.get('medalMediaId')
        if m.get('medalName') is not None:
            self.medal_name = m.get('medalName')
        if m.get('orgId') is not None:
            self.org_id = m.get('orgId')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CreateOrgHonorTemplateShrinkRequest(TeaModel):
    def __init__(
        self,
        tenant_context_shrink: str = None,
        avatar_frame_media_id: str = None,
        default_bg_color: str = None,
        medal_desc: str = None,
        medal_media_id: str = None,
        medal_name: str = None,
        org_id: int = None,
        user_id: str = None,
    ):
        self.tenant_context_shrink = tenant_context_shrink
        self.avatar_frame_media_id = avatar_frame_media_id
        self.default_bg_color = default_bg_color
        self.medal_desc = medal_desc
        self.medal_media_id = medal_media_id
        self.medal_name = medal_name
        self.org_id = org_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.avatar_frame_media_id is not None:
            result['avatarFrameMediaId'] = self.avatar_frame_media_id
        if self.default_bg_color is not None:
            result['defaultBgColor'] = self.default_bg_color
        if self.medal_desc is not None:
            result['medalDesc'] = self.medal_desc
        if self.medal_media_id is not None:
            result['medalMediaId'] = self.medal_media_id
        if self.medal_name is not None:
            result['medalName'] = self.medal_name
        if self.org_id is not None:
            result['orgId'] = self.org_id
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('avatarFrameMediaId') is not None:
            self.avatar_frame_media_id = m.get('avatarFrameMediaId')
        if m.get('defaultBgColor') is not None:
            self.default_bg_color = m.get('defaultBgColor')
        if m.get('medalDesc') is not None:
            self.medal_desc = m.get('medalDesc')
        if m.get('medalMediaId') is not None:
            self.medal_media_id = m.get('medalMediaId')
        if m.get('medalName') is not None:
            self.medal_name = m.get('medalName')
        if m.get('orgId') is not None:
            self.org_id = m.get('orgId')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class CreateOrgHonorTemplateResponseBody(TeaModel):
    def __init__(
        self,
        honor_id: str = None,
        request_id: str = None,
    ):
        self.honor_id = honor_id
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honor_id is not None:
            result['honorId'] = self.honor_id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('honorId') is not None:
            self.honor_id = m.get('honorId')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class CreateOrgHonorTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOrgHonorTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrgHonorTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateReportHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateReportHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateReportHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateReportHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateReportShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateReportRequestContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        content_type: str = None,
        key: str = None,
        sort: int = None,
        type: int = None,
    ):
        self.content = content
        self.content_type = content_type
        self.key = key
        self.sort = sort
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.key is not None:
            result['Key'] = self.key
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateReportRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CreateReportRequest(TeaModel):
    def __init__(
        self,
        contents: List[CreateReportRequestContents] = None,
        dd_from: str = None,
        template_id: str = None,
        tenant_context: CreateReportRequestTenantContext = None,
        to_chat: bool = None,
        to_cids: List[str] = None,
        to_userids: List[str] = None,
    ):
        self.contents = contents
        self.dd_from = dd_from
        self.template_id = template_id
        self.tenant_context = tenant_context
        self.to_chat = to_chat
        self.to_cids = to_cids
        self.to_userids = to_userids

    def validate(self):
        if self.contents:
            for k in self.contents:
                if k:
                    k.validate()
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contents'] = []
        if self.contents is not None:
            for k in self.contents:
                result['Contents'].append(k.to_map() if k else None)
        if self.dd_from is not None:
            result['DdFrom'] = self.dd_from
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.to_chat is not None:
            result['ToChat'] = self.to_chat
        if self.to_cids is not None:
            result['ToCids'] = self.to_cids
        if self.to_userids is not None:
            result['ToUserids'] = self.to_userids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contents = []
        if m.get('Contents') is not None:
            for k in m.get('Contents'):
                temp_model = CreateReportRequestContents()
                self.contents.append(temp_model.from_map(k))
        if m.get('DdFrom') is not None:
            self.dd_from = m.get('DdFrom')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TenantContext') is not None:
            temp_model = CreateReportRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('ToChat') is not None:
            self.to_chat = m.get('ToChat')
        if m.get('ToCids') is not None:
            self.to_cids = m.get('ToCids')
        if m.get('ToUserids') is not None:
            self.to_userids = m.get('ToUserids')
        return self


class CreateReportShrinkRequest(TeaModel):
    def __init__(
        self,
        contents_shrink: str = None,
        dd_from: str = None,
        template_id: str = None,
        tenant_context_shrink: str = None,
        to_chat: bool = None,
        to_cids_shrink: str = None,
        to_userids_shrink: str = None,
    ):
        self.contents_shrink = contents_shrink
        self.dd_from = dd_from
        self.template_id = template_id
        self.tenant_context_shrink = tenant_context_shrink
        self.to_chat = to_chat
        self.to_cids_shrink = to_cids_shrink
        self.to_userids_shrink = to_userids_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contents_shrink is not None:
            result['Contents'] = self.contents_shrink
        if self.dd_from is not None:
            result['DdFrom'] = self.dd_from
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.to_chat is not None:
            result['ToChat'] = self.to_chat
        if self.to_cids_shrink is not None:
            result['ToCids'] = self.to_cids_shrink
        if self.to_userids_shrink is not None:
            result['ToUserids'] = self.to_userids_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Contents') is not None:
            self.contents_shrink = m.get('Contents')
        if m.get('DdFrom') is not None:
            self.dd_from = m.get('DdFrom')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('ToChat') is not None:
            self.to_chat = m.get('ToChat')
        if m.get('ToCids') is not None:
            self.to_cids_shrink = m.get('ToCids')
        if m.get('ToUserids') is not None:
            self.to_userids_shrink = m.get('ToUserids')
        return self


class CreateReportResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # requestId
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CreateReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScenegroupHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateScenegroupHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateScenegroupHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateScenegroupHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateScenegroupShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateScenegroupRequest(TeaModel):
    def __init__(
        self,
        add_friend_forbidden: int = None,
        all_members_can_create_calendar: int = None,
        all_members_can_create_mcs_conf: int = None,
        chat_banned_type: int = None,
        group_email_disabled: int = None,
        group_live_switch: int = None,
        icon: str = None,
        management_type: int = None,
        members_to_admin_chat: int = None,
        mention_all_authority: int = None,
        only_admin_can_ding: int = None,
        only_admin_can_set_msg_top: int = None,
        searchable: int = None,
        show_history_type: int = None,
        subadmin_ids: str = None,
        template_id: str = None,
        title: str = None,
        user_ids: str = None,
        uuid: str = None,
        validation_type: int = None,
    ):
        self.add_friend_forbidden = add_friend_forbidden
        self.all_members_can_create_calendar = all_members_can_create_calendar
        self.all_members_can_create_mcs_conf = all_members_can_create_mcs_conf
        self.chat_banned_type = chat_banned_type
        self.group_email_disabled = group_email_disabled
        self.group_live_switch = group_live_switch
        self.icon = icon
        self.management_type = management_type
        self.members_to_admin_chat = members_to_admin_chat
        self.mention_all_authority = mention_all_authority
        self.only_admin_can_ding = only_admin_can_ding
        self.only_admin_can_set_msg_top = only_admin_can_set_msg_top
        self.searchable = searchable
        self.show_history_type = show_history_type
        self.subadmin_ids = subadmin_ids
        self.template_id = template_id
        self.title = title
        self.user_ids = user_ids
        self.uuid = uuid
        self.validation_type = validation_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_friend_forbidden is not None:
            result['AddFriendForbidden'] = self.add_friend_forbidden
        if self.all_members_can_create_calendar is not None:
            result['AllMembersCanCreateCalendar'] = self.all_members_can_create_calendar
        if self.all_members_can_create_mcs_conf is not None:
            result['AllMembersCanCreateMcsConf'] = self.all_members_can_create_mcs_conf
        if self.chat_banned_type is not None:
            result['ChatBannedType'] = self.chat_banned_type
        if self.group_email_disabled is not None:
            result['GroupEmailDisabled'] = self.group_email_disabled
        if self.group_live_switch is not None:
            result['GroupLiveSwitch'] = self.group_live_switch
        if self.icon is not None:
            result['Icon'] = self.icon
        if self.management_type is not None:
            result['ManagementType'] = self.management_type
        if self.members_to_admin_chat is not None:
            result['MembersToAdminChat'] = self.members_to_admin_chat
        if self.mention_all_authority is not None:
            result['MentionAllAuthority'] = self.mention_all_authority
        if self.only_admin_can_ding is not None:
            result['OnlyAdminCanDing'] = self.only_admin_can_ding
        if self.only_admin_can_set_msg_top is not None:
            result['OnlyAdminCanSetMsgTop'] = self.only_admin_can_set_msg_top
        if self.searchable is not None:
            result['Searchable'] = self.searchable
        if self.show_history_type is not None:
            result['ShowHistoryType'] = self.show_history_type
        if self.subadmin_ids is not None:
            result['SubadminIds'] = self.subadmin_ids
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.title is not None:
            result['Title'] = self.title
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.validation_type is not None:
            result['ValidationType'] = self.validation_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddFriendForbidden') is not None:
            self.add_friend_forbidden = m.get('AddFriendForbidden')
        if m.get('AllMembersCanCreateCalendar') is not None:
            self.all_members_can_create_calendar = m.get('AllMembersCanCreateCalendar')
        if m.get('AllMembersCanCreateMcsConf') is not None:
            self.all_members_can_create_mcs_conf = m.get('AllMembersCanCreateMcsConf')
        if m.get('ChatBannedType') is not None:
            self.chat_banned_type = m.get('ChatBannedType')
        if m.get('GroupEmailDisabled') is not None:
            self.group_email_disabled = m.get('GroupEmailDisabled')
        if m.get('GroupLiveSwitch') is not None:
            self.group_live_switch = m.get('GroupLiveSwitch')
        if m.get('Icon') is not None:
            self.icon = m.get('Icon')
        if m.get('ManagementType') is not None:
            self.management_type = m.get('ManagementType')
        if m.get('MembersToAdminChat') is not None:
            self.members_to_admin_chat = m.get('MembersToAdminChat')
        if m.get('MentionAllAuthority') is not None:
            self.mention_all_authority = m.get('MentionAllAuthority')
        if m.get('OnlyAdminCanDing') is not None:
            self.only_admin_can_ding = m.get('OnlyAdminCanDing')
        if m.get('OnlyAdminCanSetMsgTop') is not None:
            self.only_admin_can_set_msg_top = m.get('OnlyAdminCanSetMsgTop')
        if m.get('Searchable') is not None:
            self.searchable = m.get('Searchable')
        if m.get('ShowHistoryType') is not None:
            self.show_history_type = m.get('ShowHistoryType')
        if m.get('SubadminIds') is not None:
            self.subadmin_ids = m.get('SubadminIds')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('ValidationType') is not None:
            self.validation_type = m.get('ValidationType')
        return self


class CreateScenegroupResponseBody(TeaModel):
    def __init__(
        self,
        open_conversation_id: str = None,
        request_id: str = None,
    ):
        self.open_conversation_id = open_conversation_id
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.open_conversation_id is not None:
            result['openConversationId'] = self.open_conversation_id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('openConversationId') is not None:
            self.open_conversation_id = m.get('openConversationId')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class CreateScenegroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateScenegroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateScenegroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScheduleConferenceHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateScheduleConferenceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateScheduleConferenceHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateScheduleConferenceHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateScheduleConferenceShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateScheduleConferenceRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CreateScheduleConferenceRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        start_time: int = None,
        tenant_context: CreateScheduleConferenceRequestTenantContext = None,
        title: str = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.tenant_context = tenant_context
        self.title = title

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantContext') is not None:
            temp_model = CreateScheduleConferenceRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class CreateScheduleConferenceShrinkRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        start_time: int = None,
        tenant_context_shrink: str = None,
        title: str = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.tenant_context_shrink = tenant_context_shrink
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class CreateScheduleConferenceResponseBody(TeaModel):
    def __init__(
        self,
        phones: List[str] = None,
        request_id: str = None,
        room_code: str = None,
        schedule_conference_id: str = None,
        url: str = None,
    ):
        self.phones = phones
        # requestId
        self.request_id = request_id
        self.room_code = room_code
        self.schedule_conference_id = schedule_conference_id
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.phones is not None:
            result['phones'] = self.phones
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.room_code is not None:
            result['roomCode'] = self.room_code
        if self.schedule_conference_id is not None:
            result['scheduleConferenceId'] = self.schedule_conference_id
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('phones') is not None:
            self.phones = m.get('phones')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('roomCode') is not None:
            self.room_code = m.get('roomCode')
        if m.get('scheduleConferenceId') is not None:
            self.schedule_conference_id = m.get('scheduleConferenceId')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class CreateScheduleConferenceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateScheduleConferenceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateScheduleConferenceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSheetHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateSheetHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateSheetHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateSheetHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateSheetShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateSheetRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CreateSheetRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        tenant_context: CreateSheetRequestTenantContext = None,
        workbook_id: str = None,
    ):
        self.name = name
        self.tenant_context = tenant_context
        self.workbook_id = workbook_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TenantContext') is not None:
            temp_model = CreateSheetRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class CreateSheetShrinkRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        tenant_context_shrink: str = None,
        workbook_id: str = None,
    ):
        self.name = name
        self.tenant_context_shrink = tenant_context_shrink
        self.workbook_id = workbook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class CreateSheetResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
        request_id: str = None,
        visibility: str = None,
    ):
        self.id = id
        self.name = name
        self.request_id = request_id
        self.visibility = visibility

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.visibility is not None:
            result['visibility'] = self.visibility
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('visibility') is not None:
            self.visibility = m.get('visibility')
        return self


class CreateSheetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSheetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSheetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSubscribedCalendarHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateSubscribedCalendarHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateSubscribedCalendarHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateSubscribedCalendarHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateSubscribedCalendarShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateSubscribedCalendarRequestSubscribeScope(TeaModel):
    def __init__(
        self,
        user_ids: List[str] = None,
    ):
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class CreateSubscribedCalendarRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        managers: List[str] = None,
        name: str = None,
        subscribe_scope: CreateSubscribedCalendarRequestSubscribeScope = None,
    ):
        self.description = description
        self.managers = managers
        self.name = name
        self.subscribe_scope = subscribe_scope

    def validate(self):
        if self.subscribe_scope:
            self.subscribe_scope.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.managers is not None:
            result['Managers'] = self.managers
        if self.name is not None:
            result['Name'] = self.name
        if self.subscribe_scope is not None:
            result['SubscribeScope'] = self.subscribe_scope.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Managers') is not None:
            self.managers = m.get('Managers')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SubscribeScope') is not None:
            temp_model = CreateSubscribedCalendarRequestSubscribeScope()
            self.subscribe_scope = temp_model.from_map(m['SubscribeScope'])
        return self


class CreateSubscribedCalendarShrinkRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        managers_shrink: str = None,
        name: str = None,
        subscribe_scope_shrink: str = None,
    ):
        self.description = description
        self.managers_shrink = managers_shrink
        self.name = name
        self.subscribe_scope_shrink = subscribe_scope_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.managers_shrink is not None:
            result['Managers'] = self.managers_shrink
        if self.name is not None:
            result['Name'] = self.name
        if self.subscribe_scope_shrink is not None:
            result['SubscribeScope'] = self.subscribe_scope_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Managers') is not None:
            self.managers_shrink = m.get('Managers')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SubscribeScope') is not None:
            self.subscribe_scope_shrink = m.get('SubscribeScope')
        return self


class CreateSubscribedCalendarResponseBody(TeaModel):
    def __init__(
        self,
        calendar_id: str = None,
        request_id: str = None,
    ):
        self.calendar_id = calendar_id
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calendar_id is not None:
            result['calendarId'] = self.calendar_id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('calendarId') is not None:
            self.calendar_id = m.get('calendarId')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class CreateSubscribedCalendarResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSubscribedCalendarResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSubscribedCalendarResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTodoTaskHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateTodoTaskHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateTodoTaskHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateTodoTaskHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateTodoTaskShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateTodoTaskRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CreateTodoTaskRequestContentFieldList(TeaModel):
    def __init__(
        self,
        field_key: str = None,
        field_value: str = None,
    ):
        # fieldKey
        self.field_key = field_key
        # fieldValue
        self.field_value = field_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_key is not None:
            result['fieldKey'] = self.field_key
        if self.field_value is not None:
            result['fieldValue'] = self.field_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fieldKey') is not None:
            self.field_key = m.get('fieldKey')
        if m.get('fieldValue') is not None:
            self.field_value = m.get('fieldValue')
        return self


class CreateTodoTaskRequestDetailUrl(TeaModel):
    def __init__(
        self,
        app_url: str = None,
        pc_url: str = None,
    ):
        self.app_url = app_url
        self.pc_url = pc_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_url is not None:
            result['appUrl'] = self.app_url
        if self.pc_url is not None:
            result['pcUrl'] = self.pc_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('appUrl') is not None:
            self.app_url = m.get('appUrl')
        if m.get('pcUrl') is not None:
            self.pc_url = m.get('pcUrl')
        return self


class CreateTodoTaskRequestNotifyConfigs(TeaModel):
    def __init__(
        self,
        ding_notify: str = None,
    ):
        self.ding_notify = ding_notify

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ding_notify is not None:
            result['dingNotify'] = self.ding_notify
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dingNotify') is not None:
            self.ding_notify = m.get('dingNotify')
        return self


class CreateTodoTaskRequest(TeaModel):
    def __init__(
        self,
        tenant_context: CreateTodoTaskRequestTenantContext = None,
        content_field_list: List[CreateTodoTaskRequestContentFieldList] = None,
        creator_id: str = None,
        description: str = None,
        detail_url: CreateTodoTaskRequestDetailUrl = None,
        due_time: int = None,
        executor_ids: List[str] = None,
        is_only_show_executor: bool = None,
        notify_configs: CreateTodoTaskRequestNotifyConfigs = None,
        operator_id: str = None,
        participant_ids: List[str] = None,
        priority: int = None,
        source_id: str = None,
        subject: str = None,
    ):
        self.tenant_context = tenant_context
        self.content_field_list = content_field_list
        self.creator_id = creator_id
        self.description = description
        self.detail_url = detail_url
        self.due_time = due_time
        self.executor_ids = executor_ids
        self.is_only_show_executor = is_only_show_executor
        self.notify_configs = notify_configs
        self.operator_id = operator_id
        self.participant_ids = participant_ids
        self.priority = priority
        self.source_id = source_id
        self.subject = subject

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()
        if self.content_field_list:
            for k in self.content_field_list:
                if k:
                    k.validate()
        if self.detail_url:
            self.detail_url.validate()
        if self.notify_configs:
            self.notify_configs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        result['contentFieldList'] = []
        if self.content_field_list is not None:
            for k in self.content_field_list:
                result['contentFieldList'].append(k.to_map() if k else None)
        if self.creator_id is not None:
            result['creatorId'] = self.creator_id
        if self.description is not None:
            result['description'] = self.description
        if self.detail_url is not None:
            result['detailUrl'] = self.detail_url.to_map()
        if self.due_time is not None:
            result['dueTime'] = self.due_time
        if self.executor_ids is not None:
            result['executorIds'] = self.executor_ids
        if self.is_only_show_executor is not None:
            result['isOnlyShowExecutor'] = self.is_only_show_executor
        if self.notify_configs is not None:
            result['notifyConfigs'] = self.notify_configs.to_map()
        if self.operator_id is not None:
            result['operatorId'] = self.operator_id
        if self.participant_ids is not None:
            result['participantIds'] = self.participant_ids
        if self.priority is not None:
            result['priority'] = self.priority
        if self.source_id is not None:
            result['sourceId'] = self.source_id
        if self.subject is not None:
            result['subject'] = self.subject
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            temp_model = CreateTodoTaskRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        self.content_field_list = []
        if m.get('contentFieldList') is not None:
            for k in m.get('contentFieldList'):
                temp_model = CreateTodoTaskRequestContentFieldList()
                self.content_field_list.append(temp_model.from_map(k))
        if m.get('creatorId') is not None:
            self.creator_id = m.get('creatorId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('detailUrl') is not None:
            temp_model = CreateTodoTaskRequestDetailUrl()
            self.detail_url = temp_model.from_map(m['detailUrl'])
        if m.get('dueTime') is not None:
            self.due_time = m.get('dueTime')
        if m.get('executorIds') is not None:
            self.executor_ids = m.get('executorIds')
        if m.get('isOnlyShowExecutor') is not None:
            self.is_only_show_executor = m.get('isOnlyShowExecutor')
        if m.get('notifyConfigs') is not None:
            temp_model = CreateTodoTaskRequestNotifyConfigs()
            self.notify_configs = temp_model.from_map(m['notifyConfigs'])
        if m.get('operatorId') is not None:
            self.operator_id = m.get('operatorId')
        if m.get('participantIds') is not None:
            self.participant_ids = m.get('participantIds')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('sourceId') is not None:
            self.source_id = m.get('sourceId')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        return self


class CreateTodoTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        tenant_context_shrink: str = None,
        content_field_list_shrink: str = None,
        creator_id: str = None,
        description: str = None,
        detail_url_shrink: str = None,
        due_time: int = None,
        executor_ids_shrink: str = None,
        is_only_show_executor: bool = None,
        notify_configs_shrink: str = None,
        operator_id: str = None,
        participant_ids_shrink: str = None,
        priority: int = None,
        source_id: str = None,
        subject: str = None,
    ):
        self.tenant_context_shrink = tenant_context_shrink
        self.content_field_list_shrink = content_field_list_shrink
        self.creator_id = creator_id
        self.description = description
        self.detail_url_shrink = detail_url_shrink
        self.due_time = due_time
        self.executor_ids_shrink = executor_ids_shrink
        self.is_only_show_executor = is_only_show_executor
        self.notify_configs_shrink = notify_configs_shrink
        self.operator_id = operator_id
        self.participant_ids_shrink = participant_ids_shrink
        self.priority = priority
        self.source_id = source_id
        self.subject = subject

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.content_field_list_shrink is not None:
            result['contentFieldList'] = self.content_field_list_shrink
        if self.creator_id is not None:
            result['creatorId'] = self.creator_id
        if self.description is not None:
            result['description'] = self.description
        if self.detail_url_shrink is not None:
            result['detailUrl'] = self.detail_url_shrink
        if self.due_time is not None:
            result['dueTime'] = self.due_time
        if self.executor_ids_shrink is not None:
            result['executorIds'] = self.executor_ids_shrink
        if self.is_only_show_executor is not None:
            result['isOnlyShowExecutor'] = self.is_only_show_executor
        if self.notify_configs_shrink is not None:
            result['notifyConfigs'] = self.notify_configs_shrink
        if self.operator_id is not None:
            result['operatorId'] = self.operator_id
        if self.participant_ids_shrink is not None:
            result['participantIds'] = self.participant_ids_shrink
        if self.priority is not None:
            result['priority'] = self.priority
        if self.source_id is not None:
            result['sourceId'] = self.source_id
        if self.subject is not None:
            result['subject'] = self.subject
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('contentFieldList') is not None:
            self.content_field_list_shrink = m.get('contentFieldList')
        if m.get('creatorId') is not None:
            self.creator_id = m.get('creatorId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('detailUrl') is not None:
            self.detail_url_shrink = m.get('detailUrl')
        if m.get('dueTime') is not None:
            self.due_time = m.get('dueTime')
        if m.get('executorIds') is not None:
            self.executor_ids_shrink = m.get('executorIds')
        if m.get('isOnlyShowExecutor') is not None:
            self.is_only_show_executor = m.get('isOnlyShowExecutor')
        if m.get('notifyConfigs') is not None:
            self.notify_configs_shrink = m.get('notifyConfigs')
        if m.get('operatorId') is not None:
            self.operator_id = m.get('operatorId')
        if m.get('participantIds') is not None:
            self.participant_ids_shrink = m.get('participantIds')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('sourceId') is not None:
            self.source_id = m.get('sourceId')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        return self


class CreateTodoTaskResponseBodyContentFieldList(TeaModel):
    def __init__(
        self,
        field_key: str = None,
        field_value: str = None,
    ):
        # fieldKey
        self.field_key = field_key
        # fieldValue
        self.field_value = field_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_key is not None:
            result['fieldKey'] = self.field_key
        if self.field_value is not None:
            result['fieldValue'] = self.field_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fieldKey') is not None:
            self.field_key = m.get('fieldKey')
        if m.get('fieldValue') is not None:
            self.field_value = m.get('fieldValue')
        return self


class CreateTodoTaskResponseBodyDetailUrl(TeaModel):
    def __init__(
        self,
        app_url: str = None,
        pc_url: str = None,
    ):
        self.app_url = app_url
        self.pc_url = pc_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_url is not None:
            result['appUrl'] = self.app_url
        if self.pc_url is not None:
            result['pcUrl'] = self.pc_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('appUrl') is not None:
            self.app_url = m.get('appUrl')
        if m.get('pcUrl') is not None:
            self.pc_url = m.get('pcUrl')
        return self


class CreateTodoTaskResponseBodyNotifyConfigs(TeaModel):
    def __init__(
        self,
        ding_notify: str = None,
    ):
        self.ding_notify = ding_notify

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ding_notify is not None:
            result['dingNotify'] = self.ding_notify
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dingNotify') is not None:
            self.ding_notify = m.get('dingNotify')
        return self


class CreateTodoTaskResponseBody(TeaModel):
    def __init__(
        self,
        biz_tag: str = None,
        content_field_list: List[CreateTodoTaskResponseBodyContentFieldList] = None,
        created_time: int = None,
        creator_id: str = None,
        description: str = None,
        detail_url: CreateTodoTaskResponseBodyDetailUrl = None,
        done: bool = None,
        due_time: int = None,
        executor_ids: List[str] = None,
        finish_time: int = None,
        id: str = None,
        is_only_show_executor: bool = None,
        modified_time: int = None,
        modifier_id: str = None,
        notify_configs: CreateTodoTaskResponseBodyNotifyConfigs = None,
        participant_ids: List[str] = None,
        priority: int = None,
        request_id: str = None,
        source: str = None,
        source_id: str = None,
        start_time: int = None,
        subject: str = None,
    ):
        self.biz_tag = biz_tag
        self.content_field_list = content_field_list
        self.created_time = created_time
        self.creator_id = creator_id
        self.description = description
        self.detail_url = detail_url
        self.done = done
        self.due_time = due_time
        self.executor_ids = executor_ids
        self.finish_time = finish_time
        self.id = id
        self.is_only_show_executor = is_only_show_executor
        self.modified_time = modified_time
        self.modifier_id = modifier_id
        self.notify_configs = notify_configs
        self.participant_ids = participant_ids
        self.priority = priority
        # requestId
        self.request_id = request_id
        self.source = source
        self.source_id = source_id
        self.start_time = start_time
        self.subject = subject

    def validate(self):
        if self.content_field_list:
            for k in self.content_field_list:
                if k:
                    k.validate()
        if self.detail_url:
            self.detail_url.validate()
        if self.notify_configs:
            self.notify_configs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_tag is not None:
            result['bizTag'] = self.biz_tag
        result['contentFieldList'] = []
        if self.content_field_list is not None:
            for k in self.content_field_list:
                result['contentFieldList'].append(k.to_map() if k else None)
        if self.created_time is not None:
            result['createdTime'] = self.created_time
        if self.creator_id is not None:
            result['creatorId'] = self.creator_id
        if self.description is not None:
            result['description'] = self.description
        if self.detail_url is not None:
            result['detailUrl'] = self.detail_url.to_map()
        if self.done is not None:
            result['done'] = self.done
        if self.due_time is not None:
            result['dueTime'] = self.due_time
        if self.executor_ids is not None:
            result['executorIds'] = self.executor_ids
        if self.finish_time is not None:
            result['finishTime'] = self.finish_time
        if self.id is not None:
            result['id'] = self.id
        if self.is_only_show_executor is not None:
            result['isOnlyShowExecutor'] = self.is_only_show_executor
        if self.modified_time is not None:
            result['modifiedTime'] = self.modified_time
        if self.modifier_id is not None:
            result['modifierId'] = self.modifier_id
        if self.notify_configs is not None:
            result['notifyConfigs'] = self.notify_configs.to_map()
        if self.participant_ids is not None:
            result['participantIds'] = self.participant_ids
        if self.priority is not None:
            result['priority'] = self.priority
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.source is not None:
            result['source'] = self.source
        if self.source_id is not None:
            result['sourceId'] = self.source_id
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.subject is not None:
            result['subject'] = self.subject
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bizTag') is not None:
            self.biz_tag = m.get('bizTag')
        self.content_field_list = []
        if m.get('contentFieldList') is not None:
            for k in m.get('contentFieldList'):
                temp_model = CreateTodoTaskResponseBodyContentFieldList()
                self.content_field_list.append(temp_model.from_map(k))
        if m.get('createdTime') is not None:
            self.created_time = m.get('createdTime')
        if m.get('creatorId') is not None:
            self.creator_id = m.get('creatorId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('detailUrl') is not None:
            temp_model = CreateTodoTaskResponseBodyDetailUrl()
            self.detail_url = temp_model.from_map(m['detailUrl'])
        if m.get('done') is not None:
            self.done = m.get('done')
        if m.get('dueTime') is not None:
            self.due_time = m.get('dueTime')
        if m.get('executorIds') is not None:
            self.executor_ids = m.get('executorIds')
        if m.get('finishTime') is not None:
            self.finish_time = m.get('finishTime')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('isOnlyShowExecutor') is not None:
            self.is_only_show_executor = m.get('isOnlyShowExecutor')
        if m.get('modifiedTime') is not None:
            self.modified_time = m.get('modifiedTime')
        if m.get('modifierId') is not None:
            self.modifier_id = m.get('modifierId')
        if m.get('notifyConfigs') is not None:
            temp_model = CreateTodoTaskResponseBodyNotifyConfigs()
            self.notify_configs = temp_model.from_map(m['notifyConfigs'])
        if m.get('participantIds') is not None:
            self.participant_ids = m.get('participantIds')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('source') is not None:
            self.source = m.get('source')
        if m.get('sourceId') is not None:
            self.source_id = m.get('sourceId')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('subject') is not None:
            self.subject = m.get('subject')
        return self


class CreateTodoTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTodoTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTodoTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVideoConferenceHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateVideoConferenceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateVideoConferenceHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateVideoConferenceHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateVideoConferenceShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateVideoConferenceRequest(TeaModel):
    def __init__(
        self,
        conf_title: str = None,
        invite_caller: bool = None,
        invite_user_ids: List[str] = None,
    ):
        self.conf_title = conf_title
        self.invite_caller = invite_caller
        self.invite_user_ids = invite_user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conf_title is not None:
            result['ConfTitle'] = self.conf_title
        if self.invite_caller is not None:
            result['InviteCaller'] = self.invite_caller
        if self.invite_user_ids is not None:
            result['InviteUserIds'] = self.invite_user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfTitle') is not None:
            self.conf_title = m.get('ConfTitle')
        if m.get('InviteCaller') is not None:
            self.invite_caller = m.get('InviteCaller')
        if m.get('InviteUserIds') is not None:
            self.invite_user_ids = m.get('InviteUserIds')
        return self


class CreateVideoConferenceShrinkRequest(TeaModel):
    def __init__(
        self,
        conf_title: str = None,
        invite_caller: bool = None,
        invite_user_ids_shrink: str = None,
    ):
        self.conf_title = conf_title
        self.invite_caller = invite_caller
        self.invite_user_ids_shrink = invite_user_ids_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conf_title is not None:
            result['ConfTitle'] = self.conf_title
        if self.invite_caller is not None:
            result['InviteCaller'] = self.invite_caller
        if self.invite_user_ids_shrink is not None:
            result['InviteUserIds'] = self.invite_user_ids_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfTitle') is not None:
            self.conf_title = m.get('ConfTitle')
        if m.get('InviteCaller') is not None:
            self.invite_caller = m.get('InviteCaller')
        if m.get('InviteUserIds') is not None:
            self.invite_user_ids_shrink = m.get('InviteUserIds')
        return self


class CreateVideoConferenceResponseBody(TeaModel):
    def __init__(
        self,
        conference_id: str = None,
        conference_password: str = None,
        external_link_url: str = None,
        host_password: str = None,
        phone_numbers: List[str] = None,
        request_id: str = None,
        room_code: str = None,
    ):
        self.conference_id = conference_id
        self.conference_password = conference_password
        self.external_link_url = external_link_url
        self.host_password = host_password
        self.phone_numbers = phone_numbers
        # requestId
        self.request_id = request_id
        self.room_code = room_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conference_id is not None:
            result['conferenceId'] = self.conference_id
        if self.conference_password is not None:
            result['conferencePassword'] = self.conference_password
        if self.external_link_url is not None:
            result['externalLinkUrl'] = self.external_link_url
        if self.host_password is not None:
            result['hostPassword'] = self.host_password
        if self.phone_numbers is not None:
            result['phoneNumbers'] = self.phone_numbers
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.room_code is not None:
            result['roomCode'] = self.room_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('conferenceId') is not None:
            self.conference_id = m.get('conferenceId')
        if m.get('conferencePassword') is not None:
            self.conference_password = m.get('conferencePassword')
        if m.get('externalLinkUrl') is not None:
            self.external_link_url = m.get('externalLinkUrl')
        if m.get('hostPassword') is not None:
            self.host_password = m.get('hostPassword')
        if m.get('phoneNumbers') is not None:
            self.phone_numbers = m.get('phoneNumbers')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('roomCode') is not None:
            self.room_code = m.get('roomCode')
        return self


class CreateVideoConferenceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVideoConferenceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVideoConferenceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWorkspaceHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateWorkspaceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateWorkspaceHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateWorkspaceHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateWorkspaceShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateWorkspaceRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CreateWorkspaceRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        tenant_context: CreateWorkspaceRequestTenantContext = None,
    ):
        self.description = description
        self.name = name
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TenantContext') is not None:
            temp_model = CreateWorkspaceRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class CreateWorkspaceShrinkRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        tenant_context_shrink: str = None,
    ):
        self.description = description
        self.name = name
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class CreateWorkspaceResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        request_id: str = None,
        url: str = None,
        workspace_id: str = None,
    ):
        self.description = description
        self.name = name
        # requestId
        self.request_id = request_id
        self.url = url
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.url is not None:
            result['url'] = self.url
        if self.workspace_id is not None:
            result['workspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('url') is not None:
            self.url = m.get('url')
        if m.get('workspaceId') is not None:
            self.workspace_id = m.get('workspaceId')
        return self


class CreateWorkspaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWorkspaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWorkspaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWorkspaceDocHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class CreateWorkspaceDocHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: CreateWorkspaceDocHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = CreateWorkspaceDocHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class CreateWorkspaceDocShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class CreateWorkspaceDocRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class CreateWorkspaceDocRequest(TeaModel):
    def __init__(
        self,
        doc_type: str = None,
        name: str = None,
        parent_node_id: str = None,
        template_id: str = None,
        template_type: str = None,
        tenant_context: CreateWorkspaceDocRequestTenantContext = None,
        workspace_id: str = None,
    ):
        self.doc_type = doc_type
        self.name = name
        self.parent_node_id = parent_node_id
        self.template_id = template_id
        self.template_type = template_type
        self.tenant_context = tenant_context
        self.workspace_id = workspace_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_node_id is not None:
            result['ParentNodeId'] = self.parent_node_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentNodeId') is not None:
            self.parent_node_id = m.get('ParentNodeId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('TenantContext') is not None:
            temp_model = CreateWorkspaceDocRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CreateWorkspaceDocShrinkRequest(TeaModel):
    def __init__(
        self,
        doc_type: str = None,
        name: str = None,
        parent_node_id: str = None,
        template_id: str = None,
        template_type: str = None,
        tenant_context_shrink: str = None,
        workspace_id: str = None,
    ):
        self.doc_type = doc_type
        self.name = name
        self.parent_node_id = parent_node_id
        self.template_id = template_id
        self.template_type = template_type
        self.tenant_context_shrink = tenant_context_shrink
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_type is not None:
            result['DocType'] = self.doc_type
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_node_id is not None:
            result['ParentNodeId'] = self.parent_node_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DocType') is not None:
            self.doc_type = m.get('DocType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentNodeId') is not None:
            self.parent_node_id = m.get('ParentNodeId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class CreateWorkspaceDocResponseBody(TeaModel):
    def __init__(
        self,
        doc_key: str = None,
        node_id: str = None,
        request_id: str = None,
        url: str = None,
        workspace_id: str = None,
    ):
        self.doc_key = doc_key
        self.node_id = node_id
        # requestId
        self.request_id = request_id
        self.url = url
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doc_key is not None:
            result['docKey'] = self.doc_key
        if self.node_id is not None:
            result['nodeId'] = self.node_id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.url is not None:
            result['url'] = self.url
        if self.workspace_id is not None:
            result['workspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('docKey') is not None:
            self.doc_key = m.get('docKey')
        if m.get('nodeId') is not None:
            self.node_id = m.get('nodeId')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('url') is not None:
            self.url = m.get('url')
        if m.get('workspaceId') is not None:
            self.workspace_id = m.get('workspaceId')
        return self


class CreateWorkspaceDocResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateWorkspaceDocResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateWorkspaceDocResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteColumnsHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteColumnsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteColumnsHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteColumnsHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteColumnsShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteColumnsRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class DeleteColumnsRequest(TeaModel):
    def __init__(
        self,
        column: int = None,
        column_count: int = None,
        sheet_id: str = None,
        tenant_context: DeleteColumnsRequestTenantContext = None,
        workbook_id: str = None,
    ):
        self.column = column
        self.column_count = column_count
        self.sheet_id = sheet_id
        self.tenant_context = tenant_context
        self.workbook_id = workbook_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column is not None:
            result['Column'] = self.column
        if self.column_count is not None:
            result['ColumnCount'] = self.column_count
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Column') is not None:
            self.column = m.get('Column')
        if m.get('ColumnCount') is not None:
            self.column_count = m.get('ColumnCount')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            temp_model = DeleteColumnsRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class DeleteColumnsShrinkRequest(TeaModel):
    def __init__(
        self,
        column: int = None,
        column_count: int = None,
        sheet_id: str = None,
        tenant_context_shrink: str = None,
        workbook_id: str = None,
    ):
        self.column = column
        self.column_count = column_count
        self.sheet_id = sheet_id
        self.tenant_context_shrink = tenant_context_shrink
        self.workbook_id = workbook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column is not None:
            result['Column'] = self.column
        if self.column_count is not None:
            result['ColumnCount'] = self.column_count
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Column') is not None:
            self.column = m.get('Column')
        if m.get('ColumnCount') is not None:
            self.column_count = m.get('ColumnCount')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class DeleteColumnsResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
    ):
        self.id = id
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class DeleteColumnsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteColumnsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteColumnsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEventHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteEventHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteEventHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteEventHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteEventShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteEventRequest(TeaModel):
    def __init__(
        self,
        calendar_id: str = None,
        event_id: str = None,
        push_notification: bool = None,
    ):
        self.calendar_id = calendar_id
        self.event_id = event_id
        self.push_notification = push_notification

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.push_notification is not None:
            result['pushNotification'] = self.push_notification
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('pushNotification') is not None:
            self.push_notification = m.get('pushNotification')
        return self


class DeleteEventResponseBodyContent(TeaModel):
    def __init__(
        self,
        data: Any = None,
    ):
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class DeleteEventResponseBody(TeaModel):
    def __init__(
        self,
        content: DeleteEventResponseBodyContent = None,
        error_code: str = None,
        error_ctx: Dict[str, Any] = None,
        error_msg: str = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.content = content
        self.error_code = error_code
        self.error_ctx = error_ctx
        self.error_msg = error_msg
        self.http_status_code = http_status_code
        # requestId
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content.to_map()
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.error_ctx is not None:
            result['errorCtx'] = self.error_ctx
        if self.error_msg is not None:
            result['errorMsg'] = self.error_msg
        if self.http_status_code is not None:
            result['httpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            temp_model = DeleteEventResponseBodyContent()
            self.content = temp_model.from_map(m['content'])
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('errorCtx') is not None:
            self.error_ctx = m.get('errorCtx')
        if m.get('errorMsg') is not None:
            self.error_msg = m.get('errorMsg')
        if m.get('httpStatusCode') is not None:
            self.http_status_code = m.get('httpStatusCode')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteEventResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEventResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEventResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFormDataHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteFormDataHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteFormDataHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteFormDataHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteFormDataShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteFormDataRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        form_instance_id: str = None,
        language: str = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.form_instance_id = form_instance_id
        self.language = language
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.form_instance_id is not None:
            result['FormInstanceId'] = self.form_instance_id
        if self.language is not None:
            result['Language'] = self.language
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FormInstanceId') is not None:
            self.form_instance_id = m.get('FormInstanceId')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class DeleteFormDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.request_id = request_id
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class DeleteFormDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteFormDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFormDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteLiveHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteLiveHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteLiveHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteLiveShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteLiveRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class DeleteLiveRequest(TeaModel):
    def __init__(
        self,
        live_id: str = None,
        tenant_context: DeleteLiveRequestTenantContext = None,
    ):
        self.live_id = live_id
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_id is not None:
            result['LiveId'] = self.live_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LiveId') is not None:
            self.live_id = m.get('LiveId')
        if m.get('TenantContext') is not None:
            temp_model = DeleteLiveRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class DeleteLiveShrinkRequest(TeaModel):
    def __init__(
        self,
        live_id: str = None,
        tenant_context_shrink: str = None,
    ):
        self.live_id = live_id
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_id is not None:
            result['LiveId'] = self.live_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LiveId') is not None:
            self.live_id = m.get('LiveId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class DeleteLiveResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # requestId
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteLiveResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMeetingRoomHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteMeetingRoomHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteMeetingRoomHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteMeetingRoomHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteMeetingRoomShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteMeetingRoomRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class DeleteMeetingRoomRequest(TeaModel):
    def __init__(
        self,
        room_id: str = None,
        tenant_context: DeleteMeetingRoomRequestTenantContext = None,
    ):
        self.room_id = room_id
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        if m.get('TenantContext') is not None:
            temp_model = DeleteMeetingRoomRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class DeleteMeetingRoomShrinkRequest(TeaModel):
    def __init__(
        self,
        room_id: str = None,
        tenant_context_shrink: str = None,
    ):
        self.room_id = room_id
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class DeleteMeetingRoomResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: bool = None,
    ):
        # requestId
        self.request_id = request_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteMeetingRoomResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMeetingRoomResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMeetingRoomResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMeetingRoomGroupHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteMeetingRoomGroupHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteMeetingRoomGroupHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteMeetingRoomGroupHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteMeetingRoomGroupShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteMeetingRoomGroupRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class DeleteMeetingRoomGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        tenant_context: DeleteMeetingRoomGroupRequestTenantContext = None,
    ):
        self.group_id = group_id
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('TenantContext') is not None:
            temp_model = DeleteMeetingRoomGroupRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class DeleteMeetingRoomGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        tenant_context_shrink: str = None,
    ):
        self.group_id = group_id
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class DeleteMeetingRoomGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: bool = None,
    ):
        # requestId
        self.request_id = request_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteMeetingRoomGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMeetingRoomGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMeetingRoomGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRowsHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteRowsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteRowsHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteRowsHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteRowsShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteRowsRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class DeleteRowsRequest(TeaModel):
    def __init__(
        self,
        row: int = None,
        row_count: int = None,
        sheet_id: str = None,
        tenant_context: DeleteRowsRequestTenantContext = None,
        workbook_id: str = None,
    ):
        self.row = row
        self.row_count = row_count
        self.sheet_id = sheet_id
        self.tenant_context = tenant_context
        self.workbook_id = workbook_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.row is not None:
            result['Row'] = self.row
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Row') is not None:
            self.row = m.get('Row')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            temp_model = DeleteRowsRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class DeleteRowsShrinkRequest(TeaModel):
    def __init__(
        self,
        row: int = None,
        row_count: int = None,
        sheet_id: str = None,
        tenant_context_shrink: str = None,
        workbook_id: str = None,
    ):
        self.row = row
        self.row_count = row_count
        self.sheet_id = sheet_id
        self.tenant_context_shrink = tenant_context_shrink
        self.workbook_id = workbook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.row is not None:
            result['Row'] = self.row
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Row') is not None:
            self.row = m.get('Row')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class DeleteRowsResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
    ):
        self.id = id
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class DeleteRowsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRowsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRowsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteScenegroupMemberHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteScenegroupMemberHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteScenegroupMemberHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteScenegroupMemberHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteScenegroupMemberShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteScenegroupMemberRequest(TeaModel):
    def __init__(
        self,
        open_conversation_id: str = None,
        user_ids: str = None,
    ):
        self.open_conversation_id = open_conversation_id
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.open_conversation_id is not None:
            result['OpenConversationId'] = self.open_conversation_id
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OpenConversationId') is not None:
            self.open_conversation_id = m.get('OpenConversationId')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class DeleteScenegroupMemberResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # requestId
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteScenegroupMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteScenegroupMemberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteScenegroupMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSheetHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteSheetHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteSheetHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteSheetHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteSheetShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteSheetRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class DeleteSheetRequest(TeaModel):
    def __init__(
        self,
        sheet_id: str = None,
        tenant_context: DeleteSheetRequestTenantContext = None,
        workbook_id: str = None,
    ):
        self.sheet_id = sheet_id
        self.tenant_context = tenant_context
        self.workbook_id = workbook_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            temp_model = DeleteSheetRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class DeleteSheetShrinkRequest(TeaModel):
    def __init__(
        self,
        sheet_id: str = None,
        tenant_context_shrink: str = None,
        workbook_id: str = None,
    ):
        self.sheet_id = sheet_id
        self.tenant_context_shrink = tenant_context_shrink
        self.workbook_id = workbook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class DeleteSheetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # requestId
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteSheetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSheetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSheetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSubscribedCalendarHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteSubscribedCalendarHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteSubscribedCalendarHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteSubscribedCalendarHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteSubscribedCalendarShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteSubscribedCalendarRequest(TeaModel):
    def __init__(
        self,
        calendar_id: str = None,
    ):
        self.calendar_id = calendar_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        return self


class DeleteSubscribedCalendarResponseBody(TeaModel):
    def __init__(
        self,
        result: bool = None,
        request_id: str = None,
    ):
        self.result = result
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['Result'] = self.result
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class DeleteSubscribedCalendarResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSubscribedCalendarResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSubscribedCalendarResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTodoTaskHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteTodoTaskHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteTodoTaskHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteTodoTaskHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteTodoTaskShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteTodoTaskRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class DeleteTodoTaskRequest(TeaModel):
    def __init__(
        self,
        tenant_context: DeleteTodoTaskRequestTenantContext = None,
        operator_id: str = None,
        task_id: str = None,
    ):
        self.tenant_context = tenant_context
        self.operator_id = operator_id
        self.task_id = task_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.operator_id is not None:
            result['operatorId'] = self.operator_id
        if self.task_id is not None:
            result['taskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            temp_model = DeleteTodoTaskRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('operatorId') is not None:
            self.operator_id = m.get('operatorId')
        if m.get('taskId') is not None:
            self.task_id = m.get('taskId')
        return self


class DeleteTodoTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        tenant_context_shrink: str = None,
        operator_id: str = None,
        task_id: str = None,
    ):
        self.tenant_context_shrink = tenant_context_shrink
        self.operator_id = operator_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.operator_id is not None:
            result['operatorId'] = self.operator_id
        if self.task_id is not None:
            result['taskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('operatorId') is not None:
            self.operator_id = m.get('operatorId')
        if m.get('taskId') is not None:
            self.task_id = m.get('taskId')
        return self


class DeleteTodoTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: bool = None,
    ):
        # requestId
        self.request_id = request_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteTodoTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTodoTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTodoTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWorkspaceDocMembersHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteWorkspaceDocMembersHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteWorkspaceDocMembersHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteWorkspaceDocMembersHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteWorkspaceDocMembersShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteWorkspaceDocMembersRequestMembers(TeaModel):
    def __init__(
        self,
        member_id: str = None,
        member_type: str = None,
    ):
        self.member_id = member_id
        self.member_type = member_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_type is not None:
            result['MemberType'] = self.member_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberType') is not None:
            self.member_type = m.get('MemberType')
        return self


class DeleteWorkspaceDocMembersRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class DeleteWorkspaceDocMembersRequest(TeaModel):
    def __init__(
        self,
        members: List[DeleteWorkspaceDocMembersRequestMembers] = None,
        node_id: str = None,
        tenant_context: DeleteWorkspaceDocMembersRequestTenantContext = None,
        workspace_id: str = None,
    ):
        self.members = members
        self.node_id = node_id
        self.tenant_context = tenant_context
        self.workspace_id = workspace_id

    def validate(self):
        if self.members:
            for k in self.members:
                if k:
                    k.validate()
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Members'] = []
        if self.members is not None:
            for k in self.members:
                result['Members'].append(k.to_map() if k else None)
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.members = []
        if m.get('Members') is not None:
            for k in m.get('Members'):
                temp_model = DeleteWorkspaceDocMembersRequestMembers()
                self.members.append(temp_model.from_map(k))
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TenantContext') is not None:
            temp_model = DeleteWorkspaceDocMembersRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteWorkspaceDocMembersShrinkRequest(TeaModel):
    def __init__(
        self,
        members_shrink: str = None,
        node_id: str = None,
        tenant_context_shrink: str = None,
        workspace_id: str = None,
    ):
        self.members_shrink = members_shrink
        self.node_id = node_id
        self.tenant_context_shrink = tenant_context_shrink
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.members_shrink is not None:
            result['Members'] = self.members_shrink
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Members') is not None:
            self.members_shrink = m.get('Members')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteWorkspaceDocMembersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class DeleteWorkspaceDocMembersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteWorkspaceDocMembersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWorkspaceDocMembersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWorkspaceMembersHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class DeleteWorkspaceMembersHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: DeleteWorkspaceMembersHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = DeleteWorkspaceMembersHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class DeleteWorkspaceMembersShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class DeleteWorkspaceMembersRequestMembers(TeaModel):
    def __init__(
        self,
        member_id: str = None,
        member_type: str = None,
    ):
        self.member_id = member_id
        self.member_type = member_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_type is not None:
            result['MemberType'] = self.member_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberType') is not None:
            self.member_type = m.get('MemberType')
        return self


class DeleteWorkspaceMembersRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class DeleteWorkspaceMembersRequest(TeaModel):
    def __init__(
        self,
        members: List[DeleteWorkspaceMembersRequestMembers] = None,
        tenant_context: DeleteWorkspaceMembersRequestTenantContext = None,
        workspace_id: str = None,
    ):
        self.members = members
        self.tenant_context = tenant_context
        self.workspace_id = workspace_id

    def validate(self):
        if self.members:
            for k in self.members:
                if k:
                    k.validate()
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Members'] = []
        if self.members is not None:
            for k in self.members:
                result['Members'].append(k.to_map() if k else None)
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.members = []
        if m.get('Members') is not None:
            for k in m.get('Members'):
                temp_model = DeleteWorkspaceMembersRequestMembers()
                self.members.append(temp_model.from_map(k))
        if m.get('TenantContext') is not None:
            temp_model = DeleteWorkspaceMembersRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteWorkspaceMembersShrinkRequest(TeaModel):
    def __init__(
        self,
        members_shrink: str = None,
        tenant_context_shrink: str = None,
        workspace_id: str = None,
    ):
        self.members_shrink = members_shrink
        self.tenant_context_shrink = tenant_context_shrink
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.members_shrink is not None:
            result['Members'] = self.members_shrink
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Members') is not None:
            self.members_shrink = m.get('Members')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class DeleteWorkspaceMembersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class DeleteWorkspaceMembersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteWorkspaceMembersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteWorkspaceMembersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAllSheetsHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetAllSheetsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetAllSheetsHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetAllSheetsHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetAllSheetsShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetAllSheetsRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetAllSheetsRequest(TeaModel):
    def __init__(
        self,
        tenant_context: GetAllSheetsRequestTenantContext = None,
        workbook_id: str = None,
    ):
        self.tenant_context = tenant_context
        self.workbook_id = workbook_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            temp_model = GetAllSheetsRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class GetAllSheetsShrinkRequest(TeaModel):
    def __init__(
        self,
        tenant_context_shrink: str = None,
        workbook_id: str = None,
    ):
        self.tenant_context_shrink = tenant_context_shrink
        self.workbook_id = workbook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class GetAllSheetsResponseBodyValue(TeaModel):
    def __init__(
        self,
        id: str = None,
        name: str = None,
    ):
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetAllSheetsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        value: List[GetAllSheetsResponseBodyValue] = None,
    ):
        # requestId
        self.request_id = request_id
        self.value = value

    def validate(self):
        if self.value:
            for k in self.value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['value'] = []
        if self.value is not None:
            for k in self.value:
                result['value'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.value = []
        if m.get('value') is not None:
            for k in m.get('value'):
                temp_model = GetAllSheetsResponseBodyValue()
                self.value.append(temp_model.from_map(k))
        return self


class GetAllSheetsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAllSheetsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAllSheetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEventHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetEventHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetEventHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetEventHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetEventShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetEventRequest(TeaModel):
    def __init__(
        self,
        calendar_id: str = None,
        event_id: str = None,
        max_attendees: int = None,
    ):
        self.calendar_id = calendar_id
        self.event_id = event_id
        self.max_attendees = max_attendees

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.max_attendees is not None:
            result['MaxAttendees'] = self.max_attendees
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('MaxAttendees') is not None:
            self.max_attendees = m.get('MaxAttendees')
        return self


class GetEventResponseBodyAttendees(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        id: str = None,
        is_optional: bool = None,
        response_status: str = None,
        self_: bool = None,
    ):
        self.display_name = display_name
        self.id = id
        self.is_optional = is_optional
        self.response_status = response_status
        self.self_ = self_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.id is not None:
            result['Id'] = self.id
        if self.is_optional is not None:
            result['IsOptional'] = self.is_optional
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.self_ is not None:
            result['Self'] = self.self_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsOptional') is not None:
            self.is_optional = m.get('IsOptional')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('Self') is not None:
            self.self_ = m.get('Self')
        return self


class GetEventResponseBodyCategories(TeaModel):
    def __init__(
        self,
        display_name: str = None,
    ):
        self.display_name = display_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        return self


class GetEventResponseBodyEnd(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class GetEventResponseBodyExtendedPropertiesSharedProperties(TeaModel):
    def __init__(
        self,
        belong_corp_id: str = None,
        source_open_cid: str = None,
    ):
        self.belong_corp_id = belong_corp_id
        self.source_open_cid = source_open_cid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.belong_corp_id is not None:
            result['BelongCorpId'] = self.belong_corp_id
        if self.source_open_cid is not None:
            result['SourceOpenCid'] = self.source_open_cid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BelongCorpId') is not None:
            self.belong_corp_id = m.get('BelongCorpId')
        if m.get('SourceOpenCid') is not None:
            self.source_open_cid = m.get('SourceOpenCid')
        return self


class GetEventResponseBodyExtendedProperties(TeaModel):
    def __init__(
        self,
        shared_properties: GetEventResponseBodyExtendedPropertiesSharedProperties = None,
    ):
        self.shared_properties = shared_properties

    def validate(self):
        if self.shared_properties:
            self.shared_properties.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.shared_properties is not None:
            result['SharedProperties'] = self.shared_properties.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SharedProperties') is not None:
            temp_model = GetEventResponseBodyExtendedPropertiesSharedProperties()
            self.shared_properties = temp_model.from_map(m['SharedProperties'])
        return self


class GetEventResponseBodyLocation(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        meeting_rooms: List[str] = None,
    ):
        self.display_name = display_name
        # --\
        self.meeting_rooms = meeting_rooms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.meeting_rooms is not None:
            result['MeetingRooms'] = self.meeting_rooms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('MeetingRooms') is not None:
            self.meeting_rooms = m.get('MeetingRooms')
        return self


class GetEventResponseBodyMeetingRooms(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        response_status: str = None,
        room_id: str = None,
    ):
        self.display_name = display_name
        self.response_status = response_status
        self.room_id = room_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class GetEventResponseBodyOnlineMeetingInfo(TeaModel):
    def __init__(
        self,
        conference_id: str = None,
        extra_info: Dict[str, Any] = None,
        type: str = None,
        url: str = None,
    ):
        self.conference_id = conference_id
        self.extra_info = extra_info
        self.type = type
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conference_id is not None:
            result['ConferenceId'] = self.conference_id
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConferenceId') is not None:
            self.conference_id = m.get('ConferenceId')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetEventResponseBodyOrganizer(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        id: str = None,
        response_status: str = None,
        self_: bool = None,
    ):
        self.display_name = display_name
        self.id = id
        self.response_status = response_status
        self.self_ = self_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.id is not None:
            result['Id'] = self.id
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.self_ is not None:
            result['Self'] = self.self_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('Self') is not None:
            self.self_ = m.get('Self')
        return self


class GetEventResponseBodyOriginStart(TeaModel):
    def __init__(
        self,
        date_time: str = None,
    ):
        self.date_time = date_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        return self


class GetEventResponseBodyRecurrencePattern(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        days_of_week: str = None,
        index: str = None,
        interval: int = None,
        type: str = None,
    ):
        self.day_of_month = day_of_month
        self.days_of_week = days_of_week
        self.index = index
        self.interval = interval
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['DayOfMonth'] = self.day_of_month
        if self.days_of_week is not None:
            result['DaysOfWeek'] = self.days_of_week
        if self.index is not None:
            result['Index'] = self.index
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DayOfMonth') is not None:
            self.day_of_month = m.get('DayOfMonth')
        if m.get('DaysOfWeek') is not None:
            self.days_of_week = m.get('DaysOfWeek')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetEventResponseBodyRecurrenceRange(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        number_of_occurrences: int = None,
        type: str = None,
    ):
        self.end_date = end_date
        self.number_of_occurrences = number_of_occurrences
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.number_of_occurrences is not None:
            result['NumberOfOccurrences'] = self.number_of_occurrences
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('NumberOfOccurrences') is not None:
            self.number_of_occurrences = m.get('NumberOfOccurrences')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetEventResponseBodyRecurrence(TeaModel):
    def __init__(
        self,
        pattern: GetEventResponseBodyRecurrencePattern = None,
        range: GetEventResponseBodyRecurrenceRange = None,
    ):
        self.pattern = pattern
        self.range = range

    def validate(self):
        if self.pattern:
            self.pattern.validate()
        if self.range:
            self.range.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pattern is not None:
            result['Pattern'] = self.pattern.to_map()
        if self.range is not None:
            result['Range'] = self.range.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pattern') is not None:
            temp_model = GetEventResponseBodyRecurrencePattern()
            self.pattern = temp_model.from_map(m['Pattern'])
        if m.get('Range') is not None:
            temp_model = GetEventResponseBodyRecurrenceRange()
            self.range = temp_model.from_map(m['Range'])
        return self


class GetEventResponseBodyReminders(TeaModel):
    def __init__(
        self,
        method: str = None,
        minutes: str = None,
    ):
        self.method = method
        self.minutes = minutes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method is not None:
            result['Method'] = self.method
        if self.minutes is not None:
            result['Minutes'] = self.minutes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Minutes') is not None:
            self.minutes = m.get('Minutes')
        return self


class GetEventResponseBodyRichTextDescription(TeaModel):
    def __init__(
        self,
        text: str = None,
    ):
        self.text = text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class GetEventResponseBodyStart(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class GetEventResponseBody(TeaModel):
    def __init__(
        self,
        attendees: List[GetEventResponseBodyAttendees] = None,
        categories: List[GetEventResponseBodyCategories] = None,
        create_time: str = None,
        description: str = None,
        end: GetEventResponseBodyEnd = None,
        extended_properties: GetEventResponseBodyExtendedProperties = None,
        id: str = None,
        is_all_day: bool = None,
        location: GetEventResponseBodyLocation = None,
        meeting_rooms: List[GetEventResponseBodyMeetingRooms] = None,
        online_meeting_info: GetEventResponseBodyOnlineMeetingInfo = None,
        organizer: GetEventResponseBodyOrganizer = None,
        origin_start: GetEventResponseBodyOriginStart = None,
        recurrence: GetEventResponseBodyRecurrence = None,
        reminders: List[GetEventResponseBodyReminders] = None,
        request_id: str = None,
        rich_text_description: GetEventResponseBodyRichTextDescription = None,
        series_master_id: str = None,
        start: GetEventResponseBodyStart = None,
        status: str = None,
        summary: str = None,
        update_time: str = None,
    ):
        self.attendees = attendees
        self.categories = categories
        self.create_time = create_time
        self.description = description
        self.end = end
        self.extended_properties = extended_properties
        self.id = id
        self.is_all_day = is_all_day
        self.location = location
        self.meeting_rooms = meeting_rooms
        self.online_meeting_info = online_meeting_info
        self.organizer = organizer
        self.origin_start = origin_start
        self.recurrence = recurrence
        self.reminders = reminders
        # requestId
        self.request_id = request_id
        self.rich_text_description = rich_text_description
        self.series_master_id = series_master_id
        self.start = start
        self.status = status
        self.summary = summary
        self.update_time = update_time

    def validate(self):
        if self.attendees:
            for k in self.attendees:
                if k:
                    k.validate()
        if self.categories:
            for k in self.categories:
                if k:
                    k.validate()
        if self.end:
            self.end.validate()
        if self.extended_properties:
            self.extended_properties.validate()
        if self.location:
            self.location.validate()
        if self.meeting_rooms:
            for k in self.meeting_rooms:
                if k:
                    k.validate()
        if self.online_meeting_info:
            self.online_meeting_info.validate()
        if self.organizer:
            self.organizer.validate()
        if self.origin_start:
            self.origin_start.validate()
        if self.recurrence:
            self.recurrence.validate()
        if self.reminders:
            for k in self.reminders:
                if k:
                    k.validate()
        if self.rich_text_description:
            self.rich_text_description.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['attendees'] = []
        if self.attendees is not None:
            for k in self.attendees:
                result['attendees'].append(k.to_map() if k else None)
        result['categories'] = []
        if self.categories is not None:
            for k in self.categories:
                result['categories'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.description is not None:
            result['description'] = self.description
        if self.end is not None:
            result['end'] = self.end.to_map()
        if self.extended_properties is not None:
            result['extendedProperties'] = self.extended_properties.to_map()
        if self.id is not None:
            result['id'] = self.id
        if self.is_all_day is not None:
            result['isAllDay'] = self.is_all_day
        if self.location is not None:
            result['location'] = self.location.to_map()
        result['meetingRooms'] = []
        if self.meeting_rooms is not None:
            for k in self.meeting_rooms:
                result['meetingRooms'].append(k.to_map() if k else None)
        if self.online_meeting_info is not None:
            result['onlineMeetingInfo'] = self.online_meeting_info.to_map()
        if self.organizer is not None:
            result['organizer'] = self.organizer.to_map()
        if self.origin_start is not None:
            result['originStart'] = self.origin_start.to_map()
        if self.recurrence is not None:
            result['recurrence'] = self.recurrence.to_map()
        result['reminders'] = []
        if self.reminders is not None:
            for k in self.reminders:
                result['reminders'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.rich_text_description is not None:
            result['richTextDescription'] = self.rich_text_description.to_map()
        if self.series_master_id is not None:
            result['seriesMasterId'] = self.series_master_id
        if self.start is not None:
            result['start'] = self.start.to_map()
        if self.status is not None:
            result['status'] = self.status
        if self.summary is not None:
            result['summary'] = self.summary
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attendees = []
        if m.get('attendees') is not None:
            for k in m.get('attendees'):
                temp_model = GetEventResponseBodyAttendees()
                self.attendees.append(temp_model.from_map(k))
        self.categories = []
        if m.get('categories') is not None:
            for k in m.get('categories'):
                temp_model = GetEventResponseBodyCategories()
                self.categories.append(temp_model.from_map(k))
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('end') is not None:
            temp_model = GetEventResponseBodyEnd()
            self.end = temp_model.from_map(m['end'])
        if m.get('extendedProperties') is not None:
            temp_model = GetEventResponseBodyExtendedProperties()
            self.extended_properties = temp_model.from_map(m['extendedProperties'])
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('isAllDay') is not None:
            self.is_all_day = m.get('isAllDay')
        if m.get('location') is not None:
            temp_model = GetEventResponseBodyLocation()
            self.location = temp_model.from_map(m['location'])
        self.meeting_rooms = []
        if m.get('meetingRooms') is not None:
            for k in m.get('meetingRooms'):
                temp_model = GetEventResponseBodyMeetingRooms()
                self.meeting_rooms.append(temp_model.from_map(k))
        if m.get('onlineMeetingInfo') is not None:
            temp_model = GetEventResponseBodyOnlineMeetingInfo()
            self.online_meeting_info = temp_model.from_map(m['onlineMeetingInfo'])
        if m.get('organizer') is not None:
            temp_model = GetEventResponseBodyOrganizer()
            self.organizer = temp_model.from_map(m['organizer'])
        if m.get('originStart') is not None:
            temp_model = GetEventResponseBodyOriginStart()
            self.origin_start = temp_model.from_map(m['originStart'])
        if m.get('recurrence') is not None:
            temp_model = GetEventResponseBodyRecurrence()
            self.recurrence = temp_model.from_map(m['recurrence'])
        self.reminders = []
        if m.get('reminders') is not None:
            for k in m.get('reminders'):
                temp_model = GetEventResponseBodyReminders()
                self.reminders.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('richTextDescription') is not None:
            temp_model = GetEventResponseBodyRichTextDescription()
            self.rich_text_description = temp_model.from_map(m['richTextDescription'])
        if m.get('seriesMasterId') is not None:
            self.series_master_id = m.get('seriesMasterId')
        if m.get('start') is not None:
            temp_model = GetEventResponseBodyStart()
            self.start = temp_model.from_map(m['start'])
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('summary') is not None:
            self.summary = m.get('summary')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class GetEventResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEventResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEventResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFieldDefByUuidHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetFieldDefByUuidHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetFieldDefByUuidHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetFieldDefByUuidHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetFieldDefByUuidShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetFieldDefByUuidRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        form_uuid: str = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.form_uuid = form_uuid
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class GetFieldDefByUuidResponseBodyResult(TeaModel):
    def __init__(
        self,
        behavior: str = None,
        children: str = None,
        component_name: str = None,
        field_id: str = None,
        label: Any = None,
        props: Any = None,
        success: bool = None,
    ):
        self.behavior = behavior
        self.children = children
        self.component_name = component_name
        self.field_id = field_id
        self.label = label
        self.props = props
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.behavior is not None:
            result['Behavior'] = self.behavior
        if self.children is not None:
            result['Children'] = self.children
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.field_id is not None:
            result['FieldId'] = self.field_id
        if self.label is not None:
            result['Label'] = self.label
        if self.props is not None:
            result['Props'] = self.props
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Behavior') is not None:
            self.behavior = m.get('Behavior')
        if m.get('Children') is not None:
            self.children = m.get('Children')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('FieldId') is not None:
            self.field_id = m.get('FieldId')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Props') is not None:
            self.props = m.get('Props')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFieldDefByUuidResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: List[GetFieldDefByUuidResponseBodyResult] = None,
        success: bool = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.request_id = request_id
        self.result = result
        self.success = success
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = GetFieldDefByUuidResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class GetFieldDefByUuidResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFieldDefByUuidResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFieldDefByUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFormComponentDefinitionListHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetFormComponentDefinitionListHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetFormComponentDefinitionListHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetFormComponentDefinitionListHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetFormComponentDefinitionListShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetFormComponentDefinitionListRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        form_uuid: str = None,
        language: str = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.form_uuid = form_uuid
        self.language = language
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.language is not None:
            result['Language'] = self.language
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class GetFormComponentDefinitionListResponseBodyResult(TeaModel):
    def __init__(
        self,
        component_name: str = None,
        field_id: str = None,
        label: str = None,
        parent_id: str = None,
    ):
        self.component_name = component_name
        self.field_id = field_id
        self.label = label
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.field_id is not None:
            result['FieldId'] = self.field_id
        if self.label is not None:
            result['Label'] = self.label
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('FieldId') is not None:
            self.field_id = m.get('FieldId')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class GetFormComponentDefinitionListResponseBody(TeaModel):
    def __init__(
        self,
        result: List[GetFormComponentDefinitionListResponseBodyResult] = None,
        request_id: str = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.result = result
        self.request_id = request_id
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = GetFormComponentDefinitionListResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class GetFormComponentDefinitionListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFormComponentDefinitionListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFormComponentDefinitionListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFormDataByIDHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetFormDataByIDHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetFormDataByIDHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetFormDataByIDHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetFormDataByIDShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetFormDataByIDRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        id: str = None,
        language: str = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.id = id
        self.language = language
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.id is not None:
            result['Id'] = self.id
        if self.language is not None:
            result['Language'] = self.language
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class GetFormDataByIDResponseBodyOriginatorName(TeaModel):
    def __init__(
        self,
        name_in_chinese: str = None,
        name_in_english: str = None,
        type: str = None,
    ):
        self.name_in_chinese = name_in_chinese
        self.name_in_english = name_in_english
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_in_chinese is not None:
            result['NameInChinese'] = self.name_in_chinese
        if self.name_in_english is not None:
            result['NameInEnglish'] = self.name_in_english
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameInChinese') is not None:
            self.name_in_chinese = m.get('NameInChinese')
        if m.get('NameInEnglish') is not None:
            self.name_in_english = m.get('NameInEnglish')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetFormDataByIDResponseBodyOriginator(TeaModel):
    def __init__(
        self,
        department_name: str = None,
        email: str = None,
        name: GetFormDataByIDResponseBodyOriginatorName = None,
        user_id: str = None,
    ):
        self.department_name = department_name
        self.email = email
        self.name = name
        self.user_id = user_id

    def validate(self):
        if self.name:
            self.name.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_name is not None:
            result['DepartmentName'] = self.department_name
        if self.email is not None:
            result['Email'] = self.email
        if self.name is not None:
            result['Name'] = self.name.to_map()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentName') is not None:
            self.department_name = m.get('DepartmentName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('Name') is not None:
            temp_model = GetFormDataByIDResponseBodyOriginatorName()
            self.name = temp_model.from_map(m['Name'])
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetFormDataByIDResponseBody(TeaModel):
    def __init__(
        self,
        form_data: Dict[str, Any] = None,
        form_inst_id: str = None,
        modified_time_gmt: str = None,
        originator: GetFormDataByIDResponseBodyOriginator = None,
        request_id: str = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.form_data = form_data
        self.form_inst_id = form_inst_id
        self.modified_time_gmt = modified_time_gmt
        self.originator = originator
        self.request_id = request_id
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        if self.originator:
            self.originator.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.form_data is not None:
            result['formData'] = self.form_data
        if self.form_inst_id is not None:
            result['formInstId'] = self.form_inst_id
        if self.modified_time_gmt is not None:
            result['modifiedTimeGMT'] = self.modified_time_gmt
        if self.originator is not None:
            result['originator'] = self.originator.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('formData') is not None:
            self.form_data = m.get('formData')
        if m.get('formInstId') is not None:
            self.form_inst_id = m.get('formInstId')
        if m.get('modifiedTimeGMT') is not None:
            self.modified_time_gmt = m.get('modifiedTimeGMT')
        if m.get('originator') is not None:
            temp_model = GetFormDataByIDResponseBodyOriginator()
            self.originator = temp_model.from_map(m['originator'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class GetFormDataByIDResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFormDataByIDResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFormDataByIDResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFormListInAppHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetFormListInAppHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetFormListInAppHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetFormListInAppHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetFormListInAppShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetFormListInAppRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        form_types: str = None,
        page_number: int = None,
        page_size: int = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.form_types = form_types
        self.page_number = page_number
        self.page_size = page_size
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.form_types is not None:
            result['FormTypes'] = self.form_types
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FormTypes') is not None:
            self.form_types = m.get('FormTypes')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class GetFormListInAppResponseBodyDataTitle(TeaModel):
    def __init__(
        self,
        en_us: str = None,
        zh_cn: str = None,
    ):
        self.en_us = en_us
        self.zh_cn = zh_cn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.en_us is not None:
            result['EnUS'] = self.en_us
        if self.zh_cn is not None:
            result['ZhCN'] = self.zh_cn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnUS') is not None:
            self.en_us = m.get('EnUS')
        if m.get('ZhCN') is not None:
            self.zh_cn = m.get('ZhCN')
        return self


class GetFormListInAppResponseBodyData(TeaModel):
    def __init__(
        self,
        creator: str = None,
        form_type: str = None,
        form_uuid: str = None,
        gmt_create: str = None,
        title: GetFormListInAppResponseBodyDataTitle = None,
    ):
        self.creator = creator
        self.form_type = form_type
        self.form_uuid = form_uuid
        self.gmt_create = gmt_create
        self.title = title

    def validate(self):
        if self.title:
            self.title.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.form_type is not None:
            result['FormType'] = self.form_type
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.title is not None:
            result['Title'] = self.title.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('FormType') is not None:
            self.form_type = m.get('FormType')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Title') is not None:
            temp_model = GetFormListInAppResponseBodyDataTitle()
            self.title = temp_model.from_map(m['Title'])
        return self


class GetFormListInAppResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        data: List[GetFormListInAppResponseBodyData] = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.current_page = current_page
        self.data = data
        self.request_id = request_id
        self.success = success
        self.total_count = total_count
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['currentPage'] = self.current_page
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('currentPage') is not None:
            self.current_page = m.get('currentPage')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = GetFormListInAppResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class GetFormListInAppResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFormListInAppResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFormListInAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMeetingRoomsScheduleHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetMeetingRoomsScheduleHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetMeetingRoomsScheduleHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetMeetingRoomsScheduleHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetMeetingRoomsScheduleShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetMeetingRoomsScheduleRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        room_ids: List[str] = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.room_ids = room_ids
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.room_ids is not None:
            result['RoomIds'] = self.room_ids
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RoomIds') is not None:
            self.room_ids = m.get('RoomIds')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetMeetingRoomsScheduleShrinkRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        room_ids_shrink: str = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.room_ids_shrink = room_ids_shrink
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.room_ids_shrink is not None:
            result['RoomIds'] = self.room_ids_shrink
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RoomIds') is not None:
            self.room_ids_shrink = m.get('RoomIds')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItemsEnd(TeaModel):
    def __init__(
        self,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItemsOrganizer(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItemsStart(TeaModel):
    def __init__(
        self,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItems(TeaModel):
    def __init__(
        self,
        end: GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItemsEnd = None,
        event_id: str = None,
        organizer: GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItemsOrganizer = None,
        start: GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItemsStart = None,
        status: str = None,
    ):
        self.end = end
        self.event_id = event_id
        self.organizer = organizer
        self.start = start
        self.status = status

    def validate(self):
        if self.end:
            self.end.validate()
        if self.organizer:
            self.organizer.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end.to_map()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.organizer is not None:
            result['Organizer'] = self.organizer.to_map()
        if self.start is not None:
            result['Start'] = self.start.to_map()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            temp_model = GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItemsEnd()
            self.end = temp_model.from_map(m['End'])
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Organizer') is not None:
            temp_model = GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItemsOrganizer()
            self.organizer = temp_model.from_map(m['Organizer'])
        if m.get('Start') is not None:
            temp_model = GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItemsStart()
            self.start = temp_model.from_map(m['Start'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetMeetingRoomsScheduleResponseBodyScheduleInformation(TeaModel):
    def __init__(
        self,
        error: str = None,
        room_id: str = None,
        schedule_items: List[GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItems] = None,
    ):
        self.error = error
        self.room_id = room_id
        self.schedule_items = schedule_items

    def validate(self):
        if self.schedule_items:
            for k in self.schedule_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error is not None:
            result['Error'] = self.error
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        result['ScheduleItems'] = []
        if self.schedule_items is not None:
            for k in self.schedule_items:
                result['ScheduleItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Error') is not None:
            self.error = m.get('Error')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        self.schedule_items = []
        if m.get('ScheduleItems') is not None:
            for k in m.get('ScheduleItems'):
                temp_model = GetMeetingRoomsScheduleResponseBodyScheduleInformationScheduleItems()
                self.schedule_items.append(temp_model.from_map(k))
        return self


class GetMeetingRoomsScheduleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        schedule_information: List[GetMeetingRoomsScheduleResponseBodyScheduleInformation] = None,
    ):
        # requestId
        self.request_id = request_id
        self.schedule_information = schedule_information

    def validate(self):
        if self.schedule_information:
            for k in self.schedule_information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['scheduleInformation'] = []
        if self.schedule_information is not None:
            for k in self.schedule_information:
                result['scheduleInformation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.schedule_information = []
        if m.get('scheduleInformation') is not None:
            for k in m.get('scheduleInformation'):
                temp_model = GetMeetingRoomsScheduleResponseBodyScheduleInformation()
                self.schedule_information.append(temp_model.from_map(k))
        return self


class GetMeetingRoomsScheduleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMeetingRoomsScheduleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMeetingRoomsScheduleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMineWorkspaceHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetMineWorkspaceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetMineWorkspaceHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetMineWorkspaceHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetMineWorkspaceShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetMineWorkspaceRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetMineWorkspaceRequest(TeaModel):
    def __init__(
        self,
        request: Dict[str, Any] = None,
        tenant_context: GetMineWorkspaceRequestTenantContext = None,
    ):
        self.request = request
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request is not None:
            result['Request'] = self.request
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Request') is not None:
            self.request = m.get('Request')
        if m.get('TenantContext') is not None:
            temp_model = GetMineWorkspaceRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class GetMineWorkspaceShrinkRequest(TeaModel):
    def __init__(
        self,
        request_shrink: str = None,
        tenant_context_shrink: str = None,
    ):
        self.request_shrink = request_shrink
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_shrink is not None:
            result['Request'] = self.request_shrink
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Request') is not None:
            self.request_shrink = m.get('Request')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class GetMineWorkspaceResponseBodyWorkspaceIcon(TeaModel):
    def __init__(
        self,
        type: str = None,
        value: str = None,
    ):
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetMineWorkspaceResponseBodyWorkspace(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        cover: str = None,
        create_time: str = None,
        creator_id: str = None,
        description: str = None,
        icon: GetMineWorkspaceResponseBodyWorkspaceIcon = None,
        modified_time: str = None,
        modifier_id: str = None,
        name: str = None,
        permission_role: str = None,
        root_node_id: str = None,
        team_id: str = None,
        type: str = None,
        url: str = None,
        workspace_id: str = None,
    ):
        self.corp_id = corp_id
        self.cover = cover
        self.create_time = create_time
        self.creator_id = creator_id
        self.description = description
        self.icon = icon
        self.modified_time = modified_time
        self.modifier_id = modifier_id
        self.name = name
        self.permission_role = permission_role
        self.root_node_id = root_node_id
        self.team_id = team_id
        self.type = type
        self.url = url
        self.workspace_id = workspace_id

    def validate(self):
        if self.icon:
            self.icon.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.cover is not None:
            result['Cover'] = self.cover
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.description is not None:
            result['Description'] = self.description
        if self.icon is not None:
            result['Icon'] = self.icon.to_map()
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.modifier_id is not None:
            result['ModifierId'] = self.modifier_id
        if self.name is not None:
            result['Name'] = self.name
        if self.permission_role is not None:
            result['PermissionRole'] = self.permission_role
        if self.root_node_id is not None:
            result['RootNodeId'] = self.root_node_id
        if self.team_id is not None:
            result['TeamId'] = self.team_id
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('Cover') is not None:
            self.cover = m.get('Cover')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Icon') is not None:
            temp_model = GetMineWorkspaceResponseBodyWorkspaceIcon()
            self.icon = temp_model.from_map(m['Icon'])
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ModifierId') is not None:
            self.modifier_id = m.get('ModifierId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PermissionRole') is not None:
            self.permission_role = m.get('PermissionRole')
        if m.get('RootNodeId') is not None:
            self.root_node_id = m.get('RootNodeId')
        if m.get('TeamId') is not None:
            self.team_id = m.get('TeamId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetMineWorkspaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        workspace: GetMineWorkspaceResponseBodyWorkspace = None,
    ):
        # requestId
        self.request_id = request_id
        self.workspace = workspace

    def validate(self):
        if self.workspace:
            self.workspace.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.workspace is not None:
            result['workspace'] = self.workspace.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('workspace') is not None:
            temp_model = GetMineWorkspaceResponseBodyWorkspace()
            self.workspace = temp_model.from_map(m['workspace'])
        return self


class GetMineWorkspaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMineWorkspaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMineWorkspaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetNodeHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetNodeHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetNodeHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetNodeShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetNodeRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetNodeRequest(TeaModel):
    def __init__(
        self,
        node_id: str = None,
        tenant_context: GetNodeRequestTenantContext = None,
        with_permission_role: bool = None,
        with_statistical_info: bool = None,
    ):
        self.node_id = node_id
        self.tenant_context = tenant_context
        self.with_permission_role = with_permission_role
        self.with_statistical_info = with_statistical_info

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.with_permission_role is not None:
            result['WithPermissionRole'] = self.with_permission_role
        if self.with_statistical_info is not None:
            result['WithStatisticalInfo'] = self.with_statistical_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TenantContext') is not None:
            temp_model = GetNodeRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WithPermissionRole') is not None:
            self.with_permission_role = m.get('WithPermissionRole')
        if m.get('WithStatisticalInfo') is not None:
            self.with_statistical_info = m.get('WithStatisticalInfo')
        return self


class GetNodeShrinkRequest(TeaModel):
    def __init__(
        self,
        node_id: str = None,
        tenant_context_shrink: str = None,
        with_permission_role: bool = None,
        with_statistical_info: bool = None,
    ):
        self.node_id = node_id
        self.tenant_context_shrink = tenant_context_shrink
        self.with_permission_role = with_permission_role
        self.with_statistical_info = with_statistical_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.with_permission_role is not None:
            result['WithPermissionRole'] = self.with_permission_role
        if self.with_statistical_info is not None:
            result['WithStatisticalInfo'] = self.with_statistical_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WithPermissionRole') is not None:
            self.with_permission_role = m.get('WithPermissionRole')
        if m.get('WithStatisticalInfo') is not None:
            self.with_statistical_info = m.get('WithStatisticalInfo')
        return self


class GetNodeResponseBodyNodeStatisticalInfo(TeaModel):
    def __init__(
        self,
        word_count: int = None,
    ):
        self.word_count = word_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.word_count is not None:
            result['WordCount'] = self.word_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WordCount') is not None:
            self.word_count = m.get('WordCount')
        return self


class GetNodeResponseBodyNode(TeaModel):
    def __init__(
        self,
        category: str = None,
        create_time: str = None,
        creator_id: str = None,
        extension: str = None,
        has_children: bool = None,
        modified_time: str = None,
        modifier_id: str = None,
        name: str = None,
        node_id: str = None,
        permission_role: str = None,
        size: int = None,
        statistical_info: GetNodeResponseBodyNodeStatisticalInfo = None,
        type: str = None,
        url: str = None,
        workspace_id: str = None,
    ):
        self.category = category
        self.create_time = create_time
        self.creator_id = creator_id
        self.extension = extension
        self.has_children = has_children
        self.modified_time = modified_time
        self.modifier_id = modifier_id
        self.name = name
        self.node_id = node_id
        self.permission_role = permission_role
        self.size = size
        self.statistical_info = statistical_info
        self.type = type
        self.url = url
        self.workspace_id = workspace_id

    def validate(self):
        if self.statistical_info:
            self.statistical_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.has_children is not None:
            result['HasChildren'] = self.has_children
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.modifier_id is not None:
            result['ModifierId'] = self.modifier_id
        if self.name is not None:
            result['Name'] = self.name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.permission_role is not None:
            result['PermissionRole'] = self.permission_role
        if self.size is not None:
            result['Size'] = self.size
        if self.statistical_info is not None:
            result['StatisticalInfo'] = self.statistical_info.to_map()
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('HasChildren') is not None:
            self.has_children = m.get('HasChildren')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ModifierId') is not None:
            self.modifier_id = m.get('ModifierId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PermissionRole') is not None:
            self.permission_role = m.get('PermissionRole')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StatisticalInfo') is not None:
            temp_model = GetNodeResponseBodyNodeStatisticalInfo()
            self.statistical_info = temp_model.from_map(m['StatisticalInfo'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetNodeResponseBody(TeaModel):
    def __init__(
        self,
        node: GetNodeResponseBodyNode = None,
        request_id: str = None,
    ):
        self.node = node
        # requestId
        self.request_id = request_id

    def validate(self):
        if self.node:
            self.node.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node is not None:
            result['node'] = self.node.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('node') is not None:
            temp_model = GetNodeResponseBodyNode()
            self.node = temp_model.from_map(m['node'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class GetNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetNodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeByUrlHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetNodeByUrlHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetNodeByUrlHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetNodeByUrlHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetNodeByUrlShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetNodeByUrlRequestOption(TeaModel):
    def __init__(
        self,
        with_permission_role: bool = None,
        with_statistical_info: bool = None,
    ):
        self.with_permission_role = with_permission_role
        self.with_statistical_info = with_statistical_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.with_permission_role is not None:
            result['WithPermissionRole'] = self.with_permission_role
        if self.with_statistical_info is not None:
            result['WithStatisticalInfo'] = self.with_statistical_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WithPermissionRole') is not None:
            self.with_permission_role = m.get('WithPermissionRole')
        if m.get('WithStatisticalInfo') is not None:
            self.with_statistical_info = m.get('WithStatisticalInfo')
        return self


class GetNodeByUrlRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetNodeByUrlRequest(TeaModel):
    def __init__(
        self,
        option: GetNodeByUrlRequestOption = None,
        tenant_context: GetNodeByUrlRequestTenantContext = None,
        url: str = None,
    ):
        self.option = option
        self.tenant_context = tenant_context
        self.url = url

    def validate(self):
        if self.option:
            self.option.validate()
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.option is not None:
            result['Option'] = self.option.to_map()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Option') is not None:
            temp_model = GetNodeByUrlRequestOption()
            self.option = temp_model.from_map(m['Option'])
        if m.get('TenantContext') is not None:
            temp_model = GetNodeByUrlRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetNodeByUrlShrinkRequest(TeaModel):
    def __init__(
        self,
        option_shrink: str = None,
        tenant_context_shrink: str = None,
        url: str = None,
    ):
        self.option_shrink = option_shrink
        self.tenant_context_shrink = tenant_context_shrink
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.option_shrink is not None:
            result['Option'] = self.option_shrink
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Option') is not None:
            self.option_shrink = m.get('Option')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetNodeByUrlResponseBodyNodeStatisticalInfo(TeaModel):
    def __init__(
        self,
        word_count: int = None,
    ):
        self.word_count = word_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.word_count is not None:
            result['WordCount'] = self.word_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WordCount') is not None:
            self.word_count = m.get('WordCount')
        return self


class GetNodeByUrlResponseBodyNode(TeaModel):
    def __init__(
        self,
        category: str = None,
        create_time: str = None,
        creator_id: str = None,
        extension: str = None,
        has_children: bool = None,
        modified_time: str = None,
        modifier_id: str = None,
        name: str = None,
        node_id: str = None,
        permission_role: str = None,
        size: int = None,
        statistical_info: GetNodeByUrlResponseBodyNodeStatisticalInfo = None,
        type: str = None,
        url: str = None,
        workspace_id: str = None,
    ):
        self.category = category
        self.create_time = create_time
        self.creator_id = creator_id
        self.extension = extension
        self.has_children = has_children
        self.modified_time = modified_time
        self.modifier_id = modifier_id
        self.name = name
        self.node_id = node_id
        self.permission_role = permission_role
        self.size = size
        self.statistical_info = statistical_info
        self.type = type
        self.url = url
        self.workspace_id = workspace_id

    def validate(self):
        if self.statistical_info:
            self.statistical_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.has_children is not None:
            result['HasChildren'] = self.has_children
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.modifier_id is not None:
            result['ModifierId'] = self.modifier_id
        if self.name is not None:
            result['Name'] = self.name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.permission_role is not None:
            result['PermissionRole'] = self.permission_role
        if self.size is not None:
            result['Size'] = self.size
        if self.statistical_info is not None:
            result['StatisticalInfo'] = self.statistical_info.to_map()
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('HasChildren') is not None:
            self.has_children = m.get('HasChildren')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ModifierId') is not None:
            self.modifier_id = m.get('ModifierId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PermissionRole') is not None:
            self.permission_role = m.get('PermissionRole')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StatisticalInfo') is not None:
            temp_model = GetNodeByUrlResponseBodyNodeStatisticalInfo()
            self.statistical_info = temp_model.from_map(m['StatisticalInfo'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetNodeByUrlResponseBody(TeaModel):
    def __init__(
        self,
        node: GetNodeByUrlResponseBodyNode = None,
        request_id: str = None,
    ):
        self.node = node
        # requestId
        self.request_id = request_id

    def validate(self):
        if self.node:
            self.node.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node is not None:
            result['node'] = self.node.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('node') is not None:
            temp_model = GetNodeByUrlResponseBodyNode()
            self.node = temp_model.from_map(m['node'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class GetNodeByUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetNodeByUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetNodeByUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodesHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetNodesHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetNodesHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetNodesHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetNodesShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetNodesRequestOption(TeaModel):
    def __init__(
        self,
        with_permission_role: bool = None,
        with_statistical_info: bool = None,
    ):
        self.with_permission_role = with_permission_role
        self.with_statistical_info = with_statistical_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.with_permission_role is not None:
            result['WithPermissionRole'] = self.with_permission_role
        if self.with_statistical_info is not None:
            result['WithStatisticalInfo'] = self.with_statistical_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WithPermissionRole') is not None:
            self.with_permission_role = m.get('WithPermissionRole')
        if m.get('WithStatisticalInfo') is not None:
            self.with_statistical_info = m.get('WithStatisticalInfo')
        return self


class GetNodesRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetNodesRequest(TeaModel):
    def __init__(
        self,
        node_ids: List[str] = None,
        option: GetNodesRequestOption = None,
        tenant_context: GetNodesRequestTenantContext = None,
    ):
        self.node_ids = node_ids
        self.option = option
        self.tenant_context = tenant_context

    def validate(self):
        if self.option:
            self.option.validate()
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_ids is not None:
            result['NodeIds'] = self.node_ids
        if self.option is not None:
            result['Option'] = self.option.to_map()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeIds') is not None:
            self.node_ids = m.get('NodeIds')
        if m.get('Option') is not None:
            temp_model = GetNodesRequestOption()
            self.option = temp_model.from_map(m['Option'])
        if m.get('TenantContext') is not None:
            temp_model = GetNodesRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class GetNodesShrinkRequest(TeaModel):
    def __init__(
        self,
        node_ids_shrink: str = None,
        option_shrink: str = None,
        tenant_context_shrink: str = None,
    ):
        self.node_ids_shrink = node_ids_shrink
        self.option_shrink = option_shrink
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_ids_shrink is not None:
            result['NodeIds'] = self.node_ids_shrink
        if self.option_shrink is not None:
            result['Option'] = self.option_shrink
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeIds') is not None:
            self.node_ids_shrink = m.get('NodeIds')
        if m.get('Option') is not None:
            self.option_shrink = m.get('Option')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class GetNodesResponseBodyNodesStatisticalInfo(TeaModel):
    def __init__(
        self,
        word_count: int = None,
    ):
        self.word_count = word_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.word_count is not None:
            result['WordCount'] = self.word_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WordCount') is not None:
            self.word_count = m.get('WordCount')
        return self


class GetNodesResponseBodyNodes(TeaModel):
    def __init__(
        self,
        category: str = None,
        create_time: str = None,
        creator_id: str = None,
        extension: str = None,
        has_children: bool = None,
        modified_time: str = None,
        modifier_id: str = None,
        name: str = None,
        node_id: str = None,
        permission_role: str = None,
        size: int = None,
        statistical_info: GetNodesResponseBodyNodesStatisticalInfo = None,
        type: str = None,
        url: str = None,
        workspace_id: str = None,
    ):
        self.category = category
        self.create_time = create_time
        self.creator_id = creator_id
        self.extension = extension
        self.has_children = has_children
        self.modified_time = modified_time
        self.modifier_id = modifier_id
        self.name = name
        self.node_id = node_id
        self.permission_role = permission_role
        self.size = size
        self.statistical_info = statistical_info
        self.type = type
        self.url = url
        self.workspace_id = workspace_id

    def validate(self):
        if self.statistical_info:
            self.statistical_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.has_children is not None:
            result['HasChildren'] = self.has_children
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.modifier_id is not None:
            result['ModifierId'] = self.modifier_id
        if self.name is not None:
            result['Name'] = self.name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.permission_role is not None:
            result['PermissionRole'] = self.permission_role
        if self.size is not None:
            result['Size'] = self.size
        if self.statistical_info is not None:
            result['StatisticalInfo'] = self.statistical_info.to_map()
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('HasChildren') is not None:
            self.has_children = m.get('HasChildren')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ModifierId') is not None:
            self.modifier_id = m.get('ModifierId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PermissionRole') is not None:
            self.permission_role = m.get('PermissionRole')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StatisticalInfo') is not None:
            temp_model = GetNodesResponseBodyNodesStatisticalInfo()
            self.statistical_info = temp_model.from_map(m['StatisticalInfo'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetNodesResponseBody(TeaModel):
    def __init__(
        self,
        nodes: List[GetNodesResponseBodyNodes] = None,
        request_id: str = None,
    ):
        self.nodes = nodes
        # requestId
        self.request_id = request_id

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['nodes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('nodes') is not None:
            for k in m.get('nodes'):
                temp_model = GetNodesResponseBodyNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class GetNodesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetNodesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetNodesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOpenUrlHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetOpenUrlHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetOpenUrlHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetOpenUrlHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetOpenUrlShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetOpenUrlRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        file_url: str = None,
        language: str = None,
        system_token: str = None,
        timeout: int = None,
    ):
        self.app_type = app_type
        self.file_url = file_url
        self.language = language
        self.system_token = system_token
        self.timeout = timeout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.language is not None:
            result['Language'] = self.language
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        return self


class GetOpenUrlResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: str = None,
    ):
        # requestId
        self.request_id = request_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class GetOpenUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetOpenUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOpenUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRangeHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetRangeHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetRangeHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetRangeHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetRangeShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetRangeRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetRangeRequest(TeaModel):
    def __init__(
        self,
        range_address: str = None,
        select: str = None,
        sheet_id: str = None,
        tenant_context: GetRangeRequestTenantContext = None,
        workbook_id: str = None,
    ):
        self.range_address = range_address
        self.select = select
        self.sheet_id = sheet_id
        self.tenant_context = tenant_context
        self.workbook_id = workbook_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.range_address is not None:
            result['RangeAddress'] = self.range_address
        if self.select is not None:
            result['Select'] = self.select
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RangeAddress') is not None:
            self.range_address = m.get('RangeAddress')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            temp_model = GetRangeRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class GetRangeShrinkRequest(TeaModel):
    def __init__(
        self,
        range_address: str = None,
        select: str = None,
        sheet_id: str = None,
        tenant_context_shrink: str = None,
        workbook_id: str = None,
    ):
        self.range_address = range_address
        self.select = select
        self.sheet_id = sheet_id
        self.tenant_context_shrink = tenant_context_shrink
        self.workbook_id = workbook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.range_address is not None:
            result['RangeAddress'] = self.range_address
        if self.select is not None:
            result['Select'] = self.select
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RangeAddress') is not None:
            self.range_address = m.get('RangeAddress')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class GetRangeResponseBodyBackgroundColors(TeaModel):
    def __init__(
        self,
        red: int = None,
        green: int = None,
        blue: int = None,
        hex_string: str = None,
    ):
        # red
        self.red = red
        # green
        self.green = green
        # blue
        self.blue = blue
        # hexString
        self.hex_string = hex_string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.red is not None:
            result['Red'] = self.red
        if self.green is not None:
            result['Green'] = self.green
        if self.blue is not None:
            result['Blue'] = self.blue
        if self.hex_string is not None:
            result['HexString'] = self.hex_string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Red') is not None:
            self.red = m.get('Red')
        if m.get('Green') is not None:
            self.green = m.get('Green')
        if m.get('Blue') is not None:
            self.blue = m.get('Blue')
        if m.get('HexString') is not None:
            self.hex_string = m.get('HexString')
        return self


class GetRangeResponseBody(TeaModel):
    def __init__(
        self,
        background_colors: List[List[GetRangeResponseBodyBackgroundColors]] = None,
        display_values: List[List[str]] = None,
        formulas: List[List[str]] = None,
        request_id: str = None,
        values: List[List[Any]] = None,
    ):
        self.background_colors = background_colors
        self.display_values = display_values
        self.formulas = formulas
        # requestId
        self.request_id = request_id
        self.values = values

    def validate(self):
        if self.background_colors:
            for k in self.background_colors:
                for k1 in k:
                    if k1:
                        k1.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['backgroundColors'] = []
        if self.background_colors is not None:
            for k in self.background_colors:
                l1 = []
                for k1 in k:
                    l1.append(k1.to_map() if k1 else None)
                result['backgroundColors'].append(l1)
        if self.display_values is not None:
            result['displayValues'] = self.display_values
        if self.formulas is not None:
            result['formulas'] = self.formulas
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.values is not None:
            result['values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.background_colors = []
        if m.get('backgroundColors') is not None:
            for k in m.get('backgroundColors'):
                l1 = []
                for k1 in k:
                    temp_model = GetRangeResponseBodyBackgroundColors()
                    l1.append(temp_model.from_map(k1))
                self.background_colors.append(l1)
        if m.get('displayValues') is not None:
            self.display_values = m.get('displayValues')
        if m.get('formulas') is not None:
            self.formulas = m.get('formulas')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('values') is not None:
            self.values = m.get('values')
        return self


class GetRangeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRangeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRangeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetReportTemplateByNameHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetReportTemplateByNameHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetReportTemplateByNameHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetReportTemplateByNameHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetReportTemplateByNameShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetReportTemplateByNameRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetReportTemplateByNameRequest(TeaModel):
    def __init__(
        self,
        template_name: str = None,
        tenant_context: GetReportTemplateByNameRequestTenantContext = None,
    ):
        self.template_name = template_name
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TenantContext') is not None:
            temp_model = GetReportTemplateByNameRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class GetReportTemplateByNameShrinkRequest(TeaModel):
    def __init__(
        self,
        template_name: str = None,
        tenant_context_shrink: str = None,
    ):
        self.template_name = template_name
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class GetReportTemplateByNameResponseBodyDefaultReceivedConvs(TeaModel):
    def __init__(
        self,
        conversation_id: str = None,
        title: str = None,
    ):
        self.conversation_id = conversation_id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conversation_id is not None:
            result['ConversationId'] = self.conversation_id
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConversationId') is not None:
            self.conversation_id = m.get('ConversationId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetReportTemplateByNameResponseBodyDefaultReceivers(TeaModel):
    def __init__(
        self,
        user_name: str = None,
        userid: str = None,
    ):
        self.user_name = user_name
        self.userid = userid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.userid is not None:
            result['Userid'] = self.userid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('Userid') is not None:
            self.userid = m.get('Userid')
        return self


class GetReportTemplateByNameResponseBodyFields(TeaModel):
    def __init__(
        self,
        field_name: str = None,
        sort: int = None,
        type: int = None,
    ):
        self.field_name = field_name
        self.sort = sort
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetReportTemplateByNameResponseBody(TeaModel):
    def __init__(
        self,
        default_received_convs: List[GetReportTemplateByNameResponseBodyDefaultReceivedConvs] = None,
        default_receivers: List[GetReportTemplateByNameResponseBodyDefaultReceivers] = None,
        fields: List[GetReportTemplateByNameResponseBodyFields] = None,
        id: str = None,
        name: str = None,
        request_id: str = None,
        user_name: str = None,
        userid: str = None,
    ):
        self.default_received_convs = default_received_convs
        self.default_receivers = default_receivers
        self.fields = fields
        self.id = id
        self.name = name
        # requestId
        self.request_id = request_id
        self.user_name = user_name
        self.userid = userid

    def validate(self):
        if self.default_received_convs:
            for k in self.default_received_convs:
                if k:
                    k.validate()
        if self.default_receivers:
            for k in self.default_receivers:
                if k:
                    k.validate()
        if self.fields:
            for k in self.fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['defaultReceivedConvs'] = []
        if self.default_received_convs is not None:
            for k in self.default_received_convs:
                result['defaultReceivedConvs'].append(k.to_map() if k else None)
        result['defaultReceivers'] = []
        if self.default_receivers is not None:
            for k in self.default_receivers:
                result['defaultReceivers'].append(k.to_map() if k else None)
        result['fields'] = []
        if self.fields is not None:
            for k in self.fields:
                result['fields'].append(k.to_map() if k else None)
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.user_name is not None:
            result['userName'] = self.user_name
        if self.userid is not None:
            result['userid'] = self.userid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.default_received_convs = []
        if m.get('defaultReceivedConvs') is not None:
            for k in m.get('defaultReceivedConvs'):
                temp_model = GetReportTemplateByNameResponseBodyDefaultReceivedConvs()
                self.default_received_convs.append(temp_model.from_map(k))
        self.default_receivers = []
        if m.get('defaultReceivers') is not None:
            for k in m.get('defaultReceivers'):
                temp_model = GetReportTemplateByNameResponseBodyDefaultReceivers()
                self.default_receivers.append(temp_model.from_map(k))
        self.fields = []
        if m.get('fields') is not None:
            for k in m.get('fields'):
                temp_model = GetReportTemplateByNameResponseBodyFields()
                self.fields.append(temp_model.from_map(k))
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('userName') is not None:
            self.user_name = m.get('userName')
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        return self


class GetReportTemplateByNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetReportTemplateByNameResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetReportTemplateByNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetReportUnReadCountHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetReportUnReadCountHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetReportUnReadCountHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetReportUnReadCountHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetReportUnReadCountShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetReportUnReadCountRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetReportUnReadCountRequest(TeaModel):
    def __init__(
        self,
        request: Dict[str, Any] = None,
        tenant_context: GetReportUnReadCountRequestTenantContext = None,
    ):
        self.request = request
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request is not None:
            result['Request'] = self.request
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Request') is not None:
            self.request = m.get('Request')
        if m.get('TenantContext') is not None:
            temp_model = GetReportUnReadCountRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class GetReportUnReadCountShrinkRequest(TeaModel):
    def __init__(
        self,
        request_shrink: str = None,
        tenant_context_shrink: str = None,
    ):
        self.request_shrink = request_shrink
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_shrink is not None:
            result['Request'] = self.request_shrink
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Request') is not None:
            self.request_shrink = m.get('Request')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class GetReportUnReadCountResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        request_id: str = None,
    ):
        self.count = count
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class GetReportUnReadCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetReportUnReadCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetReportUnReadCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSheetHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetSheetHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetSheetHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetSheetHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetSheetShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetSheetRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetSheetRequest(TeaModel):
    def __init__(
        self,
        sheet_id: str = None,
        tenant_context: GetSheetRequestTenantContext = None,
        workbook_id: str = None,
    ):
        self.sheet_id = sheet_id
        self.tenant_context = tenant_context
        self.workbook_id = workbook_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            temp_model = GetSheetRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class GetSheetShrinkRequest(TeaModel):
    def __init__(
        self,
        sheet_id: str = None,
        tenant_context_shrink: str = None,
        workbook_id: str = None,
    ):
        self.sheet_id = sheet_id
        self.tenant_context_shrink = tenant_context_shrink
        self.workbook_id = workbook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class GetSheetResponseBody(TeaModel):
    def __init__(
        self,
        column_count: int = None,
        id: str = None,
        last_non_empty_column: int = None,
        last_non_empty_row: int = None,
        name: str = None,
        request_id: str = None,
        row_count: int = None,
        visibility: str = None,
    ):
        self.column_count = column_count
        self.id = id
        self.last_non_empty_column = last_non_empty_column
        self.last_non_empty_row = last_non_empty_row
        self.name = name
        # requestId
        self.request_id = request_id
        self.row_count = row_count
        self.visibility = visibility

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_count is not None:
            result['columnCount'] = self.column_count
        if self.id is not None:
            result['id'] = self.id
        if self.last_non_empty_column is not None:
            result['lastNonEmptyColumn'] = self.last_non_empty_column
        if self.last_non_empty_row is not None:
            result['lastNonEmptyRow'] = self.last_non_empty_row
        if self.name is not None:
            result['name'] = self.name
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.row_count is not None:
            result['rowCount'] = self.row_count
        if self.visibility is not None:
            result['visibility'] = self.visibility
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('columnCount') is not None:
            self.column_count = m.get('columnCount')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('lastNonEmptyColumn') is not None:
            self.last_non_empty_column = m.get('lastNonEmptyColumn')
        if m.get('lastNonEmptyRow') is not None:
            self.last_non_empty_row = m.get('lastNonEmptyRow')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('rowCount') is not None:
            self.row_count = m.get('rowCount')
        if m.get('visibility') is not None:
            self.visibility = m.get('visibility')
        return self


class GetSheetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSheetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSheetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSpaceDirectoriesHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetSpaceDirectoriesHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetSpaceDirectoriesHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetSpaceDirectoriesHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetSpaceDirectoriesShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetSpaceDirectoriesRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetSpaceDirectoriesRequest(TeaModel):
    def __init__(
        self,
        dentry_id: str = None,
        max_results: int = None,
        next_token: str = None,
        space_id: str = None,
        tenant_context: GetSpaceDirectoriesRequestTenantContext = None,
    ):
        self.dentry_id = dentry_id
        self.max_results = max_results
        self.next_token = next_token
        self.space_id = space_id
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dentry_id is not None:
            result['DentryId'] = self.dentry_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DentryId') is not None:
            self.dentry_id = m.get('DentryId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('TenantContext') is not None:
            temp_model = GetSpaceDirectoriesRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class GetSpaceDirectoriesShrinkRequest(TeaModel):
    def __init__(
        self,
        dentry_id: str = None,
        max_results: int = None,
        next_token: str = None,
        space_id: str = None,
        tenant_context_shrink: str = None,
    ):
        self.dentry_id = dentry_id
        self.max_results = max_results
        self.next_token = next_token
        self.space_id = space_id
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dentry_id is not None:
            result['DentryId'] = self.dentry_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DentryId') is not None:
            self.dentry_id = m.get('DentryId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class GetSpaceDirectoriesResponseBodyChildrenCreator(TeaModel):
    def __init__(
        self,
        name: str = None,
        user_id: str = None,
    ):
        self.name = name
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetSpaceDirectoriesResponseBodyChildrenLinkSourceInfoIconUrl(TeaModel):
    def __init__(
        self,
        line: str = None,
        small: str = None,
    ):
        self.line = line
        self.small = small

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.line is not None:
            result['Line'] = self.line
        if self.small is not None:
            result['Small'] = self.small
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('Small') is not None:
            self.small = m.get('Small')
        return self


class GetSpaceDirectoriesResponseBodyChildrenLinkSourceInfo(TeaModel):
    def __init__(
        self,
        extension: str = None,
        icon_url: GetSpaceDirectoriesResponseBodyChildrenLinkSourceInfoIconUrl = None,
        id: str = None,
        link_type: int = None,
        space_id: str = None,
    ):
        self.extension = extension
        self.icon_url = icon_url
        self.id = id
        self.link_type = link_type
        self.space_id = space_id

    def validate(self):
        if self.icon_url:
            self.icon_url.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.icon_url is not None:
            result['IconUrl'] = self.icon_url.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.link_type is not None:
            result['LinkType'] = self.link_type
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('IconUrl') is not None:
            temp_model = GetSpaceDirectoriesResponseBodyChildrenLinkSourceInfoIconUrl()
            self.icon_url = temp_model.from_map(m['IconUrl'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LinkType') is not None:
            self.link_type = m.get('LinkType')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        return self


class GetSpaceDirectoriesResponseBodyChildrenSpaceHdIconVO(TeaModel):
    def __init__(
        self,
        icon: str = None,
        type: str = None,
    ):
        self.icon = icon
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.icon is not None:
            result['Icon'] = self.icon
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Icon') is not None:
            self.icon = m.get('Icon')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetSpaceDirectoriesResponseBodyChildrenSpaceIconVO(TeaModel):
    def __init__(
        self,
        icon: str = None,
        type: str = None,
    ):
        self.icon = icon
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.icon is not None:
            result['Icon'] = self.icon
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Icon') is not None:
            self.icon = m.get('Icon')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetSpaceDirectoriesResponseBodyChildrenSpaceOwner(TeaModel):
    def __init__(
        self,
        name: str = None,
        user_id: str = None,
    ):
        self.name = name
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetSpaceDirectoriesResponseBodyChildrenSpaceVisitorInfo(TeaModel):
    def __init__(
        self,
        dentry_actions: List[str] = None,
        role_code: str = None,
        space_actions: List[str] = None,
    ):
        self.dentry_actions = dentry_actions
        self.role_code = role_code
        self.space_actions = space_actions

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dentry_actions is not None:
            result['DentryActions'] = self.dentry_actions
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        if self.space_actions is not None:
            result['SpaceActions'] = self.space_actions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DentryActions') is not None:
            self.dentry_actions = m.get('DentryActions')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        if m.get('SpaceActions') is not None:
            self.space_actions = m.get('SpaceActions')
        return self


class GetSpaceDirectoriesResponseBodyChildrenSpace(TeaModel):
    def __init__(
        self,
        cover: str = None,
        description: str = None,
        hd_icon_vo: GetSpaceDirectoriesResponseBodyChildrenSpaceHdIconVO = None,
        icon_vo: GetSpaceDirectoriesResponseBodyChildrenSpaceIconVO = None,
        id: str = None,
        name: str = None,
        owner: GetSpaceDirectoriesResponseBodyChildrenSpaceOwner = None,
        recent_list: List[Any] = None,
        type: int = None,
        url: str = None,
        visitor_info: GetSpaceDirectoriesResponseBodyChildrenSpaceVisitorInfo = None,
    ):
        self.cover = cover
        self.description = description
        self.hd_icon_vo = hd_icon_vo
        self.icon_vo = icon_vo
        self.id = id
        self.name = name
        self.owner = owner
        self.recent_list = recent_list
        self.type = type
        self.url = url
        self.visitor_info = visitor_info

    def validate(self):
        if self.hd_icon_vo:
            self.hd_icon_vo.validate()
        if self.icon_vo:
            self.icon_vo.validate()
        if self.owner:
            self.owner.validate()
        if self.visitor_info:
            self.visitor_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cover is not None:
            result['Cover'] = self.cover
        if self.description is not None:
            result['Description'] = self.description
        if self.hd_icon_vo is not None:
            result['HdIconVO'] = self.hd_icon_vo.to_map()
        if self.icon_vo is not None:
            result['IconVO'] = self.icon_vo.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.owner is not None:
            result['Owner'] = self.owner.to_map()
        if self.recent_list is not None:
            result['RecentList'] = self.recent_list
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.visitor_info is not None:
            result['VisitorInfo'] = self.visitor_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cover') is not None:
            self.cover = m.get('Cover')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HdIconVO') is not None:
            temp_model = GetSpaceDirectoriesResponseBodyChildrenSpaceHdIconVO()
            self.hd_icon_vo = temp_model.from_map(m['HdIconVO'])
        if m.get('IconVO') is not None:
            temp_model = GetSpaceDirectoriesResponseBodyChildrenSpaceIconVO()
            self.icon_vo = temp_model.from_map(m['IconVO'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Owner') is not None:
            temp_model = GetSpaceDirectoriesResponseBodyChildrenSpaceOwner()
            self.owner = temp_model.from_map(m['Owner'])
        if m.get('RecentList') is not None:
            self.recent_list = m.get('RecentList')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('VisitorInfo') is not None:
            temp_model = GetSpaceDirectoriesResponseBodyChildrenSpaceVisitorInfo()
            self.visitor_info = temp_model.from_map(m['VisitorInfo'])
        return self


class GetSpaceDirectoriesResponseBodyChildrenStatisticalInfo(TeaModel):
    def __init__(
        self,
        word_count: int = None,
    ):
        # WordCount
        self.word_count = word_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.word_count is not None:
            result['WordCount'] = self.word_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WordCount') is not None:
            self.word_count = m.get('WordCount')
        return self


class GetSpaceDirectoriesResponseBodyChildrenUpdater(TeaModel):
    def __init__(
        self,
        name: str = None,
        user_id: str = None,
    ):
        self.name = name
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetSpaceDirectoriesResponseBodyChildrenVisitorInfo(TeaModel):
    def __init__(
        self,
        dentry_actions: List[str] = None,
        role_code: str = None,
        space_actions: List[str] = None,
    ):
        self.dentry_actions = dentry_actions
        self.role_code = role_code
        self.space_actions = space_actions

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dentry_actions is not None:
            result['DentryActions'] = self.dentry_actions
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        if self.space_actions is not None:
            result['SpaceActions'] = self.space_actions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DentryActions') is not None:
            self.dentry_actions = m.get('DentryActions')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        if m.get('SpaceActions') is not None:
            self.space_actions = m.get('SpaceActions')
        return self


class GetSpaceDirectoriesResponseBodyChildren(TeaModel):
    def __init__(
        self,
        content_type: str = None,
        created_time: int = None,
        creator: GetSpaceDirectoriesResponseBodyChildrenCreator = None,
        dentry_id: str = None,
        dentry_type: str = None,
        dentry_uuid: str = None,
        doc_key: str = None,
        extension: str = None,
        has_children: bool = None,
        link_source_info: GetSpaceDirectoriesResponseBodyChildrenLinkSourceInfo = None,
        name: str = None,
        path: str = None,
        space: GetSpaceDirectoriesResponseBodyChildrenSpace = None,
        space_id: str = None,
        statistical_info: GetSpaceDirectoriesResponseBodyChildrenStatisticalInfo = None,
        updated_time: int = None,
        updater: GetSpaceDirectoriesResponseBodyChildrenUpdater = None,
        url: str = None,
        visitor_info: GetSpaceDirectoriesResponseBodyChildrenVisitorInfo = None,
    ):
        self.content_type = content_type
        self.created_time = created_time
        self.creator = creator
        self.dentry_id = dentry_id
        self.dentry_type = dentry_type
        self.dentry_uuid = dentry_uuid
        self.doc_key = doc_key
        self.extension = extension
        self.has_children = has_children
        self.link_source_info = link_source_info
        self.name = name
        self.path = path
        self.space = space
        self.space_id = space_id
        self.statistical_info = statistical_info
        self.updated_time = updated_time
        self.updater = updater
        self.url = url
        self.visitor_info = visitor_info

    def validate(self):
        if self.creator:
            self.creator.validate()
        if self.link_source_info:
            self.link_source_info.validate()
        if self.space:
            self.space.validate()
        if self.statistical_info:
            self.statistical_info.validate()
        if self.updater:
            self.updater.validate()
        if self.visitor_info:
            self.visitor_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_type is not None:
            result['ContentType'] = self.content_type
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.creator is not None:
            result['Creator'] = self.creator.to_map()
        if self.dentry_id is not None:
            result['DentryId'] = self.dentry_id
        if self.dentry_type is not None:
            result['DentryType'] = self.dentry_type
        if self.dentry_uuid is not None:
            result['DentryUuid'] = self.dentry_uuid
        if self.doc_key is not None:
            result['DocKey'] = self.doc_key
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.has_children is not None:
            result['HasChildren'] = self.has_children
        if self.link_source_info is not None:
            result['LinkSourceInfo'] = self.link_source_info.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.space is not None:
            result['Space'] = self.space.to_map()
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.statistical_info is not None:
            result['StatisticalInfo'] = self.statistical_info.to_map()
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        if self.updater is not None:
            result['Updater'] = self.updater.to_map()
        if self.url is not None:
            result['Url'] = self.url
        if self.visitor_info is not None:
            result['VisitorInfo'] = self.visitor_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContentType') is not None:
            self.content_type = m.get('ContentType')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Creator') is not None:
            temp_model = GetSpaceDirectoriesResponseBodyChildrenCreator()
            self.creator = temp_model.from_map(m['Creator'])
        if m.get('DentryId') is not None:
            self.dentry_id = m.get('DentryId')
        if m.get('DentryType') is not None:
            self.dentry_type = m.get('DentryType')
        if m.get('DentryUuid') is not None:
            self.dentry_uuid = m.get('DentryUuid')
        if m.get('DocKey') is not None:
            self.doc_key = m.get('DocKey')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('HasChildren') is not None:
            self.has_children = m.get('HasChildren')
        if m.get('LinkSourceInfo') is not None:
            temp_model = GetSpaceDirectoriesResponseBodyChildrenLinkSourceInfo()
            self.link_source_info = temp_model.from_map(m['LinkSourceInfo'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Space') is not None:
            temp_model = GetSpaceDirectoriesResponseBodyChildrenSpace()
            self.space = temp_model.from_map(m['Space'])
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('StatisticalInfo') is not None:
            temp_model = GetSpaceDirectoriesResponseBodyChildrenStatisticalInfo()
            self.statistical_info = temp_model.from_map(m['StatisticalInfo'])
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        if m.get('Updater') is not None:
            temp_model = GetSpaceDirectoriesResponseBodyChildrenUpdater()
            self.updater = temp_model.from_map(m['Updater'])
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('VisitorInfo') is not None:
            temp_model = GetSpaceDirectoriesResponseBodyChildrenVisitorInfo()
            self.visitor_info = temp_model.from_map(m['VisitorInfo'])
        return self


class GetSpaceDirectoriesResponseBody(TeaModel):
    def __init__(
        self,
        children: List[GetSpaceDirectoriesResponseBodyChildren] = None,
        has_more: bool = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.children = children
        self.has_more = has_more
        self.next_token = next_token
        # requestId
        self.request_id = request_id

    def validate(self):
        if self.children:
            for k in self.children:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['children'] = []
        if self.children is not None:
            for k in self.children:
                result['children'].append(k.to_map() if k else None)
        if self.has_more is not None:
            result['hasMore'] = self.has_more
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.children = []
        if m.get('children') is not None:
            for k in m.get('children'):
                temp_model = GetSpaceDirectoriesResponseBodyChildren()
                self.children.append(temp_model.from_map(k))
        if m.get('hasMore') is not None:
            self.has_more = m.get('hasMore')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class GetSpaceDirectoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSpaceDirectoriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSpaceDirectoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSubscribedCalendarHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetSubscribedCalendarHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetSubscribedCalendarHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetSubscribedCalendarHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetSubscribedCalendarShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetSubscribedCalendarRequest(TeaModel):
    def __init__(
        self,
        calendar_id: str = None,
    ):
        self.calendar_id = calendar_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        return self


class GetSubscribedCalendarResponseBodySubscribeScope(TeaModel):
    def __init__(
        self,
        corp_ids: List[str] = None,
        open_conversation_ids: List[str] = None,
        user_ids: List[str] = None,
    ):
        self.corp_ids = corp_ids
        self.open_conversation_ids = open_conversation_ids
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_ids is not None:
            result['CorpIds'] = self.corp_ids
        if self.open_conversation_ids is not None:
            result['OpenConversationIds'] = self.open_conversation_ids
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CorpIds') is not None:
            self.corp_ids = m.get('CorpIds')
        if m.get('OpenConversationIds') is not None:
            self.open_conversation_ids = m.get('OpenConversationIds')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class GetSubscribedCalendarResponseBody(TeaModel):
    def __init__(
        self,
        author: str = None,
        calendar_id: str = None,
        description: str = None,
        managers: List[str] = None,
        name: str = None,
        request_id: str = None,
        subscribe_scope: GetSubscribedCalendarResponseBodySubscribeScope = None,
    ):
        self.author = author
        self.calendar_id = calendar_id
        self.description = description
        self.managers = managers
        self.name = name
        # requestId
        self.request_id = request_id
        self.subscribe_scope = subscribe_scope

    def validate(self):
        if self.subscribe_scope:
            self.subscribe_scope.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.author is not None:
            result['author'] = self.author
        if self.calendar_id is not None:
            result['calendarId'] = self.calendar_id
        if self.description is not None:
            result['description'] = self.description
        if self.managers is not None:
            result['managers'] = self.managers
        if self.name is not None:
            result['name'] = self.name
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.subscribe_scope is not None:
            result['subscribeScope'] = self.subscribe_scope.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('author') is not None:
            self.author = m.get('author')
        if m.get('calendarId') is not None:
            self.calendar_id = m.get('calendarId')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('managers') is not None:
            self.managers = m.get('managers')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('subscribeScope') is not None:
            temp_model = GetSubscribedCalendarResponseBodySubscribeScope()
            self.subscribe_scope = temp_model.from_map(m['subscribeScope'])
        return self


class GetSubscribedCalendarResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSubscribedCalendarResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSubscribedCalendarResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTemplateListByUserIdHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetTemplateListByUserIdHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetTemplateListByUserIdHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetTemplateListByUserIdHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetTemplateListByUserIdShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetTemplateListByUserIdRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetTemplateListByUserIdRequest(TeaModel):
    def __init__(
        self,
        offset: int = None,
        size: int = None,
        tenant_context: GetTemplateListByUserIdRequestTenantContext = None,
    ):
        self.offset = offset
        self.size = size
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.size is not None:
            result['Size'] = self.size
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('TenantContext') is not None:
            temp_model = GetTemplateListByUserIdRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class GetTemplateListByUserIdShrinkRequest(TeaModel):
    def __init__(
        self,
        offset: int = None,
        size: int = None,
        tenant_context_shrink: str = None,
    ):
        self.offset = offset
        self.size = size
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.size is not None:
            result['Size'] = self.size
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class GetTemplateListByUserIdResponseBodyTemplateList(TeaModel):
    def __init__(
        self,
        icon_url: str = None,
        name: str = None,
        report_code: str = None,
        url: str = None,
    ):
        self.icon_url = icon_url
        self.name = name
        self.report_code = report_code
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.icon_url is not None:
            result['IconUrl'] = self.icon_url
        if self.name is not None:
            result['Name'] = self.name
        if self.report_code is not None:
            result['ReportCode'] = self.report_code
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IconUrl') is not None:
            self.icon_url = m.get('IconUrl')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ReportCode') is not None:
            self.report_code = m.get('ReportCode')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetTemplateListByUserIdResponseBody(TeaModel):
    def __init__(
        self,
        next_cursor: int = None,
        request_id: str = None,
        template_list: List[GetTemplateListByUserIdResponseBodyTemplateList] = None,
    ):
        self.next_cursor = next_cursor
        # requestId
        self.request_id = request_id
        self.template_list = template_list

    def validate(self):
        if self.template_list:
            for k in self.template_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_cursor is not None:
            result['nextCursor'] = self.next_cursor
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['templateList'] = []
        if self.template_list is not None:
            for k in self.template_list:
                result['templateList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nextCursor') is not None:
            self.next_cursor = m.get('nextCursor')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.template_list = []
        if m.get('templateList') is not None:
            for k in m.get('templateList'):
                temp_model = GetTemplateListByUserIdResponseBodyTemplateList()
                self.template_list.append(temp_model.from_map(k))
        return self


class GetTemplateListByUserIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTemplateListByUserIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTemplateListByUserIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetUserHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetUserHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetUserHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetUserShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetUserRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetUserRequest(TeaModel):
    def __init__(
        self,
        tenant_context: GetUserRequestTenantContext = None,
        language: str = None,
    ):
        self.tenant_context = tenant_context
        self.language = language

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.language is not None:
            result['language'] = self.language
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            temp_model = GetUserRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('language') is not None:
            self.language = m.get('language')
        return self


class GetUserShrinkRequest(TeaModel):
    def __init__(
        self,
        tenant_context_shrink: str = None,
        language: str = None,
    ):
        self.tenant_context_shrink = tenant_context_shrink
        self.language = language

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.language is not None:
            result['language'] = self.language
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('language') is not None:
            self.language = m.get('language')
        return self


class GetUserResponseBodyDeptOrderList(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        order: int = None,
    ):
        self.dept_id = dept_id
        self.order = order

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.order is not None:
            result['order'] = self.order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('order') is not None:
            self.order = m.get('order')
        return self


class GetUserResponseBodyLeaderInDept(TeaModel):
    def __init__(
        self,
        dept_id: int = None,
        leader: bool = None,
    ):
        self.dept_id = dept_id
        self.leader = leader

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['deptId'] = self.dept_id
        if self.leader is not None:
            result['leader'] = self.leader
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('deptId') is not None:
            self.dept_id = m.get('deptId')
        if m.get('leader') is not None:
            self.leader = m.get('leader')
        return self


class GetUserResponseBodyRoleList(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        id: int = None,
        name: str = None,
    ):
        self.group_name = group_name
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class GetUserResponseBodyUnionEmpExtUnionEmpMapList(TeaModel):
    def __init__(
        self,
        crop_id: str = None,
        userid: str = None,
    ):
        self.crop_id = crop_id
        self.userid = userid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.crop_id is not None:
            result['cropId'] = self.crop_id
        if self.userid is not None:
            result['userid'] = self.userid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cropId') is not None:
            self.crop_id = m.get('cropId')
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        return self


class GetUserResponseBodyUnionEmpExt(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        union_emp_map_list: List[GetUserResponseBodyUnionEmpExtUnionEmpMapList] = None,
        userid: str = None,
    ):
        self.corp_id = corp_id
        self.union_emp_map_list = union_emp_map_list
        self.userid = userid

    def validate(self):
        if self.union_emp_map_list:
            for k in self.union_emp_map_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corpId'] = self.corp_id
        result['unionEmpMapList'] = []
        if self.union_emp_map_list is not None:
            for k in self.union_emp_map_list:
                result['unionEmpMapList'].append(k.to_map() if k else None)
        if self.userid is not None:
            result['userid'] = self.userid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corpId') is not None:
            self.corp_id = m.get('corpId')
        self.union_emp_map_list = []
        if m.get('unionEmpMapList') is not None:
            for k in m.get('unionEmpMapList'):
                temp_model = GetUserResponseBodyUnionEmpExtUnionEmpMapList()
                self.union_emp_map_list.append(temp_model.from_map(k))
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        return self


class GetUserResponseBody(TeaModel):
    def __init__(
        self,
        active: bool = None,
        admin: bool = None,
        avatar: str = None,
        boss: bool = None,
        dept_id_list: List[int] = None,
        dept_order_list: List[GetUserResponseBodyDeptOrderList] = None,
        email: str = None,
        exclusive_account: bool = None,
        exclusive_account_corp_id: str = None,
        exclusive_account_corp_name: str = None,
        exclusive_account_type: str = None,
        extension: str = None,
        hide_mobile: bool = None,
        hired_date: int = None,
        job_number: str = None,
        leader_in_dept: List[GetUserResponseBodyLeaderInDept] = None,
        login_id: str = None,
        manager_userid: str = None,
        mobile: str = None,
        name: str = None,
        nickname: str = None,
        org_email: str = None,
        real_authed: bool = None,
        remark: str = None,
        request_id: str = None,
        role_list: List[GetUserResponseBodyRoleList] = None,
        senior: bool = None,
        state_code: str = None,
        telephone: str = None,
        title: str = None,
        union_emp_ext: GetUserResponseBodyUnionEmpExt = None,
        userid: str = None,
        work_place: str = None,
    ):
        self.active = active
        self.admin = admin
        self.avatar = avatar
        self.boss = boss
        self.dept_id_list = dept_id_list
        self.dept_order_list = dept_order_list
        self.email = email
        self.exclusive_account = exclusive_account
        self.exclusive_account_corp_id = exclusive_account_corp_id
        self.exclusive_account_corp_name = exclusive_account_corp_name
        self.exclusive_account_type = exclusive_account_type
        self.extension = extension
        self.hide_mobile = hide_mobile
        self.hired_date = hired_date
        self.job_number = job_number
        self.leader_in_dept = leader_in_dept
        self.login_id = login_id
        self.manager_userid = manager_userid
        self.mobile = mobile
        self.name = name
        self.nickname = nickname
        self.org_email = org_email
        self.real_authed = real_authed
        self.remark = remark
        self.request_id = request_id
        self.role_list = role_list
        self.senior = senior
        self.state_code = state_code
        self.telephone = telephone
        self.title = title
        self.union_emp_ext = union_emp_ext
        self.userid = userid
        self.work_place = work_place

    def validate(self):
        if self.dept_order_list:
            for k in self.dept_order_list:
                if k:
                    k.validate()
        if self.leader_in_dept:
            for k in self.leader_in_dept:
                if k:
                    k.validate()
        if self.role_list:
            for k in self.role_list:
                if k:
                    k.validate()
        if self.union_emp_ext:
            self.union_emp_ext.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['active'] = self.active
        if self.admin is not None:
            result['admin'] = self.admin
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.boss is not None:
            result['boss'] = self.boss
        if self.dept_id_list is not None:
            result['deptIdList'] = self.dept_id_list
        result['deptOrderList'] = []
        if self.dept_order_list is not None:
            for k in self.dept_order_list:
                result['deptOrderList'].append(k.to_map() if k else None)
        if self.email is not None:
            result['email'] = self.email
        if self.exclusive_account is not None:
            result['exclusiveAccount'] = self.exclusive_account
        if self.exclusive_account_corp_id is not None:
            result['exclusiveAccountCorpId'] = self.exclusive_account_corp_id
        if self.exclusive_account_corp_name is not None:
            result['exclusiveAccountCorpName'] = self.exclusive_account_corp_name
        if self.exclusive_account_type is not None:
            result['exclusiveAccountType'] = self.exclusive_account_type
        if self.extension is not None:
            result['extension'] = self.extension
        if self.hide_mobile is not None:
            result['hideMobile'] = self.hide_mobile
        if self.hired_date is not None:
            result['hiredDate'] = self.hired_date
        if self.job_number is not None:
            result['jobNumber'] = self.job_number
        result['leaderInDept'] = []
        if self.leader_in_dept is not None:
            for k in self.leader_in_dept:
                result['leaderInDept'].append(k.to_map() if k else None)
        if self.login_id is not None:
            result['loginId'] = self.login_id
        if self.manager_userid is not None:
            result['managerUserid'] = self.manager_userid
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.nickname is not None:
            result['nickname'] = self.nickname
        if self.org_email is not None:
            result['orgEmail'] = self.org_email
        if self.real_authed is not None:
            result['realAuthed'] = self.real_authed
        if self.remark is not None:
            result['remark'] = self.remark
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['roleList'] = []
        if self.role_list is not None:
            for k in self.role_list:
                result['roleList'].append(k.to_map() if k else None)
        if self.senior is not None:
            result['senior'] = self.senior
        if self.state_code is not None:
            result['stateCode'] = self.state_code
        if self.telephone is not None:
            result['telephone'] = self.telephone
        if self.title is not None:
            result['title'] = self.title
        if self.union_emp_ext is not None:
            result['unionEmpExt'] = self.union_emp_ext.to_map()
        if self.userid is not None:
            result['userid'] = self.userid
        if self.work_place is not None:
            result['workPlace'] = self.work_place
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('active') is not None:
            self.active = m.get('active')
        if m.get('admin') is not None:
            self.admin = m.get('admin')
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('boss') is not None:
            self.boss = m.get('boss')
        if m.get('deptIdList') is not None:
            self.dept_id_list = m.get('deptIdList')
        self.dept_order_list = []
        if m.get('deptOrderList') is not None:
            for k in m.get('deptOrderList'):
                temp_model = GetUserResponseBodyDeptOrderList()
                self.dept_order_list.append(temp_model.from_map(k))
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('exclusiveAccount') is not None:
            self.exclusive_account = m.get('exclusiveAccount')
        if m.get('exclusiveAccountCorpId') is not None:
            self.exclusive_account_corp_id = m.get('exclusiveAccountCorpId')
        if m.get('exclusiveAccountCorpName') is not None:
            self.exclusive_account_corp_name = m.get('exclusiveAccountCorpName')
        if m.get('exclusiveAccountType') is not None:
            self.exclusive_account_type = m.get('exclusiveAccountType')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('hideMobile') is not None:
            self.hide_mobile = m.get('hideMobile')
        if m.get('hiredDate') is not None:
            self.hired_date = m.get('hiredDate')
        if m.get('jobNumber') is not None:
            self.job_number = m.get('jobNumber')
        self.leader_in_dept = []
        if m.get('leaderInDept') is not None:
            for k in m.get('leaderInDept'):
                temp_model = GetUserResponseBodyLeaderInDept()
                self.leader_in_dept.append(temp_model.from_map(k))
        if m.get('loginId') is not None:
            self.login_id = m.get('loginId')
        if m.get('managerUserid') is not None:
            self.manager_userid = m.get('managerUserid')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nickname') is not None:
            self.nickname = m.get('nickname')
        if m.get('orgEmail') is not None:
            self.org_email = m.get('orgEmail')
        if m.get('realAuthed') is not None:
            self.real_authed = m.get('realAuthed')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.role_list = []
        if m.get('roleList') is not None:
            for k in m.get('roleList'):
                temp_model = GetUserResponseBodyRoleList()
                self.role_list.append(temp_model.from_map(k))
        if m.get('senior') is not None:
            self.senior = m.get('senior')
        if m.get('stateCode') is not None:
            self.state_code = m.get('stateCode')
        if m.get('telephone') is not None:
            self.telephone = m.get('telephone')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('unionEmpExt') is not None:
            temp_model = GetUserResponseBodyUnionEmpExt()
            self.union_emp_ext = temp_model.from_map(m['unionEmpExt'])
        if m.get('userid') is not None:
            self.userid = m.get('userid')
        if m.get('workPlace') is not None:
            self.work_place = m.get('workPlace')
        return self


class GetUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkspaceHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetWorkspaceHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetWorkspaceHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetWorkspaceHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetWorkspaceShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetWorkspaceRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetWorkspaceRequest(TeaModel):
    def __init__(
        self,
        tenant_context: GetWorkspaceRequestTenantContext = None,
        with_permission_role: bool = None,
        workspace_id: str = None,
    ):
        self.tenant_context = tenant_context
        self.with_permission_role = with_permission_role
        self.workspace_id = workspace_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.with_permission_role is not None:
            result['WithPermissionRole'] = self.with_permission_role
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            temp_model = GetWorkspaceRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WithPermissionRole') is not None:
            self.with_permission_role = m.get('WithPermissionRole')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetWorkspaceShrinkRequest(TeaModel):
    def __init__(
        self,
        tenant_context_shrink: str = None,
        with_permission_role: bool = None,
        workspace_id: str = None,
    ):
        self.tenant_context_shrink = tenant_context_shrink
        self.with_permission_role = with_permission_role
        self.workspace_id = workspace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.with_permission_role is not None:
            result['WithPermissionRole'] = self.with_permission_role
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WithPermissionRole') is not None:
            self.with_permission_role = m.get('WithPermissionRole')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetWorkspaceResponseBodyWorkspaceIcon(TeaModel):
    def __init__(
        self,
        type: str = None,
        value: str = None,
    ):
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetWorkspaceResponseBodyWorkspace(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        cover: str = None,
        create_time: str = None,
        creator_id: str = None,
        description: str = None,
        icon: GetWorkspaceResponseBodyWorkspaceIcon = None,
        modified_time: str = None,
        modifier_id: str = None,
        name: str = None,
        permission_role: str = None,
        root_node_id: str = None,
        team_id: str = None,
        type: str = None,
        url: str = None,
        workspace_id: str = None,
    ):
        self.corp_id = corp_id
        self.cover = cover
        self.create_time = create_time
        self.creator_id = creator_id
        self.description = description
        self.icon = icon
        self.modified_time = modified_time
        self.modifier_id = modifier_id
        self.name = name
        self.permission_role = permission_role
        self.root_node_id = root_node_id
        self.team_id = team_id
        self.type = type
        self.url = url
        self.workspace_id = workspace_id

    def validate(self):
        if self.icon:
            self.icon.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.cover is not None:
            result['Cover'] = self.cover
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.description is not None:
            result['Description'] = self.description
        if self.icon is not None:
            result['Icon'] = self.icon.to_map()
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.modifier_id is not None:
            result['ModifierId'] = self.modifier_id
        if self.name is not None:
            result['Name'] = self.name
        if self.permission_role is not None:
            result['PermissionRole'] = self.permission_role
        if self.root_node_id is not None:
            result['RootNodeId'] = self.root_node_id
        if self.team_id is not None:
            result['TeamId'] = self.team_id
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('Cover') is not None:
            self.cover = m.get('Cover')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Icon') is not None:
            temp_model = GetWorkspaceResponseBodyWorkspaceIcon()
            self.icon = temp_model.from_map(m['Icon'])
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ModifierId') is not None:
            self.modifier_id = m.get('ModifierId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PermissionRole') is not None:
            self.permission_role = m.get('PermissionRole')
        if m.get('RootNodeId') is not None:
            self.root_node_id = m.get('RootNodeId')
        if m.get('TeamId') is not None:
            self.team_id = m.get('TeamId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetWorkspaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        workspace: GetWorkspaceResponseBodyWorkspace = None,
    ):
        # requestId
        self.request_id = request_id
        self.workspace = workspace

    def validate(self):
        if self.workspace:
            self.workspace.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.workspace is not None:
            result['workspace'] = self.workspace.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('workspace') is not None:
            temp_model = GetWorkspaceResponseBodyWorkspace()
            self.workspace = temp_model.from_map(m['workspace'])
        return self


class GetWorkspaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWorkspaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWorkspaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkspacesHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GetWorkspacesHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GetWorkspacesHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GetWorkspacesHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GetWorkspacesShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GetWorkspacesRequestOption(TeaModel):
    def __init__(
        self,
        with_permission_role: bool = None,
    ):
        self.with_permission_role = with_permission_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.with_permission_role is not None:
            result['WithPermissionRole'] = self.with_permission_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WithPermissionRole') is not None:
            self.with_permission_role = m.get('WithPermissionRole')
        return self


class GetWorkspacesRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GetWorkspacesRequest(TeaModel):
    def __init__(
        self,
        option: GetWorkspacesRequestOption = None,
        tenant_context: GetWorkspacesRequestTenantContext = None,
        workspace_ids: List[str] = None,
    ):
        self.option = option
        self.tenant_context = tenant_context
        self.workspace_ids = workspace_ids

    def validate(self):
        if self.option:
            self.option.validate()
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.option is not None:
            result['Option'] = self.option.to_map()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workspace_ids is not None:
            result['WorkspaceIds'] = self.workspace_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Option') is not None:
            temp_model = GetWorkspacesRequestOption()
            self.option = temp_model.from_map(m['Option'])
        if m.get('TenantContext') is not None:
            temp_model = GetWorkspacesRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkspaceIds') is not None:
            self.workspace_ids = m.get('WorkspaceIds')
        return self


class GetWorkspacesShrinkRequest(TeaModel):
    def __init__(
        self,
        option_shrink: str = None,
        tenant_context_shrink: str = None,
        workspace_ids_shrink: str = None,
    ):
        self.option_shrink = option_shrink
        self.tenant_context_shrink = tenant_context_shrink
        self.workspace_ids_shrink = workspace_ids_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.option_shrink is not None:
            result['Option'] = self.option_shrink
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workspace_ids_shrink is not None:
            result['WorkspaceIds'] = self.workspace_ids_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Option') is not None:
            self.option_shrink = m.get('Option')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkspaceIds') is not None:
            self.workspace_ids_shrink = m.get('WorkspaceIds')
        return self


class GetWorkspacesResponseBodyWorkspaceIcon(TeaModel):
    def __init__(
        self,
        type: str = None,
        value: str = None,
    ):
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetWorkspacesResponseBodyWorkspace(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        cover: str = None,
        create_time: str = None,
        creator_id: str = None,
        description: str = None,
        icon: GetWorkspacesResponseBodyWorkspaceIcon = None,
        modified_time: str = None,
        modifier_id: str = None,
        name: str = None,
        permission_role: str = None,
        root_node_id: str = None,
        team_id: str = None,
        type: str = None,
        url: str = None,
        workspace_id: str = None,
    ):
        self.corp_id = corp_id
        self.cover = cover
        self.create_time = create_time
        self.creator_id = creator_id
        self.description = description
        self.icon = icon
        self.modified_time = modified_time
        self.modifier_id = modifier_id
        self.name = name
        self.permission_role = permission_role
        self.root_node_id = root_node_id
        self.team_id = team_id
        self.type = type
        self.url = url
        self.workspace_id = workspace_id

    def validate(self):
        if self.icon:
            self.icon.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.cover is not None:
            result['Cover'] = self.cover
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.description is not None:
            result['Description'] = self.description
        if self.icon is not None:
            result['Icon'] = self.icon.to_map()
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.modifier_id is not None:
            result['ModifierId'] = self.modifier_id
        if self.name is not None:
            result['Name'] = self.name
        if self.permission_role is not None:
            result['PermissionRole'] = self.permission_role
        if self.root_node_id is not None:
            result['RootNodeId'] = self.root_node_id
        if self.team_id is not None:
            result['TeamId'] = self.team_id
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('Cover') is not None:
            self.cover = m.get('Cover')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Icon') is not None:
            temp_model = GetWorkspacesResponseBodyWorkspaceIcon()
            self.icon = temp_model.from_map(m['Icon'])
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ModifierId') is not None:
            self.modifier_id = m.get('ModifierId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PermissionRole') is not None:
            self.permission_role = m.get('PermissionRole')
        if m.get('RootNodeId') is not None:
            self.root_node_id = m.get('RootNodeId')
        if m.get('TeamId') is not None:
            self.team_id = m.get('TeamId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class GetWorkspacesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        workspace: List[GetWorkspacesResponseBodyWorkspace] = None,
    ):
        # requestId
        self.request_id = request_id
        self.workspace = workspace

    def validate(self):
        if self.workspace:
            for k in self.workspace:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['workspace'] = []
        if self.workspace is not None:
            for k in self.workspace:
                result['workspace'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.workspace = []
        if m.get('workspace') is not None:
            for k in m.get('workspace'):
                temp_model = GetWorkspacesResponseBodyWorkspace()
                self.workspace.append(temp_model.from_map(k))
        return self


class GetWorkspacesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetWorkspacesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetWorkspacesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GrantHonorHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class GrantHonorHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: GrantHonorHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = GrantHonorHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class GrantHonorShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class GrantHonorRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class GrantHonorRequest(TeaModel):
    def __init__(
        self,
        tenant_context: GrantHonorRequestTenantContext = None,
        expiration_time: int = None,
        grant_reason: str = None,
        granter_name: str = None,
        honor_id: str = None,
        notice_announcer: bool = None,
        notice_single: bool = None,
        open_conversation_ids: List[str] = None,
        org_id: int = None,
        receiver_user_ids: List[str] = None,
        sender_user_id: str = None,
    ):
        self.tenant_context = tenant_context
        self.expiration_time = expiration_time
        self.grant_reason = grant_reason
        self.granter_name = granter_name
        self.honor_id = honor_id
        self.notice_announcer = notice_announcer
        self.notice_single = notice_single
        self.open_conversation_ids = open_conversation_ids
        self.org_id = org_id
        self.receiver_user_ids = receiver_user_ids
        self.sender_user_id = sender_user_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.expiration_time is not None:
            result['expirationTime'] = self.expiration_time
        if self.grant_reason is not None:
            result['grantReason'] = self.grant_reason
        if self.granter_name is not None:
            result['granterName'] = self.granter_name
        if self.honor_id is not None:
            result['honorId'] = self.honor_id
        if self.notice_announcer is not None:
            result['noticeAnnouncer'] = self.notice_announcer
        if self.notice_single is not None:
            result['noticeSingle'] = self.notice_single
        if self.open_conversation_ids is not None:
            result['openConversationIds'] = self.open_conversation_ids
        if self.org_id is not None:
            result['orgId'] = self.org_id
        if self.receiver_user_ids is not None:
            result['receiverUserIds'] = self.receiver_user_ids
        if self.sender_user_id is not None:
            result['senderUserId'] = self.sender_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            temp_model = GrantHonorRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('expirationTime') is not None:
            self.expiration_time = m.get('expirationTime')
        if m.get('grantReason') is not None:
            self.grant_reason = m.get('grantReason')
        if m.get('granterName') is not None:
            self.granter_name = m.get('granterName')
        if m.get('honorId') is not None:
            self.honor_id = m.get('honorId')
        if m.get('noticeAnnouncer') is not None:
            self.notice_announcer = m.get('noticeAnnouncer')
        if m.get('noticeSingle') is not None:
            self.notice_single = m.get('noticeSingle')
        if m.get('openConversationIds') is not None:
            self.open_conversation_ids = m.get('openConversationIds')
        if m.get('orgId') is not None:
            self.org_id = m.get('orgId')
        if m.get('receiverUserIds') is not None:
            self.receiver_user_ids = m.get('receiverUserIds')
        if m.get('senderUserId') is not None:
            self.sender_user_id = m.get('senderUserId')
        return self


class GrantHonorShrinkRequest(TeaModel):
    def __init__(
        self,
        tenant_context_shrink: str = None,
        expiration_time: int = None,
        grant_reason: str = None,
        granter_name: str = None,
        honor_id: str = None,
        notice_announcer: bool = None,
        notice_single: bool = None,
        open_conversation_ids_shrink: str = None,
        org_id: int = None,
        receiver_user_ids_shrink: str = None,
        sender_user_id: str = None,
    ):
        self.tenant_context_shrink = tenant_context_shrink
        self.expiration_time = expiration_time
        self.grant_reason = grant_reason
        self.granter_name = granter_name
        self.honor_id = honor_id
        self.notice_announcer = notice_announcer
        self.notice_single = notice_single
        self.open_conversation_ids_shrink = open_conversation_ids_shrink
        self.org_id = org_id
        self.receiver_user_ids_shrink = receiver_user_ids_shrink
        self.sender_user_id = sender_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.expiration_time is not None:
            result['expirationTime'] = self.expiration_time
        if self.grant_reason is not None:
            result['grantReason'] = self.grant_reason
        if self.granter_name is not None:
            result['granterName'] = self.granter_name
        if self.honor_id is not None:
            result['honorId'] = self.honor_id
        if self.notice_announcer is not None:
            result['noticeAnnouncer'] = self.notice_announcer
        if self.notice_single is not None:
            result['noticeSingle'] = self.notice_single
        if self.open_conversation_ids_shrink is not None:
            result['openConversationIds'] = self.open_conversation_ids_shrink
        if self.org_id is not None:
            result['orgId'] = self.org_id
        if self.receiver_user_ids_shrink is not None:
            result['receiverUserIds'] = self.receiver_user_ids_shrink
        if self.sender_user_id is not None:
            result['senderUserId'] = self.sender_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('expirationTime') is not None:
            self.expiration_time = m.get('expirationTime')
        if m.get('grantReason') is not None:
            self.grant_reason = m.get('grantReason')
        if m.get('granterName') is not None:
            self.granter_name = m.get('granterName')
        if m.get('honorId') is not None:
            self.honor_id = m.get('honorId')
        if m.get('noticeAnnouncer') is not None:
            self.notice_announcer = m.get('noticeAnnouncer')
        if m.get('noticeSingle') is not None:
            self.notice_single = m.get('noticeSingle')
        if m.get('openConversationIds') is not None:
            self.open_conversation_ids_shrink = m.get('openConversationIds')
        if m.get('orgId') is not None:
            self.org_id = m.get('orgId')
        if m.get('receiverUserIds') is not None:
            self.receiver_user_ids_shrink = m.get('receiverUserIds')
        if m.get('senderUserId') is not None:
            self.sender_user_id = m.get('senderUserId')
        return self


class GrantHonorResponseBody(TeaModel):
    def __init__(
        self,
        failed_user_ids: List[str] = None,
        request_id: str = None,
        success_user_ids: List[str] = None,
    ):
        self.failed_user_ids = failed_user_ids
        # requestId
        self.request_id = request_id
        self.success_user_ids = success_user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_user_ids is not None:
            result['failedUserIds'] = self.failed_user_ids
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success_user_ids is not None:
            result['successUserIds'] = self.success_user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('failedUserIds') is not None:
            self.failed_user_ids = m.get('failedUserIds')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('successUserIds') is not None:
            self.success_user_ids = m.get('successUserIds')
        return self


class GrantHonorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GrantHonorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GrantHonorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InsertColumnsBeforeHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class InsertColumnsBeforeHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: InsertColumnsBeforeHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = InsertColumnsBeforeHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class InsertColumnsBeforeShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class InsertColumnsBeforeRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class InsertColumnsBeforeRequest(TeaModel):
    def __init__(
        self,
        column: int = None,
        column_count: int = None,
        sheet_id: str = None,
        tenant_context: InsertColumnsBeforeRequestTenantContext = None,
        workbook_id: str = None,
    ):
        self.column = column
        self.column_count = column_count
        self.sheet_id = sheet_id
        self.tenant_context = tenant_context
        self.workbook_id = workbook_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column is not None:
            result['Column'] = self.column
        if self.column_count is not None:
            result['ColumnCount'] = self.column_count
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Column') is not None:
            self.column = m.get('Column')
        if m.get('ColumnCount') is not None:
            self.column_count = m.get('ColumnCount')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            temp_model = InsertColumnsBeforeRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class InsertColumnsBeforeShrinkRequest(TeaModel):
    def __init__(
        self,
        column: int = None,
        column_count: int = None,
        sheet_id: str = None,
        tenant_context_shrink: str = None,
        workbook_id: str = None,
    ):
        self.column = column
        self.column_count = column_count
        self.sheet_id = sheet_id
        self.tenant_context_shrink = tenant_context_shrink
        self.workbook_id = workbook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column is not None:
            result['Column'] = self.column
        if self.column_count is not None:
            result['ColumnCount'] = self.column_count
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Column') is not None:
            self.column = m.get('Column')
        if m.get('ColumnCount') is not None:
            self.column_count = m.get('ColumnCount')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class InsertColumnsBeforeResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
    ):
        self.id = id
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class InsertColumnsBeforeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InsertColumnsBeforeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InsertColumnsBeforeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InsertRowsBeforeHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class InsertRowsBeforeHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: InsertRowsBeforeHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = InsertRowsBeforeHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class InsertRowsBeforeShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class InsertRowsBeforeRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class InsertRowsBeforeRequest(TeaModel):
    def __init__(
        self,
        row: int = None,
        row_count: int = None,
        sheet_id: str = None,
        tenant_context: InsertRowsBeforeRequestTenantContext = None,
        workbook_id: str = None,
    ):
        self.row = row
        self.row_count = row_count
        self.sheet_id = sheet_id
        self.tenant_context = tenant_context
        self.workbook_id = workbook_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.row is not None:
            result['Row'] = self.row
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Row') is not None:
            self.row = m.get('Row')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            temp_model = InsertRowsBeforeRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class InsertRowsBeforeShrinkRequest(TeaModel):
    def __init__(
        self,
        row: int = None,
        row_count: int = None,
        sheet_id: str = None,
        tenant_context_shrink: str = None,
        workbook_id: str = None,
    ):
        self.row = row
        self.row_count = row_count
        self.sheet_id = sheet_id
        self.tenant_context_shrink = tenant_context_shrink
        self.workbook_id = workbook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.row is not None:
            result['Row'] = self.row
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        if self.sheet_id is not None:
            result['SheetId'] = self.sheet_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.workbook_id is not None:
            result['WorkbookId'] = self.workbook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Row') is not None:
            self.row = m.get('Row')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        if m.get('SheetId') is not None:
            self.sheet_id = m.get('SheetId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WorkbookId') is not None:
            self.workbook_id = m.get('WorkbookId')
        return self


class InsertRowsBeforeResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
    ):
        self.id = id
        # requestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class InsertRowsBeforeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InsertRowsBeforeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InsertRowsBeforeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InviteUsersHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class InviteUsersHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: InviteUsersHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = InviteUsersHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class InviteUsersShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class InviteUsersRequestInviteeList(TeaModel):
    def __init__(
        self,
        nick: str = None,
        user_id: str = None,
    ):
        self.nick = nick
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nick is not None:
            result['Nick'] = self.nick
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Nick') is not None:
            self.nick = m.get('Nick')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class InviteUsersRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class InviteUsersRequest(TeaModel):
    def __init__(
        self,
        invitee_list: List[InviteUsersRequestInviteeList] = None,
        tenant_context: InviteUsersRequestTenantContext = None,
        conference_id: str = None,
    ):
        self.invitee_list = invitee_list
        self.tenant_context = tenant_context
        self.conference_id = conference_id

    def validate(self):
        if self.invitee_list:
            for k in self.invitee_list:
                if k:
                    k.validate()
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InviteeList'] = []
        if self.invitee_list is not None:
            for k in self.invitee_list:
                result['InviteeList'].append(k.to_map() if k else None)
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.conference_id is not None:
            result['conferenceId'] = self.conference_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.invitee_list = []
        if m.get('InviteeList') is not None:
            for k in m.get('InviteeList'):
                temp_model = InviteUsersRequestInviteeList()
                self.invitee_list.append(temp_model.from_map(k))
        if m.get('TenantContext') is not None:
            temp_model = InviteUsersRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('conferenceId') is not None:
            self.conference_id = m.get('conferenceId')
        return self


class InviteUsersShrinkRequest(TeaModel):
    def __init__(
        self,
        invitee_list_shrink: str = None,
        tenant_context_shrink: str = None,
        conference_id: str = None,
    ):
        self.invitee_list_shrink = invitee_list_shrink
        self.tenant_context_shrink = tenant_context_shrink
        self.conference_id = conference_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invitee_list_shrink is not None:
            result['InviteeList'] = self.invitee_list_shrink
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.conference_id is not None:
            result['conferenceId'] = self.conference_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InviteeList') is not None:
            self.invitee_list_shrink = m.get('InviteeList')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('conferenceId') is not None:
            self.conference_id = m.get('conferenceId')
        return self


class InviteUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # requestId
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class InviteUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InviteUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InviteUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCalendarsHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class ListCalendarsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: ListCalendarsHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = ListCalendarsHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class ListCalendarsShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class ListCalendarsRequest(TeaModel):
    def __init__(
        self,
        request: Dict[str, Any] = None,
    ):
        self.request = request

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request is not None:
            result['Request'] = self.request
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Request') is not None:
            self.request = m.get('Request')
        return self


class ListCalendarsShrinkRequest(TeaModel):
    def __init__(
        self,
        request_shrink: str = None,
    ):
        self.request_shrink = request_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_shrink is not None:
            result['Request'] = self.request_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Request') is not None:
            self.request_shrink = m.get('Request')
        return self


class ListCalendarsResponseBodyResponseCalendars(TeaModel):
    def __init__(
        self,
        description: str = None,
        etag: str = None,
        id: str = None,
        privilege: str = None,
        summary: str = None,
        time_zone: str = None,
        type: str = None,
    ):
        self.description = description
        self.etag = etag
        self.id = id
        self.privilege = privilege
        self.summary = summary
        self.time_zone = time_zone
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.etag is not None:
            result['ETag'] = self.etag
        if self.id is not None:
            result['Id'] = self.id
        if self.privilege is not None:
            result['Privilege'] = self.privilege
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ETag') is not None:
            self.etag = m.get('ETag')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Privilege') is not None:
            self.privilege = m.get('Privilege')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListCalendarsResponseBodyResponse(TeaModel):
    def __init__(
        self,
        calendars: List[ListCalendarsResponseBodyResponseCalendars] = None,
    ):
        self.calendars = calendars

    def validate(self):
        if self.calendars:
            for k in self.calendars:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Calendars'] = []
        if self.calendars is not None:
            for k in self.calendars:
                result['Calendars'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.calendars = []
        if m.get('Calendars') is not None:
            for k in m.get('Calendars'):
                temp_model = ListCalendarsResponseBodyResponseCalendars()
                self.calendars.append(temp_model.from_map(k))
        return self


class ListCalendarsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        response: ListCalendarsResponseBodyResponse = None,
    ):
        # requestId
        self.request_id = request_id
        self.response = response

    def validate(self):
        if self.response:
            self.response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.response is not None:
            result['response'] = self.response.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('response') is not None:
            temp_model = ListCalendarsResponseBodyResponse()
            self.response = temp_model.from_map(m['response'])
        return self


class ListCalendarsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListCalendarsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCalendarsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEventsHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class ListEventsHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: ListEventsHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = ListEventsHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class ListEventsShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class ListEventsRequest(TeaModel):
    def __init__(
        self,
        calendar_id: str = None,
        max_attendees: int = None,
        max_results: int = None,
        next_token: str = None,
        series_master_id: str = None,
        show_deleted: bool = None,
        sync_token: str = None,
        time_max: str = None,
        time_min: str = None,
    ):
        self.calendar_id = calendar_id
        self.max_attendees = max_attendees
        self.max_results = max_results
        self.next_token = next_token
        self.series_master_id = series_master_id
        self.show_deleted = show_deleted
        self.sync_token = sync_token
        self.time_max = time_max
        self.time_min = time_min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        if self.max_attendees is not None:
            result['MaxAttendees'] = self.max_attendees
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.series_master_id is not None:
            result['SeriesMasterId'] = self.series_master_id
        if self.show_deleted is not None:
            result['ShowDeleted'] = self.show_deleted
        if self.sync_token is not None:
            result['SyncToken'] = self.sync_token
        if self.time_max is not None:
            result['TimeMax'] = self.time_max
        if self.time_min is not None:
            result['TimeMin'] = self.time_min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        if m.get('MaxAttendees') is not None:
            self.max_attendees = m.get('MaxAttendees')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('SeriesMasterId') is not None:
            self.series_master_id = m.get('SeriesMasterId')
        if m.get('ShowDeleted') is not None:
            self.show_deleted = m.get('ShowDeleted')
        if m.get('SyncToken') is not None:
            self.sync_token = m.get('SyncToken')
        if m.get('TimeMax') is not None:
            self.time_max = m.get('TimeMax')
        if m.get('TimeMin') is not None:
            self.time_min = m.get('TimeMin')
        return self


class ListEventsResponseBodyEventsAttendees(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        is_optional: bool = None,
        response_status: str = None,
        self_: bool = None,
    ):
        self.display_name = display_name
        self.is_optional = is_optional
        self.response_status = response_status
        self.self_ = self_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.is_optional is not None:
            result['IsOptional'] = self.is_optional
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.self_ is not None:
            result['Self'] = self.self_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('IsOptional') is not None:
            self.is_optional = m.get('IsOptional')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('Self') is not None:
            self.self_ = m.get('Self')
        return self


class ListEventsResponseBodyEventsCategories(TeaModel):
    def __init__(
        self,
        display_name: str = None,
    ):
        self.display_name = display_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        return self


class ListEventsResponseBodyEventsEnd(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class ListEventsResponseBodyEventsExtendedPropertiesSharedProperties(TeaModel):
    def __init__(
        self,
        belong_corp_id: str = None,
        source_open_cid: str = None,
    ):
        self.belong_corp_id = belong_corp_id
        self.source_open_cid = source_open_cid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.belong_corp_id is not None:
            result['BelongCorpId'] = self.belong_corp_id
        if self.source_open_cid is not None:
            result['SourceOpenCid'] = self.source_open_cid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BelongCorpId') is not None:
            self.belong_corp_id = m.get('BelongCorpId')
        if m.get('SourceOpenCid') is not None:
            self.source_open_cid = m.get('SourceOpenCid')
        return self


class ListEventsResponseBodyEventsExtendedProperties(TeaModel):
    def __init__(
        self,
        shared_properties: ListEventsResponseBodyEventsExtendedPropertiesSharedProperties = None,
    ):
        self.shared_properties = shared_properties

    def validate(self):
        if self.shared_properties:
            self.shared_properties.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.shared_properties is not None:
            result['SharedProperties'] = self.shared_properties.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SharedProperties') is not None:
            temp_model = ListEventsResponseBodyEventsExtendedPropertiesSharedProperties()
            self.shared_properties = temp_model.from_map(m['SharedProperties'])
        return self


class ListEventsResponseBodyEventsLocation(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        meeting_rooms: List[str] = None,
    ):
        self.display_name = display_name
        self.meeting_rooms = meeting_rooms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.meeting_rooms is not None:
            result['MeetingRooms'] = self.meeting_rooms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('MeetingRooms') is not None:
            self.meeting_rooms = m.get('MeetingRooms')
        return self


class ListEventsResponseBodyEventsMeetingRooms(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        response_status: str = None,
        room_id: str = None,
    ):
        self.display_name = display_name
        self.response_status = response_status
        self.room_id = room_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class ListEventsResponseBodyEventsOnlineMeetingInfo(TeaModel):
    def __init__(
        self,
        conference_id: str = None,
        extra_info: Dict[str, Any] = None,
        type: str = None,
        url: str = None,
    ):
        self.conference_id = conference_id
        self.extra_info = extra_info
        self.type = type
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conference_id is not None:
            result['ConferenceId'] = self.conference_id
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConferenceId') is not None:
            self.conference_id = m.get('ConferenceId')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListEventsResponseBodyEventsOrganizer(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        response_status: str = None,
        self_: bool = None,
    ):
        self.display_name = display_name
        self.response_status = response_status
        self.self_ = self_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.self_ is not None:
            result['Self'] = self.self_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('Self') is not None:
            self.self_ = m.get('Self')
        return self


class ListEventsResponseBodyEventsOriginStart(TeaModel):
    def __init__(
        self,
        date_time: str = None,
    ):
        self.date_time = date_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        return self


class ListEventsResponseBodyEventsRecurrencePattern(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        days_of_week: str = None,
        index: str = None,
        interval: int = None,
        type: str = None,
    ):
        self.day_of_month = day_of_month
        self.days_of_week = days_of_week
        self.index = index
        self.interval = interval
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['DayOfMonth'] = self.day_of_month
        if self.days_of_week is not None:
            result['DaysOfWeek'] = self.days_of_week
        if self.index is not None:
            result['Index'] = self.index
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DayOfMonth') is not None:
            self.day_of_month = m.get('DayOfMonth')
        if m.get('DaysOfWeek') is not None:
            self.days_of_week = m.get('DaysOfWeek')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListEventsResponseBodyEventsRecurrenceRange(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        number_of_occurrences: int = None,
        type: str = None,
    ):
        self.end_date = end_date
        self.number_of_occurrences = number_of_occurrences
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.number_of_occurrences is not None:
            result['NumberOfOccurrences'] = self.number_of_occurrences
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('NumberOfOccurrences') is not None:
            self.number_of_occurrences = m.get('NumberOfOccurrences')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListEventsResponseBodyEventsRecurrence(TeaModel):
    def __init__(
        self,
        pattern: ListEventsResponseBodyEventsRecurrencePattern = None,
        range: ListEventsResponseBodyEventsRecurrenceRange = None,
    ):
        self.pattern = pattern
        self.range = range

    def validate(self):
        if self.pattern:
            self.pattern.validate()
        if self.range:
            self.range.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pattern is not None:
            result['Pattern'] = self.pattern.to_map()
        if self.range is not None:
            result['Range'] = self.range.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pattern') is not None:
            temp_model = ListEventsResponseBodyEventsRecurrencePattern()
            self.pattern = temp_model.from_map(m['Pattern'])
        if m.get('Range') is not None:
            temp_model = ListEventsResponseBodyEventsRecurrenceRange()
            self.range = temp_model.from_map(m['Range'])
        return self


class ListEventsResponseBodyEventsReminders(TeaModel):
    def __init__(
        self,
        method: str = None,
        minutes: str = None,
    ):
        self.method = method
        self.minutes = minutes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method is not None:
            result['Method'] = self.method
        if self.minutes is not None:
            result['Minutes'] = self.minutes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Minutes') is not None:
            self.minutes = m.get('Minutes')
        return self


class ListEventsResponseBodyEventsRichTextDescription(TeaModel):
    def __init__(
        self,
        text: str = None,
    ):
        self.text = text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class ListEventsResponseBodyEventsStart(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class ListEventsResponseBodyEvents(TeaModel):
    def __init__(
        self,
        attendees: List[ListEventsResponseBodyEventsAttendees] = None,
        categories: List[ListEventsResponseBodyEventsCategories] = None,
        create_time: str = None,
        description: str = None,
        end: ListEventsResponseBodyEventsEnd = None,
        extended_properties: ListEventsResponseBodyEventsExtendedProperties = None,
        id: str = None,
        is_all_day: bool = None,
        location: ListEventsResponseBodyEventsLocation = None,
        meeting_rooms: List[ListEventsResponseBodyEventsMeetingRooms] = None,
        online_meeting_info: ListEventsResponseBodyEventsOnlineMeetingInfo = None,
        organizer: ListEventsResponseBodyEventsOrganizer = None,
        origin_start: ListEventsResponseBodyEventsOriginStart = None,
        recurrence: ListEventsResponseBodyEventsRecurrence = None,
        reminders: List[ListEventsResponseBodyEventsReminders] = None,
        rich_text_description: ListEventsResponseBodyEventsRichTextDescription = None,
        series_master_id: str = None,
        start: ListEventsResponseBodyEventsStart = None,
        status: str = None,
        summary: str = None,
        update_time: str = None,
    ):
        self.attendees = attendees
        self.categories = categories
        self.create_time = create_time
        self.description = description
        self.end = end
        self.extended_properties = extended_properties
        self.id = id
        self.is_all_day = is_all_day
        self.location = location
        self.meeting_rooms = meeting_rooms
        self.online_meeting_info = online_meeting_info
        self.organizer = organizer
        self.origin_start = origin_start
        self.recurrence = recurrence
        self.reminders = reminders
        self.rich_text_description = rich_text_description
        self.series_master_id = series_master_id
        self.start = start
        self.status = status
        self.summary = summary
        self.update_time = update_time

    def validate(self):
        if self.attendees:
            for k in self.attendees:
                if k:
                    k.validate()
        if self.categories:
            for k in self.categories:
                if k:
                    k.validate()
        if self.end:
            self.end.validate()
        if self.extended_properties:
            self.extended_properties.validate()
        if self.location:
            self.location.validate()
        if self.meeting_rooms:
            for k in self.meeting_rooms:
                if k:
                    k.validate()
        if self.online_meeting_info:
            self.online_meeting_info.validate()
        if self.organizer:
            self.organizer.validate()
        if self.origin_start:
            self.origin_start.validate()
        if self.recurrence:
            self.recurrence.validate()
        if self.reminders:
            for k in self.reminders:
                if k:
                    k.validate()
        if self.rich_text_description:
            self.rich_text_description.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attendees'] = []
        if self.attendees is not None:
            for k in self.attendees:
                result['Attendees'].append(k.to_map() if k else None)
        result['Categories'] = []
        if self.categories is not None:
            for k in self.categories:
                result['Categories'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.end is not None:
            result['End'] = self.end.to_map()
        if self.extended_properties is not None:
            result['ExtendedProperties'] = self.extended_properties.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.is_all_day is not None:
            result['IsAllDay'] = self.is_all_day
        if self.location is not None:
            result['Location'] = self.location.to_map()
        result['MeetingRooms'] = []
        if self.meeting_rooms is not None:
            for k in self.meeting_rooms:
                result['MeetingRooms'].append(k.to_map() if k else None)
        if self.online_meeting_info is not None:
            result['OnlineMeetingInfo'] = self.online_meeting_info.to_map()
        if self.organizer is not None:
            result['Organizer'] = self.organizer.to_map()
        if self.origin_start is not None:
            result['OriginStart'] = self.origin_start.to_map()
        if self.recurrence is not None:
            result['Recurrence'] = self.recurrence.to_map()
        result['Reminders'] = []
        if self.reminders is not None:
            for k in self.reminders:
                result['Reminders'].append(k.to_map() if k else None)
        if self.rich_text_description is not None:
            result['RichTextDescription'] = self.rich_text_description.to_map()
        if self.series_master_id is not None:
            result['SeriesMasterId'] = self.series_master_id
        if self.start is not None:
            result['Start'] = self.start.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attendees = []
        if m.get('Attendees') is not None:
            for k in m.get('Attendees'):
                temp_model = ListEventsResponseBodyEventsAttendees()
                self.attendees.append(temp_model.from_map(k))
        self.categories = []
        if m.get('Categories') is not None:
            for k in m.get('Categories'):
                temp_model = ListEventsResponseBodyEventsCategories()
                self.categories.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('End') is not None:
            temp_model = ListEventsResponseBodyEventsEnd()
            self.end = temp_model.from_map(m['End'])
        if m.get('ExtendedProperties') is not None:
            temp_model = ListEventsResponseBodyEventsExtendedProperties()
            self.extended_properties = temp_model.from_map(m['ExtendedProperties'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsAllDay') is not None:
            self.is_all_day = m.get('IsAllDay')
        if m.get('Location') is not None:
            temp_model = ListEventsResponseBodyEventsLocation()
            self.location = temp_model.from_map(m['Location'])
        self.meeting_rooms = []
        if m.get('MeetingRooms') is not None:
            for k in m.get('MeetingRooms'):
                temp_model = ListEventsResponseBodyEventsMeetingRooms()
                self.meeting_rooms.append(temp_model.from_map(k))
        if m.get('OnlineMeetingInfo') is not None:
            temp_model = ListEventsResponseBodyEventsOnlineMeetingInfo()
            self.online_meeting_info = temp_model.from_map(m['OnlineMeetingInfo'])
        if m.get('Organizer') is not None:
            temp_model = ListEventsResponseBodyEventsOrganizer()
            self.organizer = temp_model.from_map(m['Organizer'])
        if m.get('OriginStart') is not None:
            temp_model = ListEventsResponseBodyEventsOriginStart()
            self.origin_start = temp_model.from_map(m['OriginStart'])
        if m.get('Recurrence') is not None:
            temp_model = ListEventsResponseBodyEventsRecurrence()
            self.recurrence = temp_model.from_map(m['Recurrence'])
        self.reminders = []
        if m.get('Reminders') is not None:
            for k in m.get('Reminders'):
                temp_model = ListEventsResponseBodyEventsReminders()
                self.reminders.append(temp_model.from_map(k))
        if m.get('RichTextDescription') is not None:
            temp_model = ListEventsResponseBodyEventsRichTextDescription()
            self.rich_text_description = temp_model.from_map(m['RichTextDescription'])
        if m.get('SeriesMasterId') is not None:
            self.series_master_id = m.get('SeriesMasterId')
        if m.get('Start') is not None:
            temp_model = ListEventsResponseBodyEventsStart()
            self.start = temp_model.from_map(m['Start'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListEventsResponseBody(TeaModel):
    def __init__(
        self,
        events: List[ListEventsResponseBodyEvents] = None,
        next_token: str = None,
        request_id: str = None,
        sync_token: str = None,
    ):
        self.events = events
        self.next_token = next_token
        # requestId
        self.request_id = request_id
        self.sync_token = sync_token

    def validate(self):
        if self.events:
            for k in self.events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['events'] = []
        if self.events is not None:
            for k in self.events:
                result['events'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.sync_token is not None:
            result['syncToken'] = self.sync_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.events = []
        if m.get('events') is not None:
            for k in m.get('events'):
                temp_model = ListEventsResponseBodyEvents()
                self.events.append(temp_model.from_map(k))
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('syncToken') is not None:
            self.sync_token = m.get('syncToken')
        return self


class ListEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEventsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEventsViewHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class ListEventsViewHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: ListEventsViewHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = ListEventsViewHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class ListEventsViewShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class ListEventsViewRequest(TeaModel):
    def __init__(
        self,
        calendar_id: str = None,
        max_attendees: int = None,
        max_results: int = None,
        next_token: str = None,
        time_max: str = None,
        time_min: str = None,
    ):
        self.calendar_id = calendar_id
        self.max_attendees = max_attendees
        self.max_results = max_results
        self.next_token = next_token
        self.time_max = time_max
        self.time_min = time_min

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        if self.max_attendees is not None:
            result['MaxAttendees'] = self.max_attendees
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.time_max is not None:
            result['TimeMax'] = self.time_max
        if self.time_min is not None:
            result['TimeMin'] = self.time_min
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        if m.get('MaxAttendees') is not None:
            self.max_attendees = m.get('MaxAttendees')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TimeMax') is not None:
            self.time_max = m.get('TimeMax')
        if m.get('TimeMin') is not None:
            self.time_min = m.get('TimeMin')
        return self


class ListEventsViewResponseBodyEventsAttendees(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        id: str = None,
        is_optional: bool = None,
        response_status: str = None,
        self_: bool = None,
    ):
        self.display_name = display_name
        self.id = id
        self.is_optional = is_optional
        self.response_status = response_status
        self.self_ = self_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.id is not None:
            result['Id'] = self.id
        if self.is_optional is not None:
            result['IsOptional'] = self.is_optional
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.self_ is not None:
            result['Self'] = self.self_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsOptional') is not None:
            self.is_optional = m.get('IsOptional')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('Self') is not None:
            self.self_ = m.get('Self')
        return self


class ListEventsViewResponseBodyEventsCategories(TeaModel):
    def __init__(
        self,
        display_name: str = None,
    ):
        self.display_name = display_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        return self


class ListEventsViewResponseBodyEventsEnd(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class ListEventsViewResponseBodyEventsExtendedPropertiesSharedProperties(TeaModel):
    def __init__(
        self,
        belong_corp_id: str = None,
        source_open_cid: str = None,
    ):
        self.belong_corp_id = belong_corp_id
        self.source_open_cid = source_open_cid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.belong_corp_id is not None:
            result['BelongCorpId'] = self.belong_corp_id
        if self.source_open_cid is not None:
            result['SourceOpenCid'] = self.source_open_cid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BelongCorpId') is not None:
            self.belong_corp_id = m.get('BelongCorpId')
        if m.get('SourceOpenCid') is not None:
            self.source_open_cid = m.get('SourceOpenCid')
        return self


class ListEventsViewResponseBodyEventsExtendedProperties(TeaModel):
    def __init__(
        self,
        shared_properties: ListEventsViewResponseBodyEventsExtendedPropertiesSharedProperties = None,
    ):
        self.shared_properties = shared_properties

    def validate(self):
        if self.shared_properties:
            self.shared_properties.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.shared_properties is not None:
            result['SharedProperties'] = self.shared_properties.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SharedProperties') is not None:
            temp_model = ListEventsViewResponseBodyEventsExtendedPropertiesSharedProperties()
            self.shared_properties = temp_model.from_map(m['SharedProperties'])
        return self


class ListEventsViewResponseBodyEventsLocation(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        meeting_rooms: List[str] = None,
    ):
        self.display_name = display_name
        self.meeting_rooms = meeting_rooms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.meeting_rooms is not None:
            result['MeetingRooms'] = self.meeting_rooms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('MeetingRooms') is not None:
            self.meeting_rooms = m.get('MeetingRooms')
        return self


class ListEventsViewResponseBodyEventsMeetingRooms(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        response_status: str = None,
        room_id: str = None,
    ):
        self.display_name = display_name
        self.response_status = response_status
        self.room_id = room_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class ListEventsViewResponseBodyEventsOnlineMeetingInfo(TeaModel):
    def __init__(
        self,
        conference_id: str = None,
        extra_info: Dict[str, Any] = None,
        type: str = None,
        url: str = None,
    ):
        self.conference_id = conference_id
        self.extra_info = extra_info
        self.type = type
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conference_id is not None:
            result['ConferenceId'] = self.conference_id
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConferenceId') is not None:
            self.conference_id = m.get('ConferenceId')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListEventsViewResponseBodyEventsOrganizer(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        id: str = None,
        response_status: str = None,
        self_: bool = None,
    ):
        self.display_name = display_name
        self.id = id
        self.response_status = response_status
        self.self_ = self_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.id is not None:
            result['Id'] = self.id
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.self_ is not None:
            result['Self'] = self.self_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('Self') is not None:
            self.self_ = m.get('Self')
        return self


class ListEventsViewResponseBodyEventsOriginStart(TeaModel):
    def __init__(
        self,
        date_time: str = None,
    ):
        self.date_time = date_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        return self


class ListEventsViewResponseBodyEventsRecurrencePattern(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        days_of_week: str = None,
        index: str = None,
        interval: int = None,
        type: str = None,
    ):
        self.day_of_month = day_of_month
        self.days_of_week = days_of_week
        self.index = index
        self.interval = interval
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['DayOfMonth'] = self.day_of_month
        if self.days_of_week is not None:
            result['DaysOfWeek'] = self.days_of_week
        if self.index is not None:
            result['Index'] = self.index
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DayOfMonth') is not None:
            self.day_of_month = m.get('DayOfMonth')
        if m.get('DaysOfWeek') is not None:
            self.days_of_week = m.get('DaysOfWeek')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListEventsViewResponseBodyEventsRecurrenceRange(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        number_of_occurrences: int = None,
        type: str = None,
    ):
        self.end_date = end_date
        self.number_of_occurrences = number_of_occurrences
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.number_of_occurrences is not None:
            result['NumberOfOccurrences'] = self.number_of_occurrences
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('NumberOfOccurrences') is not None:
            self.number_of_occurrences = m.get('NumberOfOccurrences')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListEventsViewResponseBodyEventsRecurrence(TeaModel):
    def __init__(
        self,
        pattern: ListEventsViewResponseBodyEventsRecurrencePattern = None,
        range: ListEventsViewResponseBodyEventsRecurrenceRange = None,
    ):
        self.pattern = pattern
        self.range = range

    def validate(self):
        if self.pattern:
            self.pattern.validate()
        if self.range:
            self.range.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pattern is not None:
            result['Pattern'] = self.pattern.to_map()
        if self.range is not None:
            result['Range'] = self.range.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pattern') is not None:
            temp_model = ListEventsViewResponseBodyEventsRecurrencePattern()
            self.pattern = temp_model.from_map(m['Pattern'])
        if m.get('Range') is not None:
            temp_model = ListEventsViewResponseBodyEventsRecurrenceRange()
            self.range = temp_model.from_map(m['Range'])
        return self


class ListEventsViewResponseBodyEventsRichTextDescription(TeaModel):
    def __init__(
        self,
        text: str = None,
    ):
        self.text = text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class ListEventsViewResponseBodyEventsStart(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class ListEventsViewResponseBodyEvents(TeaModel):
    def __init__(
        self,
        attendees: List[ListEventsViewResponseBodyEventsAttendees] = None,
        categories: List[ListEventsViewResponseBodyEventsCategories] = None,
        create_time: str = None,
        description: str = None,
        end: ListEventsViewResponseBodyEventsEnd = None,
        extended_properties: ListEventsViewResponseBodyEventsExtendedProperties = None,
        id: str = None,
        is_all_day: bool = None,
        location: ListEventsViewResponseBodyEventsLocation = None,
        meeting_rooms: List[ListEventsViewResponseBodyEventsMeetingRooms] = None,
        online_meeting_info: ListEventsViewResponseBodyEventsOnlineMeetingInfo = None,
        organizer: ListEventsViewResponseBodyEventsOrganizer = None,
        origin_start: ListEventsViewResponseBodyEventsOriginStart = None,
        recurrence: ListEventsViewResponseBodyEventsRecurrence = None,
        rich_text_description: ListEventsViewResponseBodyEventsRichTextDescription = None,
        series_master_id: str = None,
        start: ListEventsViewResponseBodyEventsStart = None,
        status: str = None,
        summary: str = None,
        update_time: str = None,
    ):
        self.attendees = attendees
        self.categories = categories
        self.create_time = create_time
        self.description = description
        self.end = end
        self.extended_properties = extended_properties
        self.id = id
        self.is_all_day = is_all_day
        self.location = location
        self.meeting_rooms = meeting_rooms
        self.online_meeting_info = online_meeting_info
        self.organizer = organizer
        self.origin_start = origin_start
        self.recurrence = recurrence
        self.rich_text_description = rich_text_description
        self.series_master_id = series_master_id
        self.start = start
        self.status = status
        self.summary = summary
        self.update_time = update_time

    def validate(self):
        if self.attendees:
            for k in self.attendees:
                if k:
                    k.validate()
        if self.categories:
            for k in self.categories:
                if k:
                    k.validate()
        if self.end:
            self.end.validate()
        if self.extended_properties:
            self.extended_properties.validate()
        if self.location:
            self.location.validate()
        if self.meeting_rooms:
            for k in self.meeting_rooms:
                if k:
                    k.validate()
        if self.online_meeting_info:
            self.online_meeting_info.validate()
        if self.organizer:
            self.organizer.validate()
        if self.origin_start:
            self.origin_start.validate()
        if self.recurrence:
            self.recurrence.validate()
        if self.rich_text_description:
            self.rich_text_description.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attendees'] = []
        if self.attendees is not None:
            for k in self.attendees:
                result['Attendees'].append(k.to_map() if k else None)
        result['Categories'] = []
        if self.categories is not None:
            for k in self.categories:
                result['Categories'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.end is not None:
            result['End'] = self.end.to_map()
        if self.extended_properties is not None:
            result['ExtendedProperties'] = self.extended_properties.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.is_all_day is not None:
            result['IsAllDay'] = self.is_all_day
        if self.location is not None:
            result['Location'] = self.location.to_map()
        result['MeetingRooms'] = []
        if self.meeting_rooms is not None:
            for k in self.meeting_rooms:
                result['MeetingRooms'].append(k.to_map() if k else None)
        if self.online_meeting_info is not None:
            result['OnlineMeetingInfo'] = self.online_meeting_info.to_map()
        if self.organizer is not None:
            result['Organizer'] = self.organizer.to_map()
        if self.origin_start is not None:
            result['OriginStart'] = self.origin_start.to_map()
        if self.recurrence is not None:
            result['Recurrence'] = self.recurrence.to_map()
        if self.rich_text_description is not None:
            result['RichTextDescription'] = self.rich_text_description.to_map()
        if self.series_master_id is not None:
            result['SeriesMasterId'] = self.series_master_id
        if self.start is not None:
            result['Start'] = self.start.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attendees = []
        if m.get('Attendees') is not None:
            for k in m.get('Attendees'):
                temp_model = ListEventsViewResponseBodyEventsAttendees()
                self.attendees.append(temp_model.from_map(k))
        self.categories = []
        if m.get('Categories') is not None:
            for k in m.get('Categories'):
                temp_model = ListEventsViewResponseBodyEventsCategories()
                self.categories.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('End') is not None:
            temp_model = ListEventsViewResponseBodyEventsEnd()
            self.end = temp_model.from_map(m['End'])
        if m.get('ExtendedProperties') is not None:
            temp_model = ListEventsViewResponseBodyEventsExtendedProperties()
            self.extended_properties = temp_model.from_map(m['ExtendedProperties'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsAllDay') is not None:
            self.is_all_day = m.get('IsAllDay')
        if m.get('Location') is not None:
            temp_model = ListEventsViewResponseBodyEventsLocation()
            self.location = temp_model.from_map(m['Location'])
        self.meeting_rooms = []
        if m.get('MeetingRooms') is not None:
            for k in m.get('MeetingRooms'):
                temp_model = ListEventsViewResponseBodyEventsMeetingRooms()
                self.meeting_rooms.append(temp_model.from_map(k))
        if m.get('OnlineMeetingInfo') is not None:
            temp_model = ListEventsViewResponseBodyEventsOnlineMeetingInfo()
            self.online_meeting_info = temp_model.from_map(m['OnlineMeetingInfo'])
        if m.get('Organizer') is not None:
            temp_model = ListEventsViewResponseBodyEventsOrganizer()
            self.organizer = temp_model.from_map(m['Organizer'])
        if m.get('OriginStart') is not None:
            temp_model = ListEventsViewResponseBodyEventsOriginStart()
            self.origin_start = temp_model.from_map(m['OriginStart'])
        if m.get('Recurrence') is not None:
            temp_model = ListEventsViewResponseBodyEventsRecurrence()
            self.recurrence = temp_model.from_map(m['Recurrence'])
        if m.get('RichTextDescription') is not None:
            temp_model = ListEventsViewResponseBodyEventsRichTextDescription()
            self.rich_text_description = temp_model.from_map(m['RichTextDescription'])
        if m.get('SeriesMasterId') is not None:
            self.series_master_id = m.get('SeriesMasterId')
        if m.get('Start') is not None:
            temp_model = ListEventsViewResponseBodyEventsStart()
            self.start = temp_model.from_map(m['Start'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListEventsViewResponseBody(TeaModel):
    def __init__(
        self,
        events: List[ListEventsViewResponseBodyEvents] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.events = events
        self.next_token = next_token
        # requestId
        self.request_id = request_id

    def validate(self):
        if self.events:
            for k in self.events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['events'] = []
        if self.events is not None:
            for k in self.events:
                result['events'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.events = []
        if m.get('events') is not None:
            for k in m.get('events'):
                temp_model = ListEventsViewResponseBodyEvents()
                self.events.append(temp_model.from_map(k))
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class ListEventsViewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEventsViewResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEventsViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFormRemarksHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class ListFormRemarksHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: ListFormRemarksHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = ListFormRemarksHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class ListFormRemarksShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class ListFormRemarksRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        form_instance_id_list: List[str] = None,
        form_uuid: str = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.form_instance_id_list = form_instance_id_list
        self.form_uuid = form_uuid
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.form_instance_id_list is not None:
            result['FormInstanceIdList'] = self.form_instance_id_list
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FormInstanceIdList') is not None:
            self.form_instance_id_list = m.get('FormInstanceIdList')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class ListFormRemarksShrinkRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        form_instance_id_list_shrink: str = None,
        form_uuid: str = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.form_instance_id_list_shrink = form_instance_id_list_shrink
        self.form_uuid = form_uuid
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.form_instance_id_list_shrink is not None:
            result['FormInstanceIdList'] = self.form_instance_id_list_shrink
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FormInstanceIdList') is not None:
            self.form_instance_id_list_shrink = m.get('FormInstanceIdList')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class ListFormRemarksResponseBody(TeaModel):
    def __init__(
        self,
        form_remark_vo_map: Dict[str, Any] = None,
        request_id: str = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.form_remark_vo_map = form_remark_vo_map
        self.request_id = request_id
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.form_remark_vo_map is not None:
            result['formRemarkVoMap'] = self.form_remark_vo_map
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('formRemarkVoMap') is not None:
            self.form_remark_vo_map = m.get('formRemarkVoMap')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class ListFormRemarksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListFormRemarksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListFormRemarksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNavigationByFormTypeHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class ListNavigationByFormTypeHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: ListNavigationByFormTypeHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = ListNavigationByFormTypeHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class ListNavigationByFormTypeShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class ListNavigationByFormTypeRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        form_type: str = None,
        language: str = None,
        system_token: str = None,
    ):
        self.app_type = app_type
        self.form_type = form_type
        self.language = language
        self.system_token = system_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.form_type is not None:
            result['FormType'] = self.form_type
        if self.language is not None:
            result['Language'] = self.language
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FormType') is not None:
            self.form_type = m.get('FormType')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        return self


class ListNavigationByFormTypeResponseBodyResultTitle(TeaModel):
    def __init__(
        self,
        name_in_chinese: str = None,
        name_in_english: str = None,
        type: str = None,
    ):
        self.name_in_chinese = name_in_chinese
        self.name_in_english = name_in_english
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_in_chinese is not None:
            result['NameInChinese'] = self.name_in_chinese
        if self.name_in_english is not None:
            result['NameInEnglish'] = self.name_in_english
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameInChinese') is not None:
            self.name_in_chinese = m.get('NameInChinese')
        if m.get('NameInEnglish') is not None:
            self.name_in_english = m.get('NameInEnglish')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListNavigationByFormTypeResponseBodyResult(TeaModel):
    def __init__(
        self,
        form_uuid: str = None,
        process_code: str = None,
        title: ListNavigationByFormTypeResponseBodyResultTitle = None,
    ):
        self.form_uuid = form_uuid
        self.process_code = process_code
        self.title = title

    def validate(self):
        if self.title:
            self.title.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.process_code is not None:
            result['ProcessCode'] = self.process_code
        if self.title is not None:
            result['Title'] = self.title.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('ProcessCode') is not None:
            self.process_code = m.get('ProcessCode')
        if m.get('Title') is not None:
            temp_model = ListNavigationByFormTypeResponseBodyResultTitle()
            self.title = temp_model.from_map(m['Title'])
        return self


class ListNavigationByFormTypeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: List[ListNavigationByFormTypeResponseBodyResult] = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.request_id = request_id
        self.result = result
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = ListNavigationByFormTypeResponseBodyResult()
                self.result.append(temp_model.from_map(k))
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class ListNavigationByFormTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListNavigationByFormTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListNavigationByFormTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNodesHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class ListNodesHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: ListNodesHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = ListNodesHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class ListNodesShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class ListNodesRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class ListNodesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        parent_node_id: str = None,
        tenant_context: ListNodesRequestTenantContext = None,
        with_permission_role: bool = None,
    ):
        self.max_results = max_results
        self.next_token = next_token
        self.parent_node_id = parent_node_id
        self.tenant_context = tenant_context
        self.with_permission_role = with_permission_role

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.parent_node_id is not None:
            result['ParentNodeId'] = self.parent_node_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.with_permission_role is not None:
            result['WithPermissionRole'] = self.with_permission_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ParentNodeId') is not None:
            self.parent_node_id = m.get('ParentNodeId')
        if m.get('TenantContext') is not None:
            temp_model = ListNodesRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WithPermissionRole') is not None:
            self.with_permission_role = m.get('WithPermissionRole')
        return self


class ListNodesShrinkRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        parent_node_id: str = None,
        tenant_context_shrink: str = None,
        with_permission_role: bool = None,
    ):
        self.max_results = max_results
        self.next_token = next_token
        self.parent_node_id = parent_node_id
        self.tenant_context_shrink = tenant_context_shrink
        self.with_permission_role = with_permission_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.parent_node_id is not None:
            result['ParentNodeId'] = self.parent_node_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.with_permission_role is not None:
            result['WithPermissionRole'] = self.with_permission_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ParentNodeId') is not None:
            self.parent_node_id = m.get('ParentNodeId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WithPermissionRole') is not None:
            self.with_permission_role = m.get('WithPermissionRole')
        return self


class ListNodesResponseBodyNodesStatisticalInfo(TeaModel):
    def __init__(
        self,
        word_count: int = None,
    ):
        self.word_count = word_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.word_count is not None:
            result['WordCount'] = self.word_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WordCount') is not None:
            self.word_count = m.get('WordCount')
        return self


class ListNodesResponseBodyNodes(TeaModel):
    def __init__(
        self,
        category: str = None,
        create_time: str = None,
        creator_id: str = None,
        extension: str = None,
        has_children: bool = None,
        modified_time: str = None,
        modifier_id: str = None,
        name: str = None,
        node_id: str = None,
        permission_role: str = None,
        size: int = None,
        statistical_info: ListNodesResponseBodyNodesStatisticalInfo = None,
        type: str = None,
        url: str = None,
        workspace_id: str = None,
    ):
        self.category = category
        self.create_time = create_time
        self.creator_id = creator_id
        self.extension = extension
        self.has_children = has_children
        self.modified_time = modified_time
        self.modifier_id = modifier_id
        self.name = name
        self.node_id = node_id
        self.permission_role = permission_role
        self.size = size
        self.statistical_info = statistical_info
        self.type = type
        self.url = url
        self.workspace_id = workspace_id

    def validate(self):
        if self.statistical_info:
            self.statistical_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.has_children is not None:
            result['HasChildren'] = self.has_children
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.modifier_id is not None:
            result['ModifierId'] = self.modifier_id
        if self.name is not None:
            result['Name'] = self.name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.permission_role is not None:
            result['PermissionRole'] = self.permission_role
        if self.size is not None:
            result['Size'] = self.size
        if self.statistical_info is not None:
            result['StatisticalInfo'] = self.statistical_info.to_map()
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('HasChildren') is not None:
            self.has_children = m.get('HasChildren')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ModifierId') is not None:
            self.modifier_id = m.get('ModifierId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PermissionRole') is not None:
            self.permission_role = m.get('PermissionRole')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StatisticalInfo') is not None:
            temp_model = ListNodesResponseBodyNodesStatisticalInfo()
            self.statistical_info = temp_model.from_map(m['StatisticalInfo'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListNodesResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        nodes: List[ListNodesResponseBodyNodes] = None,
        request_id: str = None,
    ):
        self.next_token = next_token
        self.nodes = nodes
        # requestId
        self.request_id = request_id

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        result['nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['nodes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        self.nodes = []
        if m.get('nodes') is not None:
            for k in m.get('nodes'):
                temp_model = ListNodesResponseBodyNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class ListNodesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListNodesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListNodesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListReportHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class ListReportHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: ListReportHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = ListReportHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class ListReportShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class ListReportRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class ListReportRequest(TeaModel):
    def __init__(
        self,
        cursor: int = None,
        end_time: int = None,
        modified_end_time: int = None,
        modified_start_time: int = None,
        size: int = None,
        start_time: int = None,
        template_name: str = None,
        tenant_context: ListReportRequestTenantContext = None,
    ):
        self.cursor = cursor
        self.end_time = end_time
        self.modified_end_time = modified_end_time
        self.modified_start_time = modified_start_time
        self.size = size
        self.start_time = start_time
        self.template_name = template_name
        self.tenant_context = tenant_context

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cursor is not None:
            result['Cursor'] = self.cursor
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.modified_end_time is not None:
            result['ModifiedEndTime'] = self.modified_end_time
        if self.modified_start_time is not None:
            result['ModifiedStartTime'] = self.modified_start_time
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cursor') is not None:
            self.cursor = m.get('Cursor')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ModifiedEndTime') is not None:
            self.modified_end_time = m.get('ModifiedEndTime')
        if m.get('ModifiedStartTime') is not None:
            self.modified_start_time = m.get('ModifiedStartTime')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TenantContext') is not None:
            temp_model = ListReportRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        return self


class ListReportShrinkRequest(TeaModel):
    def __init__(
        self,
        cursor: int = None,
        end_time: int = None,
        modified_end_time: int = None,
        modified_start_time: int = None,
        size: int = None,
        start_time: int = None,
        template_name: str = None,
        tenant_context_shrink: str = None,
    ):
        self.cursor = cursor
        self.end_time = end_time
        self.modified_end_time = modified_end_time
        self.modified_start_time = modified_start_time
        self.size = size
        self.start_time = start_time
        self.template_name = template_name
        self.tenant_context_shrink = tenant_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cursor is not None:
            result['Cursor'] = self.cursor
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.modified_end_time is not None:
            result['ModifiedEndTime'] = self.modified_end_time
        if self.modified_start_time is not None:
            result['ModifiedStartTime'] = self.modified_start_time
        if self.size is not None:
            result['Size'] = self.size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cursor') is not None:
            self.cursor = m.get('Cursor')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ModifiedEndTime') is not None:
            self.modified_end_time = m.get('ModifiedEndTime')
        if m.get('ModifiedStartTime') is not None:
            self.modified_start_time = m.get('ModifiedStartTime')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        return self


class ListReportResponseBodyDataListContents(TeaModel):
    def __init__(
        self,
        key: str = None,
        sort: str = None,
        type: str = None,
        value: str = None,
    ):
        self.key = key
        self.sort = sort
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListReportResponseBodyDataList(TeaModel):
    def __init__(
        self,
        contents: List[ListReportResponseBodyDataListContents] = None,
        create_time: int = None,
        creator_id: str = None,
        creator_name: str = None,
        dept_name: str = None,
        images: List[str] = None,
        latitude: str = None,
        longitude: str = None,
        modified_time: int = None,
        remark: str = None,
        report_id: str = None,
        template_name: str = None,
    ):
        self.contents = contents
        self.create_time = create_time
        self.creator_id = creator_id
        self.creator_name = creator_name
        self.dept_name = dept_name
        self.images = images
        self.latitude = latitude
        self.longitude = longitude
        self.modified_time = modified_time
        self.remark = remark
        self.report_id = report_id
        self.template_name = template_name

    def validate(self):
        if self.contents:
            for k in self.contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contents'] = []
        if self.contents is not None:
            for k in self.contents:
                result['Contents'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.dept_name is not None:
            result['DeptName'] = self.dept_name
        if self.images is not None:
            result['Images'] = self.images
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.contents = []
        if m.get('Contents') is not None:
            for k in m.get('Contents'):
                temp_model = ListReportResponseBodyDataListContents()
                self.contents.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('DeptName') is not None:
            self.dept_name = m.get('DeptName')
        if m.get('Images') is not None:
            self.images = m.get('Images')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        return self


class ListReportResponseBody(TeaModel):
    def __init__(
        self,
        data_list: List[ListReportResponseBodyDataList] = None,
        has_more: bool = None,
        next_cursor: int = None,
        request_id: str = None,
        size: int = None,
    ):
        self.data_list = data_list
        self.has_more = has_more
        self.next_cursor = next_cursor
        # requestId
        self.request_id = request_id
        self.size = size

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['dataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['dataList'].append(k.to_map() if k else None)
        if self.has_more is not None:
            result['hasMore'] = self.has_more
        if self.next_cursor is not None:
            result['nextCursor'] = self.next_cursor
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.size is not None:
            result['size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('dataList') is not None:
            for k in m.get('dataList'):
                temp_model = ListReportResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('hasMore') is not None:
            self.has_more = m.get('hasMore')
        if m.get('nextCursor') is not None:
            self.next_cursor = m.get('nextCursor')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('size') is not None:
            self.size = m.get('size')
        return self


class ListReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTableDataByFormInstanceIdTableIdHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class ListTableDataByFormInstanceIdTableIdHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: ListTableDataByFormInstanceIdTableIdHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = ListTableDataByFormInstanceIdTableIdHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class ListTableDataByFormInstanceIdTableIdShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class ListTableDataByFormInstanceIdTableIdRequest(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        form_instance_id: str = None,
        form_uuid: str = None,
        page_number: int = None,
        page_size: int = None,
        system_token: str = None,
        table_field_id: str = None,
    ):
        self.app_type = app_type
        self.form_instance_id = form_instance_id
        self.form_uuid = form_uuid
        self.page_number = page_number
        self.page_size = page_size
        self.system_token = system_token
        self.table_field_id = table_field_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.form_instance_id is not None:
            result['FormInstanceId'] = self.form_instance_id
        if self.form_uuid is not None:
            result['FormUuid'] = self.form_uuid
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.system_token is not None:
            result['SystemToken'] = self.system_token
        if self.table_field_id is not None:
            result['TableFieldId'] = self.table_field_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('FormInstanceId') is not None:
            self.form_instance_id = m.get('FormInstanceId')
        if m.get('FormUuid') is not None:
            self.form_uuid = m.get('FormUuid')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SystemToken') is not None:
            self.system_token = m.get('SystemToken')
        if m.get('TableFieldId') is not None:
            self.table_field_id = m.get('TableFieldId')
        return self


class ListTableDataByFormInstanceIdTableIdResponseBody(TeaModel):
    def __init__(
        self,
        data: List[str] = None,
        page_number: int = None,
        request_id: str = None,
        total_count: int = None,
        vendor_request_id: str = None,
        vendor_type: str = None,
    ):
        self.data = data
        self.page_number = page_number
        self.request_id = request_id
        self.total_count = total_count
        self.vendor_request_id = vendor_request_id
        self.vendor_type = vendor_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        if self.vendor_request_id is not None:
            result['vendorRequestId'] = self.vendor_request_id
        if self.vendor_type is not None:
            result['vendorType'] = self.vendor_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        if m.get('vendorRequestId') is not None:
            self.vendor_request_id = m.get('vendorRequestId')
        if m.get('vendorType') is not None:
            self.vendor_type = m.get('vendorType')
        return self


class ListTableDataByFormInstanceIdTableIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListTableDataByFormInstanceIdTableIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTableDataByFormInstanceIdTableIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListWorkspacesHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class ListWorkspacesHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: ListWorkspacesHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = ListWorkspacesHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class ListWorkspacesShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class ListWorkspacesRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class ListWorkspacesRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        order_by: str = None,
        team_id: str = None,
        tenant_context: ListWorkspacesRequestTenantContext = None,
        with_permission_role: bool = None,
    ):
        self.max_results = max_results
        self.next_token = next_token
        self.order_by = order_by
        self.team_id = team_id
        self.tenant_context = tenant_context
        self.with_permission_role = with_permission_role

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.team_id is not None:
            result['TeamId'] = self.team_id
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.with_permission_role is not None:
            result['WithPermissionRole'] = self.with_permission_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('TeamId') is not None:
            self.team_id = m.get('TeamId')
        if m.get('TenantContext') is not None:
            temp_model = ListWorkspacesRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('WithPermissionRole') is not None:
            self.with_permission_role = m.get('WithPermissionRole')
        return self


class ListWorkspacesShrinkRequest(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        order_by: str = None,
        team_id: str = None,
        tenant_context_shrink: str = None,
        with_permission_role: bool = None,
    ):
        self.max_results = max_results
        self.next_token = next_token
        self.order_by = order_by
        self.team_id = team_id
        self.tenant_context_shrink = tenant_context_shrink
        self.with_permission_role = with_permission_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.team_id is not None:
            result['TeamId'] = self.team_id
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.with_permission_role is not None:
            result['WithPermissionRole'] = self.with_permission_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('TeamId') is not None:
            self.team_id = m.get('TeamId')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('WithPermissionRole') is not None:
            self.with_permission_role = m.get('WithPermissionRole')
        return self


class ListWorkspacesResponseBodyWorkspacesIcon(TeaModel):
    def __init__(
        self,
        type: str = None,
        value: str = None,
    ):
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListWorkspacesResponseBodyWorkspaces(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        cover: str = None,
        create_time: str = None,
        creator_id: str = None,
        description: str = None,
        icon: ListWorkspacesResponseBodyWorkspacesIcon = None,
        modified_time: str = None,
        modifier_id: str = None,
        name: str = None,
        permission_role: str = None,
        root_node_id: str = None,
        team_id: str = None,
        type: str = None,
        url: str = None,
        workspace_id: str = None,
    ):
        self.corp_id = corp_id
        self.cover = cover
        self.create_time = create_time
        self.creator_id = creator_id
        self.description = description
        self.icon = icon
        self.modified_time = modified_time
        self.modifier_id = modifier_id
        self.name = name
        self.permission_role = permission_role
        self.root_node_id = root_node_id
        self.team_id = team_id
        self.type = type
        self.url = url
        self.workspace_id = workspace_id

    def validate(self):
        if self.icon:
            self.icon.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.cover is not None:
            result['Cover'] = self.cover
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.description is not None:
            result['Description'] = self.description
        if self.icon is not None:
            result['Icon'] = self.icon.to_map()
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.modifier_id is not None:
            result['ModifierId'] = self.modifier_id
        if self.name is not None:
            result['Name'] = self.name
        if self.permission_role is not None:
            result['PermissionRole'] = self.permission_role
        if self.root_node_id is not None:
            result['RootNodeId'] = self.root_node_id
        if self.team_id is not None:
            result['TeamId'] = self.team_id
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('Cover') is not None:
            self.cover = m.get('Cover')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Icon') is not None:
            temp_model = ListWorkspacesResponseBodyWorkspacesIcon()
            self.icon = temp_model.from_map(m['Icon'])
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ModifierId') is not None:
            self.modifier_id = m.get('ModifierId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PermissionRole') is not None:
            self.permission_role = m.get('PermissionRole')
        if m.get('RootNodeId') is not None:
            self.root_node_id = m.get('RootNodeId')
        if m.get('TeamId') is not None:
            self.team_id = m.get('TeamId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        return self


class ListWorkspacesResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        request_id: str = None,
        workspaces: List[ListWorkspacesResponseBodyWorkspaces] = None,
    ):
        self.next_token = next_token
        # requestId
        self.request_id = request_id
        self.workspaces = workspaces

    def validate(self):
        if self.workspaces:
            for k in self.workspaces:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['workspaces'] = []
        if self.workspaces is not None:
            for k in self.workspaces:
                result['workspaces'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.workspaces = []
        if m.get('workspaces') is not None:
            for k in m.get('workspaces'):
                temp_model = ListWorkspacesResponseBodyWorkspaces()
                self.workspaces.append(temp_model.from_map(k))
        return self


class ListWorkspacesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListWorkspacesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListWorkspacesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PatchEventHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class PatchEventHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: PatchEventHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = PatchEventHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class PatchEventShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class PatchEventRequestAttendees(TeaModel):
    def __init__(
        self,
        id: str = None,
        is_optional: bool = None,
    ):
        self.id = id
        self.is_optional = is_optional

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.is_optional is not None:
            result['isOptional'] = self.is_optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('isOptional') is not None:
            self.is_optional = m.get('isOptional')
        return self


class PatchEventRequestEnd(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['date'] = self.date
        if self.date_time is not None:
            result['dateTime'] = self.date_time
        if self.time_zone is not None:
            result['timeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('dateTime') is not None:
            self.date_time = m.get('dateTime')
        if m.get('timeZone') is not None:
            self.time_zone = m.get('timeZone')
        return self


class PatchEventRequestLocation(TeaModel):
    def __init__(
        self,
        display_name: str = None,
    ):
        self.display_name = display_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['displayName'] = self.display_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('displayName') is not None:
            self.display_name = m.get('displayName')
        return self


class PatchEventRequestRecurrencePattern(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        days_of_week: str = None,
        index: str = None,
        interval: int = None,
        type: str = None,
    ):
        self.day_of_month = day_of_month
        self.days_of_week = days_of_week
        self.index = index
        self.interval = interval
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['dayOfMonth'] = self.day_of_month
        if self.days_of_week is not None:
            result['daysOfWeek'] = self.days_of_week
        if self.index is not None:
            result['index'] = self.index
        if self.interval is not None:
            result['interval'] = self.interval
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dayOfMonth') is not None:
            self.day_of_month = m.get('dayOfMonth')
        if m.get('daysOfWeek') is not None:
            self.days_of_week = m.get('daysOfWeek')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('interval') is not None:
            self.interval = m.get('interval')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class PatchEventRequestRecurrenceRange(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        number_of_occurrences: int = None,
        type: str = None,
    ):
        self.end_date = end_date
        self.number_of_occurrences = number_of_occurrences
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['endDate'] = self.end_date
        if self.number_of_occurrences is not None:
            result['numberOfOccurrences'] = self.number_of_occurrences
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endDate') is not None:
            self.end_date = m.get('endDate')
        if m.get('numberOfOccurrences') is not None:
            self.number_of_occurrences = m.get('numberOfOccurrences')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class PatchEventRequestRecurrence(TeaModel):
    def __init__(
        self,
        pattern: PatchEventRequestRecurrencePattern = None,
        range: PatchEventRequestRecurrenceRange = None,
    ):
        self.pattern = pattern
        self.range = range

    def validate(self):
        if self.pattern:
            self.pattern.validate()
        if self.range:
            self.range.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pattern is not None:
            result['pattern'] = self.pattern.to_map()
        if self.range is not None:
            result['range'] = self.range.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pattern') is not None:
            temp_model = PatchEventRequestRecurrencePattern()
            self.pattern = temp_model.from_map(m['pattern'])
        if m.get('range') is not None:
            temp_model = PatchEventRequestRecurrenceRange()
            self.range = temp_model.from_map(m['range'])
        return self


class PatchEventRequestReminders(TeaModel):
    def __init__(
        self,
        method: str = None,
        minutes: int = None,
    ):
        self.method = method
        self.minutes = minutes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method is not None:
            result['method'] = self.method
        if self.minutes is not None:
            result['minutes'] = self.minutes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('method') is not None:
            self.method = m.get('method')
        if m.get('minutes') is not None:
            self.minutes = m.get('minutes')
        return self


class PatchEventRequestStart(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['date'] = self.date
        if self.date_time is not None:
            result['dateTime'] = self.date_time
        if self.time_zone is not None:
            result['timeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('dateTime') is not None:
            self.date_time = m.get('dateTime')
        if m.get('timeZone') is not None:
            self.time_zone = m.get('timeZone')
        return self


class PatchEventRequest(TeaModel):
    def __init__(
        self,
        attendees: List[PatchEventRequestAttendees] = None,
        calendar_id: str = None,
        description: str = None,
        end: PatchEventRequestEnd = None,
        event_id: str = None,
        extra: Dict[str, str] = None,
        is_all_day: bool = None,
        location: PatchEventRequestLocation = None,
        recurrence: PatchEventRequestRecurrence = None,
        reminders: List[PatchEventRequestReminders] = None,
        start: PatchEventRequestStart = None,
        summary: str = None,
    ):
        self.attendees = attendees
        self.calendar_id = calendar_id
        self.description = description
        self.end = end
        self.event_id = event_id
        self.extra = extra
        self.is_all_day = is_all_day
        self.location = location
        self.recurrence = recurrence
        self.reminders = reminders
        self.start = start
        self.summary = summary

    def validate(self):
        if self.attendees:
            for k in self.attendees:
                if k:
                    k.validate()
        if self.end:
            self.end.validate()
        if self.location:
            self.location.validate()
        if self.recurrence:
            self.recurrence.validate()
        if self.reminders:
            for k in self.reminders:
                if k:
                    k.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attendees'] = []
        if self.attendees is not None:
            for k in self.attendees:
                result['Attendees'].append(k.to_map() if k else None)
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        if self.description is not None:
            result['Description'] = self.description
        if self.end is not None:
            result['End'] = self.end.to_map()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.is_all_day is not None:
            result['IsAllDay'] = self.is_all_day
        if self.location is not None:
            result['Location'] = self.location.to_map()
        if self.recurrence is not None:
            result['Recurrence'] = self.recurrence.to_map()
        result['Reminders'] = []
        if self.reminders is not None:
            for k in self.reminders:
                result['Reminders'].append(k.to_map() if k else None)
        if self.start is not None:
            result['Start'] = self.start.to_map()
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attendees = []
        if m.get('Attendees') is not None:
            for k in m.get('Attendees'):
                temp_model = PatchEventRequestAttendees()
                self.attendees.append(temp_model.from_map(k))
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('End') is not None:
            temp_model = PatchEventRequestEnd()
            self.end = temp_model.from_map(m['End'])
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('IsAllDay') is not None:
            self.is_all_day = m.get('IsAllDay')
        if m.get('Location') is not None:
            temp_model = PatchEventRequestLocation()
            self.location = temp_model.from_map(m['Location'])
        if m.get('Recurrence') is not None:
            temp_model = PatchEventRequestRecurrence()
            self.recurrence = temp_model.from_map(m['Recurrence'])
        self.reminders = []
        if m.get('Reminders') is not None:
            for k in m.get('Reminders'):
                temp_model = PatchEventRequestReminders()
                self.reminders.append(temp_model.from_map(k))
        if m.get('Start') is not None:
            temp_model = PatchEventRequestStart()
            self.start = temp_model.from_map(m['Start'])
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class PatchEventShrinkRequest(TeaModel):
    def __init__(
        self,
        attendees_shrink: str = None,
        calendar_id: str = None,
        description: str = None,
        end_shrink: str = None,
        event_id: str = None,
        extra_shrink: str = None,
        is_all_day: bool = None,
        location_shrink: str = None,
        recurrence_shrink: str = None,
        reminders_shrink: str = None,
        start_shrink: str = None,
        summary: str = None,
    ):
        self.attendees_shrink = attendees_shrink
        self.calendar_id = calendar_id
        self.description = description
        self.end_shrink = end_shrink
        self.event_id = event_id
        self.extra_shrink = extra_shrink
        self.is_all_day = is_all_day
        self.location_shrink = location_shrink
        self.recurrence_shrink = recurrence_shrink
        self.reminders_shrink = reminders_shrink
        self.start_shrink = start_shrink
        self.summary = summary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attendees_shrink is not None:
            result['Attendees'] = self.attendees_shrink
        if self.calendar_id is not None:
            result['CalendarId'] = self.calendar_id
        if self.description is not None:
            result['Description'] = self.description
        if self.end_shrink is not None:
            result['End'] = self.end_shrink
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.extra_shrink is not None:
            result['Extra'] = self.extra_shrink
        if self.is_all_day is not None:
            result['IsAllDay'] = self.is_all_day
        if self.location_shrink is not None:
            result['Location'] = self.location_shrink
        if self.recurrence_shrink is not None:
            result['Recurrence'] = self.recurrence_shrink
        if self.reminders_shrink is not None:
            result['Reminders'] = self.reminders_shrink
        if self.start_shrink is not None:
            result['Start'] = self.start_shrink
        if self.summary is not None:
            result['Summary'] = self.summary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Attendees') is not None:
            self.attendees_shrink = m.get('Attendees')
        if m.get('CalendarId') is not None:
            self.calendar_id = m.get('CalendarId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('End') is not None:
            self.end_shrink = m.get('End')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Extra') is not None:
            self.extra_shrink = m.get('Extra')
        if m.get('IsAllDay') is not None:
            self.is_all_day = m.get('IsAllDay')
        if m.get('Location') is not None:
            self.location_shrink = m.get('Location')
        if m.get('Recurrence') is not None:
            self.recurrence_shrink = m.get('Recurrence')
        if m.get('Reminders') is not None:
            self.reminders_shrink = m.get('Reminders')
        if m.get('Start') is not None:
            self.start_shrink = m.get('Start')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        return self


class PatchEventResponseBodyAttendees(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        id: str = None,
        is_optional: bool = None,
        response_status: str = None,
        self_: bool = None,
    ):
        self.display_name = display_name
        self.id = id
        self.is_optional = is_optional
        self.response_status = response_status
        self.self_ = self_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.id is not None:
            result['Id'] = self.id
        if self.is_optional is not None:
            result['IsOptional'] = self.is_optional
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.self_ is not None:
            result['Self'] = self.self_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsOptional') is not None:
            self.is_optional = m.get('IsOptional')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('Self') is not None:
            self.self_ = m.get('Self')
        return self


class PatchEventResponseBodyEnd(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class PatchEventResponseBodyLocation(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        meeting_rooms: List[str] = None,
    ):
        self.display_name = display_name
        self.meeting_rooms = meeting_rooms

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.meeting_rooms is not None:
            result['MeetingRooms'] = self.meeting_rooms
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('MeetingRooms') is not None:
            self.meeting_rooms = m.get('MeetingRooms')
        return self


class PatchEventResponseBodyOrganizer(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        id: str = None,
        response_status: str = None,
        self_: bool = None,
    ):
        self.display_name = display_name
        self.id = id
        self.response_status = response_status
        self.self_ = self_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.id is not None:
            result['Id'] = self.id
        if self.response_status is not None:
            result['ResponseStatus'] = self.response_status
        if self.self_ is not None:
            result['Self'] = self.self_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ResponseStatus') is not None:
            self.response_status = m.get('ResponseStatus')
        if m.get('Self') is not None:
            self.self_ = m.get('Self')
        return self


class PatchEventResponseBodyRecurrencePattern(TeaModel):
    def __init__(
        self,
        day_of_month: int = None,
        days_of_week: str = None,
        index: str = None,
        interval: int = None,
        type: str = None,
    ):
        self.day_of_month = day_of_month
        self.days_of_week = days_of_week
        self.index = index
        self.interval = interval
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.day_of_month is not None:
            result['DayOfMonth'] = self.day_of_month
        if self.days_of_week is not None:
            result['DaysOfWeek'] = self.days_of_week
        if self.index is not None:
            result['Index'] = self.index
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DayOfMonth') is not None:
            self.day_of_month = m.get('DayOfMonth')
        if m.get('DaysOfWeek') is not None:
            self.days_of_week = m.get('DaysOfWeek')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class PatchEventResponseBodyRecurrenceRange(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        number_of_occurrences: int = None,
        type: str = None,
    ):
        self.end_date = end_date
        self.number_of_occurrences = number_of_occurrences
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.number_of_occurrences is not None:
            result['NumberOfOccurrences'] = self.number_of_occurrences
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('NumberOfOccurrences') is not None:
            self.number_of_occurrences = m.get('NumberOfOccurrences')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class PatchEventResponseBodyRecurrence(TeaModel):
    def __init__(
        self,
        pattern: PatchEventResponseBodyRecurrencePattern = None,
        range: PatchEventResponseBodyRecurrenceRange = None,
    ):
        self.pattern = pattern
        self.range = range

    def validate(self):
        if self.pattern:
            self.pattern.validate()
        if self.range:
            self.range.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pattern is not None:
            result['Pattern'] = self.pattern.to_map()
        if self.range is not None:
            result['Range'] = self.range.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pattern') is not None:
            temp_model = PatchEventResponseBodyRecurrencePattern()
            self.pattern = temp_model.from_map(m['Pattern'])
        if m.get('Range') is not None:
            temp_model = PatchEventResponseBodyRecurrenceRange()
            self.range = temp_model.from_map(m['Range'])
        return self


class PatchEventResponseBodyReminders(TeaModel):
    def __init__(
        self,
        method: str = None,
        minutes: str = None,
    ):
        self.method = method
        self.minutes = minutes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method is not None:
            result['Method'] = self.method
        if self.minutes is not None:
            result['Minutes'] = self.minutes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Minutes') is not None:
            self.minutes = m.get('Minutes')
        return self


class PatchEventResponseBodyStart(TeaModel):
    def __init__(
        self,
        date: str = None,
        date_time: str = None,
        time_zone: str = None,
    ):
        self.date = date
        self.date_time = date_time
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class PatchEventResponseBody(TeaModel):
    def __init__(
        self,
        attendees: List[PatchEventResponseBodyAttendees] = None,
        create_time: str = None,
        description: str = None,
        end: PatchEventResponseBodyEnd = None,
        id: str = None,
        is_all_day: bool = None,
        location: PatchEventResponseBodyLocation = None,
        organizer: PatchEventResponseBodyOrganizer = None,
        recurrence: PatchEventResponseBodyRecurrence = None,
        reminders: List[PatchEventResponseBodyReminders] = None,
        request_id: str = None,
        start: PatchEventResponseBodyStart = None,
        summary: str = None,
        update_time: str = None,
    ):
        self.attendees = attendees
        self.create_time = create_time
        self.description = description
        self.end = end
        self.id = id
        self.is_all_day = is_all_day
        self.location = location
        self.organizer = organizer
        self.recurrence = recurrence
        self.reminders = reminders
        # requestId
        self.request_id = request_id
        self.start = start
        self.summary = summary
        self.update_time = update_time

    def validate(self):
        if self.attendees:
            for k in self.attendees:
                if k:
                    k.validate()
        if self.end:
            self.end.validate()
        if self.location:
            self.location.validate()
        if self.organizer:
            self.organizer.validate()
        if self.recurrence:
            self.recurrence.validate()
        if self.reminders:
            for k in self.reminders:
                if k:
                    k.validate()
        if self.start:
            self.start.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['attendees'] = []
        if self.attendees is not None:
            for k in self.attendees:
                result['attendees'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.description is not None:
            result['description'] = self.description
        if self.end is not None:
            result['end'] = self.end.to_map()
        if self.id is not None:
            result['id'] = self.id
        if self.is_all_day is not None:
            result['isAllDay'] = self.is_all_day
        if self.location is not None:
            result['location'] = self.location.to_map()
        if self.organizer is not None:
            result['organizer'] = self.organizer.to_map()
        if self.recurrence is not None:
            result['recurrence'] = self.recurrence.to_map()
        result['reminders'] = []
        if self.reminders is not None:
            for k in self.reminders:
                result['reminders'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.start is not None:
            result['start'] = self.start.to_map()
        if self.summary is not None:
            result['summary'] = self.summary
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attendees = []
        if m.get('attendees') is not None:
            for k in m.get('attendees'):
                temp_model = PatchEventResponseBodyAttendees()
                self.attendees.append(temp_model.from_map(k))
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('end') is not None:
            temp_model = PatchEventResponseBodyEnd()
            self.end = temp_model.from_map(m['end'])
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('isAllDay') is not None:
            self.is_all_day = m.get('isAllDay')
        if m.get('location') is not None:
            temp_model = PatchEventResponseBodyLocation()
            self.location = temp_model.from_map(m['location'])
        if m.get('organizer') is not None:
            temp_model = PatchEventResponseBodyOrganizer()
            self.organizer = temp_model.from_map(m['organizer'])
        if m.get('recurrence') is not None:
            temp_model = PatchEventResponseBodyRecurrence()
            self.recurrence = temp_model.from_map(m['recurrence'])
        self.reminders = []
        if m.get('reminders') is not None:
            for k in m.get('reminders'):
                temp_model = PatchEventResponseBodyReminders()
                self.reminders.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('start') is not None:
            temp_model = PatchEventResponseBodyStart()
            self.start = temp_model.from_map(m['start'])
        if m.get('summary') is not None:
            self.summary = m.get('summary')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class PatchEventResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: PatchEventResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = PatchEventResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCloudRecordTextHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class QueryCloudRecordTextHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: QueryCloudRecordTextHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = QueryCloudRecordTextHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class QueryCloudRecordTextShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class QueryCloudRecordTextRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class QueryCloudRecordTextRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        max_results: int = None,
        next_token: int = None,
        start_time: int = None,
        tenant_context: QueryCloudRecordTextRequestTenantContext = None,
        conference_id: str = None,
    ):
        self.direction = direction
        self.max_results = max_results
        self.next_token = next_token
        self.start_time = start_time
        self.tenant_context = tenant_context
        self.conference_id = conference_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.conference_id is not None:
            result['conferenceId'] = self.conference_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantContext') is not None:
            temp_model = QueryCloudRecordTextRequestTenantContext()
            self.tenant_context = temp_model.from_map(m['TenantContext'])
        if m.get('conferenceId') is not None:
            self.conference_id = m.get('conferenceId')
        return self


class QueryCloudRecordTextShrinkRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        max_results: int = None,
        next_token: int = None,
        start_time: int = None,
        tenant_context_shrink: str = None,
        conference_id: str = None,
    ):
        self.direction = direction
        self.max_results = max_results
        self.next_token = next_token
        self.start_time = start_time
        self.tenant_context_shrink = tenant_context_shrink
        self.conference_id = conference_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_context_shrink is not None:
            result['TenantContext'] = self.tenant_context_shrink
        if self.conference_id is not None:
            result['conferenceId'] = self.conference_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantContext') is not None:
            self.tenant_context_shrink = m.get('TenantContext')
        if m.get('conferenceId') is not None:
            self.conference_id = m.get('conferenceId')
        return self


class QueryCloudRecordTextResponseBodyParagraphListSentenceListWordList(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        start_time: int = None,
        word: str = None,
        word_id: str = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.word = word
        self.word_id = word_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.word is not None:
            result['Word'] = self.word
        if self.word_id is not None:
            result['WordId'] = self.word_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Word') is not None:
            self.word = m.get('Word')
        if m.get('WordId') is not None:
            self.word_id = m.get('WordId')
        return self


class QueryCloudRecordTextResponseBodyParagraphListSentenceList(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        sentence: str = None,
        start_time: int = None,
        user_id: str = None,
        word_list: List[QueryCloudRecordTextResponseBodyParagraphListSentenceListWordList] = None,
    ):
        self.end_time = end_time
        self.sentence = sentence
        self.start_time = start_time
        self.user_id = user_id
        self.word_list = word_list

    def validate(self):
        if self.word_list:
            for k in self.word_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.sentence is not None:
            result['Sentence'] = self.sentence
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        result['WordList'] = []
        if self.word_list is not None:
            for k in self.word_list:
                result['WordList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Sentence') is not None:
            self.sentence = m.get('Sentence')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        self.word_list = []
        if m.get('WordList') is not None:
            for k in m.get('WordList'):
                temp_model = QueryCloudRecordTextResponseBodyParagraphListSentenceListWordList()
                self.word_list.append(temp_model.from_map(k))
        return self


class QueryCloudRecordTextResponseBodyParagraphList(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        next_ttoken: int = None,
        nick_name: str = None,
        paragraph: str = None,
        record_id: int = None,
        sentence_list: List[QueryCloudRecordTextResponseBodyParagraphListSentenceList] = None,
        start_time: int = None,
        status: int = None,
        user_id: str = None,
    ):
        self.end_time = end_time
        self.next_ttoken = next_ttoken
        self.nick_name = nick_name
        self.paragraph = paragraph
        self.record_id = record_id
        self.sentence_list = sentence_list
        self.start_time = start_time
        self.status = status
        self.user_id = user_id

    def validate(self):
        if self.sentence_list:
            for k in self.sentence_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.next_ttoken is not None:
            result['NextTtoken'] = self.next_ttoken
        if self.nick_name is not None:
            result['NickName'] = self.nick_name
        if self.paragraph is not None:
            result['Paragraph'] = self.paragraph
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        result['SentenceList'] = []
        if self.sentence_list is not None:
            for k in self.sentence_list:
                result['SentenceList'].append(k.to_map() if k else None)
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NextTtoken') is not None:
            self.next_ttoken = m.get('NextTtoken')
        if m.get('NickName') is not None:
            self.nick_name = m.get('NickName')
        if m.get('Paragraph') is not None:
            self.paragraph = m.get('Paragraph')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        self.sentence_list = []
        if m.get('SentenceList') is not None:
            for k in m.get('SentenceList'):
                temp_model = QueryCloudRecordTextResponseBodyParagraphListSentenceList()
                self.sentence_list.append(temp_model.from_map(k))
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class QueryCloudRecordTextResponseBody(TeaModel):
    def __init__(
        self,
        has_more: bool = None,
        paragraph_list: List[QueryCloudRecordTextResponseBodyParagraphList] = None,
        request_id: str = None,
    ):
        self.has_more = has_more
        self.paragraph_list = paragraph_list
        # requestId
        self.request_id = request_id

    def validate(self):
        if self.paragraph_list:
            for k in self.paragraph_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.has_more is not None:
            result['hasMore'] = self.has_more
        result['paragraphList'] = []
        if self.paragraph_list is not None:
            for k in self.paragraph_list:
                result['paragraphList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hasMore') is not None:
            self.has_more = m.get('hasMore')
        self.paragraph_list = []
        if m.get('paragraphList') is not None:
            for k in m.get('paragraphList'):
                temp_model = QueryCloudRecordTextResponseBodyParagraphList()
                self.paragraph_list.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class QueryCloudRecordTextResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryCloudRecordTextResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryCloudRecordTextResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCloudRecordVideoHeadersAccountContext(TeaModel):
    def __init__(
        self,
        account_id: str = None,
    ):
        self.account_id = account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        return self


class QueryCloudRecordVideoHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context: QueryCloudRecordVideoHeadersAccountContext = None,
    ):
        self.common_headers = common_headers
        self.account_context = account_context

    def validate(self):
        if self.account_context:
            self.account_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context is not None:
            result['AccountContext'] = self.account_context.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            temp_model = QueryCloudRecordVideoHeadersAccountContext()
            self.account_context = temp_model.from_map(m['AccountContext'])
        return self


class QueryCloudRecordVideoShrinkHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        account_context_shrink: str = None,
    ):
        self.common_headers = common_headers
        self.account_context_shrink = account_context_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.account_context_shrink is not None:
            result['AccountContext'] = self.account_context_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('AccountContext') is not None:
            self.account_context_shrink = m.get('AccountContext')
        return self


class QueryCloudRecordVideoRequestTenantContext(TeaModel):
    def __init__(
        self,
        tenant_id: str = None,
    ):
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['tenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tenantId') is not None:
            self.tenant_id = m.get('tenantId')
        return self


class QueryCloudRecordVideoRequest(TeaModel):
    def __init__(
        self,
        tenant_context: QueryCloudRecordVideoRequestTenantContext = None,
        conference_id: str = None,
    ):
        self.tenant_context = tenant_context
        self.conference_id = conference_id

    def validate(self):
        if self.tenant_context:
            self.tenant_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_context is not None:
            result['TenantContext'] = self.tenant_context.to_map()
        if self.conference_id is not None:
            result['conferenceId'] = self.conference