import numpy as np

CHIP_BITMAP_CHIP_BY_CHIP = np.array(
    [1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288,
     1048576, 2097152, 4194304, 8388608, 16777216, 33554432, 67108864, 134217728, 268435456, 536870912,
     4294967296, 8589934592, 17179869184, 34359738368, 68719476736, 137438953472, 274877906944,
     549755813888, 1099511627776, 2199023255552, 4398046511104, 8796093022208, 17592186044416, 35184372088832,
     70368744177664, 140737488355328, 281474976710656, 562949953421312, 1125899906842624, 2251799813685248,
     4503599627370496, 9007199254740992, 18014398509481984, 36028797018963968, 72057594037927936, 144115188075855872,
     288230376151711744, 576460752303423488, 1152921504606846976, 2305843009213693952], dtype=np.uint64)


def convert(chip_bitmap: int, incr: int) -> (np.ndarray, np.ndarray):
    """
    Convert chip_bitmap to the corresponding bitmap array, and position array
    :param chip_bitmap: bitmap of the selected chip
    :param incr: size of the data we expect, 5 for chip register and 480 for pixel_register
    :return: bitmap array / position array
    """
    number_of_chips: int = len(CHIP_BITMAP_CHIP_BY_CHIP)
    binary_list = [int(c) for c in bin(chip_bitmap)[2:]]
    binary_list = np.flip(binary_list) > 0

    if len(binary_list) < number_of_chips:
        app = np.full((number_of_chips - len(binary_list),), False)
        binary_list = np.append(binary_list, app)

    out_list = CHIP_BITMAP_CHIP_BY_CHIP[binary_list]
    pos_list = np.uint64(np.log2(out_list))
    incr_arr = np.multiply(pos_list, incr, dtype=np.uint32)

    return out_list, incr_arr


