import click

from ..decorators import require_bins, require_login
from . import GlobalOptions
from .sym import sym


@sym.command(hidden=True, short_help="New SSM Session")
@click.argument("resource")
@click.option(
    "--target", help="target instance id", metavar="<instance-id>", required=True
)
@click.make_pass_decorator(GlobalOptions)
@require_bins("aws", "session-manager-plugin")
@require_login
def ssm(options: GlobalOptions, resource: str, target: str) -> None:
    """Use approved creds for RESOURCE to start an SSM session to an EC2 instance"""
    options.create_saml_client(resource).exec(
        "aws", "ssm", "start-session", target=target
    )
