"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnSlo = exports.ThresholdTimeframe = exports.CfnSloPropsType = exports.toJson_Threshold = exports.toJson_Query = exports.toJson_Creator = exports.toJson_CfnSloProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnSloProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnSloProps(obj) {
    var _b, _c, _d, _e;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Creator': toJson_Creator(obj.creator),
        'Description': obj.description,
        'Groups': (_b = obj.groups) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'MonitorIds': (_c = obj.monitorIds) === null || _c === void 0 ? void 0 : _c.map(y => y),
        'Name': obj.name,
        'Query': toJson_Query(obj.query),
        'Tags': (_d = obj.tags) === null || _d === void 0 ? void 0 : _d.map(y => y),
        'Thresholds': (_e = obj.thresholds) === null || _e === void 0 ? void 0 : _e.map(y => toJson_Threshold(y)),
        'Type': obj.type,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnSloProps = toJson_CfnSloProps;
/**
 * Converts an object of type 'Creator' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Creator(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Handle': obj.handle,
        'Email': obj.email,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Creator = toJson_Creator;
/**
 * Converts an object of type 'Query' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Query(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Numerator': obj.numerator,
        'Denominator': obj.denominator,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Query = toJson_Query;
/**
 * Converts an object of type 'Threshold' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Threshold(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Target': obj.target,
        'TargetDisplay': obj.targetDisplay,
        'Timeframe': obj.timeframe,
        'Warning': obj.warning,
        'WarningDisplay': obj.warningDisplay,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Threshold = toJson_Threshold;
/* eslint-enable max-len, quote-props */
/**
 * The type of the slo
 *
 * @schema CfnSloPropsType
 */
var CfnSloPropsType;
(function (CfnSloPropsType) {
    /** monitor */
    CfnSloPropsType["MONITOR"] = "monitor";
    /** metric */
    CfnSloPropsType["METRIC"] = "metric";
})(CfnSloPropsType = exports.CfnSloPropsType || (exports.CfnSloPropsType = {}));
/**
 * The SLO time window options. Allowed enum values: 7d,30d,90d
 *
 * @schema ThresholdTimeframe
 */
var ThresholdTimeframe;
(function (ThresholdTimeframe) {
    /** 7d */
    ThresholdTimeframe["VALUE_7D"] = "7d";
    /** 30d */
    ThresholdTimeframe["VALUE_30D"] = "30d";
    /** 90d */
    ThresholdTimeframe["VALUE_90D"] = "90d";
})(ThresholdTimeframe = exports.ThresholdTimeframe || (exports.ThresholdTimeframe = {}));
/**
 * A CloudFormation `Datadog::SLOs::SLO`
 *
 * @cloudformationResource Datadog::SLOs::SLO
 * @stability external
 * @link http://unknown-url
 */
class CfnSlo extends cdk.CfnResource {
    /**
     * Create a new `Datadog::SLOs::SLO`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnSlo.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnSloProps(props) });
        this.props = props;
        this.attrModified = cdk.Token.asString(this.getAtt('Modified'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrDeleted = cdk.Token.asString(this.getAtt('Deleted'));
        this.attrCreated = cdk.Token.asString(this.getAtt('Created'));
    }
}
exports.CfnSlo = CfnSlo;
_a = JSII_RTTI_SYMBOL_1;
CfnSlo[_a] = { fqn: "@cdk-cloudformation/datadog-slos-slo.CfnSlo", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnSlo.CFN_RESOURCE_TYPE_NAME = "Datadog::SLOs::SLO";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwwQkFBMEI7QUFDMUIsbUNBQW1DO0FBb0VuQzs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQixrQkFBa0IsQ0FBQyxHQUE0Qjs7SUFDN0QsSUFBSSxHQUFHLEtBQUssU0FBUyxFQUFFO1FBQUUsT0FBTyxTQUFTLENBQUM7S0FBRTtJQUM1QyxNQUFNLE1BQU0sR0FBRztRQUNiLFNBQVMsRUFBRSxjQUFjLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQztRQUN0QyxhQUFhLEVBQUUsR0FBRyxDQUFDLFdBQVc7UUFDOUIsUUFBUSxRQUFFLEdBQUcsQ0FBQyxNQUFNLDBDQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztRQUNqQyxZQUFZLFFBQUUsR0FBRyxDQUFDLFVBQVUsMENBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBQ3pDLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixPQUFPLEVBQUUsWUFBWSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUM7UUFDaEMsTUFBTSxRQUFFLEdBQUcsQ0FBQyxJQUFJLDBDQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztRQUM3QixZQUFZLFFBQUUsR0FBRyxDQUFDLFVBQVUsMENBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDM0QsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO0tBQ2pCLENBQUM7SUFDRiwwQkFBMEI7SUFDMUIsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDMUcsQ0FBQztBQWZELGdEQWVDO0FBOEJEOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLGNBQWMsQ0FBQyxHQUF3QjtJQUNyRCxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFFBQVEsRUFBRSxHQUFHLENBQUMsTUFBTTtRQUNwQixPQUFPLEVBQUUsR0FBRyxDQUFDLEtBQUs7S0FDbkIsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBVEQsd0NBU0M7QUF1QkQ7O0dBRUc7QUFDSCx5Q0FBeUM7QUFDekMsU0FBZ0IsWUFBWSxDQUFDLEdBQXNCO0lBQ2pELElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixXQUFXLEVBQUUsR0FBRyxDQUFDLFNBQVM7UUFDMUIsYUFBYSxFQUFFLEdBQUcsQ0FBQyxXQUFXO0tBQy9CLENBQUM7SUFDRiwwQkFBMEI7SUFDMUIsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDMUcsQ0FBQztBQVJELG9DQVFDO0FBNENEOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLGdCQUFnQixDQUFDLEdBQTBCO0lBQ3pELElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixRQUFRLEVBQUUsR0FBRyxDQUFDLE1BQU07UUFDcEIsZUFBZSxFQUFFLEdBQUcsQ0FBQyxhQUFhO1FBQ2xDLFdBQVcsRUFBRSxHQUFHLENBQUMsU0FBUztRQUMxQixTQUFTLEVBQUUsR0FBRyxDQUFDLE9BQU87UUFDdEIsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWM7S0FDckMsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBWEQsNENBV0M7QUFDRCx3Q0FBd0M7QUFFeEM7Ozs7R0FJRztBQUNILElBQVksZUFLWDtBQUxELFdBQVksZUFBZTtJQUN6QixjQUFjO0lBQ2Qsc0NBQW1CLENBQUE7SUFDbkIsYUFBYTtJQUNiLG9DQUFpQixDQUFBO0FBQ25CLENBQUMsRUFMVyxlQUFlLEdBQWYsdUJBQWUsS0FBZix1QkFBZSxRQUsxQjtBQUVEOzs7O0dBSUc7QUFDSCxJQUFZLGtCQU9YO0FBUEQsV0FBWSxrQkFBa0I7SUFDNUIsU0FBUztJQUNULHFDQUFlLENBQUE7SUFDZixVQUFVO0lBQ1YsdUNBQWlCLENBQUE7SUFDakIsVUFBVTtJQUNWLHVDQUFpQixDQUFBO0FBQ25CLENBQUMsRUFQVyxrQkFBa0IsR0FBbEIsMEJBQWtCLEtBQWxCLDBCQUFrQixRQU83QjtBQUdEOzs7Ozs7R0FNRztBQUNILE1BQWEsTUFBTyxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBZ0N6Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQTJCLEVBQUUsRUFBVSxFQUFFLEtBQWtCO1FBQ3JFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLE1BQU0sQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsa0JBQWtCLENBQUMsS0FBSyxDQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWxHLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBRW5CLElBQUksQ0FBQyxZQUFZLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO1FBQ2hFLElBQUksQ0FBQyxNQUFNLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO1FBQ3BELElBQUksQ0FBQyxXQUFXLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO1FBQzlELElBQUksQ0FBQyxXQUFXLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQ2hFLENBQUM7O0FBaERILHdCQWlEQzs7O0FBaERDOztFQUVFO0FBQ3FCLDZCQUFzQixHQUFHLG9CQUFvQixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gR2VuZXJhdGVkIGJ5IGNkay1pbXBvcnRcbmltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgKiBhcyBjb25zdHJ1Y3RzIGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIERhdGFkb2cgU0xPIDEuMC4wXG4gKlxuICogQHNjaGVtYSBDZm5TbG9Qcm9wc1xuICovXG5leHBvcnQgaW50ZXJmYWNlIENmblNsb1Byb3BzIHtcbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuU2xvUHJvcHMjQ3JlYXRvclxuICAgKi9cbiAgcmVhZG9ubHkgY3JlYXRvcj86IENyZWF0b3I7XG5cbiAgLyoqXG4gICAqIERlc2NyaXB0aW9uIG9mIHRoZSBzbG9cbiAgICpcbiAgICogQHNjaGVtYSBDZm5TbG9Qcm9wcyNEZXNjcmlwdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEEgbGlzdCBvZiAodXAgdG8gMjApIG1vbml0b3IgZ3JvdXBzIHRoYXQgbmFycm93IHRoZSBzY29wZSBvZiBhIG1vbml0b3Igc2VydmljZSBsZXZlbCBvYmplY3RpdmUuXG4gICAqXG4gICAqIEBzY2hlbWEgQ2ZuU2xvUHJvcHMjR3JvdXBzXG4gICAqL1xuICByZWFkb25seSBncm91cHM/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogQSBsaXN0IG9mIG1vbml0b3IgaWRzIHRoYXQgZGVmaW5lcyB0aGUgc2NvcGUgb2YgYSBtb25pdG9yIHNlcnZpY2UgbGV2ZWwgb2JqZWN0aXZlLiBSZXF1aXJlZCBpZiB0eXBlIGlzIG1vbml0b3IuXG4gICAqXG4gICAqIEBzY2hlbWEgQ2ZuU2xvUHJvcHMjTW9uaXRvcklkc1xuICAgKi9cbiAgcmVhZG9ubHkgbW9uaXRvcklkcz86IG51bWJlcltdO1xuXG4gIC8qKlxuICAgKiBOYW1lIG9mIHRoZSBzbG9cbiAgICpcbiAgICogQHNjaGVtYSBDZm5TbG9Qcm9wcyNOYW1lXG4gICAqL1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuU2xvUHJvcHMjUXVlcnlcbiAgICovXG4gIHJlYWRvbmx5IHF1ZXJ5PzogUXVlcnk7XG5cbiAgLyoqXG4gICAqIFRhZ3MgYXNzb2NpYXRlZCB3aXRoIHRoZSBzbG9cbiAgICpcbiAgICogQHNjaGVtYSBDZm5TbG9Qcm9wcyNUYWdzXG4gICAqL1xuICByZWFkb25seSB0YWdzPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuU2xvUHJvcHMjVGhyZXNob2xkc1xuICAgKi9cbiAgcmVhZG9ubHkgdGhyZXNob2xkczogVGhyZXNob2xkW107XG5cbiAgLyoqXG4gICAqIFRoZSB0eXBlIG9mIHRoZSBzbG9cbiAgICpcbiAgICogQHNjaGVtYSBDZm5TbG9Qcm9wcyNUeXBlXG4gICAqL1xuICByZWFkb25seSB0eXBlOiBDZm5TbG9Qcm9wc1R5cGU7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnQ2ZuU2xvUHJvcHMnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX0NmblNsb1Byb3BzKG9iajogQ2ZuU2xvUHJvcHMgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdDcmVhdG9yJzogdG9Kc29uX0NyZWF0b3Iob2JqLmNyZWF0b3IpLFxuICAgICdEZXNjcmlwdGlvbic6IG9iai5kZXNjcmlwdGlvbixcbiAgICAnR3JvdXBzJzogb2JqLmdyb3Vwcz8ubWFwKHkgPT4geSksXG4gICAgJ01vbml0b3JJZHMnOiBvYmoubW9uaXRvcklkcz8ubWFwKHkgPT4geSksXG4gICAgJ05hbWUnOiBvYmoubmFtZSxcbiAgICAnUXVlcnknOiB0b0pzb25fUXVlcnkob2JqLnF1ZXJ5KSxcbiAgICAnVGFncyc6IG9iai50YWdzPy5tYXAoeSA9PiB5KSxcbiAgICAnVGhyZXNob2xkcyc6IG9iai50aHJlc2hvbGRzPy5tYXAoeSA9PiB0b0pzb25fVGhyZXNob2xkKHkpKSxcbiAgICAnVHlwZSc6IG9iai50eXBlLFxuICB9O1xuICAvLyBmaWx0ZXIgdW5kZWZpbmVkIHZhbHVlc1xuICByZXR1cm4gT2JqZWN0LmVudHJpZXMocmVzdWx0KS5yZWR1Y2UoKHIsIGkpID0+IChpWzFdID09PSB1bmRlZmluZWQpID8gciA6ICh7IC4uLnIsIFtpWzBdXTogaVsxXSB9KSwge30pO1xufVxuLyogZXNsaW50LWVuYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuXG4vKipcbiAqIEBzY2hlbWEgQ3JlYXRvclxuICovXG5leHBvcnQgaW50ZXJmYWNlIENyZWF0b3Ige1xuICAvKipcbiAgICogTmFtZSBvZiB0aGUgY3JlYXRvciBvZiB0aGUgc2xvXG4gICAqXG4gICAqIEBzY2hlbWEgQ3JlYXRvciNOYW1lXG4gICAqL1xuICByZWFkb25seSBuYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBIYW5kbGUgb2YgdGhlIGNyZWF0b3Igb2YgdGhlIHNsb1xuICAgKlxuICAgKiBAc2NoZW1hIENyZWF0b3IjSGFuZGxlXG4gICAqL1xuICByZWFkb25seSBoYW5kbGU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEVtYWlsIG9mIHRoZSBjcmVhdG9yIG9mIHRoZSBzbG9cbiAgICpcbiAgICogQHNjaGVtYSBDcmVhdG9yI0VtYWlsXG4gICAqL1xuICByZWFkb25seSBlbWFpbD86IHN0cmluZztcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdDcmVhdG9yJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9DcmVhdG9yKG9iajogQ3JlYXRvciB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ05hbWUnOiBvYmoubmFtZSxcbiAgICAnSGFuZGxlJzogb2JqLmhhbmRsZSxcbiAgICAnRW1haWwnOiBvYmouZW1haWwsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4vKiBlc2xpbnQtZW5hYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5cbi8qKlxuICogQHNjaGVtYSBRdWVyeVxuICovXG5leHBvcnQgaW50ZXJmYWNlIFF1ZXJ5IHtcbiAgLyoqXG4gICAqIEEgRGF0YWRvZyBtZXRyaWMgcXVlcnkgZm9yIHRvdGFsICh2YWxpZCkgZXZlbnRzLlxuICAgKlxuICAgKiBAc2NoZW1hIFF1ZXJ5I051bWVyYXRvclxuICAgKi9cbiAgcmVhZG9ubHkgbnVtZXJhdG9yPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBIERhdGFkb2cgbWV0cmljIHF1ZXJ5IGZvciBnb29kIGV2ZW50cy5cbiAgICpcbiAgICogQHNjaGVtYSBRdWVyeSNEZW5vbWluYXRvclxuICAgKi9cbiAgcmVhZG9ubHkgZGVub21pbmF0b3I/OiBzdHJpbmc7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnUXVlcnknIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX1F1ZXJ5KG9iajogUXVlcnkgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdOdW1lcmF0b3InOiBvYmoubnVtZXJhdG9yLFxuICAgICdEZW5vbWluYXRvcic6IG9iai5kZW5vbWluYXRvcixcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbi8qIGVzbGludC1lbmFibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cblxuLyoqXG4gKiBAc2NoZW1hIFRocmVzaG9sZFxuICovXG5leHBvcnQgaW50ZXJmYWNlIFRocmVzaG9sZCB7XG4gIC8qKlxuICAgKiBUaGUgdGFyZ2V0IHZhbHVlIGZvciB0aGUgc2VydmljZSBsZXZlbCBpbmRpY2F0b3Igd2l0aGluIHRoZSBjb3JyZXNwb25kaW5nIHRpbWVmcmFtZS5cbiAgICpcbiAgICogQHNjaGVtYSBUaHJlc2hvbGQjVGFyZ2V0XG4gICAqL1xuICByZWFkb25seSB0YXJnZXQ/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIEEgc3RyaW5nIHJlcHJlc2VudGF0aW9uIG9mIHRoZSB0YXJnZXQgdGhhdCBpbmRpY2F0ZXMgaXRzIHByZWNpc2lvbi4oZS5nLiA5OC4wMClcbiAgICpcbiAgICogQHNjaGVtYSBUaHJlc2hvbGQjVGFyZ2V0RGlzcGxheVxuICAgKi9cbiAgcmVhZG9ubHkgdGFyZ2V0RGlzcGxheT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIFNMTyB0aW1lIHdpbmRvdyBvcHRpb25zLiBBbGxvd2VkIGVudW0gdmFsdWVzOiA3ZCwzMGQsOTBkXG4gICAqXG4gICAqIEBzY2hlbWEgVGhyZXNob2xkI1RpbWVmcmFtZVxuICAgKi9cbiAgcmVhZG9ubHkgdGltZWZyYW1lPzogVGhyZXNob2xkVGltZWZyYW1lO1xuXG4gIC8qKlxuICAgKiBUaGUgd2FybmluZyB2YWx1ZSBmb3IgdGhlIHNlcnZpY2UgbGV2ZWwgb2JqZWN0aXZlLlxuICAgKlxuICAgKiBAc2NoZW1hIFRocmVzaG9sZCNXYXJuaW5nXG4gICAqL1xuICByZWFkb25seSB3YXJuaW5nPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBBIHN0cmluZyByZXByZXNlbnRhdGlvbiBvZiB0aGUgd2FybmluZyB0YXJnZXQuKGUuZy4gOTguMDApXG4gICAqXG4gICAqIEBzY2hlbWEgVGhyZXNob2xkI1dhcm5pbmdEaXNwbGF5XG4gICAqL1xuICByZWFkb25seSB3YXJuaW5nRGlzcGxheT86IHN0cmluZztcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdUaHJlc2hvbGQnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX1RocmVzaG9sZChvYmo6IFRocmVzaG9sZCB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ1RhcmdldCc6IG9iai50YXJnZXQsXG4gICAgJ1RhcmdldERpc3BsYXknOiBvYmoudGFyZ2V0RGlzcGxheSxcbiAgICAnVGltZWZyYW1lJzogb2JqLnRpbWVmcmFtZSxcbiAgICAnV2FybmluZyc6IG9iai53YXJuaW5nLFxuICAgICdXYXJuaW5nRGlzcGxheSc6IG9iai53YXJuaW5nRGlzcGxheSxcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbi8qIGVzbGludC1lbmFibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cblxuLyoqXG4gKiBUaGUgdHlwZSBvZiB0aGUgc2xvXG4gKlxuICogQHNjaGVtYSBDZm5TbG9Qcm9wc1R5cGVcbiAqL1xuZXhwb3J0IGVudW0gQ2ZuU2xvUHJvcHNUeXBlIHtcbiAgLyoqIG1vbml0b3IgKi9cbiAgTU9OSVRPUiA9ICdtb25pdG9yJyxcbiAgLyoqIG1ldHJpYyAqL1xuICBNRVRSSUMgPSAnbWV0cmljJyxcbn1cblxuLyoqXG4gKiBUaGUgU0xPIHRpbWUgd2luZG93IG9wdGlvbnMuIEFsbG93ZWQgZW51bSB2YWx1ZXM6IDdkLDMwZCw5MGRcbiAqXG4gKiBAc2NoZW1hIFRocmVzaG9sZFRpbWVmcmFtZVxuICovXG5leHBvcnQgZW51bSBUaHJlc2hvbGRUaW1lZnJhbWUge1xuICAvKiogN2QgKi9cbiAgVkFMVUVfN0QgPSAnN2QnLFxuICAvKiogMzBkICovXG4gIFZBTFVFXzMwRCA9ICczMGQnLFxuICAvKiogOTBkICovXG4gIFZBTFVFXzkwRCA9ICc5MGQnLFxufVxuXG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgRGF0YWRvZzo6U0xPczo6U0xPYFxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIERhdGFkb2c6OlNMT3M6OlNMT1xuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICogQGxpbmsgaHR0cDovL3Vua25vd24tdXJsXG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5TbG8gZXh0ZW5kcyBjZGsuQ2ZuUmVzb3VyY2Uge1xuICAvKipcbiAgKiBUaGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxuICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENGTl9SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkRhdGFkb2c6OlNMT3M6OlNMT1wiO1xuXG4gIC8qKlxuICAgKiBSZXNvdXJjZSBwcm9wcy5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBwcm9wczogQ2ZuU2xvUHJvcHM7XG5cbiAgLyoqXG4gICAqIEF0dHJpYnV0ZSBgRGF0YWRvZzo6U0xPczo6U0xPLk1vZGlmaWVkYFxuICAgKiBAbGluayBodHRwOi8vdW5rbm93bi11cmxcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBhdHRyTW9kaWZpZWQ6IHN0cmluZztcbiAgLyoqXG4gICAqIEF0dHJpYnV0ZSBgRGF0YWRvZzo6U0xPczo6U0xPLklkYFxuICAgKiBAbGluayBodHRwOi8vdW5rbm93bi11cmxcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBhdHRySWQ6IHN0cmluZztcbiAgLyoqXG4gICAqIEF0dHJpYnV0ZSBgRGF0YWRvZzo6U0xPczo6U0xPLkRlbGV0ZWRgXG4gICAqIEBsaW5rIGh0dHA6Ly91bmtub3duLXVybFxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGF0dHJEZWxldGVkOiBzdHJpbmc7XG4gIC8qKlxuICAgKiBBdHRyaWJ1dGUgYERhdGFkb2c6OlNMT3M6OlNMTy5DcmVhdGVkYFxuICAgKiBAbGluayBodHRwOi8vdW5rbm93bi11cmxcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBhdHRyQ3JlYXRlZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBDcmVhdGUgYSBuZXcgYERhdGFkb2c6OlNMT3M6OlNMT2AuXG4gICAqXG4gICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICovXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjb25zdHJ1Y3RzLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmblNsb1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmblNsby5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiB0b0pzb25fQ2ZuU2xvUHJvcHMocHJvcHMpISB9KTtcblxuICAgIHRoaXMucHJvcHMgPSBwcm9wcztcblxuICAgIHRoaXMuYXR0ck1vZGlmaWVkID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdNb2RpZmllZCcpKTtcbiAgICB0aGlzLmF0dHJJZCA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnSWQnKSk7XG4gICAgdGhpcy5hdHRyRGVsZXRlZCA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnRGVsZXRlZCcpKTtcbiAgICB0aGlzLmF0dHJDcmVhdGVkID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdDcmVhdGVkJykpO1xuICB9XG59Il19