from setuptools import setup, find_packages
from os import path

here = path.abspath(path.dirname(__file__))

with open(path.join(here, "README.md"), encoding="utf-8") as file:
    long_description = file.read()

setup(
    name="ctx19",
    version="1.0.1",
    description="A Python driver for Contextual19 markup language",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/syntpump/contextual19",
    author="Syntpump",
    author_email="lynnporu@gmail.com",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License"
    ],
    keywords="nlp",
    packages=find_packages(),
    python_requires=">3",
    project_urls={
        "Syntpump on GitHub": "https://github.com/syntpump"
    }
)
