# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['what_to_eat',
 'what_to_eat.gateways',
 'what_to_eat.models',
 'what_to_eat.services',
 'what_to_eat.utils']

package_data = \
{'': ['*']}

install_requires = \
['httpx>=0.23.1,<0.24.0',
 'inquirer>=2.10.1,<4.0.0',
 'pydantic>=1.10.2,<2.0.0',
 'typer[all]>=0.7.0,<0.8.0']

entry_points = \
{'console_scripts': ['what-to-eat = what_to_eat.main:app']}

setup_kwargs = {
    'name': 'what-to-eat',
    'version': '1.0.0',
    'description': 'What to eat? CLI tool to interaction with Wolt API',
    'long_description': '<h1>🍔 What to eat? 🍕</h1>\n<p align="center">\n    <em>CLI tool to query Wolt API in your location!</em>\n</p>\n\n![Release](https://github.com/Valaraucoo/what-to-eat/actions/workflows/release.yml/badge.svg)\n![Build Status](https://github.com/Valaraucoo/what-to-eat/actions/workflows/tests.yml/badge.svg)\n[![PyPI](https://img.shields.io/pypi/v/what-to-eat.svg)](https://pypi.python.org/pypi/what-to-eat/)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n\n\n\nWhy to use *what-to-eat*? How many times have you not known what to order for dinner or lunch? *What-to-eat* will help you querying and filtering restaurants available in your location via [Wolt](https://wolt.com/pl/discovery) app! 🍔\n\nExample usage:\n\n<p align="center">\n    <img src="https://raw.githubusercontent.com/Valaraucoo/what-to-eat/master/images/ls-query-example.png" alt="demo" width="900"/>\n</p>\n\n<h2>✨ Features </h2>\n\n* 🍔 Query restaurants in your location\n* 🍕 Filter restaurants by name, cuisine, price, rating, delivery time, etc.\n* 🍗 Display restaurant details\n* 🍟 Random restaurant draw\n\n<h2>🛠️ Installation</h2>\n\n*What to eat* is compatible with Python 3.10+ and runs on Linux, macOS and Windows. The latest releases with binary wheels are available from pip. Before you install *What to eat* and its dependencies, make sure that your pip, setuptools and wheel are up to date.\n\nYou can install `what-to-eat` using [pip](https://pypi.org/project/what-to-eat/):\n\n```console\npip install what-to-eat\n```\n\n<h2>💬 Available commands</h2>\n\nThere are currently 3 commands available, one of which is used to configure the tool: `configure`, `ls`, `random`:\n\n```console\n$ what-to-eat --help\n\n Usage: what-to-eat [OPTIONS] COMMAND [ARGS]...\n\n╭─ Options ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ --version             -v                                                                                                    │\n│ --install-completion            Install completion for the current shell.                                                   │\n│ --show-completion               Show completion for the current shell, to copy it or customize the installation.            │\n│ --help                          Show this message and exit.                                                                 │\n╰─────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Commands ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ configure                                Create configuration file to your orders                                           │\n│ ls                                       List restaurants queried from Wolt API.                                            │\n│ random                                   Finds random restaurant via Wolt API                                               │\n╰─────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n\n```\n\nYou can find examples of using these commands in the section below.\n\n\n<h2>✨ Examples</h2>\nConfigure your tool:\n\n```console\n$ what-to-eat configure\n```\n\n\nList all available restaurants in your localization:\n\n```console\n$ what-to-eat ls\n```\n\n\nSort restaurants by `rating` and limit results to 5 records:\n```console\n$ what-to-eat ls --sort rating --ordering desc --limit 5\n┏━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━┳━━━━━━━━┳━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━┓\n┃ No. ┃                               Restaurant ┃                  Address ┃ Estimate time ┃ Delivery cost ┃ Rating ┃ Price ┃                Tags ┃\n┡━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━╇━━━━━━━━╇━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━┩\n│ 1   │               Mikropiekarnia Pochlebstwo │       Romanowicza 5/LU7b │   25 - 35 min │ (No delivery) │   10.0 │  💰💰 │     Bakery, Grocery │\n│ 2   │                            KruKam Kraków │        ul. Krakowska 35A │   30 - 40 min │ (No delivery) │    9.8 │  💰💰 │    Grocery, Healthy │\n│ 3   │                    Piekarnia Mojego Taty │           ul. Meiselsa 6 │   20 - 30 min │ (No delivery) │    9.8 │    💰 │     Bakery, Grocery │\n│ 4   │  MARLIN - Fish & Chips - Smażalnie Rybne │ Krowoderskich Zuchów 21A │   45 - 55 min │ (No delivery) │    9.6 │  💰💰 │ Fish, Mediterranean │\n│ 5   │ Lody Ice Cream NOW - Stare Miasto II (K) │  This is a virtual venue │   20 - 30 min │ (No delivery) │    9.6 │  💰💰 │           Ice cream │\n└─────┴──────────────────────────────────────────┴──────────────────────────┴───────────────┴───────────────┴────────┴───────┴─────────────────────┘\n                                                        🍿 Restaurants in Kraków via wolt 🍿\n```\n\nWhile using `ls` command you can also use option `query` to filter results by restaurant name, address or tags:\n\n```console\n$ what-to-eat ls --query Pizza --limit 3\n┏━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━┳━━━━━━━━┳━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━┓\n┃ No. ┃                          Restaurant ┃           Address ┃ Estimate time ┃ Delivery cost ┃ Rating ┃ Price ┃                  Tags ┃\n┡━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━╇━━━━━━━━╇━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━┩\n│ 1   │ Pizzeria Caprese Chillzone Młynówka │    Racławicka 21, │   20 - 30 min │ (No delivery) │    8.4 │  💰💰 │        Italian, pizza │\n│ 2   │                            U Filipa │ Ul. Św. Filipa 25 │   30 - 40 min │ (No delivery) │    7.8 │    💰 │                 pizza │\n│ 3   │                  Baqaro - Rakowicka │      Rakowicka 11 │   25 - 35 min │ (No delivery) │      - │  💰💰 │ Italian, Pinsa, pizza │\n└─────┴─────────────────────────────────────┴───────────────────┴───────────────┴───────────────┴────────┴───────┴───────────────────────┘\n                                                   🍿 Restaurants in Kraków via wolt 🍿\n```\n\nBy default your first profile is `default` one. But while listing restaurants you can change it using `profile` option:\n\n```console\n$ what-to-eat ls --profile work\n```\n\nYou can also display restaurant details by using `ls` command with restaurant name:\n\n```console\n$ what-to-eat ls zapiecek\n┏━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓\n┃     🍕 Zapiecek ┃                       Kraków, Ul. Floriańska 20 🍕 ┃\n┡━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩\n│          Rating │                           Amazing (9 / 20 reviews) │\n│           Price │                                                 💰 │\n│    Opening time │                                      10:00 - 20:45 │\n│         Website │ https://wolt.com/pl/pol/krakow/restaurant/zapiecek │\n│           Phone │                                      +48 124221345 │\n│       Estimates │                                         30 minutes │\n│ Payment Methods │                                               Card │\n│     Description │               Kultowy bar kanapkowo - sałatkowy... │\n│            Tags │                                    Sandwich, Salad │\n└─────────────────┴────────────────────────────────────────────────────┘\n```\n\nHowever, perhaps the coolest options is to randomly select restaurants.\n```console\n$ what-to-eat random\n```\n\n**Note:** The selection algorithm is based on the ranking and delivery time for a given restaurant.\n\nYou can also enter a tag based on which a restaurant will be randomly selected:\n\n```console\n$ what-to-eat random --tag pizza\n```\n\nRandom command supports `technique` option, which allows you to choose the algorithm used to select a restaurant. The default value is `mix` and it means that the restaurant will be selected based on the ranking and delivery time.\n\n```console:\n$ what-to-eat random --technique mix\n```\n\nYou can select one of the following techniques:\n- `mix` - the restaurant will be selected based on the ranking and delivery time.\n- `rating` - the restaurant will be selected based on the ranking.\n- `delivery_time` - the restaurant will be selected based on the delivery time.\n- `random` - the restaurant will be selected randomly.\n\n<h2>📖 Documentation </h2>\n\n| Documentation                                             | Command               | Options                                                |\n|-----------------------------------------------------------|-----------------------|--------------------------------------------------------|\n| [🚀 List all restaurants](./docs/list-all-restaurants.md) | `what-to-eat ls`      | `query`, `profile`, `tag`, `sort`, `ordering`, `limit` |\n| [🎲 Random restaurant](./docs/random.md)                  | `what-to-eat random`  | `profile`, `tag`, `technique`                          |\n| 👤 Configure profile                                      | `what-to-eat config`  |                                                        |\n\n<h2>📚 License</h2>\n\nThis project is licensed under the terms of the MIT license.\n',
    'author': 'Kamil Woźniak',
    'author_email': 'info@kamilwozniak.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
