"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnCluster = exports.toJson_S3Destination = exports.AwsAttributesEbsVolumeType = exports.AwsAttributesAvailability = exports.toJson_CfnClusterPropsDefaultTags = exports.toJson_CfnClusterPropsDriverInstanceSource = exports.toJson_CfnClusterPropsInstanceSource = exports.toJson_InitScriptsListItem = exports.toJson_AwsAttributes = exports.toJson_Autoscale = exports.toJson_CfnClusterProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnClusterProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'NumWorkers': obj.numWorkers,
        'Autoscale': toJson_Autoscale(obj.autoscale),
        'ClusterName': obj.clusterName,
        'SparkVersion': obj.sparkVersion,
        'SparkConf': obj.sparkConf,
        'AwsAttributes': toJson_AwsAttributes(obj.awsAttributes),
        'NodeTypeId': obj.nodeTypeId,
        'DriverNodeTypeId': obj.driverNodeTypeId,
        'SshPublicKeys': obj.sshPublicKeys?.map(y => y),
        'CustomTags': obj.customTags,
        'InitScripts': obj.initScripts?.map(y => toJson_InitScriptsListItem(y)),
        'SparkEnvVars': obj.sparkEnvVars,
        'AutoterminationMinutes': obj.autoterminationMinutes,
        'EnableElasticDisk': obj.enableElasticDisk,
        'DriverInstancePoolId': obj.driverInstancePoolId,
        'InstancePoolId': obj.instancePoolId,
        'IdempotencyToken': obj.idempotencyToken,
        'ApplyPolicyDefaultValues': obj.applyPolicyDefaultValues,
        'EnableLocalDiskEncryption': obj.enableLocalDiskEncryption,
        'RuntimeEngine': obj.runtimeEngine,
        'ClusterMemoryMb': obj.clusterMemoryMb,
        'ClusterCores': obj.clusterCores,
        'InstanceSource': toJson_CfnClusterPropsInstanceSource(obj.instanceSource),
        'Driver': obj.driver,
        'DriverInstanceSource': toJson_CfnClusterPropsDriverInstanceSource(obj.driverInstanceSource),
        'ClusterSource': obj.clusterSource,
        'CreatorUserName': obj.creatorUserName,
        'DefaultTags': toJson_CfnClusterPropsDefaultTags(obj.defaultTags),
        'EffectiveSparkVersion': obj.effectiveSparkVersion,
        'StartTime': obj.startTime,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterProps = toJson_CfnClusterProps;
/**
 * Converts an object of type 'Autoscale' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Autoscale(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MinWorkers': obj.minWorkers,
        'MaxWorkers': obj.maxWorkers,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Autoscale = toJson_Autoscale;
/**
 * Converts an object of type 'AwsAttributes' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AwsAttributes(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'FirstOnDemand': obj.firstOnDemand,
        'Availability': obj.availability,
        'ZoneId': obj.zoneId,
        'SpotBidPricePercent': obj.spotBidPricePercent,
        'EbsVolumeType': obj.ebsVolumeType,
        'EbsVolumeCount': obj.ebsVolumeCount,
        'EbsVolumeSize': obj.ebsVolumeSize,
        'EbsVolumeIops': obj.ebsVolumeIops,
        'EbsVolumeThroughput': obj.ebsVolumeThroughput,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AwsAttributes = toJson_AwsAttributes;
/**
 * Converts an object of type 'InitScriptsListItem' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_InitScriptsListItem(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'S3': toJson_S3Destination(obj.s3),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_InitScriptsListItem = toJson_InitScriptsListItem;
/**
 * Converts an object of type 'CfnClusterPropsInstanceSource' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterPropsInstanceSource(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'InstancePoolId': obj.instancePoolId,
        'NodeTypeId': obj.nodeTypeId,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterPropsInstanceSource = toJson_CfnClusterPropsInstanceSource;
/**
 * Converts an object of type 'CfnClusterPropsDriverInstanceSource' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterPropsDriverInstanceSource(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'InstancePoolId': obj.instancePoolId,
        'NodeTypeId': obj.nodeTypeId,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterPropsDriverInstanceSource = toJson_CfnClusterPropsDriverInstanceSource;
/**
 * Converts an object of type 'CfnClusterPropsDefaultTags' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterPropsDefaultTags(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ClusterId': obj.clusterId,
        'ClusterName': obj.clusterName,
        'Creator': obj.creator,
        'Vendor': obj.vendor,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterPropsDefaultTags = toJson_CfnClusterPropsDefaultTags;
/* eslint-enable max-len, quote-props */
/**
 * Availability type used for all subsequent nodes past the first_on_demand ones. Note: If first_on_demand is zero, this availability type will be used for the entire cluster.
 *
 * @schema AwsAttributesAvailability
 */
var AwsAttributesAvailability;
(function (AwsAttributesAvailability) {
    /** SPOT */
    AwsAttributesAvailability["SPOT"] = "SPOT";
    /** ON_DEMAND */
    AwsAttributesAvailability["ON_DEMAND"] = "ON_DEMAND";
    /** SPOT_WITH_FALLBACK */
    AwsAttributesAvailability["SPOT_WITH_FALLBACK"] = "SPOT_WITH_FALLBACK";
})(AwsAttributesAvailability = exports.AwsAttributesAvailability || (exports.AwsAttributesAvailability = {}));
/**
 * The type of EBS volumes that will be launched with this cluster.
 *
 * @schema AwsAttributesEbsVolumeType
 */
var AwsAttributesEbsVolumeType;
(function (AwsAttributesEbsVolumeType) {
    /** GENERAL_PURPOSE_SSD */
    AwsAttributesEbsVolumeType["GENERAL_PURPOSE_SSD"] = "GENERAL_PURPOSE_SSD";
    /** THROUGHPUT_OPTIMIZED_HDD */
    AwsAttributesEbsVolumeType["THROUGHPUT_OPTIMIZED_HDD"] = "THROUGHPUT_OPTIMIZED_HDD";
})(AwsAttributesEbsVolumeType = exports.AwsAttributesEbsVolumeType || (exports.AwsAttributesEbsVolumeType = {}));
/**
 * Converts an object of type 'S3Destination' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_S3Destination(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Destination': obj.destination,
        'Region': obj.region,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_S3Destination = toJson_S3Destination;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Databricks::Clusters::Cluster`
 *
 * @cloudformationResource Databricks::Clusters::Cluster
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
 */
class CfnCluster extends cdk.CfnResource {
    /**
     * Create a new `Databricks::Clusters::Cluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCluster.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnClusterProps(props) });
        this.props = props;
        this.attrClusterId = cdk.Token.asString(this.getAtt('ClusterId'));
        this.attrState = cdk.Token.asString(this.getAtt('State'));
        this.attrStateMessage = cdk.Token.asString(this.getAtt('StateMessage'));
        this.attrLastStateLossTime = cdk.Token.asNumber(this.getAtt('LastStateLossTime'));
        this.attrLastActivityTime = cdk.Token.asNumber(this.getAtt('LastActivityTime'));
        this.attrLastRestartedTime = cdk.Token.asNumber(this.getAtt('LastRestartedTime'));
        this.attrInitScriptsSafeMode = this.getAtt('InitScriptsSafeMode');
    }
}
exports.CfnCluster = CfnCluster;
_a = JSII_RTTI_SYMBOL_1;
CfnCluster[_a] = { fqn: "@cdk-cloudformation/databricks-clusters-cluster.CfnCluster", version: "1.1.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnCluster.CFN_RESOURCE_TYPE_NAME = "Databricks::Clusters::Cluster";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwwQkFBMEI7QUFDMUIsbUNBQW1DO0FBK01uQzs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQixzQkFBc0IsQ0FBQyxHQUFnQztJQUNyRSxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsWUFBWSxFQUFFLEdBQUcsQ0FBQyxVQUFVO1FBQzVCLFdBQVcsRUFBRSxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsU0FBUyxDQUFDO1FBQzVDLGFBQWEsRUFBRSxHQUFHLENBQUMsV0FBVztRQUM5QixjQUFjLEVBQUUsR0FBRyxDQUFDLFlBQVk7UUFDaEMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxTQUFTO1FBQzFCLGVBQWUsRUFBRSxvQkFBb0IsQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDO1FBQ3hELFlBQVksRUFBRSxHQUFHLENBQUMsVUFBVTtRQUM1QixrQkFBa0IsRUFBRSxHQUFHLENBQUMsZ0JBQWdCO1FBQ3hDLGVBQWUsRUFBRSxHQUFHLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztRQUMvQyxZQUFZLEVBQUUsR0FBRyxDQUFDLFVBQVU7UUFDNUIsYUFBYSxFQUFFLEdBQUcsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDdkUsY0FBYyxFQUFFLEdBQUcsQ0FBQyxZQUFZO1FBQ2hDLHdCQUF3QixFQUFFLEdBQUcsQ0FBQyxzQkFBc0I7UUFDcEQsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGlCQUFpQjtRQUMxQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsb0JBQW9CO1FBQ2hELGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjO1FBQ3BDLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxnQkFBZ0I7UUFDeEMsMEJBQTBCLEVBQUUsR0FBRyxDQUFDLHdCQUF3QjtRQUN4RCwyQkFBMkIsRUFBRSxHQUFHLENBQUMseUJBQXlCO1FBQzFELGVBQWUsRUFBRSxHQUFHLENBQUMsYUFBYTtRQUNsQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsZUFBZTtRQUN0QyxjQUFjLEVBQUUsR0FBRyxDQUFDLFlBQVk7UUFDaEMsZ0JBQWdCLEVBQUUsb0NBQW9DLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQztRQUMxRSxRQUFRLEVBQUUsR0FBRyxDQUFDLE1BQU07UUFDcEIsc0JBQXNCLEVBQUUsMENBQTBDLENBQUMsR0FBRyxDQUFDLG9CQUFvQixDQUFDO1FBQzVGLGVBQWUsRUFBRSxHQUFHLENBQUMsYUFBYTtRQUNsQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsZUFBZTtRQUN0QyxhQUFhLEVBQUUsaUNBQWlDLENBQUMsR0FBRyxDQUFDLFdBQVcsQ0FBQztRQUNqRSx1QkFBdUIsRUFBRSxHQUFHLENBQUMscUJBQXFCO1FBQ2xELFdBQVcsRUFBRSxHQUFHLENBQUMsU0FBUztLQUMzQixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFwQ0Qsd0RBb0NDO0FBeUJEOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLGdCQUFnQixDQUFDLEdBQTBCO0lBQ3pELElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixZQUFZLEVBQUUsR0FBRyxDQUFDLFVBQVU7UUFDNUIsWUFBWSxFQUFFLEdBQUcsQ0FBQyxVQUFVO0tBQzdCLENBQUM7SUFDRiwwQkFBMEI7SUFDMUIsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDMUcsQ0FBQztBQVJELDRDQVFDO0FBOEZEOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLG9CQUFvQixDQUFDLEdBQThCO0lBQ2pFLElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixlQUFlLEVBQUUsR0FBRyxDQUFDLGFBQWE7UUFDbEMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxZQUFZO1FBQ2hDLFFBQVEsRUFBRSxHQUFHLENBQUMsTUFBTTtRQUNwQixxQkFBcUIsRUFBRSxHQUFHLENBQUMsbUJBQW1CO1FBQzlDLGVBQWUsRUFBRSxHQUFHLENBQUMsYUFBYTtRQUNsQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsY0FBYztRQUNwQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGFBQWE7UUFDbEMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxhQUFhO1FBQ2xDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUI7S0FDL0MsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBZkQsb0RBZUM7QUFjRDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQiwwQkFBMEIsQ0FBQyxHQUFvQztJQUM3RSxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsSUFBSSxFQUFFLG9CQUFvQixDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUM7S0FDbkMsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBUEQsZ0VBT0M7QUFtQkQ7O0dBRUc7QUFDSCx5Q0FBeUM7QUFDekMsU0FBZ0Isb0NBQW9DLENBQUMsR0FBOEM7SUFDakcsSUFBSSxHQUFHLEtBQUssU0FBUyxFQUFFO1FBQUUsT0FBTyxTQUFTLENBQUM7S0FBRTtJQUM1QyxNQUFNLE1BQU0sR0FBRztRQUNiLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjO1FBQ3BDLFlBQVksRUFBRSxHQUFHLENBQUMsVUFBVTtLQUM3QixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFSRCxvRkFRQztBQW1CRDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQiwwQ0FBMEMsQ0FBQyxHQUFvRDtJQUM3RyxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWM7UUFDcEMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxVQUFVO0tBQzdCLENBQUM7SUFDRiwwQkFBMEI7SUFDMUIsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDMUcsQ0FBQztBQVJELGdHQVFDO0FBNkJEOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLGlDQUFpQyxDQUFDLEdBQTJDO0lBQzNGLElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixXQUFXLEVBQUUsR0FBRyxDQUFDLFNBQVM7UUFDMUIsYUFBYSxFQUFFLEdBQUcsQ0FBQyxXQUFXO1FBQzlCLFNBQVMsRUFBRSxHQUFHLENBQUMsT0FBTztRQUN0QixRQUFRLEVBQUUsR0FBRyxDQUFDLE1BQU07S0FDckIsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBVkQsOEVBVUM7QUFDRCx3Q0FBd0M7QUFFeEM7Ozs7R0FJRztBQUNILElBQVkseUJBT1g7QUFQRCxXQUFZLHlCQUF5QjtJQUNuQyxXQUFXO0lBQ1gsMENBQWEsQ0FBQTtJQUNiLGdCQUFnQjtJQUNoQixvREFBdUIsQ0FBQTtJQUN2Qix5QkFBeUI7SUFDekIsc0VBQXlDLENBQUE7QUFDM0MsQ0FBQyxFQVBXLHlCQUF5QixHQUF6QixpQ0FBeUIsS0FBekIsaUNBQXlCLFFBT3BDO0FBRUQ7Ozs7R0FJRztBQUNILElBQVksMEJBS1g7QUFMRCxXQUFZLDBCQUEwQjtJQUNwQywwQkFBMEI7SUFDMUIseUVBQTJDLENBQUE7SUFDM0MsK0JBQStCO0lBQy9CLG1GQUFxRCxDQUFBO0FBQ3ZELENBQUMsRUFMVywwQkFBMEIsR0FBMUIsa0NBQTBCLEtBQTFCLGtDQUEwQixRQUtyQztBQWtCRDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQixvQkFBb0IsQ0FBQyxHQUE4QjtJQUNqRSxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsYUFBYSxFQUFFLEdBQUcsQ0FBQyxXQUFXO1FBQzlCLFFBQVEsRUFBRSxHQUFHLENBQUMsTUFBTTtLQUNyQixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFSRCxvREFRQztBQUNELHdDQUF3QztBQUd4Qzs7Ozs7O0dBTUc7QUFDSCxNQUFhLFVBQVcsU0FBUSxHQUFHLENBQUMsV0FBVztJQStDN0M7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUEyQixFQUFFLEVBQVUsRUFBRSxLQUFzQjtRQUN6RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxVQUFVLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLHNCQUFzQixDQUFDLEtBQUssQ0FBRSxFQUFFLENBQUMsQ0FBQztRQUUxRyxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUVuQixJQUFJLENBQUMsYUFBYSxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztRQUNsRSxJQUFJLENBQUMsU0FBUyxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztRQUMxRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO1FBQ3hFLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztRQUNsRixJQUFJLENBQUMsb0JBQW9CLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7UUFDaEYsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO1FBQ2xGLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDcEUsQ0FBQzs7QUFsRUgsZ0NBbUVDOzs7QUFsRUM7O0VBRUU7QUFDcUIsaUNBQXNCLEdBQUcsK0JBQStCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBHZW5lcmF0ZWQgYnkgY2RrLWltcG9ydFxuaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIGNvbnN0cnVjdHMgZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogTWFuYWdlIGEgRGF0YWJyaWNrcyBDbHVzdGVyXG4gKlxuICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5DbHVzdGVyUHJvcHMge1xuICAvKipcbiAgICogSWYgbnVtX3dvcmtlcnMsIG51bWJlciBvZiB3b3JrZXIgbm9kZXMgdGhhdCB0aGlzIGNsdXN0ZXIgc2hvdWxkIGhhdmUuIEEgY2x1c3RlciBoYXMgb25lIFNwYXJrIGRyaXZlciBhbmQgbnVtX3dvcmtlcnMgZXhlY3V0b3JzIGZvciBhIHRvdGFsIG9mIG51bV93b3JrZXJzICsgMSBTcGFyayBub2Rlcy5cbiAgICpcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjTnVtV29ya2Vyc1xuICAgKi9cbiAgcmVhZG9ubHkgbnVtV29ya2Vycz86IG51bWJlcjtcblxuICAvKipcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjQXV0b3NjYWxlXG4gICAqL1xuICByZWFkb25seSBhdXRvc2NhbGU/OiBBdXRvc2NhbGU7XG5cbiAgLyoqXG4gICAqIENsdXN0ZXIgbmFtZSByZXF1ZXN0ZWQgYnkgdGhlIHVzZXIuIFRoaXMgZG9lc24ndCBoYXZlIHRvIGJlIHVuaXF1ZS4gSWYgbm90IHNwZWNpZmllZCBhdCBjcmVhdGlvbiwgdGhlIGNsdXN0ZXIgbmFtZSB3aWxsIGJlIGFuIGVtcHR5IHN0cmluZy5cbiAgICpcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjQ2x1c3Rlck5hbWVcbiAgICovXG4gIHJlYWRvbmx5IGNsdXN0ZXJOYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcnVudGltZSB2ZXJzaW9uIG9mIHRoZSBjbHVzdGVyLiBZb3UgY2FuIHJldHJpZXZlIGEgbGlzdCBvZiBhdmFpbGFibGUgcnVudGltZSB2ZXJzaW9ucyBieSB1c2luZyB0aGUgUnVudGltZSB2ZXJzaW9ucyBBUEkgY2FsbC4gVGhpcyBmaWVsZCBpcyByZXF1aXJlZC5cbiAgICpcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjU3BhcmtWZXJzaW9uXG4gICAqL1xuICByZWFkb25seSBzcGFya1ZlcnNpb24/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuQ2x1c3RlclByb3BzI1NwYXJrQ29uZlxuICAgKi9cbiAgcmVhZG9ubHkgc3BhcmtDb25mPzogYW55O1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wcyNBd3NBdHRyaWJ1dGVzXG4gICAqL1xuICByZWFkb25seSBhd3NBdHRyaWJ1dGVzPzogQXdzQXR0cmlidXRlcztcblxuICAvKipcbiAgICogVGhpcyBmaWVsZCBlbmNvZGVzLCB0aHJvdWdoIGEgc2luZ2xlIHZhbHVlLCB0aGUgcmVzb3VyY2VzIGF2YWlsYWJsZSB0byBlYWNoIG9mIHRoZSBTcGFyayBub2RlcyBpbiB0aGlzIGNsdXN0ZXIuIEZvciBleGFtcGxlLCB0aGUgU3Bhcmsgbm9kZXMgY2FuIGJlIHByb3Zpc2lvbmVkIGFuZCBvcHRpbWl6ZWQgZm9yIG1lbW9yeSBvciBjb21wdXRlIGludGVuc2l2ZSB3b3JrbG9hZHMgQSBsaXN0IG9mIGF2YWlsYWJsZSBub2RlIHR5cGVzIGNhbiBiZSByZXRyaWV2ZWQgYnkgdXNpbmcgdGhlIExpc3Qgbm9kZSB0eXBlcyBBUEkgY2FsbC4gVGhpcyBmaWVsZCBpcyByZXF1aXJlZC5cbiAgICpcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjTm9kZVR5cGVJZFxuICAgKi9cbiAgcmVhZG9ubHkgbm9kZVR5cGVJZD86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIG5vZGUgdHlwZSBvZiB0aGUgU3BhcmsgZHJpdmVyLiBUaGlzIGZpZWxkIGlzIG9wdGlvbmFsOyBpZiB1bnNldCwgdGhlIGRyaXZlciBub2RlIHR5cGUgd2lsbCBiZSBzZXQgYXMgdGhlIHNhbWUgdmFsdWUgYXMgbm9kZV90eXBlX2lkIGRlZmluZWQgYWJvdmUuXG4gICAqXG4gICAqIEBzY2hlbWEgQ2ZuQ2x1c3RlclByb3BzI0RyaXZlck5vZGVUeXBlSWRcbiAgICovXG4gIHJlYWRvbmx5IGRyaXZlck5vZGVUeXBlSWQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFNTSCBwdWJsaWMga2V5IGNvbnRlbnRzIHRoYXQgd2lsbCBiZSBhZGRlZCB0byBlYWNoIFNwYXJrIG5vZGUgaW4gdGhpcyBjbHVzdGVyLiBUaGUgY29ycmVzcG9uZGluZyBwcml2YXRlIGtleXMgY2FuIGJlIHVzZWQgdG8gbG9naW4gd2l0aCB0aGUgdXNlciBuYW1lIHVidW50dSBvbiBwb3J0IDIyMDAuIFVwIHRvIDEwIGtleXMgY2FuIGJlIHNwZWNpZmllZC5cbiAgICpcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjU3NoUHVibGljS2V5c1xuICAgKi9cbiAgcmVhZG9ubHkgc3NoUHVibGljS2V5cz86IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wcyNDdXN0b21UYWdzXG4gICAqL1xuICByZWFkb25seSBjdXN0b21UYWdzPzogYW55O1xuXG4gIC8qKlxuICAgKiBUaGUgY29uZmlndXJhdGlvbiBmb3Igc3RvcmluZyBpbml0IHNjcmlwdHMuIEFueSBudW1iZXIgb2YgZGVzdGluYXRpb25zIGNhbiBiZSBzcGVjaWZpZWQuIFRoZSBzY3JpcHRzIGFyZSBleGVjdXRlZCBzZXF1ZW50aWFsbHkgaW4gdGhlIG9yZGVyIHByb3ZpZGVkLiBJZiBjbHVzdGVyX2xvZ19jb25mIGlzIHNwZWNpZmllZCwgaW5pdCBzY3JpcHQgbG9ncyBhcmUgc2VudCB0byA8ZGVzdGluYXRpb24+LzxjbHVzdGVyLUlEPi9pbml0X3NjcmlwdHMuXG4gICAqXG4gICAqIEBzY2hlbWEgQ2ZuQ2x1c3RlclByb3BzI0luaXRTY3JpcHRzXG4gICAqL1xuICByZWFkb25seSBpbml0U2NyaXB0cz86IEluaXRTY3JpcHRzTGlzdEl0ZW1bXTtcblxuICAvKipcbiAgICogQW4gb2JqZWN0IGNvbnRhaW5pbmcgYSBzZXQgb2Ygb3B0aW9uYWwsIHVzZXItc3BlY2lmaWVkIGVudmlyb25tZW50IHZhcmlhYmxlIGtleS12YWx1ZSBwYWlycy4gS2V5LXZhbHVlIHBhaXJzIG9mIHRoZSBmb3JtIChYLFkpIGFyZSBleHBvcnRlZCBhcyBpcyAodGhhdCBpcywgZXhwb3J0IFg9J1knKSB3aGlsZSBsYXVuY2hpbmcgdGhlIGRyaXZlciBhbmQgd29ya2Vycy4gSW4gb3JkZXIgdG8gc3BlY2lmeSBhbiBhZGRpdGlvbmFsIHNldCBvZiBTUEFSS19EQUVNT05fSkFWQV9PUFRTLCB3ZSByZWNvbW1lbmQgYXBwZW5kaW5nIHRoZW0gdG8gJFNQQVJLX0RBRU1PTl9KQVZBX09QVFMgYXMgc2hvd24gaW4gdGhlIGZvbGxvd2luZyBleGFtcGxlLiBUaGlzIGVuc3VyZXMgdGhhdCBhbGwgZGVmYXVsdCBEYXRhYnJpY2tzIG1hbmFnZWQgZW52aXJvbm1lbnRhbCB2YXJpYWJsZXMgYXJlIGluY2x1ZGVkIGFzIHdlbGwuIEV4YW1wbGUgU3BhcmsgZW52aXJvbm1lbnQgdmFyaWFibGVzOiB7XCJTUEFSS19XT1JLRVJfTUVNT1JZXCI6IFwiMjgwMDBtXCIsIFwiU1BBUktfTE9DQUxfRElSU1wiOiBcIi9sb2NhbF9kaXNrMFwifSBvciB7XCJTUEFSS19EQUVNT05fSkFWQV9PUFRTXCI6IFwiJFNQQVJLX0RBRU1PTl9KQVZBX09QVFNcbiAgICpcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjU3BhcmtFbnZWYXJzXG4gICAqL1xuICByZWFkb25seSBzcGFya0VudlZhcnM/OiBhbnk7XG5cbiAgLyoqXG4gICAqIEF1dG9tYXRpY2FsbHkgdGVybWluYXRlcyB0aGUgY2x1c3RlciBhZnRlciBpdCBpcyBpbmFjdGl2ZSBmb3IgdGhpcyB0aW1lIGluIG1pbnV0ZXMuIElmIG5vdCBzZXQsIHRoaXMgY2x1c3RlciB3aWxsIG5vdCBiZSBhdXRvbWF0aWNhbGx5IHRlcm1pbmF0ZWQuIElmIHNwZWNpZmllZCwgdGhlIHRocmVzaG9sZCBtdXN0IGJlIGJldHdlZW4gMTAgYW5kIDEwMDAwIG1pbnV0ZXMuIFlvdSBjYW4gYWxzbyBzZXQgdGhpcyB2YWx1ZSB0byAwIHRvIGV4cGxpY2l0bHkgZGlzYWJsZVxuICAgKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wcyNBdXRvdGVybWluYXRpb25NaW51dGVzXG4gICAqL1xuICByZWFkb25seSBhdXRvdGVybWluYXRpb25NaW51dGVzPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBBdXRvc2NhbGluZyBMb2NhbCBTdG9yYWdlOiB3aGVuIGVuYWJsZWQsIHRoaXMgY2x1c3RlciB3aWxsIGR5bmFtaWNhbGx5IGFjcXVpcmUgYWRkaXRpb25hbCBkaXNrIHNwYWNlIHdoZW4gaXRzIFNwYXJrIHdvcmtlcnMgYXJlIHJ1bm5pbmcgbG93IG9uIGRpc2sgc3BhY2UuIFRoaXMgZmVhdHVyZSByZXF1aXJlcyBzcGVjaWZpYyBBV1MgcGVybWlzc2lvbnMgdG8gZnVuY3Rpb24gY29ycmVjdGx5IC0gcmVmZXIgdG8gQXV0b3NjYWxpbmcgbG9jYWwgc3RvcmFnZSBmb3IgZGV0YWlscy5cbiAgICpcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjRW5hYmxlRWxhc3RpY0Rpc2tcbiAgICovXG4gIHJlYWRvbmx5IGVuYWJsZUVsYXN0aWNEaXNrPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIG9wdGlvbmFsIElEIG9mIHRoZSBpbnN0YW5jZSBwb29sIHRvIHVzZSBmb3IgdGhlIGRyaXZlciBub2RlLiBZb3UgbXVzdCBhbHNvIHNwZWNpZnkgaW5zdGFuY2VfcG9vbF9pZC4gUmVmZXIgdG8gSW5zdGFuY2UgUG9vbHMgQVBJIDIuMCBmb3IgZGV0YWlscy5cbiAgICpcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjRHJpdmVySW5zdGFuY2VQb29sSWRcbiAgICovXG4gIHJlYWRvbmx5IGRyaXZlckluc3RhbmNlUG9vbElkPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgb3B0aW9uYWwgSUQgb2YgdGhlIGluc3RhbmNlIHBvb2wgdG8gdXNlIGZvciBjbHVzdGVyIG5vZGVzLiBJZiBkcml2ZXJfaW5zdGFuY2VfcG9vbF9pZCBpcyBwcmVzZW50LCBpbnN0YW5jZV9wb29sX2lkIGlzIHVzZWQgZm9yIHdvcmtlciBub2RlcyBvbmx5LiBPdGhlcndpc2UsIGl0IGlzIHVzZWQgZm9yIGJvdGggdGhlIGRyaXZlciBhbmQgd29ya2VyIG5vZGVzLiBSZWZlciB0byBJbnN0YW5jZSBQb29scyBBUEkgMi4wIGZvciBkZXRhaWxzLlxuICAgKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wcyNJbnN0YW5jZVBvb2xJZFxuICAgKi9cbiAgcmVhZG9ubHkgaW5zdGFuY2VQb29sSWQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEFuIG9wdGlvbmFsIHRva2VuIHRoYXQgY2FuIGJlIHVzZWQgdG8gZ3VhcmFudGVlIHRoZSBpZGVtcG90ZW5jeSBvZiBjbHVzdGVyIGNyZWF0aW9uIHJlcXVlc3RzLiBJZiB0aGUgaWRlbXBvdGVuY3kgdG9rZW4gaXMgYXNzaWduZWQgdG8gYSBjbHVzdGVyIHRoYXQgaXMgbm90IGluIHRoZSBURVJNSU5BVEVEIHN0YXRlLCB0aGUgcmVxdWVzdCBkb2VzIG5vdCBjcmVhdGUgYSBuZXcgY2x1c3RlciBidXQgaW5zdGVhZCByZXR1cm5zIHRoZSBJRCBvZiB0aGUgZXhpc3RpbmcgY2x1c3Rlci4gT3RoZXJ3aXNlLCBhIG5ldyBjbHVzdGVyIGlzIGNyZWF0ZWQuIFRoZSBpZGVtcG90ZW5jeSB0b2tlbiBpcyBjbGVhcmVkIHdoZW4gdGhlIGNsdXN0ZXIgaXMgdGVybWluYXRlZFxuICAgKlxuICAgKiBJZiB5b3Ugc3BlY2lmeSB0aGUgaWRlbXBvdGVuY3kgdG9rZW4sIHVwb24gZmFpbHVyZSB5b3UgY2FuIHJldHJ5IHVudGlsIHRoZSByZXF1ZXN0IHN1Y2NlZWRzLiBEYXRhYnJpY2tzIGd1YXJhbnRlZXMgdGhhdCBleGFjdGx5IG9uZSBjbHVzdGVyIHdpbGwgYmUgbGF1bmNoZWQgd2l0aCB0aGF0IGlkZW1wb3RlbmN5IHRva2VuLlxuICAgKlxuICAgKiBUaGlzIHRva2VuIHNob3VsZCBoYXZlIGF0IG1vc3QgNjQgY2hhcmFjdGVycy5cbiAgICpcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjSWRlbXBvdGVuY3lUb2tlblxuICAgKi9cbiAgcmVhZG9ubHkgaWRlbXBvdGVuY3lUb2tlbj86IHN0cmluZztcblxuICAvKipcbiAgICogV2hldGhlciB0byB1c2UgcG9saWN5IGRlZmF1bHQgdmFsdWVzIGZvciBtaXNzaW5nIGNsdXN0ZXIgYXR0cmlidXRlcy5cbiAgICpcbiAgICpcbiAgICpcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjQXBwbHlQb2xpY3lEZWZhdWx0VmFsdWVzXG4gICAqL1xuICByZWFkb25seSBhcHBseVBvbGljeURlZmF1bHRWYWx1ZXM/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIGVuY3J5cHRpb24gb2YgZGlza3MgbG9jYWxseSBhdHRhY2hlZCB0byB0aGUgY2x1c3RlciBpcyBlbmFibGVkLlxuICAgKlxuICAgKlxuICAgKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wcyNFbmFibGVMb2NhbERpc2tFbmNyeXB0aW9uXG4gICAqL1xuICByZWFkb25seSBlbmFibGVMb2NhbERpc2tFbmNyeXB0aW9uPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIHR5cGUgb2YgcnVudGltZSBlbmdpbmUgdG8gdXNlLiBJZiBub3Qgc3BlY2lmaWVkLCB0aGUgcnVudGltZSBlbmdpbmUgdHlwZSBpcyBpbmZlcnJlZCBiYXNlZCBvbiB0aGUgc3BhcmtfdmVyc2lvbiB2YWx1ZS4gQWxsb3dlZCB2YWx1ZXMgaW5jbHVkZTpcbiAgICpcbiAgICogUEhPVE9OOiBVc2UgdGhlIFBob3RvbiBydW50aW1lIGVuZ2luZSB0eXBlLlxuICAgKlxuICAgKiBTVEFOREFSRDogVXNlIHRoZSBzdGFuZGFyZCBydW50aW1lIGVuZ2luZSB0eXBlLlxuICAgKlxuICAgKiBUaGlzIGZpZWxkIGlzIG9wdGlvbmFsLlxuICAgKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wcyNSdW50aW1lRW5naW5lXG4gICAqL1xuICByZWFkb25seSBydW50aW1lRW5naW5lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wcyNDbHVzdGVyTWVtb3J5TWJcbiAgICovXG4gIHJlYWRvbmx5IGNsdXN0ZXJNZW1vcnlNYj86IG51bWJlcjtcblxuICAvKipcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjQ2x1c3RlckNvcmVzXG4gICAqL1xuICByZWFkb25seSBjbHVzdGVyQ29yZXM/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuQ2x1c3RlclByb3BzI0luc3RhbmNlU291cmNlXG4gICAqL1xuICByZWFkb25seSBpbnN0YW5jZVNvdXJjZT86IENmbkNsdXN0ZXJQcm9wc0luc3RhbmNlU291cmNlO1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wcyNEcml2ZXJcbiAgICovXG4gIHJlYWRvbmx5IGRyaXZlcj86IGFueTtcblxuICAvKipcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjRHJpdmVySW5zdGFuY2VTb3VyY2VcbiAgICovXG4gIHJlYWRvbmx5IGRyaXZlckluc3RhbmNlU291cmNlPzogQ2ZuQ2x1c3RlclByb3BzRHJpdmVySW5zdGFuY2VTb3VyY2U7XG5cbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuQ2x1c3RlclByb3BzI0NsdXN0ZXJTb3VyY2VcbiAgICovXG4gIHJlYWRvbmx5IGNsdXN0ZXJTb3VyY2U/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuQ2x1c3RlclByb3BzI0NyZWF0b3JVc2VyTmFtZVxuICAgKi9cbiAgcmVhZG9ubHkgY3JlYXRvclVzZXJOYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wcyNEZWZhdWx0VGFnc1xuICAgKi9cbiAgcmVhZG9ubHkgZGVmYXVsdFRhZ3M/OiBDZm5DbHVzdGVyUHJvcHNEZWZhdWx0VGFncztcblxuICAvKipcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHMjRWZmZWN0aXZlU3BhcmtWZXJzaW9uXG4gICAqL1xuICByZWFkb25seSBlZmZlY3RpdmVTcGFya1ZlcnNpb24/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuQ2x1c3RlclByb3BzI1N0YXJ0VGltZVxuICAgKi9cbiAgcmVhZG9ubHkgc3RhcnRUaW1lPzogbnVtYmVyO1xuXG59XG5cbi8qKlxuICogQ29udmVydHMgYW4gb2JqZWN0IG9mIHR5cGUgJ0NmbkNsdXN0ZXJQcm9wcycgdG8gSlNPTiByZXByZXNlbnRhdGlvbi5cbiAqL1xuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cbmV4cG9ydCBmdW5jdGlvbiB0b0pzb25fQ2ZuQ2x1c3RlclByb3BzKG9iajogQ2ZuQ2x1c3RlclByb3BzIHwgdW5kZWZpbmVkKTogUmVjb3JkPHN0cmluZywgYW55PiB8IHVuZGVmaW5lZCB7XG4gIGlmIChvYmogPT09IHVuZGVmaW5lZCkgeyByZXR1cm4gdW5kZWZpbmVkOyB9XG4gIGNvbnN0IHJlc3VsdCA9IHtcbiAgICAnTnVtV29ya2Vycyc6IG9iai5udW1Xb3JrZXJzLFxuICAgICdBdXRvc2NhbGUnOiB0b0pzb25fQXV0b3NjYWxlKG9iai5hdXRvc2NhbGUpLFxuICAgICdDbHVzdGVyTmFtZSc6IG9iai5jbHVzdGVyTmFtZSxcbiAgICAnU3BhcmtWZXJzaW9uJzogb2JqLnNwYXJrVmVyc2lvbixcbiAgICAnU3BhcmtDb25mJzogb2JqLnNwYXJrQ29uZixcbiAgICAnQXdzQXR0cmlidXRlcyc6IHRvSnNvbl9Bd3NBdHRyaWJ1dGVzKG9iai5hd3NBdHRyaWJ1dGVzKSxcbiAgICAnTm9kZVR5cGVJZCc6IG9iai5ub2RlVHlwZUlkLFxuICAgICdEcml2ZXJOb2RlVHlwZUlkJzogb2JqLmRyaXZlck5vZGVUeXBlSWQsXG4gICAgJ1NzaFB1YmxpY0tleXMnOiBvYmouc3NoUHVibGljS2V5cz8ubWFwKHkgPT4geSksXG4gICAgJ0N1c3RvbVRhZ3MnOiBvYmouY3VzdG9tVGFncyxcbiAgICAnSW5pdFNjcmlwdHMnOiBvYmouaW5pdFNjcmlwdHM/Lm1hcCh5ID0+IHRvSnNvbl9Jbml0U2NyaXB0c0xpc3RJdGVtKHkpKSxcbiAgICAnU3BhcmtFbnZWYXJzJzogb2JqLnNwYXJrRW52VmFycyxcbiAgICAnQXV0b3Rlcm1pbmF0aW9uTWludXRlcyc6IG9iai5hdXRvdGVybWluYXRpb25NaW51dGVzLFxuICAgICdFbmFibGVFbGFzdGljRGlzayc6IG9iai5lbmFibGVFbGFzdGljRGlzayxcbiAgICAnRHJpdmVySW5zdGFuY2VQb29sSWQnOiBvYmouZHJpdmVySW5zdGFuY2VQb29sSWQsXG4gICAgJ0luc3RhbmNlUG9vbElkJzogb2JqLmluc3RhbmNlUG9vbElkLFxuICAgICdJZGVtcG90ZW5jeVRva2VuJzogb2JqLmlkZW1wb3RlbmN5VG9rZW4sXG4gICAgJ0FwcGx5UG9saWN5RGVmYXVsdFZhbHVlcyc6IG9iai5hcHBseVBvbGljeURlZmF1bHRWYWx1ZXMsXG4gICAgJ0VuYWJsZUxvY2FsRGlza0VuY3J5cHRpb24nOiBvYmouZW5hYmxlTG9jYWxEaXNrRW5jcnlwdGlvbixcbiAgICAnUnVudGltZUVuZ2luZSc6IG9iai5ydW50aW1lRW5naW5lLFxuICAgICdDbHVzdGVyTWVtb3J5TWInOiBvYmouY2x1c3Rlck1lbW9yeU1iLFxuICAgICdDbHVzdGVyQ29yZXMnOiBvYmouY2x1c3RlckNvcmVzLFxuICAgICdJbnN0YW5jZVNvdXJjZSc6IHRvSnNvbl9DZm5DbHVzdGVyUHJvcHNJbnN0YW5jZVNvdXJjZShvYmouaW5zdGFuY2VTb3VyY2UpLFxuICAgICdEcml2ZXInOiBvYmouZHJpdmVyLFxuICAgICdEcml2ZXJJbnN0YW5jZVNvdXJjZSc6IHRvSnNvbl9DZm5DbHVzdGVyUHJvcHNEcml2ZXJJbnN0YW5jZVNvdXJjZShvYmouZHJpdmVySW5zdGFuY2VTb3VyY2UpLFxuICAgICdDbHVzdGVyU291cmNlJzogb2JqLmNsdXN0ZXJTb3VyY2UsXG4gICAgJ0NyZWF0b3JVc2VyTmFtZSc6IG9iai5jcmVhdG9yVXNlck5hbWUsXG4gICAgJ0RlZmF1bHRUYWdzJzogdG9Kc29uX0NmbkNsdXN0ZXJQcm9wc0RlZmF1bHRUYWdzKG9iai5kZWZhdWx0VGFncyksXG4gICAgJ0VmZmVjdGl2ZVNwYXJrVmVyc2lvbic6IG9iai5lZmZlY3RpdmVTcGFya1ZlcnNpb24sXG4gICAgJ1N0YXJ0VGltZSc6IG9iai5zdGFydFRpbWUsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4vKiBlc2xpbnQtZW5hYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5cbi8qKlxuICogUmFuZ2UgZGVmaW5pbmcgdGhlIG1pbiBhbmQgbWF4IG51bWJlciBvZiBjbHVzdGVyIHdvcmtlcnNcbiAqXG4gKiBAc2NoZW1hIEF1dG9zY2FsZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEF1dG9zY2FsZSB7XG4gIC8qKlxuICAgKiBUaGUgbWluaW11bSBudW1iZXIgb2Ygd29ya2VycyB0byB3aGljaCB0aGUgY2x1c3RlciBjYW4gc2NhbGUgZG93biB3aGVuIHVuZGVydXRpbGl6ZWQuIEl0IGlzIGFsc28gdGhlIGluaXRpYWwgbnVtYmVyIG9mIHdvcmtlcnMgdGhlIGNsdXN0ZXIgd2lsbCBoYXZlIGFmdGVyIGNyZWF0aW9uLlxuICAgKlxuICAgKiBAc2NoZW1hIEF1dG9zY2FsZSNNaW5Xb3JrZXJzXG4gICAqL1xuICByZWFkb25seSBtaW5Xb3JrZXJzOiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBtYXhpbXVtIG51bWJlciBvZiB3b3JrZXJzIHRvIHdoaWNoIHRoZSBjbHVzdGVyIGNhbiBzY2FsZSB1cCB3aGVuIG92ZXJsb2FkZWQuIG1heF93b3JrZXJzIG11c3QgYmUgc3RyaWN0bHkgZ3JlYXRlciB0aGFuIG1pbl93b3JrZXJzLlxuICAgKlxuICAgKiBAc2NoZW1hIEF1dG9zY2FsZSNNYXhXb3JrZXJzXG4gICAqL1xuICByZWFkb25seSBtYXhXb3JrZXJzOiBudW1iZXI7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnQXV0b3NjYWxlJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9BdXRvc2NhbGUob2JqOiBBdXRvc2NhbGUgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdNaW5Xb3JrZXJzJzogb2JqLm1pbldvcmtlcnMsXG4gICAgJ01heFdvcmtlcnMnOiBvYmoubWF4V29ya2VycyxcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbi8qIGVzbGludC1lbmFibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cblxuLyoqXG4gKiBBdHRyaWJ1dGVzIHNldCBkdXJpbmcgY2x1c3RlciBjcmVhdGlvbiByZWxhdGVkIHRvIEFtYXpvbiBXZWIgU2VydmljZXMuXG4gKlxuICogQHNjaGVtYSBBd3NBdHRyaWJ1dGVzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQXdzQXR0cmlidXRlcyB7XG4gIC8qKlxuICAgKiBUaGUgZmlyc3QgZmlyc3Rfb25fZGVtYW5kIG5vZGVzIG9mIHRoZSBjbHVzdGVyIHdpbGwgYmUgcGxhY2VkIG9uIG9uLWRlbWFuZCBpbnN0YW5jZXMuIElmIHRoaXMgdmFsdWUgaXMgZ3JlYXRlciB0aGFuIDAsIHRoZSBjbHVzdGVyIGRyaXZlciBub2RlIHdpbGwgYmUgcGxhY2VkIG9uIGFuIG9uLWRlbWFuZCBpbnN0YW5jZS4gSWYgdGhpcyB2YWx1ZSBpcyBncmVhdGVyIHRoYW4gb3IgZXF1YWwgdG8gdGhlIGN1cnJlbnQgY2x1c3RlciBzaXplLCBhbGwgbm9kZXMgd2lsbCBiZSBwbGFjZWQgb24gb24tZGVtYW5kIGluc3RhbmNlcy4gSWYgdGhpcyB2YWx1ZSBpcyBsZXNzIHRoYW4gdGhlIGN1cnJlbnQgY2x1c3RlciBzaXplLCBmaXJzdF9vbl9kZW1hbmQgbm9kZXMgd2lsbCBiZSBwbGFjZWQgb24gb24tZGVtYW5kIGluc3RhbmNlcyBhbmQgdGhlIHJlbWFpbmRlciB3aWxsIGJlIHBsYWNlZCBvbiBhdmFpbGFiaWxpdHkgaW5zdGFuY2VzLiBUaGlzIHZhbHVlIGRvZXMgbm90IGFmZmVjdCBjbHVzdGVyIHNpemUgYW5kIGNhbm5vdCBiZSBtdXRhdGVkIG92ZXIgdGhlIGxpZmV0aW1lIG9mIGEgY2x1c3Rlci5cbiAgICpcbiAgICogQHNjaGVtYSBBd3NBdHRyaWJ1dGVzI0ZpcnN0T25EZW1hbmRcbiAgICovXG4gIHJlYWRvbmx5IGZpcnN0T25EZW1hbmQ/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIEF2YWlsYWJpbGl0eSB0eXBlIHVzZWQgZm9yIGFsbCBzdWJzZXF1ZW50IG5vZGVzIHBhc3QgdGhlIGZpcnN0X29uX2RlbWFuZCBvbmVzLiBOb3RlOiBJZiBmaXJzdF9vbl9kZW1hbmQgaXMgemVybywgdGhpcyBhdmFpbGFiaWxpdHkgdHlwZSB3aWxsIGJlIHVzZWQgZm9yIHRoZSBlbnRpcmUgY2x1c3Rlci5cbiAgICpcbiAgICogQHNjaGVtYSBBd3NBdHRyaWJ1dGVzI0F2YWlsYWJpbGl0eVxuICAgKi9cbiAgcmVhZG9ubHkgYXZhaWxhYmlsaXR5PzogQXdzQXR0cmlidXRlc0F2YWlsYWJpbGl0eTtcblxuICAvKipcbiAgICogSWRlbnRpZmllciBmb3IgdGhlIGF2YWlsYWJpbGl0eSB6b25lL2RhdGFjZW50ZXIgaW4gd2hpY2ggdGhlIGNsdXN0ZXIgcmVzaWRlcy4gWW91IGhhdmUgdGhyZWUgb3B0aW9uczpcbiAgICpcbiAgICogU3BlY2lmeSBhbiBhdmFpbGFiaWxpdHkgem9uZSBhcyBhIHN0cmluZywgZm9yIGV4YW1wbGU6ICd1cy13ZXN0LTJhJy4gVGhlIHByb3ZpZGVkIGF2YWlsYWJpbGl0eSB6b25lIG11c3QgYmUgaW4gdGhlIHNhbWUgcmVnaW9uIGFzIHRoZSBEYXRhYnJpY2tzIGRlcGxveW1lbnQuIEZvciBleGFtcGxlLCAndXMtd2VzdC0yYScgaXMgbm90IGEgdmFsaWQgem9uZSBJRCBpZiB0aGUgRGF0YWJyaWNrcyBkZXBsb3ltZW50IHJlc2lkZXMgaW4gdGhlICd1cy1lYXN0LTEnIHJlZ2lvbi5cbiAgICpcbiAgICogRW5hYmxlIGF1dG9tYXRpYyBhdmFpbGFiaWxpdHkgem9uZSBzZWxlY3Rpb24gKCdBdXRvLUFaJyksIGJ5IHNldHRpbmcgdGhlIHZhbHVlICdhdXRvJy4gRGF0YWJyaWNrcyBzZWxlY3RzIHRoZSBBWiBiYXNlZCBvbiBhdmFpbGFibGUgSVBzIGluIHRoZSB3b3Jrc3BhY2Ugc3VibmV0cyBhbmQgcmV0cmllcyBpbiBvdGhlciBhdmFpbGFiaWxpdHkgem9uZXMgaWYgQVdTIHJldHVybnMgaW5zdWZmaWNpZW50IGNhcGFjaXR5IGVycm9ycy5cbiAgICpcbiAgICogRG8gbm90IHNwZWNpZnkgYSB2YWx1ZS4gSWYgbm90IHNwZWNpZmllZCwgYSBkZWZhdWx0IHpvbmUgd2lsbCBiZSB1c2VkLlxuICAgKlxuICAgKiBAc2NoZW1hIEF3c0F0dHJpYnV0ZXMjWm9uZUlkXG4gICAqL1xuICByZWFkb25seSB6b25lSWQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBtYXggcHJpY2UgZm9yIEFXUyBzcG90IGluc3RhbmNlcywgYXMgYSBwZXJjZW50YWdlIG9mIHRoZSBjb3JyZXNwb25kaW5nIGluc3RhbmNlIHR5cGUncyBvbi1kZW1hbmQgcHJpY2UuIEZvciBleGFtcGxlLCBpZiB0aGlzIGZpZWxkIGlzIHNldCB0byA1MCwgYW5kIHRoZSBjbHVzdGVyIG5lZWRzIGEgbmV3IGkzLnhsYXJnZSBzcG90IGluc3RhbmNlLCB0aGVuIHRoZSBtYXggcHJpY2UgaXMgaGFsZiBvZiB0aGUgcHJpY2Ugb2Ygb24tZGVtYW5kIGkzLnhsYXJnZSBpbnN0YW5jZXMuIFNpbWlsYXJseSwgaWYgdGhpcyBmaWVsZCBpcyBzZXQgdG8gMjAwLCB0aGUgbWF4IHByaWNlIGlzIHR3aWNlIHRoZSBwcmljZSBvZiBvbi1kZW1hbmQgaTMueGxhcmdlIGluc3RhbmNlcy4gSWYgbm90IHNwZWNpZmllZCwgdGhlIGRlZmF1bHQgdmFsdWUgaXMgMTAwLiBXaGVuIHNwb3QgaW5zdGFuY2VzIGFyZSByZXF1ZXN0ZWQgZm9yIHRoaXMgY2x1c3Rlciwgb25seSBzcG90IGluc3RhbmNlcyB3aG9zZSBtYXggcHJpY2UgcGVyY2VudGFnZSBtYXRjaGVzIHRoaXMgZmllbGQgd2lsbCBiZSBjb25zaWRlcmVkLiBGb3Igc2FmZXR5LCB3ZSBlbmZvcmNlIHRoaXMgZmllbGQgdG8gYmUgbm8gbW9yZSB0aGFuIDEwMDAwLlxuICAgKlxuICAgKiBAc2NoZW1hIEF3c0F0dHJpYnV0ZXMjU3BvdEJpZFByaWNlUGVyY2VudFxuICAgKi9cbiAgcmVhZG9ubHkgc3BvdEJpZFByaWNlUGVyY2VudD86IG51bWJlcjtcblxuICAvKipcbiAgICogVGhlIHR5cGUgb2YgRUJTIHZvbHVtZXMgdGhhdCB3aWxsIGJlIGxhdW5jaGVkIHdpdGggdGhpcyBjbHVzdGVyLlxuICAgKlxuICAgKiBAc2NoZW1hIEF3c0F0dHJpYnV0ZXMjRWJzVm9sdW1lVHlwZVxuICAgKi9cbiAgcmVhZG9ubHkgZWJzVm9sdW1lVHlwZT86IEF3c0F0dHJpYnV0ZXNFYnNWb2x1bWVUeXBlO1xuXG4gIC8qKlxuICAgKiBUaGUgbnVtYmVyIG9mIHZvbHVtZXMgbGF1bmNoZWQgZm9yIGVhY2ggaW5zdGFuY2UuIFlvdSBjYW4gY2hvb3NlIHVwIHRvIDEwIHZvbHVtZXMuIFRoaXMgZmVhdHVyZSBpcyBvbmx5IGVuYWJsZWQgZm9yIHN1cHBvcnRlZCBub2RlIHR5cGVzLiBMZWdhY3kgbm9kZSB0eXBlcyBjYW5ub3Qgc3BlY2lmeSBjdXN0b20gRUJTIHZvbHVtZXMuIEZvciBub2RlIHR5cGVzIHdpdGggbm8gaW5zdGFuY2Ugc3RvcmUsIGF0IGxlYXN0IG9uZSBFQlMgdm9sdW1lIG5lZWRzIHRvIGJlIHNwZWNpZmllZDsgb3RoZXJ3aXNlLCBjbHVzdGVyIGNyZWF0aW9uIHdpbGwgZmFpbC5cbiAgICpcbiAgICogVGhlc2UgRUJTIHZvbHVtZXMgd2lsbCBiZSBtb3VudGVkIGF0IC9lYnMwLCAvZWJzMSwgYW5kIGV0Yy4gSW5zdGFuY2Ugc3RvcmUgdm9sdW1lcyB3aWxsIGJlIG1vdW50ZWQgYXQgL2xvY2FsX2Rpc2swLCAvbG9jYWxfZGlzazEsIGFuZCBldGMuXG4gICAqXG4gICAqIElmIEVCUyB2b2x1bWVzIGFyZSBhdHRhY2hlZCwgRGF0YWJyaWNrcyB3aWxsIGNvbmZpZ3VyZSBTcGFyayB0byB1c2Ugb25seSB0aGUgRUJTIHZvbHVtZXMgZm9yIHNjcmF0Y2ggc3RvcmFnZSBiZWNhdXNlIGhldGVyb2dlbmVvdXNseSBzaXplZCBzY3JhdGNoIGRldmljZXMgY2FuIGxlYWQgdG8gaW5lZmZpY2llbnQgZGlzayB1dGlsaXphdGlvbi4gSWYgbm8gRUJTIHZvbHVtZXMgYXJlIGF0dGFjaGVkLCBEYXRhYnJpY2tzIHdpbGwgY29uZmlndXJlIFNwYXJrIHRvIHVzZSBpbnN0YW5jZSBzdG9yZSB2b2x1bWVzLlxuICAgKlxuICAgKiBJZiBFQlMgdm9sdW1lcyBhcmUgc3BlY2lmaWVkLCB0aGVuIHRoZSBTcGFyayBjb25maWd1cmF0aW9uIHNwYXJrLmxvY2FsLmRpciB3aWxsIGJlIG92ZXJyaWRkZW4uXG4gICAqXG4gICAqIEBzY2hlbWEgQXdzQXR0cmlidXRlcyNFYnNWb2x1bWVDb3VudFxuICAgKi9cbiAgcmVhZG9ubHkgZWJzVm9sdW1lQ291bnQ/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBzaXplIG9mIGVhY2ggRUJTIHZvbHVtZSAoaW4gR2lCKSBsYXVuY2hlZCBmb3IgZWFjaCBpbnN0YW5jZS4gRm9yIGdlbmVyYWwgcHVycG9zZSBTU0QsIHRoaXMgdmFsdWUgbXVzdCBiZSB3aXRoaW4gdGhlIHJhbmdlIDEwMCAtIDQwOTYuIEZvciB0aHJvdWdocHV0IG9wdGltaXplZCBIREQsIHRoaXMgdmFsdWUgbXVzdCBiZSB3aXRoaW4gdGhlIHJhbmdlIDUwMCAtIDQwOTYuIEN1c3RvbSBFQlMgdm9sdW1lcyBjYW5ub3QgYmUgc3BlY2lmaWVkIGZvciB0aGUgbGVnYWN5IG5vZGUgdHlwZXMgKG1lbW9yeS1vcHRpbWl6ZWQgYW5kIGNvbXB1dGUtb3B0aW1pemVkKS5cbiAgICpcbiAgICogQHNjaGVtYSBBd3NBdHRyaWJ1dGVzI0Vic1ZvbHVtZVNpemVcbiAgICovXG4gIHJlYWRvbmx5IGVic1ZvbHVtZVNpemU/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBudW1iZXIgb2YgSU9QUyBwZXIgRUJTIGdwMyB2b2x1bWUuXG4gICAqXG4gICAqIFRoaXMgdmFsdWUgbXVzdCBiZSBiZXR3ZWVuIDMwMDAgYW5kIDE2MDAwLlxuICAgKlxuICAgKiBUaGUgdmFsdWUgb2YgSU9QUyBhbmQgdGhyb3VnaHB1dCBpcyBjYWxjdWxhdGVkIGJhc2VkIG9uIEFXUyBkb2N1bWVudGF0aW9uIHRvIG1hdGNoIHRoZSBtYXhpbXVtIHBlcmZvcm1hbmNlIG9mIGEgZ3AyIHZvbHVtZSB3aXRoIHRoZSBzYW1lIHZvbHVtZSBzaXplLlxuICAgKlxuICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIHRoZSBFQlMgdm9sdW1lIGxpbWl0IGNhbGN1bGF0b3IuXG4gICAqXG4gICAqIEBzY2hlbWEgQXdzQXR0cmlidXRlcyNFYnNWb2x1bWVJb3BzXG4gICAqL1xuICByZWFkb25seSBlYnNWb2x1bWVJb3BzPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgdGhyb3VnaHB1dCBwZXIgRUJTIGdwMyB2b2x1bWUsIGluIE1pQiBwZXIgc2Vjb25kLlxuICAgKlxuICAgKiBUaGlzIHZhbHVlIG11c3QgYmUgYmV0d2VlbiAxMjUgYW5kIDEwMDAuXG4gICAqXG4gICAqIEBzY2hlbWEgQXdzQXR0cmlidXRlcyNFYnNWb2x1bWVUaHJvdWdocHV0XG4gICAqL1xuICByZWFkb25seSBlYnNWb2x1bWVUaHJvdWdocHV0PzogbnVtYmVyO1xuXG59XG5cbi8qKlxuICogQ29udmVydHMgYW4gb2JqZWN0IG9mIHR5cGUgJ0F3c0F0dHJpYnV0ZXMnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX0F3c0F0dHJpYnV0ZXMob2JqOiBBd3NBdHRyaWJ1dGVzIHwgdW5kZWZpbmVkKTogUmVjb3JkPHN0cmluZywgYW55PiB8IHVuZGVmaW5lZCB7XG4gIGlmIChvYmogPT09IHVuZGVmaW5lZCkgeyByZXR1cm4gdW5kZWZpbmVkOyB9XG4gIGNvbnN0IHJlc3VsdCA9IHtcbiAgICAnRmlyc3RPbkRlbWFuZCc6IG9iai5maXJzdE9uRGVtYW5kLFxuICAgICdBdmFpbGFiaWxpdHknOiBvYmouYXZhaWxhYmlsaXR5LFxuICAgICdab25lSWQnOiBvYmouem9uZUlkLFxuICAgICdTcG90QmlkUHJpY2VQZXJjZW50Jzogb2JqLnNwb3RCaWRQcmljZVBlcmNlbnQsXG4gICAgJ0Vic1ZvbHVtZVR5cGUnOiBvYmouZWJzVm9sdW1lVHlwZSxcbiAgICAnRWJzVm9sdW1lQ291bnQnOiBvYmouZWJzVm9sdW1lQ291bnQsXG4gICAgJ0Vic1ZvbHVtZVNpemUnOiBvYmouZWJzVm9sdW1lU2l6ZSxcbiAgICAnRWJzVm9sdW1lSW9wcyc6IG9iai5lYnNWb2x1bWVJb3BzLFxuICAgICdFYnNWb2x1bWVUaHJvdWdocHV0Jzogb2JqLmVic1ZvbHVtZVRocm91Z2hwdXQsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4vKiBlc2xpbnQtZW5hYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5cbi8qKlxuICogQHNjaGVtYSBJbml0U2NyaXB0c0xpc3RJdGVtXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSW5pdFNjcmlwdHNMaXN0SXRlbSB7XG4gIC8qKlxuICAgKiBAc2NoZW1hIEluaXRTY3JpcHRzTGlzdEl0ZW0jUzNcbiAgICovXG4gIHJlYWRvbmx5IHMzPzogUzNEZXN0aW5hdGlvbjtcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdJbml0U2NyaXB0c0xpc3RJdGVtJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9Jbml0U2NyaXB0c0xpc3RJdGVtKG9iajogSW5pdFNjcmlwdHNMaXN0SXRlbSB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ1MzJzogdG9Kc29uX1MzRGVzdGluYXRpb24ob2JqLnMzKSxcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbi8qIGVzbGludC1lbmFibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cblxuLyoqXG4gKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wc0luc3RhbmNlU291cmNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuQ2x1c3RlclByb3BzSW5zdGFuY2VTb3VyY2Uge1xuICAvKipcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHNJbnN0YW5jZVNvdXJjZSNJbnN0YW5jZVBvb2xJZFxuICAgKi9cbiAgcmVhZG9ubHkgaW5zdGFuY2VQb29sSWQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuQ2x1c3RlclByb3BzSW5zdGFuY2VTb3VyY2UjTm9kZVR5cGVJZFxuICAgKi9cbiAgcmVhZG9ubHkgbm9kZVR5cGVJZD86IHN0cmluZztcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdDZm5DbHVzdGVyUHJvcHNJbnN0YW5jZVNvdXJjZScgdG8gSlNPTiByZXByZXNlbnRhdGlvbi5cbiAqL1xuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cbmV4cG9ydCBmdW5jdGlvbiB0b0pzb25fQ2ZuQ2x1c3RlclByb3BzSW5zdGFuY2VTb3VyY2Uob2JqOiBDZm5DbHVzdGVyUHJvcHNJbnN0YW5jZVNvdXJjZSB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ0luc3RhbmNlUG9vbElkJzogb2JqLmluc3RhbmNlUG9vbElkLFxuICAgICdOb2RlVHlwZUlkJzogb2JqLm5vZGVUeXBlSWQsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4vKiBlc2xpbnQtZW5hYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5cbi8qKlxuICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHNEcml2ZXJJbnN0YW5jZVNvdXJjZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkNsdXN0ZXJQcm9wc0RyaXZlckluc3RhbmNlU291cmNlIHtcbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuQ2x1c3RlclByb3BzRHJpdmVySW5zdGFuY2VTb3VyY2UjSW5zdGFuY2VQb29sSWRcbiAgICovXG4gIHJlYWRvbmx5IGluc3RhbmNlUG9vbElkPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wc0RyaXZlckluc3RhbmNlU291cmNlI05vZGVUeXBlSWRcbiAgICovXG4gIHJlYWRvbmx5IG5vZGVUeXBlSWQ/OiBzdHJpbmc7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnQ2ZuQ2x1c3RlclByb3BzRHJpdmVySW5zdGFuY2VTb3VyY2UnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX0NmbkNsdXN0ZXJQcm9wc0RyaXZlckluc3RhbmNlU291cmNlKG9iajogQ2ZuQ2x1c3RlclByb3BzRHJpdmVySW5zdGFuY2VTb3VyY2UgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdJbnN0YW5jZVBvb2xJZCc6IG9iai5pbnN0YW5jZVBvb2xJZCxcbiAgICAnTm9kZVR5cGVJZCc6IG9iai5ub2RlVHlwZUlkLFxuICB9O1xuICAvLyBmaWx0ZXIgdW5kZWZpbmVkIHZhbHVlc1xuICByZXR1cm4gT2JqZWN0LmVudHJpZXMocmVzdWx0KS5yZWR1Y2UoKHIsIGkpID0+IChpWzFdID09PSB1bmRlZmluZWQpID8gciA6ICh7IC4uLnIsIFtpWzBdXTogaVsxXSB9KSwge30pO1xufVxuLyogZXNsaW50LWVuYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuXG4vKipcbiAqIEBzY2hlbWEgQ2ZuQ2x1c3RlclByb3BzRGVmYXVsdFRhZ3NcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5DbHVzdGVyUHJvcHNEZWZhdWx0VGFncyB7XG4gIC8qKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wc0RlZmF1bHRUYWdzI0NsdXN0ZXJJZFxuICAgKi9cbiAgcmVhZG9ubHkgY2x1c3RlcklkPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wc0RlZmF1bHRUYWdzI0NsdXN0ZXJOYW1lXG4gICAqL1xuICByZWFkb25seSBjbHVzdGVyTmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogQHNjaGVtYSBDZm5DbHVzdGVyUHJvcHNEZWZhdWx0VGFncyNDcmVhdG9yXG4gICAqL1xuICByZWFkb25seSBjcmVhdG9yPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIENmbkNsdXN0ZXJQcm9wc0RlZmF1bHRUYWdzI1ZlbmRvclxuICAgKi9cbiAgcmVhZG9ubHkgdmVuZG9yPzogc3RyaW5nO1xuXG59XG5cbi8qKlxuICogQ29udmVydHMgYW4gb2JqZWN0IG9mIHR5cGUgJ0NmbkNsdXN0ZXJQcm9wc0RlZmF1bHRUYWdzJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9DZm5DbHVzdGVyUHJvcHNEZWZhdWx0VGFncyhvYmo6IENmbkNsdXN0ZXJQcm9wc0RlZmF1bHRUYWdzIHwgdW5kZWZpbmVkKTogUmVjb3JkPHN0cmluZywgYW55PiB8IHVuZGVmaW5lZCB7XG4gIGlmIChvYmogPT09IHVuZGVmaW5lZCkgeyByZXR1cm4gdW5kZWZpbmVkOyB9XG4gIGNvbnN0IHJlc3VsdCA9IHtcbiAgICAnQ2x1c3RlcklkJzogb2JqLmNsdXN0ZXJJZCxcbiAgICAnQ2x1c3Rlck5hbWUnOiBvYmouY2x1c3Rlck5hbWUsXG4gICAgJ0NyZWF0b3InOiBvYmouY3JlYXRvcixcbiAgICAnVmVuZG9yJzogb2JqLnZlbmRvcixcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbi8qIGVzbGludC1lbmFibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cblxuLyoqXG4gKiBBdmFpbGFiaWxpdHkgdHlwZSB1c2VkIGZvciBhbGwgc3Vic2VxdWVudCBub2RlcyBwYXN0IHRoZSBmaXJzdF9vbl9kZW1hbmQgb25lcy4gTm90ZTogSWYgZmlyc3Rfb25fZGVtYW5kIGlzIHplcm8sIHRoaXMgYXZhaWxhYmlsaXR5IHR5cGUgd2lsbCBiZSB1c2VkIGZvciB0aGUgZW50aXJlIGNsdXN0ZXIuXG4gKlxuICogQHNjaGVtYSBBd3NBdHRyaWJ1dGVzQXZhaWxhYmlsaXR5XG4gKi9cbmV4cG9ydCBlbnVtIEF3c0F0dHJpYnV0ZXNBdmFpbGFiaWxpdHkge1xuICAvKiogU1BPVCAqL1xuICBTUE9UID0gXCJTUE9UXCIsXG4gIC8qKiBPTl9ERU1BTkQgKi9cbiAgT05fREVNQU5EID0gXCJPTl9ERU1BTkRcIixcbiAgLyoqIFNQT1RfV0lUSF9GQUxMQkFDSyAqL1xuICBTUE9UX1dJVEhfRkFMTEJBQ0sgPSBcIlNQT1RfV0lUSF9GQUxMQkFDS1wiLFxufVxuXG4vKipcbiAqIFRoZSB0eXBlIG9mIEVCUyB2b2x1bWVzIHRoYXQgd2lsbCBiZSBsYXVuY2hlZCB3aXRoIHRoaXMgY2x1c3Rlci5cbiAqXG4gKiBAc2NoZW1hIEF3c0F0dHJpYnV0ZXNFYnNWb2x1bWVUeXBlXG4gKi9cbmV4cG9ydCBlbnVtIEF3c0F0dHJpYnV0ZXNFYnNWb2x1bWVUeXBlIHtcbiAgLyoqIEdFTkVSQUxfUFVSUE9TRV9TU0QgKi9cbiAgR0VORVJBTF9QVVJQT1NFX1NTRCA9IFwiR0VORVJBTF9QVVJQT1NFX1NTRFwiLFxuICAvKiogVEhST1VHSFBVVF9PUFRJTUlaRURfSEREICovXG4gIFRIUk9VR0hQVVRfT1BUSU1JWkVEX0hERCA9IFwiVEhST1VHSFBVVF9PUFRJTUlaRURfSEREXCIsXG59XG5cbi8qKlxuICogQHNjaGVtYSBTM2Rlc3RpbmF0aW9uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUzNEZXN0aW5hdGlvbiB7XG4gIC8qKlxuICAgKiBAc2NoZW1hIFMzZGVzdGluYXRpb24jRGVzdGluYXRpb25cbiAgICovXG4gIHJlYWRvbmx5IGRlc3RpbmF0aW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIFMzZGVzdGluYXRpb24jUmVnaW9uXG4gICAqL1xuICByZWFkb25seSByZWdpb24/OiBzdHJpbmc7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnUzNEZXN0aW5hdGlvbicgdG8gSlNPTiByZXByZXNlbnRhdGlvbi5cbiAqL1xuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cbmV4cG9ydCBmdW5jdGlvbiB0b0pzb25fUzNEZXN0aW5hdGlvbihvYmo6IFMzRGVzdGluYXRpb24gfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdEZXN0aW5hdGlvbic6IG9iai5kZXN0aW5hdGlvbixcbiAgICAnUmVnaW9uJzogb2JqLnJlZ2lvbixcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbi8qIGVzbGludC1lbmFibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cblxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYERhdGFicmlja3M6OkNsdXN0ZXJzOjpDbHVzdGVyYFxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIERhdGFicmlja3M6OkNsdXN0ZXJzOjpDbHVzdGVyXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKiBAbGluayBodHRwczovL2dpdGh1Yi5jb20vYXdzLWlhL2Nsb3VkZm9ybWF0aW9uLWRhdGFicmlja3MtcmVzb3VyY2UtcHJvdmlkZXJzLmdpdFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuQ2x1c3RlciBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSB7XG4gIC8qKlxuICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiRGF0YWJyaWNrczo6Q2x1c3RlcnM6OkNsdXN0ZXJcIjtcblxuICAvKipcbiAgICogUmVzb3VyY2UgcHJvcHMuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgcHJvcHM6IENmbkNsdXN0ZXJQcm9wcztcblxuICAvKipcbiAgICogQXR0cmlidXRlIGBEYXRhYnJpY2tzOjpDbHVzdGVyczo6Q2x1c3Rlci5DbHVzdGVySWRgXG4gICAqIEBsaW5rIGh0dHBzOi8vZ2l0aHViLmNvbS9hd3MtaWEvY2xvdWRmb3JtYXRpb24tZGF0YWJyaWNrcy1yZXNvdXJjZS1wcm92aWRlcnMuZ2l0XG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgYXR0ckNsdXN0ZXJJZDogc3RyaW5nO1xuICAvKipcbiAgICogQXR0cmlidXRlIGBEYXRhYnJpY2tzOjpDbHVzdGVyczo6Q2x1c3Rlci5TdGF0ZWBcbiAgICogQGxpbmsgaHR0cHM6Ly9naXRodWIuY29tL2F3cy1pYS9jbG91ZGZvcm1hdGlvbi1kYXRhYnJpY2tzLXJlc291cmNlLXByb3ZpZGVycy5naXRcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBhdHRyU3RhdGU6IHN0cmluZztcbiAgLyoqXG4gICAqIEF0dHJpYnV0ZSBgRGF0YWJyaWNrczo6Q2x1c3RlcnM6OkNsdXN0ZXIuU3RhdGVNZXNzYWdlYFxuICAgKiBAbGluayBodHRwczovL2dpdGh1Yi5jb20vYXdzLWlhL2Nsb3VkZm9ybWF0aW9uLWRhdGFicmlja3MtcmVzb3VyY2UtcHJvdmlkZXJzLmdpdFxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGF0dHJTdGF0ZU1lc3NhZ2U6IHN0cmluZztcbiAgLyoqXG4gICAqIEF0dHJpYnV0ZSBgRGF0YWJyaWNrczo6Q2x1c3RlcnM6OkNsdXN0ZXIuTGFzdFN0YXRlTG9zc1RpbWVgXG4gICAqIEBsaW5rIGh0dHBzOi8vZ2l0aHViLmNvbS9hd3MtaWEvY2xvdWRmb3JtYXRpb24tZGF0YWJyaWNrcy1yZXNvdXJjZS1wcm92aWRlcnMuZ2l0XG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgYXR0ckxhc3RTdGF0ZUxvc3NUaW1lOiBudW1iZXI7XG4gIC8qKlxuICAgKiBBdHRyaWJ1dGUgYERhdGFicmlja3M6OkNsdXN0ZXJzOjpDbHVzdGVyLkxhc3RBY3Rpdml0eVRpbWVgXG4gICAqIEBsaW5rIGh0dHBzOi8vZ2l0aHViLmNvbS9hd3MtaWEvY2xvdWRmb3JtYXRpb24tZGF0YWJyaWNrcy1yZXNvdXJjZS1wcm92aWRlcnMuZ2l0XG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgYXR0ckxhc3RBY3Rpdml0eVRpbWU6IG51bWJlcjtcbiAgLyoqXG4gICAqIEF0dHJpYnV0ZSBgRGF0YWJyaWNrczo6Q2x1c3RlcnM6OkNsdXN0ZXIuTGFzdFJlc3RhcnRlZFRpbWVgXG4gICAqIEBsaW5rIGh0dHBzOi8vZ2l0aHViLmNvbS9hd3MtaWEvY2xvdWRmb3JtYXRpb24tZGF0YWJyaWNrcy1yZXNvdXJjZS1wcm92aWRlcnMuZ2l0XG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgYXR0ckxhc3RSZXN0YXJ0ZWRUaW1lOiBudW1iZXI7XG4gIC8qKlxuICAgKiBBdHRyaWJ1dGUgYERhdGFicmlja3M6OkNsdXN0ZXJzOjpDbHVzdGVyLkluaXRTY3JpcHRzU2FmZU1vZGVgXG4gICAqIEBsaW5rIGh0dHBzOi8vZ2l0aHViLmNvbS9hd3MtaWEvY2xvdWRmb3JtYXRpb24tZGF0YWJyaWNrcy1yZXNvdXJjZS1wcm92aWRlcnMuZ2l0XG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgYXR0ckluaXRTY3JpcHRzU2FmZU1vZGU6IGNkay5JUmVzb2x2YWJsZTtcblxuICAvKipcbiAgICogQ3JlYXRlIGEgbmV3IGBEYXRhYnJpY2tzOjpDbHVzdGVyczo6Q2x1c3RlcmAuXG4gICAqXG4gICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICovXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjb25zdHJ1Y3RzLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbkNsdXN0ZXJQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBDZm5DbHVzdGVyLkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHRvSnNvbl9DZm5DbHVzdGVyUHJvcHMocHJvcHMpISB9KTtcblxuICAgIHRoaXMucHJvcHMgPSBwcm9wcztcblxuICAgIHRoaXMuYXR0ckNsdXN0ZXJJZCA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnQ2x1c3RlcklkJykpO1xuICAgIHRoaXMuYXR0clN0YXRlID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdTdGF0ZScpKTtcbiAgICB0aGlzLmF0dHJTdGF0ZU1lc3NhZ2UgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ1N0YXRlTWVzc2FnZScpKTtcbiAgICB0aGlzLmF0dHJMYXN0U3RhdGVMb3NzVGltZSA9IGNkay5Ub2tlbi5hc051bWJlcih0aGlzLmdldEF0dCgnTGFzdFN0YXRlTG9zc1RpbWUnKSk7XG4gICAgdGhpcy5hdHRyTGFzdEFjdGl2aXR5VGltZSA9IGNkay5Ub2tlbi5hc051bWJlcih0aGlzLmdldEF0dCgnTGFzdEFjdGl2aXR5VGltZScpKTtcbiAgICB0aGlzLmF0dHJMYXN0UmVzdGFydGVkVGltZSA9IGNkay5Ub2tlbi5hc051bWJlcih0aGlzLmdldEF0dCgnTGFzdFJlc3RhcnRlZFRpbWUnKSk7XG4gICAgdGhpcy5hdHRySW5pdFNjcmlwdHNTYWZlTW9kZSA9IHRoaXMuZ2V0QXR0KCdJbml0U2NyaXB0c1NhZmVNb2RlJyk7XG4gIH1cbn0iXX0=