import { SubscriptionOptions } from './subscription';
import { ITopic } from './topic-base';
import { Construct } from '@aws-cdk/core';
/**
 * Subscription configuration.
 *
 * @stability stable
 */
export interface TopicSubscriptionConfig extends SubscriptionOptions {
    /**
     * The scope in which to create the SNS subscription resource.
     *
     * Normally you'd
     * want the subscription to be created on the consuming stack because the
     * topic is usually referenced by the consumer's resource policy (e.g. SQS
     * queue policy). Otherwise, it will cause a cyclic reference.
     *
     * If this is undefined, the subscription will be created on the topic's stack.
     *
     * @default - use the topic as the scope of the subscription, in which case `subscriberId` must be defined.
     * @stability stable
     */
    readonly subscriberScope?: Construct;
    /**
     * The id of the SNS subscription resource created under `scope`.
     *
     * In most
     * cases, it is recommended to use the `uniqueId` of the topic you are
     * subscribing to.
     *
     * @stability stable
     */
    readonly subscriberId: string;
}
/**
 * Topic subscription.
 *
 * @stability stable
 */
export interface ITopicSubscription {
    /**
     * Returns a configuration used to subscribe to an SNS topic.
     *
     * @param topic topic for which subscription will be configured.
     * @stability stable
     */
    bind(topic: ITopic): TopicSubscriptionConfig;
}
