"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafwebaclToAppsync = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
// Imports
const waf = require("aws-cdk-lib/aws-wafv2");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
/**
 * @summary The WafwebaclToAppsync class.
 */
class WafwebaclToAppsync extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the WafwebaclToAppsync class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {WafwebaclToAppsyncProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Build the Web ACL
        this.webacl = defaults.buildWebacl(this, "REGIONAL", {
            existingWebaclObj: props.existingWebaclObj,
            webaclProps: props.webaclProps,
        });
        // Setup the Web ACL Association
        new waf.CfnWebACLAssociation(scope, `${id}-WebACLAssociation`, {
            webAclArn: this.webacl.attrArn,
            resourceArn: props.existingAppsyncApi.attrArn,
        });
        this.appsyncApi = props.existingAppsyncApi;
    }
}
exports.WafwebaclToAppsync = WafwebaclToAppsync;
_a = JSII_RTTI_SYMBOL_1;
WafwebaclToAppsync[_a] = { fqn: "@aws-solutions-constructs/aws-wafwebacl-appsync.WafwebaclToAppsync", version: "2.27.0" };
//# sourceMappingURL=data:application/json;base64,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