yaml = '''
global:
  imagePullSecrets:
# alertmanager:
#   alertmanagerSpec:
#     # image:
#     #   repository: quay.io/prometheus/alertmanager
#     # externalUrl:
#   ingress:
#     enabled: true
#     annotations:
#       kubernetes.io/ingress.class: "nginx"
#       nginx.ingress.kubernetes.io/rewrite-target: /$1
#       nginx.ingress.kubernetes.io/use-regex: "true"
#     paths:
#     - /alertmanager/?(.*)
#     pathType: Prefix

prometheusOperator:
  # image: 
  #   repository: quay.io/prometheus-operator/prometheus-operator
  admissionWebhooks:
    enabled: false
    patch:
      enabled: false
  # prometheusConfigReloaderImage:
  #   repository: quay.io/prometheus-operator/prometheus-config-reloader
  tls:
    enabled: false

prometheus:
  prometheusSpec:
    # image:
    #   repository: quay.io/prometheus/prometheus
    # externalUrl: 
    storageSpec:
      volumeClaimTemplate:
        spec:
          selector:
            matchLabels:
              app: prometheus
          resources:
            requests:
              storage: 5Gi
  ingress:
    enabled: true
    annotations:
      kubernetes.io/ingress.class: "nginx"
      nginx.ingress.kubernetes.io/rewrite-target: /$1
      nginx.ingress.kubernetes.io/use-regex: "true"
    paths:
    - /prometheus/?(.*)
    pathType: Prefix

grafana:
  testFramework:
    enabled: false
  # image:
  #   repository: grafana/grafana
  #   pullSecrets:
  # sidecar:
  #   image:
  #     repository: kiwigrid/k8s-sidecar
  ingress:
    enabled: true
    annotations:
      kubernetes.io/ingress.class: "nginx"
      nginx.ingress.kubernetes.io/rewrite-target: /$1
      nginx.ingress.kubernetes.io/use-regex: "true"
    path: /grafana/?(.*)
    hosts: [<hosts>]
  grafana.ini:
    server:
      root_url: http://localhost:3000/grafana
  additionalDataSources:
  - name: Loki
    access: proxy
    type: loki
    url: http://loki:3100
    jsonData:
      maxLines: "5000"
  persistence:
    enabled: true
    existingClaim: grafana
  initChownData:
    enabled: false
    # image:
    #   repository: busybox

# prometheus-node-exporter:
#   serviceAccount:
#     imagePullSecrets:
#   image:
#     repository: quay.io/prometheus/node-exporter
# kube-state-metrics:
#   image:
#     repository: quay.io/coreos/kube-state-metrics
'''