# AUTOGENERATED! DO NOT EDIT! File to edit: helper.ipynb (unless otherwise specified).

__all__ = ['DatabaseHelper']

# Cell
import pandas as pd
from datetime import datetime
import pickle, json , boto3, zlib, os, logging
from s3bz.s3bz import S3

# Cell
class DatabaseHelper:
  class Helper:
    @staticmethod
    def groupByProduct(data):
      df = pd.DataFrame(data)
      gprcode = df.groupby('ib_prcode')
      # group by ib_prcode, then ib_brcode, add timestamp as well
      res = gprcode.agg(list).apply(lambda x: {
            k:v for k,v in zip(
                x['ib_brcode'], [
                  {
                    'ib_cf_qty': int(qty),
                    'new_ib_bs_stock_cv': int(new),
                    'lastUpdate' : datetime.now().timestamp()
                  }
                  for qty,new in zip(x['ib_cf_qty'], x['new_ib_vs_stock_cv'])
                ]
              )
          } , axis = 1)
      return res.to_dict()
    @staticmethod
    def setUpdateAll():
      return list(item.setUpdate() for item in Database.scan())

    @staticmethod
    def iteratorToInvDict(data):
      return {item.ib_prcode:item.inventory for item in data}

  @classmethod
  def splitBranches(cls, key='allData',bucket = '', **kwargs):
    '''
    split database items from s3 into individual branch
    '''
    if not bucket:
      logging.warning('bucket name is empty')
      return 'empty bucket name'
    data = S3.load(key=key , bucket = bucket, **kwargs)
    # check if object is blank
    logging.debug('data has loaded')
    if not data: return 'items are empty'
    df = pd.DataFrame(data).drop(['lastUpdate', 'ib_prcode'])
    splitDict = df.T.fillna('').to_dict()
    cleanedSplitDict = {brcode:
      { k:v for k,v in inv.items()  if v}
      for brcode, inv in splitDict.items()}


    logging.warning(f'data are{cleanedSplitDict}')
    saveResults = {'success':0, 'failure':0,'errorMessage':[]}
    for k,v in cleanedSplitDict.items():
      print(k,v)
      saveResult = S3.save(key = k,
                           objectToSave = v,
                           bucket = bucket,
                           **kwargs)
      # print(saveResult)
      if saveResult: saveResults['success'] += 1
      else: saveResults['failure'] += 1
    return saveResults




