# 匠岭-通用组件-Python版本

## 简述
一些常用的组件功能，打包发布至 [Pypi](https://pypi.org/)，从而实现快速迁移及版本同步。项目尽可能只包含一些不依赖外部组件的基础功能，或者仅依赖部分常见的组件。对于一些少用组件，暂时不会依赖。

## 安装
```BASH
pip install junglead
# 或者
python -m pip install junglead
```

## 使用方法
安装好组件之后，可以导入对应的类进行使用。方法分为静态方法和属性方法，具体将在每个组件的使用方法中单独说明。

## 组件列表
针对一些常用的底层功能，所做的二次封装，提高使用的便利性。**注意！注意！注意！** 本组件仅依赖于原生代码，不依赖于任何第三方组件，因此一些需要第三方组件支持的功能，暂不包含。

### 日志组件
**Python** 自带了记录日志的 **logger** 组件，只是不便使用，封装的日志组件提供了更加简单的使用方法，只需要设置日志级别以及可选的前缀，即可针对不同场景和目的将日志记录在不同的文件中，[详细介绍](docs/logger.md)。

### 序列化组件
**Python** 自带的 **json** 组件，仅支持序列化最基础的数字、字符串类型，对于稍微复杂点的类型均不提供支持。同时由于 **Python** 是弱语言类型，导致也无法像其他强类型语言一样根据反射机制来获取属性配置，从而对于过于复杂的对象类型，也无法做到通用的配置。因此只能封装几个比较简单的特殊类型， [详细介绍](docs/json.md)。

### 日期时间组件
**Python** 中的日期时间对象，也是一个比较难用的组件，因此提供一个封装组件，提供一些计算、比较等方面的便利操作，[详细介绍](docs/datetime.md)

### 正则表达式组件
正则表达式也是语言内置的功能，封装组件仅是封装了一些常见的正则判断语句，用来进行简单的类型判断，[详细介绍](docs/regex.md)

### 邮件组件
封装了邮件操作的组件，支持原生 **SMTP** 方式发送带有附件的邮件。但是由于不想引入额外的组件依赖，因此不支持添加网络 **URL** 的文件，仅支持服务器本地文件。同时，支持原生的 **POP** 收取邮件。[详细介绍](docs/email.md)

### 雪花算法
对于大型的分布式应用，或者海量并且有关联数据的写入操作来说，对于任何数据库来说，用自增列做为唯一标识都不是一个好的选择。雪花算法正是为解决这一问题而生。[详细介绍](docs/snowflake.md)