# SMAP Effect Prediction
SMAP effect-prediction was created to predict the effects of naturally occuring sequence variants or CRISPR-cas induced mutations in a given reference gene sequence on the encoded protein. It takes as input a genotyping mastertable generated by [SMAP haplotype-window](https://gitlab.com/dschaumont/smap-haplotype-window) that lists the relative frequency of observed short haplotypes per locus per sample. 

# Installation
This software is part of the SMAP framework. Please check the [SMAP documentation](https://ngs-smap.readthedocs.io/) for how to install it as part of SMAP.

## From PyPi
```bash
python3 -m venv .venv
source .venv/bin/activate
pip install --upgrade pip
pip install smap-effect-prediction
```

## From Git
Either download a release tarball, extract it and change your current working directory to the extracted folder, or clone the git repository:

```bash
git clone git@gitlab.com:dschaumont/smap-effect-prediction.git
cd smap-effect-prediction
python3 -m venv .venv
source .venv/bin/activate
pip install --upgrade pip
pip install .
```

# Documentation
## Building from a tarball or the git respository
First, install the documentation build dependencies, then build the documentation in the `docs` directory:

```bash
pip install .[docs]
cd docs
sphinx-build -M html . build
```

# Citation

If you use SMAP, please cite "Schaumont et al., (2022). Stack Mapping Anchor Points (SMAP): a versatile suite of tools for read-backed haplotyping. https://doi.org/10.1101/2022.03.10.483555". Source code is available online at https://gitlab.com/truttink/smap/.

# Contributions
This package was created using the help of the following people:

- Arne Verstichele (INARI)
- Dries Schaumont and Tom Ruttink (ILVO)
- Kevin Debray (VIB-ILVO)
