## Project description

**lxzbiotools** is a bioinformatics data processing tools.

## Features

+ `cds2pep`         Convert cds file to pep 
+ `excel2txt`       Convert file format form excel to txt
+ `fa2fq`           Change fasta file to fastq file
+ `fq2fa`           Change fastq file to fasta file
+ `genstats`        One or more genome informatics statistics
+ `gfa2fa`          Convert gfa file to fasta file
+ `gff`             Simplify gff3 file for WGD event analysis
+ `gffstat`         Various information statistics of genome annotation file gff
+ `length`          Get the length of each sequences
+ `rds`             Read a multi-FASTA file sequence and remove duplicates
+ `parallel`        Parallelized running tasks
+ `extseq`          Extract sequences by sequence name or keyword 
+ `m2ofa`           Convert multi-line fasta to one-line fasta           
+ `movefile`        Randomly allocate files to a specified number of folders 

## QuickStart


### Install

```
pip3 install lxzbiotools
```

### Update

```
pip3 install -U lxzbiotools
```

### Use

```bash
$ lxzbiotools --help

 Usage: lxzbiotools.py [OPTIONS] COMMAND [ARGS]...
```


## Version update content
+ *2022-10-05* version **0.5.5** add **gffstat** (Various information statistics of genome annotation file gff)
+ *2022-09-22* version **0.5.4** add **movefile** (Randomly allocate files to a specified number of folders)

## Bug report 

+ Issues and bugs report to **lixingzee@gmail.com**

+ github: *https://github.com/lxingze/lxzbiotools*

