#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

import threading

import os

import time


class Counter:
    def __init__(self):
        self.value = -1

    def next(self) -> int:
        self.value += 1
        return self.value

    def __str__(self):
        return str(self.value)


class SpanCounter:
    def __init__(self):
        self.count = Counter()
        self.value = str(os.getpid()) + "." + str(int(time.time() * 1000)) + "." + str(self.count)

    def next(self) -> str:
        count = self.count.next()
        self.value = str(os.getpid()) + "." + str(int(time.time() * 1000)) + "." + str(count)
        return self.value

    def __str__(self):
        return self.value


class AtomicCounter(Counter):
    def __init__(self):
        super().__init__()
        self._lock = threading.Lock()

    def next(self) -> int:
        with self._lock:
            return Counter.next(self)
