"""
Type annotations for partnercentral-account service literal definitions.

[Documentation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_partnercentral_account/literals/)

Copyright 2025 Vlad Emelianov

Usage::

    ```python
    from mypy_boto3_partnercentral_account.literals import AccessTypeType

    data: AccessTypeType = "ALLOW_ALL"
    ```
"""

import sys

if sys.version_info >= (3, 12):
    from typing import Literal
else:
    from typing_extensions import Literal


__all__ = (
    "AccessTypeType",
    "ConnectionTypeStatusType",
    "ConnectionTypeType",
    "IndustrySegmentType",
    "InvitationStatusType",
    "ListConnectionInvitationsPaginatorName",
    "ListConnectionsPaginatorName",
    "ListPartnersPaginatorName",
    "PaginatorName",
    "ParticipantTypeType",
    "PartnerCentralAccountAPIServiceName",
    "PrimarySolutionTypeType",
    "ProfileTaskStatusType",
    "ProfileValidationErrorReasonType",
    "ProfileVisibilityType",
    "ResourceServiceName",
    "ServiceName",
    "VerificationStatusType",
    "VerificationTypeType",
)


AccessTypeType = Literal["ALLOW_ALL", "ALLOW_BY_DEFAULT_DENY_SOME", "DENY_ALL"]
ConnectionTypeStatusType = Literal["ACTIVE", "CANCELED"]
ConnectionTypeType = Literal["OPPORTUNITY_COLLABORATION", "SUBSIDIARY"]
IndustrySegmentType = Literal[
    "AGRICULTURE_MINING",
    "BIOTECHNOLOGY",
    "BUSINESS_CONSUMER_SERVICES",
    "BUSINESS_SERV",
    "COMMUNICATIONS",
    "COMPUTERS_ELECTRONICS",
    "COMPUTER_HARDWARE",
    "COMPUTER_SOFTWARE",
    "CONSUMER_GOODS",
    "CONSUMER_RELATED",
    "EDUCATION",
    "ENERGY_UTILITIES",
    "FINANCIAL_SERVICES",
    "GAMING",
    "GOVERNMENT",
    "GOVERNMENT_EDUCATION_PUBLIC_SERVICES",
    "HEALTHCARE",
    "HEALTHCARE_PHARMACEUTICALS_BIOTECH",
    "INDUSTRIAL_ENERGY",
    "INTERNET_SPECIFIC",
    "LIFE_SCIENCES",
    "MANUFACTURING",
    "MEDIA_ENTERTAINMENT",
    "MEDIA_ENTERTAINMENT_LEISURE",
    "MEDICAL_HEALTH",
    "NON_PROFIT_ORGANIZATION",
    "OTHER",
    "PROFESSIONAL_SERVICES",
    "REAL_ESTATE_CONSTRUCTION",
    "RETAIL",
    "RETAIL_WHOLESALE_DISTRIBUTION",
    "SEMICONDUCTOR_ELECTR",
    "SOFTWARE_INTERNET",
    "TELECOMMUNICATIONS",
    "TRANSPORTATION_LOGISTICS",
    "TRAVEL_HOSPITALITY",
    "WHOLESALE_DISTRIBUTION",
]
InvitationStatusType = Literal["ACCEPTED", "CANCELED", "EXPIRED", "PENDING", "REJECTED"]
ListConnectionInvitationsPaginatorName = Literal["list_connection_invitations"]
ListConnectionsPaginatorName = Literal["list_connections"]
ListPartnersPaginatorName = Literal["list_partners"]
ParticipantTypeType = Literal["RECEIVER", "SENDER"]
PrimarySolutionTypeType = Literal[
    "COMMUNICATION_SERVICES",
    "CONSULTING_SERVICES",
    "HARDWARE_PRODUCTS",
    "MANAGED_SERVICES",
    "PROFESSIONAL_SERVICES",
    "SOFTWARE_PRODUCTS",
    "TRAINING_SERVICES",
    "VALUE_ADDED_RESALE_AWS_SERVICES",
]
ProfileTaskStatusType = Literal["CANCELED", "FAILED", "IN_PROGRESS", "SUCCEEDED"]
ProfileValidationErrorReasonType = Literal[
    "DUPLICATE_PROFILE",
    "INVALID_CONTENT",
    "INVALID_LOGO",
    "INVALID_LOGO_FILE",
    "INVALID_LOGO_SIZE",
    "INVALID_LOGO_URL",
    "INVALID_WEBSITE_URL",
]
ProfileVisibilityType = Literal["PRIVATE", "PUBLIC"]
VerificationStatusType = Literal[
    "FAILED", "IN_PROGRESS", "PENDING_CUSTOMER_ACTION", "REJECTED", "SUCCEEDED"
]
VerificationTypeType = Literal["BUSINESS_VERIFICATION", "REGISTRANT_VERIFICATION"]
PartnerCentralAccountAPIServiceName = Literal["partnercentral-account"]
ServiceName = Literal[
    "accessanalyzer",
    "account",
    "acm",
    "acm-pca",
    "aiops",
    "amp",
    "amplify",
    "amplifybackend",
    "amplifyuibuilder",
    "apigateway",
    "apigatewaymanagementapi",
    "apigatewayv2",
    "appconfig",
    "appconfigdata",
    "appfabric",
    "appflow",
    "appintegrations",
    "application-autoscaling",
    "application-insights",
    "application-signals",
    "applicationcostprofiler",
    "appmesh",
    "apprunner",
    "appstream",
    "appsync",
    "arc-region-switch",
    "arc-zonal-shift",
    "artifact",
    "athena",
    "auditmanager",
    "autoscaling",
    "autoscaling-plans",
    "b2bi",
    "backup",
    "backup-gateway",
    "backupsearch",
    "batch",
    "bcm-dashboards",
    "bcm-data-exports",
    "bcm-pricing-calculator",
    "bcm-recommended-actions",
    "bedrock",
    "bedrock-agent",
    "bedrock-agent-runtime",
    "bedrock-agentcore",
    "bedrock-agentcore-control",
    "bedrock-data-automation",
    "bedrock-data-automation-runtime",
    "bedrock-runtime",
    "billing",
    "billingconductor",
    "braket",
    "budgets",
    "ce",
    "chatbot",
    "chime",
    "chime-sdk-identity",
    "chime-sdk-media-pipelines",
    "chime-sdk-meetings",
    "chime-sdk-messaging",
    "chime-sdk-voice",
    "cleanrooms",
    "cleanroomsml",
    "cloud9",
    "cloudcontrol",
    "clouddirectory",
    "cloudformation",
    "cloudfront",
    "cloudfront-keyvaluestore",
    "cloudhsm",
    "cloudhsmv2",
    "cloudsearch",
    "cloudsearchdomain",
    "cloudtrail",
    "cloudtrail-data",
    "cloudwatch",
    "codeartifact",
    "codebuild",
    "codecatalyst",
    "codecommit",
    "codeconnections",
    "codedeploy",
    "codeguru-reviewer",
    "codeguru-security",
    "codeguruprofiler",
    "codepipeline",
    "codestar-connections",
    "codestar-notifications",
    "cognito-identity",
    "cognito-idp",
    "cognito-sync",
    "comprehend",
    "comprehendmedical",
    "compute-optimizer",
    "compute-optimizer-automation",
    "config",
    "connect",
    "connect-contact-lens",
    "connectcampaigns",
    "connectcampaignsv2",
    "connectcases",
    "connectparticipant",
    "controlcatalog",
    "controltower",
    "cost-optimization-hub",
    "cur",
    "customer-profiles",
    "databrew",
    "dataexchange",
    "datapipeline",
    "datasync",
    "datazone",
    "dax",
    "deadline",
    "detective",
    "devicefarm",
    "devops-guru",
    "directconnect",
    "discovery",
    "dlm",
    "dms",
    "docdb",
    "docdb-elastic",
    "drs",
    "ds",
    "ds-data",
    "dsql",
    "dynamodb",
    "dynamodbstreams",
    "ebs",
    "ec2",
    "ec2-instance-connect",
    "ecr",
    "ecr-public",
    "ecs",
    "efs",
    "eks",
    "eks-auth",
    "elasticache",
    "elasticbeanstalk",
    "elastictranscoder",
    "elb",
    "elbv2",
    "emr",
    "emr-containers",
    "emr-serverless",
    "entityresolution",
    "es",
    "events",
    "evidently",
    "evs",
    "finspace",
    "finspace-data",
    "firehose",
    "fis",
    "fms",
    "forecast",
    "forecastquery",
    "frauddetector",
    "freetier",
    "fsx",
    "gamelift",
    "gameliftstreams",
    "geo-maps",
    "geo-places",
    "geo-routes",
    "glacier",
    "globalaccelerator",
    "glue",
    "grafana",
    "greengrass",
    "greengrassv2",
    "groundstation",
    "guardduty",
    "health",
    "healthlake",
    "iam",
    "identitystore",
    "imagebuilder",
    "importexport",
    "inspector",
    "inspector-scan",
    "inspector2",
    "internetmonitor",
    "invoicing",
    "iot",
    "iot-data",
    "iot-jobs-data",
    "iot-managed-integrations",
    "iotanalytics",
    "iotdeviceadvisor",
    "iotevents",
    "iotevents-data",
    "iotfleetwise",
    "iotsecuretunneling",
    "iotsitewise",
    "iotthingsgraph",
    "iottwinmaker",
    "iotwireless",
    "ivs",
    "ivs-realtime",
    "ivschat",
    "kafka",
    "kafkaconnect",
    "kendra",
    "kendra-ranking",
    "keyspaces",
    "keyspacesstreams",
    "kinesis",
    "kinesis-video-archived-media",
    "kinesis-video-media",
    "kinesis-video-signaling",
    "kinesis-video-webrtc-storage",
    "kinesisanalytics",
    "kinesisanalyticsv2",
    "kinesisvideo",
    "kms",
    "lakeformation",
    "lambda",
    "launch-wizard",
    "lex-models",
    "lex-runtime",
    "lexv2-models",
    "lexv2-runtime",
    "license-manager",
    "license-manager-linux-subscriptions",
    "license-manager-user-subscriptions",
    "lightsail",
    "location",
    "logs",
    "lookoutequipment",
    "m2",
    "machinelearning",
    "macie2",
    "mailmanager",
    "managedblockchain",
    "managedblockchain-query",
    "marketplace-agreement",
    "marketplace-catalog",
    "marketplace-deployment",
    "marketplace-entitlement",
    "marketplace-reporting",
    "marketplacecommerceanalytics",
    "mediaconnect",
    "mediaconvert",
    "medialive",
    "mediapackage",
    "mediapackage-vod",
    "mediapackagev2",
    "mediastore",
    "mediastore-data",
    "mediatailor",
    "medical-imaging",
    "memorydb",
    "meteringmarketplace",
    "mgh",
    "mgn",
    "migration-hub-refactor-spaces",
    "migrationhub-config",
    "migrationhuborchestrator",
    "migrationhubstrategy",
    "mpa",
    "mq",
    "mturk",
    "mwaa",
    "mwaa-serverless",
    "neptune",
    "neptune-graph",
    "neptunedata",
    "network-firewall",
    "networkflowmonitor",
    "networkmanager",
    "networkmonitor",
    "notifications",
    "notificationscontacts",
    "nova-act",
    "oam",
    "observabilityadmin",
    "odb",
    "omics",
    "opensearch",
    "opensearchserverless",
    "organizations",
    "osis",
    "outposts",
    "panorama",
    "partnercentral-account",
    "partnercentral-benefits",
    "partnercentral-channel",
    "partnercentral-selling",
    "payment-cryptography",
    "payment-cryptography-data",
    "pca-connector-ad",
    "pca-connector-scep",
    "pcs",
    "personalize",
    "personalize-events",
    "personalize-runtime",
    "pi",
    "pinpoint",
    "pinpoint-email",
    "pinpoint-sms-voice",
    "pinpoint-sms-voice-v2",
    "pipes",
    "polly",
    "pricing",
    "proton",
    "qapps",
    "qbusiness",
    "qconnect",
    "quicksight",
    "ram",
    "rbin",
    "rds",
    "rds-data",
    "redshift",
    "redshift-data",
    "redshift-serverless",
    "rekognition",
    "repostspace",
    "resiliencehub",
    "resource-explorer-2",
    "resource-groups",
    "resourcegroupstaggingapi",
    "rolesanywhere",
    "route53",
    "route53-recovery-cluster",
    "route53-recovery-control-config",
    "route53-recovery-readiness",
    "route53domains",
    "route53globalresolver",
    "route53profiles",
    "route53resolver",
    "rtbfabric",
    "rum",
    "s3",
    "s3control",
    "s3outposts",
    "s3tables",
    "s3vectors",
    "sagemaker",
    "sagemaker-a2i-runtime",
    "sagemaker-edge",
    "sagemaker-featurestore-runtime",
    "sagemaker-geospatial",
    "sagemaker-metrics",
    "sagemaker-runtime",
    "savingsplans",
    "scheduler",
    "schemas",
    "sdb",
    "secretsmanager",
    "security-ir",
    "securityhub",
    "securitylake",
    "serverlessrepo",
    "service-quotas",
    "servicecatalog",
    "servicecatalog-appregistry",
    "servicediscovery",
    "ses",
    "sesv2",
    "shield",
    "signer",
    "signin",
    "simspaceweaver",
    "snow-device-management",
    "snowball",
    "sns",
    "socialmessaging",
    "sqs",
    "ssm",
    "ssm-contacts",
    "ssm-guiconnect",
    "ssm-incidents",
    "ssm-quicksetup",
    "ssm-sap",
    "sso",
    "sso-admin",
    "sso-oidc",
    "stepfunctions",
    "storagegateway",
    "sts",
    "supplychain",
    "support",
    "support-app",
    "swf",
    "synthetics",
    "taxsettings",
    "textract",
    "timestream-influxdb",
    "timestream-query",
    "timestream-write",
    "tnb",
    "transcribe",
    "transfer",
    "translate",
    "trustedadvisor",
    "verifiedpermissions",
    "voice-id",
    "vpc-lattice",
    "waf",
    "waf-regional",
    "wafv2",
    "wellarchitected",
    "wisdom",
    "workdocs",
    "workmail",
    "workmailmessageflow",
    "workspaces",
    "workspaces-instances",
    "workspaces-thin-client",
    "workspaces-web",
    "xray",
]
ResourceServiceName = Literal[
    "cloudformation", "cloudwatch", "dynamodb", "ec2", "glacier", "iam", "s3", "sns", "sqs"
]
PaginatorName = Literal["list_connection_invitations", "list_connections", "list_partners"]
