extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',
    'sphinx.ext.coverage',
    'sphinx.ext.mathjax',
    'sphinx.ext.ifconfig',
    'sphinx.ext.githubpages',
    'sphinx.ext.autosummary',
    'sphinx.ext.autosectionlabel',
    'sphinx.ext.napoleon',
    'sphinx_mdinclude',
]

autosummary_generate = True
templates_path = ["_templates"]

source_suffix = {".rst": "restructuredtext"}

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "Touchlab Python Bindings"
copyright = "2025, Touchlab Robotics"
author = "Touchlab Robotics"

html_logo = "images/touchlab_logo.png"

# The short X.Y version.
version = "0.1.12"
# The full version, including alpha/beta/rc tags.
release = "0.1.12"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ["_build"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False


# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
default_dark_mode = True
html_theme = "sphinx_rtd_theme"
html_theme_options = {'style_nav_header_background' : '#191e24'}
html_context = {'show_source': False}

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
html_show_sphinx = False

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
html_show_copyright = True

# Output file base name for HTML help builder.
htmlhelp_basename = "touchlab-comm-pydoc"

intersphinx_mapping = {"python": ("https://docs.python.org/", 'https://docs.python.org/3/objects.inv')}

html_static_path = ['css']
html_css_files = ['custom.css',]

