# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['git_t5',
 'git_t5.cli',
 'git_t5.core',
 'git_t5.data',
 'git_t5.tests',
 'git_t5.utils']

package_data = \
{'': ['*'],
 'git_t5': ['outputs/2021-07-28/16-35-40/*',
            'outputs/2021-07-28/16-35-40/.hydra/*',
            'outputs/2021-07-28/16-37-02/*',
            'outputs/2021-07-28/16-37-02/.hydra/*',
            'outputs/2021-07-28/17-34-49/*',
            'outputs/2021-07-28/17-34-49/.hydra/*',
            'outputs/2021-07-28/17-35-38/*',
            'outputs/2021-07-28/17-35-38/.hydra/*',
            'outputs/2021-07-28/17-36-10/*',
            'outputs/2021-07-28/17-36-10/.hydra/*',
            'outputs/2021-07-28/17-37-41/*',
            'outputs/2021-07-28/17-37-41/.hydra/*',
            'outputs/2021-07-28/17-38-20/*',
            'outputs/2021-07-28/17-38-20/.hydra/*',
            'outputs/2021-07-28/17-39-19/*',
            'outputs/2021-07-28/17-39-19/.hydra/*',
            'outputs/2021-07-28/17-39-40/*',
            'outputs/2021-07-28/17-39-40/.hydra/*',
            'outputs/2021-07-28/17-40-43/*',
            'outputs/2021-07-28/17-40-43/.hydra/*',
            'outputs/2021-07-28/17-45-31/*',
            'outputs/2021-07-28/17-45-31/.hydra/*',
            'outputs/2021-07-28/22-24-04/*',
            'outputs/2021-07-28/22-24-04/.hydra/*',
            'outputs/2021-07-28/22-25-36/*',
            'outputs/2021-07-28/22-25-36/.hydra/*',
            'outputs/2021-07-28/22-25-59/*',
            'outputs/2021-07-28/22-25-59/.hydra/*',
            'outputs/2021-07-28/22-26-13/*',
            'outputs/2021-07-28/22-26-13/.hydra/*',
            'outputs/2021-07-28/22-29-34/*',
            'outputs/2021-07-28/22-29-34/.hydra/*',
            'outputs/2021-07-28/22-33-23/*',
            'outputs/2021-07-28/22-33-23/.hydra/*',
            'outputs/2021-07-28/22-33-56/*',
            'outputs/2021-07-28/22-33-56/.hydra/*',
            'outputs/2021-07-28/22-34-18/*',
            'outputs/2021-07-28/22-34-18/.hydra/*',
            'outputs/2021-07-28/22-55-53/*',
            'outputs/2021-07-28/22-55-53/.hydra/*',
            'outputs/2021-07-28/22-56-14/*',
            'outputs/2021-07-28/22-56-14/.hydra/*',
            'outputs/2021-07-28/22-56-45/*',
            'outputs/2021-07-28/22-56-45/.hydra/*',
            'outputs/2021-07-28/22-58-18/*',
            'outputs/2021-07-28/22-58-18/.hydra/*',
            'outputs/2021-07-29/01-16-44/*',
            'outputs/2021-07-29/01-16-44/.hydra/*',
            'outputs/2021-07-29/01-17-54/*',
            'outputs/2021-07-29/01-17-54/.hydra/*',
            'outputs/2021-07-29/01-18-09/*',
            'outputs/2021-07-29/01-18-09/.hydra/*',
            'outputs/2021-07-29/01-18-43/*',
            'outputs/2021-07-29/01-18-43/.hydra/*',
            'outputs/2021-07-29/01-24-20/*',
            'outputs/2021-07-29/01-24-20/.hydra/*',
            'outputs/2021-07-29/01-25-10/*',
            'outputs/2021-07-29/01-25-10/.hydra/*',
            'outputs/2021-07-29/01-26-05/*',
            'outputs/2021-07-29/01-26-05/.hydra/*',
            'outputs/2021-07-29/01-30-02/*',
            'outputs/2021-07-29/01-30-02/.hydra/*',
            'outputs/2021-07-29/01-31-37/*',
            'outputs/2021-07-29/01-31-37/.hydra/*',
            'outputs/2021-07-29/01-33-22/*',
            'outputs/2021-07-29/01-33-22/.hydra/*',
            'outputs/2021-07-29/01-34-50/*',
            'outputs/2021-07-29/01-34-50/.hydra/*',
            'outputs/2021-07-29/01-44-23/*',
            'outputs/2021-07-29/01-44-23/.hydra/*',
            'outputs/2021-07-29/02-23-30/*',
            'outputs/2021-07-29/02-23-30/.hydra/*',
            'outputs/2021-07-29/02-24-30/*',
            'outputs/2021-07-29/02-24-30/.hydra/*',
            'outputs/2021-07-29/02-25-49/*',
            'outputs/2021-07-29/02-25-49/.hydra/*',
            'outputs/2021-07-29/02-27-04/*',
            'outputs/2021-07-29/02-27-04/.hydra/*',
            'outputs/2021-07-29/02-30-21/*',
            'outputs/2021-07-29/02-30-21/.hydra/*',
            'outputs/2021-07-29/02-35-14/*',
            'outputs/2021-07-29/02-35-14/.hydra/*',
            'outputs/2021-07-29/02-36-34/*',
            'outputs/2021-07-29/02-36-34/.hydra/*',
            'outputs/2021-07-29/02-39-27/*',
            'outputs/2021-07-29/02-39-27/.hydra/*',
            'outputs/2021-07-29/02-45-07/*',
            'outputs/2021-07-29/02-45-07/.hydra/*',
            'outputs/2021-07-29/02-45-58/*',
            'outputs/2021-07-29/02-45-58/.hydra/*',
            'outputs/2021-07-29/02-47-55/*',
            'outputs/2021-07-29/02-47-55/.hydra/*',
            'outputs/2021-07-29/02-48-35/*',
            'outputs/2021-07-29/02-48-35/.hydra/*',
            'outputs/2021-07-29/02-50-27/*',
            'outputs/2021-07-29/02-50-27/.hydra/*',
            'outputs/2021-07-29/02-51-36/*',
            'outputs/2021-07-29/02-51-36/.hydra/*',
            'outputs/2021-07-29/02-51-50/*',
            'outputs/2021-07-29/02-51-50/.hydra/*',
            'outputs/2021-07-29/02-52-41/*',
            'outputs/2021-07-29/02-52-41/.hydra/*',
            'outputs/2021-07-29/02-55-13/*',
            'outputs/2021-07-29/02-55-13/.hydra/*',
            'outputs/2021-07-29/02-55-48/*',
            'outputs/2021-07-29/02-55-48/.hydra/*',
            'outputs/2021-07-29/03-00-00/*',
            'outputs/2021-07-29/03-00-00/.hydra/*',
            'outputs/2021-07-29/03-00-32/*',
            'outputs/2021-07-29/03-00-32/.hydra/*',
            'outputs/2021-07-29/03-01-44/*',
            'outputs/2021-07-29/03-01-44/.hydra/*',
            'outputs/2021-07-29/03-10-15/*',
            'outputs/2021-07-29/03-10-15/.hydra/*',
            'outputs/2021-07-29/03-11-14/*',
            'outputs/2021-07-29/03-11-14/.hydra/*',
            'outputs/2021-07-29/03-13-32/*',
            'outputs/2021-07-29/03-13-32/.hydra/*',
            'outputs/2021-07-30/15-58-46/*',
            'outputs/2021-07-30/15-58-46/.hydra/*',
            'outputs/2021-07-30/15-59-45/*',
            'outputs/2021-07-30/15-59-45/.hydra/*',
            'outputs/2021-07-30/16-00-11/*',
            'outputs/2021-07-30/16-00-11/.hydra/*',
            'outputs/2021-07-30/16-00-11/wandb/*',
            'outputs/2021-07-30/16-00-11/wandb/run-20210730_160738-201mvdh9/*',
            'outputs/2021-07-30/16-00-11/wandb/run-20210730_160738-201mvdh9/files/*',
            'outputs/2021-07-30/16-00-11/wandb/run-20210730_160738-201mvdh9/logs/*',
            'outputs/2021-07-30/16-08-55/*',
            'outputs/2021-07-30/16-08-55/.hydra/*',
            'outputs/2021-07-30/16-08-55/wandb/*',
            'outputs/2021-07-30/16-08-55/wandb/run-20210730_161614-3i1lqe86/*',
            'outputs/2021-07-30/16-08-55/wandb/run-20210730_161614-3i1lqe86/files/*',
            'outputs/2021-07-30/16-08-55/wandb/run-20210730_161614-3i1lqe86/logs/*',
            'outputs/2021-07-30/16-27-28/*',
            'outputs/2021-07-30/16-27-28/.hydra/*',
            'outputs/2021-07-30/16-58-09/*',
            'outputs/2021-07-30/16-58-09/.hydra/*']}

install_requires = \
['datasets>=1.10.1,<2.0.0',
 'flax>=0.3.4,<0.4.0',
 'hydra-core>=1.1.0,<2.0.0',
 'jax>=0.2.18,<0.3.0',
 'jaxlib>=0.1.69,<0.2.0',
 'optax>=0.0.9,<0.0.10',
 'sacrebleu>=1.5.1,<2.0.0',
 'transformers>=4.9.0,<5.0.0',
 'wandb>=0.11.0,<0.12.0']

extras_require = \
{':python_version < "3.8"': ['typing-extensions>=3.7.4,<4.0.0']}

entry_points = \
{'console_scripts': ['gt5-train-model = git_t5.cli.train_model:main',
                     'gt5-train-tokenizer = git_t5.cli.train_tokenizer:main']}

setup_kwargs = {
    'name': 'git-t5',
    'version': '0.1.0',
    'description': '',
    'long_description': None,
    'author': 'mozharovsky',
    'author_email': 'mozharovsky@live.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
