import { Construct } from 'constructs';
export interface AccessConrtolLambdaProps {
    /**
     * The version of the serverless application.
     *
     * @default '1.0.2'
     */
    readonly semanticVersion?: string;
    /**
     * The minimum prediction confidence score above which PII classification and detection would be considered as final answer. Valid range (0.5 to 1.0).
     *
     * @default '0.5'
     */
    readonly confidenceThreshold?: string;
    /**
     * Number of threads to use for calling Comprehend's ContainsPiiEntities API. This controls the number of simultaneous calls that will be made from this Lambda.
     *
     * @default '20'
     */
    readonly containsPiiEntitiesThreadCount?: string;
    /**
     * Default language of the text to be processed. This code will be used for interacting with Comprehend.
     *
     * @default 'en'
     */
    readonly defaultLanguageCode?: string;
    /**
     * Default maximum document size (in bytes) that this function can process otherwise will throw exception for too large document size.
     *
     * @default '102400'
     */
    readonly documentMaxSize?: string;
    /**
     * Maximum document size (in bytes) to be used for making calls to Comprehend's ContainsPiiEntities API.
     *
     * @default '50000'
     */
    readonly documentMaxSizeContainsPiiEntities?: string;
    /**
     * Whether to support partial objects or not. Accessing partial object through http headers such byte-range can corrupt the object and/or affect PII detection accuracy.
     *
     * @default 'false'
     */
    readonly isPartialObjectSupported?: string;
    /**
     * Log level for Lambda function logging, e.g., ERROR, INFO, DEBUG, etc.
     *
     * @default 'INFO'
     */
    readonly logLevel?: string;
    /**
     * Maximum characters to overlap among segments of a document in case chunking is needed because of maximum document size limit.
     *
     * @default '200'
     */
    readonly maxCharsOverlap?: string;
    /**
     * List of comma separated PII entity types to be considered for access control. Refer Comprehend's documentation page for list of supported PII entity types.
     *
     * @default 'ALL'
     */
    readonly piiEntityTypes?: string;
    /**
     * True if publish metrics to Cloudwatch, false otherwise. See README.md for details on CloudWatch metrics.
     *
     * @default 'true'
     */
    readonly publishCloudWatchMetrics?: string;
    /**
     * Number of tokens/words to overlap among segments of a document in case chunking is needed because of maximum document size limit.
     *
     * @default '20'
     */
    readonly subsegmentOverlappingTokens?: string;
    /**
     * Handling logic for Unsupported files. Valid values are PASS and FAIL.
     *
     * @default 'FAIL'
     */
    readonly unsupportedFileHandling?: string;
}
export declare class AccessConrtolLambda extends Construct {
    /**
     * The name of the underlying resoure in the serverless application.
     *
     * @attribute
     */
    readonly stackName: string;
    /**
     * The entity of the serverless application.
     */
    private readonly samApplication;
    constructor(scope: Construct, id: string, props: AccessConrtolLambdaProps);
}
export interface RedactionLambdaProps {
    /**
     * The version of the serverless application.
     *
     * @default '1.0.2'
     */
    readonly semanticVersion?: string;
    /**
     * Log level for Lambda function logging, e.g., ERROR, INFO, DEBUG, etc.
     *
     * @default 'INFO'
     */
    readonly logLevel?: string;
    /**
     * Handling logic for Unsupported files. Valid values are PASS and FAIL.
     *
     * @default 'FAIL'
     */
    readonly unsupportedFileHandling?: string;
    /**
     * Whether to support partial objects or not. Accessing partial object through http headers such byte-range can corrupt the object and/or affect PII detection accuracy.
     *
     * @default 'false'
     */
    readonly isPartialObjectSupported?: string;
    /**
     * Maximum document size (in bytes) to be used for making calls to Comprehend's ContainsPiiEntities API.
     *
     * @default '50000'
     */
    readonly documentMaxSizeContainsPiiEntities?: string;
    /**
     * Maximum document size (in bytes) to be used for making calls to Comprehend's DetectPiiEntities API.
     *
     * @default '5000'
     */
    readonly documentMaxSizeDetectPiiEntities?: string;
    /**
     * List of comma separated PII entity types to be considered for redaction. Refer Comprehend's documentation page for list of supported PII entity types.
     *
     * @default 'ALL'
     */
    readonly piiEntityTypes?: string;
    /**
     * A character that replaces each character in the redacted PII entity.
     *
     * @default '*'
     */
    readonly maskCharacter?: string;
    /**
     * Specifies whether the PII entity is redacted with the mask character or the entity type. Valid values - REPLACE_WITH_PII_ENTITY_TYPE and MASK.
     *
     * @fefault 'MASK'
     */
    readonly maskMode?: string;
    /**
     * Number of tokens/words to overlap among segments of a document in case chunking is needed because of maximum document size limit.
     *
     * @default '20'
     */
    readonly subsegmentOverlappingTokens?: string;
    /**
     * Default maximum document size (in bytes) that this function can process otherwise will throw exception for too large document size.
     *
     * @default '102400'
     */
    readonly documentMaxSize?: string;
    /**
     * The minimum prediction confidence score above which PII classification and detection would be considered as final answer. Valid range (0.5 to 1.0).
     *
     * @default '0.5'
     */
    readonly confidenceThreshold?: string;
    /**
     * Maximum characters to overlap among segments of a document in case chunking is needed because of maximum document size limit.
     *
     * @default '200'
     */
    readonly maxCharsOverlap?: string;
    /**
     * Default language of the text to be processed. This code will be used for interacting with Comprehend.
     *
     * @default 'en'
     */
    readonly defaultLanguageCode?: string;
    /**
     * Number of threads to use for calling Comprehend's DetectPiiEntities API. This controls the number of simultaneous calls that will be made from this Lambda.
     *
     * @default '8'
     */
    readonly detectPiiEntitiesThreadCount?: string;
    /**
     * Number of threads to use for calling Comprehend's ContainsPiiEntities API. This controls the number of simultaneous calls that will be made from this Lambda.
     *
     * @default '20'
     */
    readonly containsPiiEntitiesThreadCount?: string;
    /**
     * True if publish metrics to Cloudwatch, false otherwise. See README.md for details on CloudWatch metrics.
     *
     * @default 'true'
     */
    readonly publishCloudWatchMetrics?: string;
}
export declare class RedactionLambda extends Construct {
    /**
     * The name of the underlying resoure in the serverless application.
     *
     * @attribute
     */
    readonly stackName: string;
    /**
     * The entity of the serverless application.
     */
    private readonly samApplication;
    constructor(scope: Construct, id: string, props?: RedactionLambdaProps);
}
