from typing import Any, Generic, Optional, Sequence, Tuple, Type, TypeVar, Union

from django.core.paginator import Page, Paginator, _SupportsPagination
from django.db.models import Model
from django.http import HttpRequest, HttpResponse
from django.views.generic.base import ContextMixin, TemplateResponseMixin, View

_M = TypeVar("_M", bound=Model, covariant=True)

class MultipleObjectMixin(Generic[_M], ContextMixin):
    allow_empty: bool = ...
    queryset: Optional[_SupportsPagination[_M]] = ...
    model: Optional[Type[_M]] = ...
    paginate_by: int = ...
    paginate_orphans: int = ...
    context_object_name: Optional[str] = ...
    paginator_class: Type[Paginator] = ...
    page_kwarg: str = ...
    ordering: Optional[Union[str, Sequence[str]]] = ...
    def get_queryset(self) -> _SupportsPagination[_M]: ...
    def get_ordering(self) -> Optional[Union[str, Sequence[str]]]: ...
    def paginate_queryset(
        self, queryset: _SupportsPagination[_M], page_size: int
    ) -> Tuple[Paginator, Page, _SupportsPagination[_M], bool]: ...
    def get_paginate_by(self, queryset: _SupportsPagination[_M]) -> Optional[int]: ...
    def get_paginator(
        self,
        queryset: _SupportsPagination[_M],
        per_page: int,
        orphans: int = ...,
        allow_empty_first_page: bool = ...,
        **kwargs: Any
    ) -> Paginator: ...
    def get_paginate_orphans(self) -> int: ...
    def get_allow_empty(self) -> bool: ...
    def get_context_object_name(self, object_list: _SupportsPagination[_M]) -> Optional[str]: ...

class BaseListView(MultipleObjectMixin[_M], View):
    object_list: _SupportsPagination[_M]
    def get(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponse: ...

class MultipleObjectTemplateResponseMixin(TemplateResponseMixin):
    template_name_suffix: str = ...

class ListView(MultipleObjectTemplateResponseMixin, BaseListView[_M]): ...
