from importlib.abc import SourceLoader
from pathlib import Path
from types import TracebackType
from typing import Any, Callable, Dict, Iterator, List, Optional, Type, Union

from django.http.request import HttpRequest, QueryDict
from django.http.response import Http404, HttpResponse
from django.utils.safestring import SafeString

CLEANSED_SUBSTITUTE: str
CURRENT_DIR: Path

class CallableSettingWrapper:
    def __init__(self, callable_setting: Union[Callable, Type[Any]]) -> None: ...

def technical_500_response(request: Any, exc_type: Any, exc_value: Any, tb: Any, status_code: int = ...): ...
def get_default_exception_reporter_filter() -> SafeExceptionReporterFilter: ...
def get_exception_reporter_filter(request: Optional[HttpRequest]) -> SafeExceptionReporterFilter: ...

class SafeExceptionReporterFilter:
    def cleanse_setting(self, key: Union[int, str], value: Any) -> Any: ...
    def get_safe_settings(self) -> Dict[str, Any]: ...
    def is_active(self, request: Optional[HttpRequest]) -> bool: ...
    def get_cleansed_multivaluedict(self, request: HttpRequest, multivaluedict: QueryDict) -> QueryDict: ...
    def get_post_parameters(self, request: Optional[HttpRequest]) -> Dict[str, Any]: ...
    def cleanse_special_types(self, request: Optional[HttpRequest], value: Any) -> Any: ...
    def get_traceback_frame_variables(self, request: Any, tb_frame: Any): ...

class ExceptionReporter:
    request: Optional[HttpRequest] = ...
    filter: SafeExceptionReporterFilter = ...
    exc_type: Optional[Type[BaseException]] = ...
    exc_value: Optional[BaseException] = ...
    tb: Optional[TracebackType] = ...
    is_email: bool = ...
    template_info: Optional[Any] = ...
    template_does_not_exist: bool = ...
    postmortem: Optional[Any] = ...
    @property
    def html_template_path(self) -> Path: ...
    @property
    def text_template_path(self) -> Path: ...
    def __init__(
        self,
        request: Optional[HttpRequest],
        exc_type: Optional[Type[BaseException]],
        exc_value: Optional[BaseException],
        tb: Optional[TracebackType],
        is_email: bool = ...,
    ) -> None: ...
    def get_traceback_data(self) -> Dict[str, Any]: ...
    def get_traceback_html(self) -> SafeString: ...
    def get_traceback_text(self) -> SafeString: ...
    def get_traceback_frames(self) -> List[Any]: ...
    def get_exception_traceback_frames(
        self, exc_value: Optional[BaseException], tb: Optional[TracebackType]
    ) -> Iterator[Dict[str, Any]]: ...
    def _get_lines_from_file(
        self,
        filename: str,
        lineno: int,
        context_lines: int,
        loader: Optional[SourceLoader] = ...,
        module_name: Optional[str] = ...,
    ): ...

def technical_404_response(request: HttpRequest, exception: Http404) -> HttpResponse: ...
def default_urlconf(request: Optional[HttpResponse]) -> HttpResponse: ...
