from typing import Any, Callable, Generic, List, Optional, Tuple, Type, TypeVar, Union

from django.core.exceptions import ObjectDoesNotExist
from django.db.models.base import Model
from django.db.models.fields import Field
from django.db.models.fields.mixins import FieldCacheMixin
from django.db.models.fields.related import ForeignKey, ManyToManyField, OneToOneField, RelatedField
from django.db.models.fields.reverse_related import ManyToManyRel, ManyToOneRel, OneToOneRel
from django.db.models.query import QuerySet
from django.db.models.query_utils import DeferredAttribute

_T = TypeVar("_T")

class ForeignKeyDeferredAttribute(DeferredAttribute):
    field: RelatedField

class ForwardManyToOneDescriptor:
    field: ForeignKey
    def __init__(self, field_with_rel: ForeignKey) -> None: ...
    @property
    def RelatedObjectDoesNotExist(self) -> Type[ObjectDoesNotExist]: ...
    def is_cached(self, instance: Model) -> bool: ...
    def get_queryset(self, **hints: Any) -> QuerySet: ...
    def get_prefetch_queryset(
        self, instances: List[Model], queryset: Optional[QuerySet] = ...
    ) -> Tuple[QuerySet, Callable, Callable, bool, str, bool]: ...
    def get_object(self, instance: Model) -> Model: ...
    def __get__(
        self, instance: Optional[Model], cls: Optional[Type[Model]] = ...
    ) -> Optional[Union[Model, ForwardManyToOneDescriptor]]: ...
    def __set__(self, instance: Model, value: Optional[Model]) -> None: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[Type[Model], str]]: ...

class ForwardOneToOneDescriptor(ForwardManyToOneDescriptor):
    field: OneToOneField
    def get_object(self, instance: Model) -> Model: ...

class ReverseOneToOneDescriptor:
    related: OneToOneRel = ...
    def __init__(self, related: OneToOneRel) -> None: ...
    @property
    def RelatedObjectDoesNotExist(self) -> Type[ObjectDoesNotExist]: ...
    def is_cached(self, instance: Model) -> bool: ...
    def get_queryset(self, **hints: Any) -> QuerySet: ...
    def get_prefetch_queryset(
        self, instances: List[Model], queryset: Optional[QuerySet] = ...
    ) -> Tuple[QuerySet, Callable, Callable, bool, str, bool]: ...
    def __get__(
        self, instance: Optional[Model], cls: Optional[Type[Model]] = ...
    ) -> Union[Model, ReverseOneToOneDescriptor]: ...
    def __set__(self, instance: Model, value: Optional[Model]) -> None: ...
    def __reduce__(self) -> Tuple[Callable, Tuple[Type[Model], str]]: ...

class ReverseManyToOneDescriptor:
    rel: ManyToOneRel = ...
    field: ForeignKey = ...
    def __init__(self, rel: ManyToOneRel) -> None: ...
    @property
    def related_manager_cls(self): ...
    def __get__(self, instance: Optional[Model], cls: Optional[Type[Model]] = ...) -> ReverseManyToOneDescriptor: ...
    def __set__(self, instance: Model, value: List[Model]) -> Any: ...

def create_reverse_many_to_one_manager(superclass: Type, rel: Any): ...

class ManyToManyDescriptor(ReverseManyToOneDescriptor):
    field: ManyToManyField  # type: ignore[assignment]
    rel: ManyToManyRel  # type: ignore[assignment]
    reverse: bool = ...
    def __init__(self, rel: ManyToManyRel, reverse: bool = ...) -> None: ...
    @property
    def through(self) -> Type[Model]: ...
    @property
    def related_manager_cls(self): ...

# fake
class _ForwardManyToManyManager(Generic[_T]):
    def all(self) -> QuerySet: ...

def create_forward_many_to_many_manager(superclass: Type, rel: Any, reverse: Any) -> _ForwardManyToManyManager: ...
