from typing import Any, Callable, Iterable, List, Optional, Pattern, Tuple, Union

from django.db.models.fields import Field
from django.urls import _AnyURL
from django.views.generic import TemplateView

MODEL_METHODS_EXCLUDE: Any

class BaseAdminDocsView(TemplateView): ...
class BookmarkletsView(BaseAdminDocsView): ...
class TemplateTagIndexView(BaseAdminDocsView): ...
class TemplateFilterIndexView(BaseAdminDocsView): ...
class ViewIndexView(BaseAdminDocsView): ...
class ViewDetailView(BaseAdminDocsView): ...
class ModelIndexView(BaseAdminDocsView): ...
class ModelDetailView(BaseAdminDocsView): ...
class TemplateDetailView(BaseAdminDocsView): ...

def get_return_data_type(func_name: Any): ...
def get_readable_field_data_type(field: Union[Field, str]) -> str: ...
def extract_views_from_urlpatterns(
    urlpatterns: Iterable[_AnyURL], base: str = ..., namespace: Optional[str] = ...
) -> List[Tuple[Callable, Pattern[str], Optional[str], Optional[str]]]: ...
def simplify_regex(pattern: str) -> str: ...
