"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WgetLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const fs = require("fs");
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
/**
 * An AWS Lambda layer that includes the wget.
 */
class WgetLayer extends lambda.LayerVersion {
    constructor(scope, id) {
        super(scope, id, {
            code: lambda.Code.fromAsset(path.join(__dirname, '..', 'layer', 'layer.zip'), {
                // we hash the Dockerfile (it contains the tools versions) because hashing the zip is non-deterministic
                assetHash: hashFile(path.join(__dirname, '..', 'layer', 'Dockerfile')),
            }),
            description: '/opt/wget',
        });
    }
}
exports.WgetLayer = WgetLayer;
_a = JSII_RTTI_SYMBOL_1;
WgetLayer[_a] = { fqn: "cdk-lambda-layer-wget.WgetLayer", version: "2.0.202" };
function hashFile(fileName) {
    return crypto
        .createHash('sha256')
        .update(fs.readFileSync(fileName))
        .digest('hex');
}
//# sourceMappingURL=data:application/json;base64,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