## Synopsis
```
import yaml
from yamlfuture import Loader

# Define your own anchors:
Loader.anchors = {'name': 'YAML'}
# !import relative to this:
Loader.filepath = __file__

yamlstream = """\
---
greeting: !+ |
  Hello {*name}.
  Welcome to the future!

copyright: !import [../data.yaml, /copyright/year]
"""

print(yaml.dump(yaml.load(yamlstream, Loader))
```

## Status

This module is *very* **ALPHA**.

YAML 1.3 is still being defined.
As the various features of the YAML 1.3 evolve, `yamlfuture` will evolve.

Use with caution for now.

## Description

YAML 1.3 is bringing exciting new features to YAML (while keeping the YAML you
know and love (or hate) the same).

This package lets you use the new features (or close approximations) in PyYAML
now.

This is a very early release.
More features and documentation coming soon.
