---
name: Bug report
about: Create a report to help us improve GoSQL
title: '[BUG] '
labels: ['bug', 'needs-triage']
assignees: ''

---

**Describe the bug**
A clear and concise description of what the bug is.

**To Reproduce**
Steps to reproduce the behavior:
1. Go to '...'
2. Click on '....'
3. Scroll down to '....'
4. See error

**Expected behavior**
A clear and concise description of what you expected to happen.

**Error message/Stack trace**
```
Please paste the full error message and stack trace here
```

**Environment (please complete the following information):**
 - OS: [e.g. Ubuntu 20.04, Windows 10, macOS 12.0]
 - Python version: [e.g. 3.9.7]
 - Go version: [e.g. 1.21.0]
 - GoSQL version: [e.g. 1.0.0]
 - Database: [e.g. MySQL 8.0, PostgreSQL 15, SQL Server 2022]

**Database configuration**
- Database version: [e.g. MySQL 8.0.33]
- Connection method: [e.g. TCP, Unix socket, Named pipe]
- Authentication: [e.g. password, Windows auth]
- SSL/TLS: [e.g. enabled, disabled]

**Code sample**
```python
# Please provide a minimal code example that demonstrates the issue
import gosql

# Your code here
```

**Additional context**
Add any other context about the problem here. Include:
- Performance characteristics if relevant
- Whether this worked in previous versions
- Any workarounds you've found
- Related configuration files or environment variables

**Screenshots**
If applicable, add screenshots to help explain your problem.

**Logs**
If available, please attach relevant log files or provide log excerpts:
```
Log content here
```
