# Bionic Blue (by Kennedy Guerra)

<img style="display:block;margin:auto;" alt="game logo" src="https://i.imgur.com/tjBQKXp.png" />
<br />

<img style="display:block;margin:auto;" alt="game screenshot" src="https://i.imgur.com/wtGpzXK.png" />
<br />

<img style="display:block;margin:auto;" alt="game screenshot" src="https://i.imgur.com/kfKJRTD.gif" />
<br />


Bionic Blue is an action platformer game featuring a bionic boy tasked with protecting humanity against dangerous robots. It is currently at an early stage of development and for now works like a prototype to showcase actions/animations. This project is part of the [Indie Python](https://github.com/IndiePython) project and has a [dedicated website](https://bionicblue.indiepython.com) where you can find more info about it.

It is made in [Python](https://github.com/python/cpython)/[pygame](https://github.com/pygame/pygame) targeting desktop platforms where Python is available like Windows, Mac and Linux.

Check this youtube video where the game is briefly presented:

<a href="https://www.youtube.com/watch?v=oTrZM4GC_3w">
  <img style="display:block;margin:auto;" alt="thumb of youtube video" src="https://img.youtube.com/vi/oTrZM4GC_3w/hqdefault.jpg" />
</a>

<br />


## Installing & running the game

To run the game, installation is actually optional.


### If you want to install...

You can install bionic blue from the Python Package Index with the `pip` command:

```bash
pip install bionicblue
```

This will install the `pygame` library as well if not already present. To run the installed game, all you need now is to run the `bionicblue` command.


### If you want to use as a standalone program

Download the `bionicblue` folder in the top of the repository folder. Then, if you have `pygame` installed in your Python distribution, just execute the command below in the directory where you put the `bionicblue` folder:

```python
python3 -m bionicblue
```

Depending on your system, you might need to use the `python` command instead of the `python3` command above.


## Contributing

Pull requests to refactor/optimize the existing code or to fix bugs are welcome. For major changes, please [start a discussion](https://github.com/IndiePython/bionic-blue/discussions) first to discuss what you would like to change.

Keep in mind this is a project to design and develop a game, an interactive engaging experience/tale based on a definite subjective concept. Thus, the approach used in an open-ended application doesn't usually work. In such approach, new features are constantly being suggested/implemented as new possibilities arise. This would rather make the game stray from its concept. In other words, the features/improvements must exist within the game's concept.

Furthermore, to achieve the concept, the game has a defined design and set of features. Though such design and set of features are developed iteratively and change over time, they still do so with the purpose of realizing the game's concept.


## Issues

Issues are reserved for bugs or major inconveniences. Please, if you're not certain, [start a discussion](https://github.com/IndiePython/bionic-blue/discussions) instead. It can always be converted into an issue later if needed.

## Contact

Contact me any time via [twitter](https://twitter.com/KennedyRichard), [mastodon](https://fosstodon.org/KennedyRichard) or [email](mailto:kennedy@kennedyrichard.com).

You are also welcome on the Indie Python's [discord server](https://indiepython.com/discord).


## License

Bionic Blue is dedicated to the public domain with [The Unlicense](https://unlicense.org/).


## Help the Indie Python project

Please, [support the Indie Python project](https://indiepython.com/donate) so more free open-source games like this one can be made.


## Why the name on game's title

Making games is arduous and honest work. Musicians, illustrators and many other professionals always sign their works. People who make games should not be afraid of doing so as well. Check [Bennett Foddy and Zach Gage's video](https://www.youtube.com/watch?v=N4UFC0y1tY0) to learn more about this.
