"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketLambdaAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("@aws-cdk/aws-apigatewayv2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
/**
 * Authorize WebSocket Api routes via a lambda function
 */
class WebSocketLambdaAuthorizer {
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_WebSocketLambdaAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketLambdaAuthorizer);
            }
            throw error;
        }
    }
    bind(options) {
        if (this.webSocketApi && (this.webSocketApi.apiId !== options.route.webSocketApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            this.webSocketApi = options.route.webSocketApi;
            this.authorizer = new aws_apigatewayv2_1.WebSocketAuthorizer(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                identitySource: this.props.identitySource ?? [
                    'route.request.header.Authorization',
                ],
                type: aws_apigatewayv2_1.WebSocketAuthorizerType.LAMBDA,
                authorizerName: this.props.authorizerName ?? this.id,
                authorizerUri: lambdaAuthorizerArn(this.handler),
            });
            this.handler.addPermission(`${core_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: core_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.webSocketApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.WebSocketLambdaAuthorizer = WebSocketLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
WebSocketLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers.WebSocketLambdaAuthorizer", version: "1.176.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${core_1.Stack.of(handler).partition}:apigateway:${core_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,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