# coding: utf-8
from __future__ import with_statement
import codecs
import json
import os
import platform
import subprocess
import sys

from fabric.api import *
from fabric.colors import *
from fabric.utils import abort
from fabric.contrib.console import confirm

from .fab_utils import *


env.run = local
env.sudo = local
env.venv = 'env'
env.python = 'python2.7'
env.version = '0.0.1'

# Examples of Usage
# fab --list

# Utilities

def venv():
    return 'source %(env)s/bin/activate' % dict(env=env.venv)

# Tasks

@task
def check():
    env.run('grep -Ir "THE-PROJECT" .')

@task
def bootstrap():
    print(red("Configuring application"))
    env.run('virtualenv %(env)s -p %(python)s' % dict(env=env.venv, python=env.python))
    with prefix(venv()):
        env.run('pip install -r requirements.txt')
        env.run('pip install -r requirements-dev.txt')
    print(green("Bootstrap success"))

@task
def clean():
    env.run('rm -rf ~*')
    env.run('rm -rf *.pyc *.pyo')
    env.run('rm -rf data/')
    env.run('rm -rf *.egg-info')
    env.run('rm -rf dist/')

@task
def install():
    with prefix(venv()):
        env.run('python --version')
        env.run('easy_install pip')

@task
def test():
    env.run('tox')

@task
def tag():
    env.run('git tag %s' % env.version)
    env.run('git push origin %s' % env.version)

@task
def reset_tag():
    env.run('git tag -d %s' % env.version)
    env.run('git push origin :refs/tags/%s' % env.version)

@task
def first_publish():
    with prefix(venv()):
        env.run('python setup.py sdist')
        env.run('python setup.py register')
    publish()

@task
def publish():
    tag()
    # http://guide.python-distribute.org/quickstart.html
    # python setup.py sdist
    # python setup.py register
    # Create a .pypirc file in ~ dir (cp .pypirc ~)
    # python setup.py sdist upload
    # Manual upload to PypI
    # http://pypi.python.org/pypi/THE-PROJECT
    # Go to 'edit' link
    # Update version and save
    # Go to 'files' link and upload the file
    with prefix(venv()):
        env.run('python setup.py sdist upload')

@task
def republish():
    reset_tag()
    publish()
