"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""
from billbeeapi.api_helper import APIHelper


class BillbeeInterfacesBillbeeAPIModelShipment:

    """Implementation of the 'Billbee.Interfaces.BillbeeAPI.Model.Shipment' model.

    Represents a single shipment.

    Attributes:
        billbee_id (long|int): The billbee internal id of the shipment
        shipping_id (string): The id of this shipment
        shipper (string): The name of the shipping provider
        created (datetime): The creation date
        tracking_url (string): The url to track this shipment
        shipping_provider_id (long|int): The id of the used shipping provider
        shipping_provider_product_id (long|int): The id of the used shipping
            provider product
        shipping_carrier (int): The carrier used to ship the parcel with

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "billbee_id": "BillbeeId",
        "shipping_id": "ShippingId",
        "shipper": "Shipper",
        "created": "Created",
        "tracking_url": "TrackingUrl",
        "shipping_provider_id": "ShippingProviderId",
        "shipping_provider_product_id": "ShippingProviderProductId",
        "shipping_carrier": "ShippingCarrier",
    }

    def __init__(
        self,
        billbee_id=None,
        shipping_id=None,
        shipper=None,
        created=None,
        tracking_url=None,
        shipping_provider_id=None,
        shipping_provider_product_id=None,
        shipping_carrier=None,
    ):
        """Constructor for the BillbeeInterfacesBillbeeAPIModelShipment class"""

        # Initialize members of the class
        self.billbee_id = billbee_id
        self.shipping_id = shipping_id
        self.shipper = shipper
        self.created = APIHelper.RFC3339DateTime(created) if created else None
        self.tracking_url = tracking_url
        self.shipping_provider_id = shipping_provider_id
        self.shipping_provider_product_id = shipping_provider_product_id
        self.shipping_carrier = shipping_carrier

    @classmethod
    def from_dictionary(cls, dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        billbee_id = dictionary.get("BillbeeId")
        shipping_id = dictionary.get("ShippingId")
        shipper = dictionary.get("Shipper")
        created = (
            APIHelper.RFC3339DateTime.from_value(dictionary.get("Created")).datetime
            if dictionary.get("Created")
            else None
        )
        tracking_url = dictionary.get("TrackingUrl")
        shipping_provider_id = dictionary.get("ShippingProviderId")
        shipping_provider_product_id = dictionary.get("ShippingProviderProductId")
        shipping_carrier = dictionary.get("ShippingCarrier")

        # Return an object of this model
        return cls(
            billbee_id,
            shipping_id,
            shipper,
            created,
            tracking_url,
            shipping_provider_id,
            shipping_provider_product_id,
            shipping_carrier,
        )
