"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from billbeeapi.api_helper import APIHelper
from billbeeapi.controllers.base_controller import BaseController
from billbeeapi.http.auth.basic_auth import BasicAuth
from billbeeapi.models.microsoft_asp_net_web_hooks_web_hook import MicrosoftAspNetWebHooksWebHook


class WebhooksController(BaseController):

    """A Controller to access Endpoints in the billbeeapi API."""

    def __init__(self, config, call_back=None):
        super().__init__(config, call_back)

    def web_hook_management_get(self):
        """Does a GET request to /api/v1/webhooks.

        Gets all registered WebHooks for a given user.

        Returns:
            list of MicrosoftAspNetWebHooksWebHook: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/webhooks"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, MicrosoftAspNetWebHooksWebHook.from_dictionary)

        return decoded

    def web_hook_management_post(self, web_hook):
        """Does a POST request to /api/v1/webhooks.

        Registers a new WebHook for a given user.

        Args:
            web_hook (MicrosoftAspNetWebHooksWebHook): The webhook to create.
                Attach ?noecho to the uri to prevent echo test.

        Returns:
            MicrosoftAspNetWebHooksWebHook: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/webhooks"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(web_hook)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, MicrosoftAspNetWebHooksWebHook.from_dictionary)

        return decoded

    def web_hook_management_delete_all(self):
        """Does a DELETE request to /api/v1/webhooks.

        Deletes all existing WebHook registrations.

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/webhooks"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def web_hook_management_lookup(self, id):
        """Does a GET request to /api/v1/webhooks/{id}.

        Looks up a registered WebHook with the given {id} for a given user.

        Args:
            id (string): TODO: type description here.

        Returns:
            MicrosoftAspNetWebHooksWebHook: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/webhooks/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, MicrosoftAspNetWebHooksWebHook.from_dictionary)

        return decoded

    def web_hook_management_put(self, id, web_hook):
        """Does a PUT request to /api/v1/webhooks/{id}.

        Updates an existing WebHook registration.

        Args:
            id (string): The WebHook ID.
            web_hook (MicrosoftAspNetWebHooksWebHook): The new webhook to
                use.

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/webhooks/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.put(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(web_hook)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def web_hook_management_delete(self, id):
        """Does a DELETE request to /api/v1/webhooks/{id}.

        Deletes an existing WebHook registration.

        Args:
            id (string): The WebHook ID.

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/webhooks/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def web_hook_management_get_filters(self):
        """Does a GET request to /api/v1/webhooks/filters.

        Returns a list of all known filters you can use to register webhooks

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/webhooks/filters"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded
