"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from billbeeapi.api_helper import APIHelper
from billbeeapi.controllers.base_controller import BaseController
from billbeeapi.http.auth.basic_auth import BasicAuth
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_paged_result_system_collections_generic_list_billbee_interfaces_billbee_api_model_article_api_custom_field_definition_model import (
    RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelArticleApiCustomFieldDefinitionModel,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_paged_result_system_collections_generic_list_billbee_interfaces_billbee_api_model_article_api_model import (
    RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelArticleApiModel,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_billbee_interfaces_billbee_api_model_article_api_custom_field_definition_model import (
    RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelArticleApiCustomFieldDefinitionModel,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_billbee_interfaces_billbee_api_model_article_api_model import (
    RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelArticleApiModel,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_billbee_interfaces_billbee_api_model_article_image_relation_api_model import (
    RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelArticleImageRelationApiModel,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_billbee_interfaces_billbee_api_model_deleted_images_model import (
    RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelDeletedImagesModel,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_billbee_interfaces_billbee_api_model_get_reserved_amount_response_data import (
    RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelGetReservedAmountResponseData,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_billbee_interfaces_billbee_api_model_update_stock_code_response_data import (
    RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelUpdateStockCodeResponseData,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_billbee_interfaces_billbee_api_model_update_stock_response_data import (
    RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelUpdateStockResponseData,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_rechnungsdruck_web_app_controllers_api_search_controller_search_results_model import (
    RechnungsdruckWebAppControllersApiApiResultRechnungsdruckWebAppControllersApiSearchControllerSearchResultsModel,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_system_collections_generic_list_billbee_interfaces_billbee_api_model_article_image_relation_api_model import (
    RechnungsdruckWebAppControllersApiApiResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelArticleImageRelationApiModel,
)


class ProductsController(BaseController):

    """A Controller to access Endpoints in the billbeeapi API."""

    def __init__(self, config, call_back=None):
        super().__init__(config, call_back)

    def article_update_stock(self, model):
        """Does a POST request to /api/v1/products/updatestock.

        The article is specified by sku. You have to send the absolute value
        for the current stock

        Args:
            model (BillbeeInterfacesBillbeeAPIModelUpdateStockApiModel): TODO:
                type description here.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelUpdateStockResponseData: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/updatestock"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelUpdateStockResponseData.from_dictionary,
        )

        return decoded

    def article_get_reserved_amount(self, id, lookup_by=None, stock_id=None):
        """Does a GET request to /api/v1/products/reservedamount.

        Queries the reserved amount for a single article by id or by sku

        Args:
            id (string): The id or the sku of the article to query
            lookup_by (string, optional): Either the value id or the value sku
                to specify the meaning of the id parameter
            stock_id (long|int, optional): Optional the stock id if the multi
                stock feature is enabled

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelGetReservedAmountResponseData: Response from the API.
                OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/reservedamount"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {"id": id, "lookupBy": lookup_by, "stockId": stock_id}
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelGetReservedAmountResponseData.from_dictionary,
        )

        return decoded

    def article_update_stock_multiple(self, models):
        """Does a POST request to /api/v1/products/updatestockmultiple.

        Update the stock qty for multiple articles at once

        Args:
            models (list of
                BillbeeInterfacesBillbeeAPIModelUpdateStockApiModel): TODO:
                type description here.

        Returns:
            list of
                RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBil
                lbeeAPIModelUpdateStockResponseData: Response from the API.
                OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/updatestockmultiple"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(models)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelUpdateStockResponseData.from_dictionary,
        )

        return decoded

    def article_update_stock_code(self, model):
        """Does a POST request to /api/v1/products/updatestockcode.

        Update the stock code of an article

        Args:
            model (BillbeeInterfacesBillbeeAPIModelUpdateStockCodeApiModel):
                TODO: type description here.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelUpdateStockCodeResponseData: Response from the API.
                OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/updatestockcode"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelUpdateStockCodeResponseData.from_dictionary,
        )

        return decoded

    def article_get_article(self, id, lookup_by=None):
        """Does a GET request to /api/v1/products/{id}.

        Queries a single article by id or by sku

        Args:
            id (string): The id or the sku of the article to query
            lookup_by (string, optional): Either the value id, ean or the
                value sku to specify the meaning of the id parameter

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelArticleApiModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {"lookupBy": lookup_by}
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelArticleApiModel.from_dictionary,
        )

        return decoded

    def article_delete_article(self, id):
        """Does a DELETE request to /api/v1/products/{id}.

        Deletes a product

        Args:
            id (long|int): The id of the Product

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def article_patch_article(self, id, model):
        """Does a PATCH request to /api/v1/products/{id}.

        Updates one or more fields of a product

        Args:
            id (long|int): The id of the Product
            model (object): TODO: type description here.

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.patch(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def article_get_list(self, page=None, page_size=None, min_created_at=None):
        """Does a GET request to /api/v1/products.

        Get a list of all products

        Args:
            page (int, optional): The current page to request starting with 1
            page_size (int, optional): The pagesize for the result list.
                Values between 1 and 250 are allowed
            min_created_at (datetime, optional): Optional the oldest create
                date of the articles to be returned

        Returns:
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGe
                nericListBillbeeInterfacesBillbeeAPIModelArticleApiModel:
                Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            "page": page,
            "pageSize": page_size,
            "minCreatedAt": APIHelper.when_defined(APIHelper.RFC3339DateTime, min_created_at),
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelArticleApiModel.from_dictionary,
        )

        return decoded

    def article_create_article(self, model):
        """Does a POST request to /api/v1/products.

        Creates a new product

        Args:
            model (BillbeeInterfacesBillbeeAPIModelArticleApiModel): TODO:
                type description here.

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def article_get_custom_fields(self, page=None, page_size=None):
        """Does a GET request to /api/v1/products/custom-fields.

        Queries a list of all custom fields

        Args:
            page (int, optional): TODO: type description here.
            page_size (int, optional): TODO: type description here.

        Returns:
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGe
                nericListBillbeeInterfacesBillbeeAPIModelArticleApiCustomFieldD
                efinitionModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/custom-fields"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {"page": page, "pageSize": page_size}
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelArticleApiCustomFieldDefinitionModel.from_dictionary,
        )

        return decoded

    def article_get_custom_field(self, id):
        """Does a GET request to /api/v1/products/custom-fields/{id}.

        Queries a single custom field

        Args:
            id (long|int): The id of the custom field to query

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelArticleApiCustomFieldDefinitionModel: Response from
                the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/custom-fields/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelArticleApiCustomFieldDefinitionModel.from_dictionary,
        )

        return decoded

    def article_get_patchable_fields(self):
        """Does a GET request to /api/v1/products/PatchableFields.

        Returns a list of fields which can be updated with the patch call

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/PatchableFields"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def article_get_category(self):
        """Does a GET request to /api/v1/products/category.

        GEts a list of all defined categories

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/category"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def article_get_images(self, product_id):
        """Does a GET request to /api/v1/products/{productId}/images.

        Returns a list of all images of the product

        Args:
            product_id (long|int): The Id of the product

        Returns:
            RechnungsdruckWebAppControllersApiApiResultSystemCollectionsGeneric
                ListBillbeeInterfacesBillbeeAPIModelArticleImageRelationApiMode
                l: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/{productId}/images"
        _url_path = APIHelper.append_url_with_template_parameters(
            _url_path, {"productId": {"value": product_id, "encode": True}}
        )
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelArticleImageRelationApiModel.from_dictionary,
        )

        return decoded

    def article_put_images(self, product_id, models, replace=None):
        """Does a PUT request to /api/v1/products/{productId}/images.

        Add multiple images to a product or replace the product images by the
        given images

        Args:
            product_id (long|int): The id of the product
            models (list of
                BillbeeInterfacesBillbeeAPIModelArticleImageRelationApiModel):
                An array of ArticleApiImageModel
            replace (bool, optional): If you pass true, the images will be
                replaced by the passed images. Otherwise the passed images
                will be appended to the product.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelArticleImageRelationApiModel: Response from the API.
                OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/{productId}/images"
        _url_path = APIHelper.append_url_with_template_parameters(
            _url_path, {"productId": {"value": product_id, "encode": True}}
        )
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {"replace": replace}
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.put(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(models)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelArticleImageRelationApiModel.from_dictionary,
        )

        return decoded

    def article_get_image_from_product(self, product_id, image_id):
        """Does a GET request to /api/v1/products/{productId}/images/{imageId}.

        Returns a single image by id

        Args:
            product_id (long|int): The Id of the product
            image_id (long|int): The Id of the image

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelArticleImageRelationApiModel: Response from the API.
                OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/{productId}/images/{imageId}"
        _url_path = APIHelper.append_url_with_template_parameters(
            _url_path,
            {"productId": {"value": product_id, "encode": True}, "imageId": {"value": image_id, "encode": True}},
        )
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelArticleImageRelationApiModel.from_dictionary,
        )

        return decoded

    def article_put_image(self, product_id, image_id, model):
        """Does a PUT request to /api/v1/products/{productId}/images/{imageId}.

        Add or update an existing image of a product

        Args:
            product_id (long|int): The product id
            image_id (long|int): The image id. If you pass 0, the image will
                be added
            model
                (BillbeeInterfacesBillbeeAPIModelArticleImageRelationApiModel):
                The ArticleApiImageModel

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelArticleImageRelationApiModel: Response from the API.
                OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/{productId}/images/{imageId}"
        _url_path = APIHelper.append_url_with_template_parameters(
            _url_path,
            {"productId": {"value": product_id, "encode": True}, "imageId": {"value": image_id, "encode": True}},
        )
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(model))
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelArticleImageRelationApiModel.from_dictionary,
        )

        return decoded

    def article_delete_image_from_product(self, product_id, image_id):
        """Does a DELETE request to /api/v1/products/{productId}/images/{imageId}.

        Deletes a single image from a product

        Args:
            product_id (long|int): The product id
            image_id (long|int): The image id

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/{productId}/images/{imageId}"
        _url_path = APIHelper.append_url_with_template_parameters(
            _url_path,
            {"productId": {"value": product_id, "encode": True}, "imageId": {"value": image_id, "encode": True}},
        )
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def article_get_image(self, image_id):
        """Does a GET request to /api/v1/products/images/{imageId}.

        Returns a single image by id

        Args:
            image_id (long|int): The Id of the image

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelArticleImageRelationApiModel: Response from the API.
                OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/images/{imageId}"
        _url_path = APIHelper.append_url_with_template_parameters(
            _url_path, {"imageId": {"value": image_id, "encode": True}}
        )
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelArticleImageRelationApiModel.from_dictionary,
        )

        return decoded

    def article_delete_image(self, image_id):
        """Does a DELETE request to /api/v1/products/images/{imageId}.

        Deletes a single image by id

        Args:
            image_id (long|int): The image id

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/images/{imageId}"
        _url_path = APIHelper.append_url_with_template_parameters(
            _url_path, {"imageId": {"value": image_id, "encode": True}}
        )
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.delete(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def article_delete_images(self, image_ids):
        """Does a POST request to /api/v1/products/images/delete.

        Delete multiple images by id

        Args:
            image_ids (list of long|int): TODO: type description here.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelDeletedImagesModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/products/images/delete"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(image_ids)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelDeletedImagesModel.from_dictionary,
        )

        return decoded

    def search_search(self, model):
        """Does a POST request to /api/v1/search.

        Search for products, customers and orders.
        Type can be "order", "product" and / or "customer"
        Term can contains lucene query syntax

        Args:
            model
                (RechnungsdruckWebAppControllersApiSearchControllerSearchModel)
                : TODO: type description here.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultRechnungsdruckWebAppCont
                rollersApiSearchControllerSearchResultsModel: Response from
                the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/search"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultRechnungsdruckWebAppControllersApiSearchControllerSearchResultsModel.from_dictionary,
        )

        return decoded
