"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from billbeeapi.api_helper import APIHelper
from billbeeapi.controllers.base_controller import BaseController
from billbeeapi.exceptions.api_exception import APIException
from billbeeapi.http.auth.basic_auth import BasicAuth
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_paged_result_system_collections_generic_list_billbee_interfaces_billbee_api_model_order import (
    RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelOrder,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_billbee_interfaces_billbee_api_model_order import (
    RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelOrder,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_system_collections_generic_list_billbee_interfaces_billbee_api_models_layout_template import (
    RechnungsdruckWebAppControllersApiApiResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelsLayoutTemplate,
)


class OrdersController(BaseController):

    """A Controller to access Endpoints in the billbeeapi API."""

    def __init__(self, config, call_back=None):
        super().__init__(config, call_back)

    def layout_api_get_list(self):
        """Does a GET request to /api/v1/layouts.

        TODO: type endpoint description here.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultSystemCollectionsGeneric
                ListBillbeeInterfacesBillbeeAPIModelsLayoutTemplate: Response
                from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/layouts"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelsLayoutTemplate.from_dictionary,
        )

        return decoded

    def order_api_get_list(
        self,
        min_order_date=None,
        max_order_date=None,
        page=None,
        page_size=None,
        shop_id=None,
        order_state_id=None,
        tag=None,
        minimum_bill_bee_order_id=None,
        modified_at_min=None,
        modified_at_max=None,
        article_title_source=None,
        exclude_tags=None,
    ):
        """Does a GET request to /api/v1/orders.

        Get a list of all orders optionally filtered by date

        Args:
            min_order_date (datetime, optional): Specifies the oldest order
                date to include in the response
            max_order_date (datetime, optional): Specifies the newest order
                date to include in the response
            page (int, optional): Specifies the page to request
            page_size (int, optional): Specifies the pagesize. Defaults to 50,
                max value is 250
            shop_id (list of long|int, optional): Specifies a list of shop ids
                for which invoices should be included
            order_state_id (list of int, optional): Specifies a list of state
                ids to include in the response
            tag (list of string, optional): Specifies a list of tags the order
                must have attached to be included in the response
            minimum_bill_bee_order_id (long|int, optional): If given, all
                delivered orders have an Id greater than or equal to the given
                minimumOrderId
            modified_at_min (datetime, optional): If given, the last
                modification has to be newer than the given date
            modified_at_max (datetime, optional): If given, the last
                modification has to be older or equal than the given date.
            article_title_source (ArticleTitleSourceEnum, optional): The
                source field for the article title. 0 = Order Position
                (default), 1 = Article Title, 2 = Article Invoice Text
            exclude_tags (bool, optional): If true the list of tags passed to
                the call are used to filter orders to not include these tags

        Returns:
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGe
                nericListBillbeeInterfacesBillbeeAPIModelOrder: Response from
                the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            "minOrderDate": APIHelper.when_defined(APIHelper.RFC3339DateTime, min_order_date),
            "maxOrderDate": APIHelper.when_defined(APIHelper.RFC3339DateTime, max_order_date),
            "page": page,
            "pageSize": page_size,
            "shopId": shop_id,
            "orderStateId": order_state_id,
            "tag": tag,
            "minimumBillBeeOrderId": minimum_bill_bee_order_id,
            "modifiedAtMin": APIHelper.when_defined(APIHelper.RFC3339DateTime, modified_at_min),
            "modifiedAtMax": APIHelper.when_defined(APIHelper.RFC3339DateTime, modified_at_max),
            "articleTitleSource": article_title_source,
            "excludeTags": exclude_tags,
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelOrder.from_dictionary,
        )

        return decoded

    def order_api_post_new_order(self, order_data, shop_id=None):
        """Does a POST request to /api/v1/orders.

        To create an order POST an JSON object to the orders endpoint with the
        shown properties.
        Not all properties are required.

        Args:
            order_data (BillbeeInterfacesBillbeeAPIModelOrder): TODO: type
                description here.
            shop_id (long|int, optional): TODO: type description here.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelOrder: Response from the API. The order was created
                successfully

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {"shopId": shop_id}
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(order_data)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise APIException("Invalid data was received in the request", _response)
        elif _response.status_code == 500:
            raise APIException("An internal exception occured. Order was not created", _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelOrder.from_dictionary,
        )

        return decoded

    def order_api_tags_update(self, tag_data, id):
        """Does a PUT request to /api/v1/orders/{id}/tags.

        Updates/Sets the tags attached to an order

        Args:
            tag_data (RechnungsdruckWebAppControllersApiOrderTagCreate): Tags
                to attach
            id (long|int): The internal id of the order

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/{id}/tags"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.put(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(tag_data)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def order_api_tags_create(self, tag_data, id):
        """Does a POST request to /api/v1/orders/{id}/tags.

        When a tag is already attached, it is ignored. Tags are not case
        sensitive.

        Args:
            tag_data (RechnungsdruckWebAppControllersApiOrderTagCreate): Tags
                to attach
            id (long|int): The internal id of the order

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/{id}/tags"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(tag_data)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def order_api_get(self, id, article_title_source=None):
        """Does a GET request to /api/v1/orders/{id}.

        Get a single order by its internal billbee id. This request is
        throttled to 6 calls per order in one minute

        Args:
            id (long|int): The internal billbee id of the order
            article_title_source (ArticleTitleSourceEnum, optional): The
                source field for the article title. 0 = Order Position
                (default), 1 = Article Title, 2 = Article Invoice Text

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelOrder: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {"articleTitleSource": article_title_source}
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelOrder.from_dictionary,
        )

        return decoded

    def order_api_patch_order(self, id, model):
        """Does a PATCH request to /api/v1/orders/{id}.

        Updates one or more fields of an order

        Args:
            id (long|int): TODO: type description here.
            model (object): TODO: type description here.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelOrder: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.patch(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelOrder.from_dictionary,
        )

        return decoded

    def order_api_get_by_ext_ref(self, ext_ref):
        """Does a GET request to /api/v1/orders/findbyextref/{extRef}.

        Get a single order by its external order number

        Args:
            ext_ref (string): The extern order number of the order

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelOrder: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/findbyextref/{extRef}"
        _url_path = APIHelper.append_url_with_template_parameters(
            _url_path, {"extRef": {"value": ext_ref, "encode": True}}
        )
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelOrder.from_dictionary,
        )

        return decoded

    def order_api_update_state(self, id, model):
        """Does a PUT request to /api/v1/orders/{id}/orderstate.

        ### REMARKS ###
        Use this call to change the state of an order to i.e. paid or sent.
        The state is transfered to the external shop/marketplace if
        configured.
        This is the list of known states:
        - 1: ordered
        - 2: confirmed
        - 3: paid
        - 4: shipped
        - 5: reclamation
        - 6: deleted
        - 7: closed
        - 8: canceled
        - 9: archived
        - 10: not used
        - 11: demand note 1
        - 12: demand note 2
        - 13: packed
        - 14: offered
        - 15: payment reminder
        - 16: fulfilling

        Args:
            id (long|int): The internal id of the order
            model (RechnungsdruckWebAppControllersApiOrderStateUpdate): The
                data used to change the state

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/{id}/orderstate"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(model))
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def order_api_add_shipment(self, id, model):
        """Does a POST request to /api/v1/orders/{id}/shipment.

        Add a shipment to a given order

        Args:
            id (long|int): The internal billbee id of the order
            model
                (RechnungsdruckWebAppControllersApiApiAddShipmentToOrderModel):
                The shipment data to create the shipment

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/{id}/shipment"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def order_api_get_invoice_list(
        self,
        min_invoice_date=None,
        max_invoice_date=None,
        page=None,
        page_size=None,
        shop_id=None,
        order_state_id=None,
        tag=None,
        min_pay_date=None,
        max_pay_date=None,
        include_positions=None,
        exclude_tags=None,
    ):
        """Does a GET request to /api/v1/orders/invoices.

        Get a list of all invoices optionally filtered by date. This request
        ist throttled to 1 per 1 minute for same page and minInvoiceDate

        Args:
            min_invoice_date (datetime, optional): Specifies the oldest
                invoice date to include
            max_invoice_date (datetime, optional): Specifies the newest
                invoice date to include
            page (int, optional): Specifies the page to request
            page_size (int, optional): Specifies the pagesize. Defaults to 50,
                max value is 250
            shop_id (list of long|int, optional): Specifies a list of shop ids
                for which invoices should be included
            order_state_id (list of int, optional): Specifies a list of state
                ids to include in the response
            tag (list of string, optional): TODO: type description here.
            min_pay_date (datetime, optional): TODO: type description here.
            max_pay_date (datetime, optional): TODO: type description here.
            include_positions (bool, optional): TODO: type description here.
            exclude_tags (bool, optional): If true the list of tags passed to
                the call are used to filter orders to not include these tags

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/invoices"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            "minInvoiceDate": APIHelper.when_defined(APIHelper.RFC3339DateTime, min_invoice_date),
            "maxInvoiceDate": APIHelper.when_defined(APIHelper.RFC3339DateTime, max_invoice_date),
            "page": page,
            "pageSize": page_size,
            "shopId": shop_id,
            "orderStateId": order_state_id,
            "tag": tag,
            "minPayDate": APIHelper.when_defined(APIHelper.RFC3339DateTime, min_pay_date),
            "maxPayDate": APIHelper.when_defined(APIHelper.RFC3339DateTime, max_pay_date),
            "includePositions": include_positions,
            "excludeTags": exclude_tags,
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def order_api_find(self, id, partner):
        """Does a GET request to /api/v1/orders/find/{id}/{partner}.

        Find a single order by its external id (order number)

        Args:
            id (string): The order id from the external system
            partner (string): Optional the name of the shop/marketplace the
                order was imported from

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/find/{id}/{partner}"
        _url_path = APIHelper.append_url_with_template_parameters(
            _url_path, {"id": {"value": id, "encode": True}, "partner": {"value": partner, "encode": True}}
        )
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def order_api_create_delivery_note(self, id, include_pdf=None, send_to_cloud_id=None):
        """Does a POST request to /api/v1/orders/CreateDeliveryNote/{id}.

        Create an delivery note for an existing order. This request is extra
        throttled by order and api key to a maximum of 1 per 5 minutes.

        Args:
            id (long|int): The internal billbee id of the order
            include_pdf (bool, optional): If true, the PDF is included in the
                response as base64 encoded string
            send_to_cloud_id (long|int, optional): Optionally specify the id
                of a billbee connected cloud device to send the pdf to

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/CreateDeliveryNote/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {"includePdf": include_pdf, "sendToCloudId": send_to_cloud_id}
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def order_api_create_invoice(self, id, include_invoice_pdf=None, template_id=None, send_to_cloud_id=None):
        """Does a POST request to /api/v1/orders/CreateInvoice/{id}.

        Create an invoice for an existing order. This request is extra
        throttled by order and api key to a maximum of 1 per 5 minutes.

        Args:
            id (long|int): The internal billbee id of the order
            include_invoice_pdf (bool, optional): If true, the PDF is included
                in the response as base64 encoded string
            template_id (long|int, optional): You can pass the id of an
                invoice template to overwrite the assigned template for
                invoice creation
            send_to_cloud_id (long|int, optional): You can pass the id of a
                connected cloud printer/storage to send the invoice to it

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/CreateInvoice/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            "includeInvoicePdf": include_invoice_pdf,
            "templateId": template_id,
            "sendToCloudId": send_to_cloud_id,
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def order_api_get_patchable_fields(self):
        """Does a GET request to /api/v1/orders/PatchableFields.

        Returns a list of fields which can be updated with the orders/{id}
        patch call

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/PatchableFields"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def order_api_send_message(self, id, model):
        """Does a POST request to /api/v1/orders/{id}/send-message.

        Sends a message to the buyer

        Args:
            id (long|int): The id of the order
            model
                (RechnungsdruckWebAppControllersApiOrderApiControllerSendMessag
                eModel): The message model

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/{id}/send-message"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def order_api_trigger_event(self, id, model):
        """Does a POST request to /api/v1/orders/{id}/trigger-event.

        Triggers a rule event

        Args:
            id (long|int): The id of the order
            model
                (RechnungsdruckWebAppControllersApiOrderApiControllerTriggerEve
                ntContainer): TODO: type description here.

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/{id}/trigger-event"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded

    def order_api_parse_placeholders(self, id, container):
        """Does a POST request to /api/v1/orders/{id}/parse-placeholders.

        Parses a text and replaces all placeholders

        Args:
            id (long|int): The id of the order
            container
                (RechnungsdruckWebAppControllersApiOrderApiControllerParseTextC
                ontainer): TODO: type description here.

        Returns:
            object: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/orders/{id}/parse-placeholders"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(container)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = _response.text

        return decoded
