"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from billbeeapi.api_helper import APIHelper
from billbeeapi.controllers.base_controller import BaseController
from billbeeapi.http.auth.basic_auth import BasicAuth
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_paged_result_system_collections_generic_list_billbee_interfaces_billbee_api_model_customer_address_api_model import (
    RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_paged_result_system_collections_generic_list_billbee_interfaces_billbee_api_model_customer_api_model import (
    RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelCustomerApiModel,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_paged_result_system_collections_generic_list_rechnungsdruck_web_app_controllers_api_order import (
    RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListRechnungsdruckWebAppControllersApiOrder,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_billbee_interfaces_billbee_api_model_customer_address_api_model import (
    RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_billbee_interfaces_billbee_api_model_customer_api_model import (
    RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerApiModel,
)


class CustomersController(BaseController):

    """A Controller to access Endpoints in the billbeeapi API."""

    def __init__(self, config, call_back=None):
        super().__init__(config, call_back)

    def customer_get_all(self, page=None, page_size=None):
        """Does a GET request to /api/v1/customers.

        Get a list of all customers

        Args:
            page (int, optional): The current page to request starting with 1
            page_size (int, optional): The pagesize for the result list.
                Values between 1 and 250 are allowed

        Returns:
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGe
                nericListBillbeeInterfacesBillbeeAPIModelCustomerApiModel:
                Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customers"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {"page": page, "pageSize": page_size}
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelCustomerApiModel.from_dictionary,
        )

        return decoded

    def customer_create(self, model):
        """Does a POST request to /api/v1/customers.

        Creates a new customer

        Args:
            model (BillbeeInterfacesBillbeeAPIModelCreateCustomerApiModel):
                TODO: type description here.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelCustomerApiModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customers"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerApiModel.from_dictionary,
        )

        return decoded

    def customer_get_one(self, id):
        """Does a GET request to /api/v1/customers/{id}.

        Queries a single customer by id

        Args:
            id (long|int): The id of the customer to query

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelCustomerApiModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customers/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerApiModel.from_dictionary,
        )

        return decoded

    def customer_update(self, model, id):
        """Does a PUT request to /api/v1/customers/{id}.

        Updates a customer by id

        Args:
            model (BillbeeInterfacesBillbeeAPIModelCustomerApiModel): TODO:
                type description here.
            id (long|int): The id of the customer

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelCustomerApiModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customers/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(model))
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerApiModel.from_dictionary,
        )

        return decoded

    def customer_get_customer_orders(self, id, page=None, page_size=None):
        """Does a GET request to /api/v1/customers/{id}/orders.

        Queries a list of orders from a customer

        Args:
            id (long|int): The id of the customer
            page (int, optional): The current page to request starting with 1
            page_size (int, optional): The pagesize for the result list.
                Values between 1 and 250 are allowed

        Returns:
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGe
                nericListRechnungsdruckWebAppControllersApiOrder: Response
                from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customers/{id}/orders"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {"page": page, "pageSize": page_size}
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListRechnungsdruckWebAppControllersApiOrder.from_dictionary,
        )

        return decoded

    def customer_get_customer_addresses(self, id, page=None, page_size=None):
        """Does a GET request to /api/v1/customers/{id}/addresses.

        Queries a list of addresses from a customer

        Args:
            id (long|int): The id of the customer
            page (int, optional): The current page to request starting with 1
            page_size (int, optional): The pagesize for the result list.
                Values between 1 and 250 are allowed

        Returns:
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGe
                nericListBillbeeInterfacesBillbeeAPIModelCustomerAddressApiMode
                l: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customers/{id}/addresses"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {"page": page, "pageSize": page_size}
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel.from_dictionary,
        )

        return decoded

    def customer_add_customer_address(self, id, model):
        """Does a POST request to /api/v1/customers/{id}/addresses.

        Id and  CustomerId will be ignored in model. If Id is set, the
        addition will be stopped.

        Args:
            id (long|int): CustomerId to attach the new address to.
            model (BillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel):
                Model containing the address, that should be attached.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelCustomerAddressApiModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customers/{id}/addresses"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel.from_dictionary,
        )

        return decoded

    def customer_get_customer_address(self, id):
        """Does a GET request to /api/v1/customers/addresses/{id}.

        Queries a single address from a customer

        Args:
            id (long|int): The id of the address

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelCustomerAddressApiModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customers/addresses/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel.from_dictionary,
        )

        return decoded

    def customer_update_address(self, model, id):
        """Does a PUT request to /api/v1/customers/addresses/{id}.

        Id and CustomerId cannot be changed. Fields you do not send will
        become empty.

        Args:
            model (BillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel):
                The updated address. Please query an address via (todo) to see
                all fields. Note that Id and CustomerId cannot be changed.
            id (long|int): The id of the address

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelCustomerAddressApiModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customers/addresses/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(model))
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel.from_dictionary,
        )

        return decoded

    def customer_patch_address(self, id, model):
        """Does a PATCH request to /api/v1/customers/addresses/{id}.

        Id and CustomerId cannot be changed

        Args:
            id (long|int): The id of the address
            model (object): The address fields to be changed. Please query an
                address via (todo) to see all fields. Note that Id and
                CustomerId cannot be changed.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelCustomerAddressApiModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customers/addresses/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.patch(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel.from_dictionary,
        )

        return decoded
