"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from billbeeapi.api_helper import APIHelper
from billbeeapi.controllers.base_controller import BaseController
from billbeeapi.http.auth.basic_auth import BasicAuth
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_paged_result_system_collections_generic_list_billbee_interfaces_billbee_api_model_customer_address_api_model import (
    RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel,
)
from billbeeapi.models.rechnungsdruck_web_app_controllers_api_api_result_billbee_interfaces_billbee_api_model_customer_address_api_model import (
    RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel,
)


class CustomerAddressesController(BaseController):

    """A Controller to access Endpoints in the billbeeapi API."""

    def __init__(self, config, call_back=None):
        super().__init__(config, call_back)

    def customer_addresses_get_all(self, page=None, page_size=None):
        """Does a GET request to /api/v1/customer-addresses.

        Get a list of all customer addresses

        Args:
            page (int, optional): The current page to request starting with 1
                (default is 1)
            page_size (int, optional): The page size for the result list.
                Values between 1 and 250 are allowed. (default is 50)

        Returns:
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGe
                nericListBillbeeInterfacesBillbeeAPIModelCustomerAddressApiMode
                l: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customer-addresses"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {"page": page, "pageSize": page_size}
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder, _query_parameters)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiPagedResultSystemCollectionsGenericListBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel.from_dictionary,
        )

        return decoded

    def customer_addresses_create(self, model):
        """Does a POST request to /api/v1/customer-addresses.

        Creates a new customer address

        Args:
            model (BillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel):
                TODO: type description here.

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelCustomerAddressApiModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customer-addresses"
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.post(
            _query_url, headers=_headers, parameters=APIHelper.json_serialize(model)
        )
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel.from_dictionary,
        )

        return decoded

    def customer_addresses_get_one(self, id):
        """Does a GET request to /api/v1/customer-addresses/{id}.

        Queries a single customer address by id

        Args:
            id (long|int): The id of the address to query

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelCustomerAddressApiModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customer-addresses/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json"}

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel.from_dictionary,
        )

        return decoded

    def customer_addresses_update(self, model, id):
        """Does a PUT request to /api/v1/customer-addresses/{id}.

        Updates a customer address by id

        Args:
            model (BillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel):
                TODO: type description here.
            id (long|int): The id of the address

        Returns:
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbee
                APIModelCustomerAddressApiModel: Response from the API. OK

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = "/api/v1/customer-addresses/{id}"
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {"id": {"value": id, "encode": True}})
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {"accept": "application/json", "content-type": "application/json; charset=utf-8"}

        # Prepare and execute request
        _request = self.config.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(model))
        BasicAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(
            _response.text,
            RechnungsdruckWebAppControllersApiApiResultBillbeeInterfacesBillbeeAPIModelCustomerAddressApiModel.from_dictionary,
        )

        return decoded
