"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from enum import Enum

from billbeeapi.http.requests_client import RequestsClient


class Environment(Enum):
    """An enum for SDK environments"""

    PRODUCTION = 0


class Server(Enum):
    """An enum for API servers"""

    DEFAULT = 0


class Configuration:
    """A class used for configuring the SDK by a user."""

    @property
    def http_client(self):
        return self._http_client

    @property
    def timeout(self):
        return self._timeout

    @property
    def max_retries(self):
        return self._max_retries

    @property
    def backoff_factor(self):
        return self._backoff_factor

    @property
    def environment(self):
        return self._environment

    @property
    def basic_auth_user_name(self):
        return self._basic_auth_user_name

    @property
    def basic_auth_password(self):
        return self._basic_auth_password

    @property
    def api_key(self):
        return self._api_key

    def __init__(
        self,
        timeout=60,
        max_retries=3,
        backoff_factor=0,
        environment=Environment.PRODUCTION,
        basic_auth_user_name="TODO: Replace",
        basic_auth_password="TODO: Replace",
        api_key="TODO: Replace",
    ):
        # The value to use for connection timeout
        self._timeout = timeout

        # The number of times to retry an endpoint call if it fails
        self._max_retries = max_retries

        # A backoff factor to apply between attempts after the second try.
        # urllib3 will sleep for:
        # `{backoff factor} * (2 ** ({number of total retries} - 1))`
        self._backoff_factor = backoff_factor

        # Current API environment
        self._environment = environment

        # The username to use with basic authentication
        self._basic_auth_user_name = basic_auth_user_name

        # The password to use with basic authentication
        self._basic_auth_password = basic_auth_password

        # The api key to send as HTTP header X-Billbee-Api-Key to identifying the application/developer
        self._api_key = api_key

        # The Http Client to use for making requests.
        self._http_client = self.create_http_client()

    def clone_with(
        self,
        timeout=None,
        max_retries=None,
        backoff_factor=None,
        environment=None,
        basic_auth_user_name=None,
        basic_auth_password=None,
        api_key=None,
    ):
        timeout = timeout or self.timeout
        max_retries = max_retries or self.max_retries
        backoff_factor = backoff_factor or self.backoff_factor
        environment = environment or self.environment
        basic_auth_user_name = basic_auth_user_name or self.basic_auth_user_name
        basic_auth_password = basic_auth_password or self.basic_auth_password
        api_key = api_key or self.api_key

        return Configuration(
            timeout=timeout,
            max_retries=max_retries,
            backoff_factor=backoff_factor,
            environment=environment,
            basic_auth_user_name=basic_auth_user_name,
            basic_auth_password=basic_auth_password,
            api_key=api_key,
        )

    def create_http_client(self):
        return RequestsClient(timeout=self.timeout, max_retries=self.max_retries, backoff_factor=self.backoff_factor)

    # All the environments the SDK can run in
    environments = {Environment.PRODUCTION: {Server.DEFAULT: "https://app.billbee.io"}}

    def get_base_uri(self, server=Server.DEFAULT):
        """Generates the appropriate base URI for the environment and the
        server.

        Args:
            server (Configuration.Server): The server enum for which the base
            URI is required.

        Returns:
            String: The base URI.

        """
        return self.environments[self.environment][server]
