"""
billbeeapi

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from billbeeapi.configuration import Configuration, Environment
from billbeeapi.controllers.cloud_storage_controller import CloudStorageController
from billbeeapi.controllers.customer_addresses_controller import CustomerAddressesController
from billbeeapi.controllers.customers_controller import CustomersController
from billbeeapi.controllers.enum_api_controller import EnumApiController
from billbeeapi.controllers.events_controller import EventsController
from billbeeapi.controllers.orders_controller import OrdersController
from billbeeapi.controllers.products_controller import ProductsController
from billbeeapi.controllers.provisioning_controller import ProvisioningController
from billbeeapi.controllers.shipments_controller import ShipmentsController
from billbeeapi.controllers.webhooks_controller import WebhooksController
from billbeeapi.decorators import lazy_property


class BillbeeapiClient:
    @lazy_property
    def products(self):
        return ProductsController(self.config)

    @lazy_property
    def provisioning(self):
        return ProvisioningController(self.config)

    @lazy_property
    def cloud_storage(self):
        return CloudStorageController(self.config)

    @lazy_property
    def customers(self):
        return CustomersController(self.config)

    @lazy_property
    def customer_addresses(self):
        return CustomerAddressesController(self.config)

    @lazy_property
    def enum_api(self):
        return EnumApiController(self.config)

    @lazy_property
    def events(self):
        return EventsController(self.config)

    @lazy_property
    def orders(self):
        return OrdersController(self.config)

    @lazy_property
    def shipments(self):
        return ShipmentsController(self.config)

    @lazy_property
    def webhooks(self):
        return WebhooksController(self.config)

    def __init__(
        self,
        timeout=60,
        max_retries=3,
        backoff_factor=0,
        environment=Environment.PRODUCTION,
        basic_auth_user_name="TODO: Replace",
        basic_auth_password="TODO: Replace",
        api_key="TODO: Replace",
        config=None,
    ):
        if config is None:
            self.config = Configuration(
                timeout=timeout,
                max_retries=max_retries,
                backoff_factor=backoff_factor,
                environment=environment,
                basic_auth_user_name=basic_auth_user_name,
                basic_auth_password=basic_auth_password,
                api_key=api_key,
            )
        else:
            self.config = config
