(self["webpackChunk_jupyterlite_xeus_nelson_kernel"] = self["webpackChunk_jupyterlite_xeus_nelson_kernel"] || []).push([["vendors-node_modules_jupyterlite_contents_lib_index_js"],{

/***/ "./node_modules/@jupyterlite/contents/lib/broadcast.js":
/*!*************************************************************!*\
  !*** ./node_modules/@jupyterlite/contents/lib/broadcast.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BroadcastChannelWrapper": () => (/* binding */ BroadcastChannelWrapper)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emscripten__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./emscripten */ "./node_modules/@jupyterlite/contents/lib/emscripten.js");
/* harmony import */ var _drivefs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./drivefs */ "./node_modules/@jupyterlite/contents/lib/drivefs.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/** A broadcaster for the ServiceWorker */
class BroadcastChannelWrapper {
    constructor(options) {
        this.isDisposed = false;
        /** Handle a message received on the BroadcastChannel */
        this._onMessage = async (event) => {
            if (!this._channel) {
                return;
            }
            const { _contents } = this;
            const request = event.data;
            const { path } = request;
            // many successful responses default to null
            let response = null;
            // most requests will use a model
            let model;
            switch (request.method) {
                case 'readdir':
                    model = await _contents.get(path, { content: true });
                    response = [];
                    if (model.type === 'directory' && model.content) {
                        response = model.content.map((subcontent) => subcontent.name);
                    }
                    break;
                case 'rmdir':
                    await _contents.delete(path);
                    break;
                case 'rename':
                    await _contents.rename(path, request.data.newPath);
                    break;
                case 'getmode':
                    model = await _contents.get(path);
                    if (model.type === 'directory') {
                        response = _emscripten__WEBPACK_IMPORTED_MODULE_1__.DIR_MODE;
                    }
                    else {
                        response = _emscripten__WEBPACK_IMPORTED_MODULE_1__.FILE_MODE;
                    }
                    break;
                case 'lookup':
                    try {
                        model = await _contents.get(path);
                        response = {
                            ok: true,
                            mode: model.type === 'directory' ? _emscripten__WEBPACK_IMPORTED_MODULE_1__.DIR_MODE : _emscripten__WEBPACK_IMPORTED_MODULE_1__.FILE_MODE,
                        };
                    }
                    catch (e) {
                        response = { ok: false };
                    }
                    break;
                case 'mknod':
                    model = await _contents.newUntitled({
                        path: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.dirname(path),
                        type: Number.parseInt(request.data.mode) === _emscripten__WEBPACK_IMPORTED_MODULE_1__.DIR_MODE ? 'directory' : 'file',
                        ext: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.extname(path),
                    });
                    await _contents.rename(model.path, path);
                    break;
                case 'getattr':
                    model = await _contents.get(path);
                    response = {
                        dev: 1,
                        nlink: 1,
                        uid: 0,
                        gid: 0,
                        rdev: 0,
                        size: model.size || 0,
                        blksize: _drivefs__WEBPACK_IMPORTED_MODULE_2__.BLOCK_SIZE,
                        blocks: Math.ceil(model.size || 0 / _drivefs__WEBPACK_IMPORTED_MODULE_2__.BLOCK_SIZE),
                        atime: model.last_modified,
                        mtime: model.last_modified,
                        ctime: model.created,
                        timestamp: 0,
                    };
                    break;
                case 'get':
                    model = await _contents.get(path, { content: true });
                    if (model.type === 'directory') {
                        break;
                    }
                    response = {
                        content: model.format === 'json' ? JSON.stringify(model.content) : model.content,
                        format: model.format,
                    };
                    break;
                case 'put':
                    await _contents.save(path, {
                        content: request.data.format === 'json'
                            ? JSON.parse(request.data.data)
                            : request.data.data,
                        type: 'file',
                        format: request.data.format,
                    });
                    break;
                default:
                    response = null;
                    break;
            }
            this._channel.postMessage(response);
        };
        this._channel = null;
        this._enabled = false;
        this._contents = options.contents;
    }
    get enabled() {
        return this._enabled;
    }
    enable() {
        if (this._channel) {
            console.warn('BroadcastChannel already created and enabled');
            return;
        }
        this._channel = new BroadcastChannel(_drivefs__WEBPACK_IMPORTED_MODULE_2__.DRIVE_API_PATH);
        this._channel.addEventListener('message', this._onMessage);
        this._enabled = true;
    }
    disable() {
        if (this._channel) {
            this._channel.removeEventListener('message', this._onMessage);
            this._channel = null;
        }
        this._enabled = false;
    }
    /** Clean up the broadcaster. */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this.disable();
        this.isDisposed = true;
    }
}
//# sourceMappingURL=broadcast.js.map

/***/ }),

/***/ "./node_modules/@jupyterlite/contents/lib/contents.js":
/*!************************************************************!*\
  !*** ./node_modules/@jupyterlite/contents/lib/contents.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Contents": () => (/* binding */ Contents)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./tokens */ "./node_modules/@jupyterlite/contents/lib/tokens.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);




/**
 * The name of the local storage.
 */
const DEFAULT_STORAGE_NAME = 'JupyterLite Storage';
/**
 * The number of checkpoints to save.
 */
const N_CHECKPOINTS = 5;
/**
 * A class to handle requests to /api/contents
 */
class Contents {
    /**
     * Construct a new localForage-powered contents provider
     */
    constructor(options) {
        /**
         * A reducer for turning arbitrary binary into a string
         */
        this.reduceBytesToString = (data, byte) => {
            return data + String.fromCharCode(byte);
        };
        this._serverContents = new Map();
        this._storageName = DEFAULT_STORAGE_NAME;
        this._storageDrivers = null;
        this._localforage = options.localforage;
        this._storageName = options.storageName || DEFAULT_STORAGE_NAME;
        this._storageDrivers = options.storageDrivers || null;
        this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();
    }
    /**
     * Finish any initialization after server has started and all extensions are applied.
     */
    async initialize() {
        await this.initStorage();
        this._ready.resolve(void 0);
    }
    /**
     * Initialize all storage instances
     */
    async initStorage() {
        this._storage = this.createDefaultStorage();
        this._counters = this.createDefaultCounters();
        this._checkpoints = this.createDefaultCheckpoints();
    }
    /**
     * A promise that resolves once all storage is fully initialized.
     */
    get ready() {
        return this._ready.promise;
    }
    /**
     * A lazy reference to the underlying storage.
     */
    get storage() {
        return this.ready.then(() => this._storage);
    }
    /**
     * A lazy reference to the underlying counters.
     */
    get counters() {
        return this.ready.then(() => this._counters);
    }
    /**
     * A lazy reference to the underlying checkpoints.
     */
    get checkpoints() {
        return this.ready.then(() => this._checkpoints);
    }
    /**
     * Get default options for localForage instances
     */
    get defaultStorageOptions() {
        const driver = this._storageDrivers && this._storageDrivers.length ? this._storageDrivers : null;
        return {
            version: 1,
            name: this._storageName,
            ...(driver ? { driver } : {}),
        };
    }
    /**
     * Initialize the default storage for contents.
     */
    createDefaultStorage() {
        return this._localforage.createInstance({
            description: 'Offline Storage for Notebooks and Files',
            storeName: 'files',
            ...this.defaultStorageOptions,
        });
    }
    /**
     * Initialize the default storage for counting file suffixes.
     */
    createDefaultCounters() {
        return this._localforage.createInstance({
            description: 'Store the current file suffix counters',
            storeName: 'counters',
            ...this.defaultStorageOptions,
        });
    }
    /**
     * Create the default checkpoint storage.
     */
    createDefaultCheckpoints() {
        return this._localforage.createInstance({
            description: 'Offline Storage for Checkpoints',
            storeName: 'checkpoints',
            ...this.defaultStorageOptions,
        });
    }
    /**
     * Create a new untitled file or directory in the specified directory path.
     *
     * @param options: The options used to create the file.
     *
     * @returns A promise which resolves with the created file content when the file is created.
     */
    async newUntitled(options) {
        var _a, _b, _c;
        const path = (_a = options === null || options === void 0 ? void 0 : options.path) !== null && _a !== void 0 ? _a : '';
        const type = (_b = options === null || options === void 0 ? void 0 : options.type) !== null && _b !== void 0 ? _b : 'notebook';
        const created = new Date().toISOString();
        let dirname = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.dirname(path);
        const basename = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.basename(path);
        const extname = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.extname(path);
        const item = await this.get(dirname);
        // handle the case of "Save As", where the path points to the new file
        // to create, e.g. subfolder/example-copy.ipynb
        let name = '';
        if (path && !extname && item) {
            // directory
            dirname = `${path}/`;
            name = '';
        }
        else if (dirname && basename) {
            // file in a subfolder
            dirname = `${dirname}/`;
            name = basename;
        }
        else {
            // file at the top level
            dirname = '';
            name = path;
        }
        let file;
        switch (type) {
            case 'directory': {
                const counter = await this._incrementCounter('directory');
                name = `Untitled Folder${counter || ''}`;
                file = {
                    name,
                    path: `${dirname}${name}`,
                    last_modified: created,
                    created,
                    format: 'json',
                    mimetype: '',
                    content: null,
                    size: 0,
                    writable: true,
                    type: 'directory',
                };
                break;
            }
            case 'notebook': {
                const counter = await this._incrementCounter('notebook');
                name = name || `Untitled${counter || ''}.ipynb`;
                file = {
                    name,
                    path: `${dirname}${name}`,
                    last_modified: created,
                    created,
                    format: 'json',
                    mimetype: _tokens__WEBPACK_IMPORTED_MODULE_2__.MIME.JSON,
                    content: Private.EMPTY_NB,
                    size: JSON.stringify(Private.EMPTY_NB).length,
                    writable: true,
                    type: 'notebook',
                };
                break;
            }
            default: {
                const ext = (_c = options === null || options === void 0 ? void 0 : options.ext) !== null && _c !== void 0 ? _c : '.txt';
                const counter = await this._incrementCounter('file');
                const mimetype = _tokens__WEBPACK_IMPORTED_MODULE_2__.FILE.getType(ext) || _tokens__WEBPACK_IMPORTED_MODULE_2__.MIME.OCTET_STREAM;
                let format;
                if (_tokens__WEBPACK_IMPORTED_MODULE_2__.FILE.hasFormat(ext, 'text') || mimetype.indexOf('text') !== -1) {
                    format = 'text';
                }
                else if (ext.indexOf('json') !== -1 || ext.indexOf('ipynb') !== -1) {
                    format = 'json';
                }
                else {
                    format = 'base64';
                }
                name = name || `untitled${counter || ''}${ext}`;
                file = {
                    name,
                    path: `${dirname}${name}`,
                    last_modified: created,
                    created,
                    format,
                    mimetype,
                    content: '',
                    size: 0,
                    writable: true,
                    type: 'file',
                };
                break;
            }
        }
        const key = file.path;
        await (await this.storage).setItem(key, file);
        return file;
    }
    /**
     * Copy a file into a given directory.
     *
     * @param path - The original file path.
     * @param toDir - The destination directory path.
     *
     * @returns A promise which resolves with the new contents model when the
     *  file is copied.
     *
     * #### Notes
     * The server will select the name of the copied file.
     */
    async copy(path, toDir) {
        let name = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.basename(path);
        toDir = toDir === '' ? '' : `${toDir.slice(1)}/`;
        // TODO: better handle naming collisions with existing files
        while (await this.get(`${toDir}${name}`, { content: true })) {
            const ext = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.extname(name);
            const base = name.replace(ext, '');
            name = `${base} (copy)${ext}`;
        }
        const toPath = `${toDir}${name}`;
        let item = await this.get(path, { content: true });
        if (!item) {
            throw Error(`Could not find file with path ${path}`);
        }
        item = {
            ...item,
            name,
            path: toPath,
        };
        await (await this.storage).setItem(toPath, item);
        return item;
    }
    /**
     * Get a file or directory.
     *
     * @param path: The path to the file.
     * @param options: The options used to fetch the file.
     *
     * @returns A promise which resolves with the file content.
     */
    async get(path, options) {
        // remove leading slash
        path = decodeURIComponent(path.replace(/^\//, ''));
        if (path === '') {
            return await this._getFolder(path);
        }
        const storage = await this.storage;
        const item = await storage.getItem(path);
        const serverItem = await this._getServerContents(path, options);
        const model = (item || serverItem);
        if (!model) {
            return null;
        }
        if (!(options === null || options === void 0 ? void 0 : options.content)) {
            return {
                size: 0,
                ...model,
                content: null,
            };
        }
        // for directories, find all files with the path as the prefix
        if (model.type === 'directory') {
            const contentMap = new Map();
            await storage.iterate((file, key) => {
                // use an additional slash to not include the directory itself
                if (key === `${path}/${file.name}`) {
                    contentMap.set(file.name, file);
                }
            });
            const serverContents = serverItem
                ? serverItem.content
                : Array.from((await this._getServerDirectory(path)).values());
            for (const file of serverContents) {
                if (!contentMap.has(file.name)) {
                    contentMap.set(file.name, file);
                }
            }
            const content = [...contentMap.values()];
            return {
                name: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.basename(path),
                path,
                last_modified: model.last_modified,
                created: model.created,
                format: 'json',
                mimetype: _tokens__WEBPACK_IMPORTED_MODULE_2__.MIME.JSON,
                content,
                size: 0,
                writable: true,
                type: 'directory',
            };
        }
        return model;
    }
    /**
     * Rename a file or directory.
     *
     * @param oldLocalPath - The original file path.
     * @param newLocalPath - The new file path.
     *
     * @returns A promise which resolves with the new file content model when the file is renamed.
     */
    async rename(oldLocalPath, newLocalPath) {
        const path = decodeURIComponent(oldLocalPath);
        const file = await this.get(path, { content: true });
        if (!file) {
            throw Error(`Could not find file with path ${path}`);
        }
        const modified = new Date().toISOString();
        const name = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.basename(newLocalPath);
        const newFile = {
            ...file,
            name,
            path: newLocalPath,
            last_modified: modified,
        };
        const storage = await this.storage;
        await storage.setItem(newLocalPath, newFile);
        // remove the old file
        await storage.removeItem(path);
        // remove the corresponding checkpoint
        await (await this.checkpoints).removeItem(path);
        // if a directory, recurse through all children
        if (file.type === 'directory') {
            let child;
            for (child of file.content) {
                await this.rename(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(oldLocalPath, child.name), _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(newLocalPath, child.name));
            }
        }
        return newFile;
    }
    /**
     * Save a file.
     *
     * @param path - The desired file path.
     * @param options - Optional overrides to the model.
     *
     * @returns A promise which resolves with the file content model when the file is saved.
     */
    async save(path, options = {}) {
        var _a;
        path = decodeURIComponent(path);
        // process the file if coming from an upload
        const ext = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.extname((_a = options.name) !== null && _a !== void 0 ? _a : '');
        let item = await this.get(path);
        if (!item) {
            item = await this.newUntitled({ path, ext, type: 'file' });
        }
        if (!item) {
            return null;
        }
        // override with the new values
        const modified = new Date().toISOString();
        item = {
            ...item,
            ...options,
            last_modified: modified,
        };
        if (options.content && options.format === 'base64') {
            if (ext === '.ipynb') {
                const contentUnescaped = this.unescapeContent(options.content);
                const size = contentUnescaped.length;
                item = {
                    ...item,
                    content: JSON.parse(contentUnescaped),
                    format: 'json',
                    type: 'notebook',
                    size: size,
                };
            }
            else if (_tokens__WEBPACK_IMPORTED_MODULE_2__.FILE.hasFormat(ext, 'json')) {
                const contentUnescaped = this.unescapeContent(options.content);
                const size = contentUnescaped.length;
                item = {
                    ...item,
                    content: JSON.parse(contentUnescaped),
                    format: 'json',
                    type: 'file',
                    size: size,
                };
            }
            else if (_tokens__WEBPACK_IMPORTED_MODULE_2__.FILE.hasFormat(ext, 'text')) {
                const contentUnescaped = this.unescapeContent(options.content);
                const size = contentUnescaped.length;
                item = {
                    ...item,
                    content: contentUnescaped,
                    format: 'text',
                    type: 'file',
                    size: size,
                };
            }
            else {
                item = {
                    ...item,
                    size: atob(options.content).length,
                };
            }
        }
        await (await this.storage).setItem(path, item);
        return item;
    }
    unescapeContent(content) {
        return decodeURIComponent(escape(atob(content)));
    }
    /**
     * Delete a file from browser storage.
     *
     * Has no effect on server-backed files, which will re-appear with their
     * original timestamp.
     *
     * @param path - The path to the file.
     */
    async delete(path) {
        path = decodeURIComponent(path);
        const slashed = `${path}/`;
        const toDelete = (await (await this.storage).keys()).filter((key) => key === path || key.startsWith(slashed));
        await Promise.all(toDelete.map(this.forgetPath, this));
    }
    /**
     * Remove the localForage and checkpoints for a path.
     *
     * @param path - The path to the file
     */
    async forgetPath(path) {
        await Promise.all([
            (await this.storage).removeItem(path),
            (await this.checkpoints).removeItem(path),
        ]);
    }
    /**
     * Create a checkpoint for a file.
     *
     * @param path - The path of the file.
     *
     * @returns A promise which resolves with the new checkpoint model when the
     *   checkpoint is created.
     */
    async createCheckpoint(path) {
        var _a;
        const checkpoints = await this.checkpoints;
        path = decodeURIComponent(path);
        const item = await this.get(path, { content: true });
        if (!item) {
            throw Error(`Could not find file with path ${path}`);
        }
        const copies = ((_a = (await checkpoints.getItem(path))) !== null && _a !== void 0 ? _a : []).filter(Boolean);
        copies.push(item);
        // keep only a certain amount of checkpoints per file
        if (copies.length > N_CHECKPOINTS) {
            copies.splice(0, copies.length - N_CHECKPOINTS);
        }
        await checkpoints.setItem(path, copies);
        const id = `${copies.length - 1}`;
        return { id, last_modified: item.last_modified };
    }
    /**
     * List available checkpoints for a file.
     *
     * @param path - The path of the file.
     *
     * @returns A promise which resolves with a list of checkpoint models for
     *    the file.
     */
    async listCheckpoints(path) {
        const copies = (await (await this.checkpoints).getItem(path)) || [];
        return copies.filter(Boolean).map(this.normalizeCheckpoint, this);
    }
    normalizeCheckpoint(model, id) {
        return { id: id.toString(), last_modified: model.last_modified };
    }
    /**
     * Restore a file to a known checkpoint state.
     *
     * @param path - The path of the file.
     * @param checkpointID - The id of the checkpoint to restore.
     *
     * @returns A promise which resolves when the checkpoint is restored.
     */
    async restoreCheckpoint(path, checkpointID) {
        path = decodeURIComponent(path);
        const copies = ((await (await this.checkpoints).getItem(path)) || []);
        const id = parseInt(checkpointID);
        const item = copies[id];
        await (await this.storage).setItem(path, item);
    }
    /**
     * Delete a checkpoint for a file.
     *
     * @param path - The path of the file.
     * @param checkpointID - The id of the checkpoint to delete.
     *
     * @returns A promise which resolves when the checkpoint is deleted.
     */
    async deleteCheckpoint(path, checkpointID) {
        path = decodeURIComponent(path);
        const copies = ((await (await this.checkpoints).getItem(path)) || []);
        const id = parseInt(checkpointID);
        copies.splice(id, 1);
        await (await this.checkpoints).setItem(path, copies);
    }
    /**
     * retrieve the contents for this path from the union of local storage and
     * `api/contents/{path}/all.json`.
     *
     * @param path - The contents path to retrieve
     *
     * @returns A promise which resolves with a Map of contents, keyed by local file name
     */
    async _getFolder(path) {
        const content = new Map();
        const storage = await this.storage;
        await storage.iterate((file, key) => {
            if (key.includes('/')) {
                return;
            }
            content.set(file.path, file);
        });
        // layer in contents that don't have local overwrites
        for (const file of (await this._getServerDirectory(path)).values()) {
            if (!content.has(file.path)) {
                content.set(file.path, file);
            }
        }
        if (path && content.size === 0) {
            return null;
        }
        return {
            name: '',
            path,
            last_modified: new Date(0).toISOString(),
            created: new Date(0).toISOString(),
            format: 'json',
            mimetype: _tokens__WEBPACK_IMPORTED_MODULE_2__.MIME.JSON,
            content: Array.from(content.values()),
            size: 0,
            writable: true,
            type: 'directory',
        };
    }
    /**
     * Attempt to recover the model from `{:path}/__all__.json` file, fall back to
     * deriving the model (including content) off the file in `/files/`. Otherwise
     * return `null`.
     */
    async _getServerContents(path, options) {
        const name = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.basename(path);
        const parentContents = await this._getServerDirectory(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(path, '..'));
        let model = parentContents.get(name);
        if (!model) {
            return null;
        }
        model = model || {
            name,
            path,
            last_modified: new Date(0).toISOString(),
            created: new Date(0).toISOString(),
            format: 'text',
            mimetype: _tokens__WEBPACK_IMPORTED_MODULE_2__.MIME.PLAIN_TEXT,
            type: 'file',
            writable: true,
            size: 0,
            content: '',
        };
        if (options === null || options === void 0 ? void 0 : options.content) {
            if (model.type === 'directory') {
                const serverContents = await this._getServerDirectory(path);
                model = { ...model, content: Array.from(serverContents.values()) };
            }
            else {
                const fileUrl = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getBaseUrl(), 'files', path);
                const response = await fetch(fileUrl);
                if (!response.ok) {
                    return null;
                }
                const mimetype = model.mimetype || response.headers.get('Content-Type');
                const ext = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PathExt.extname(name);
                if (model.type === 'notebook' ||
                    _tokens__WEBPACK_IMPORTED_MODULE_2__.FILE.hasFormat(ext, 'json') ||
                    (mimetype === null || mimetype === void 0 ? void 0 : mimetype.indexOf('json')) !== -1 ||
                    path.match(/\.(ipynb|[^/]*json[^/]*)$/)) {
                    const contentText = await response.text();
                    model = {
                        ...model,
                        content: JSON.parse(contentText),
                        format: 'json',
                        mimetype: model.mimetype || _tokens__WEBPACK_IMPORTED_MODULE_2__.MIME.JSON,
                        size: contentText.length,
                    };
                }
                else if (_tokens__WEBPACK_IMPORTED_MODULE_2__.FILE.hasFormat(ext, 'text') || mimetype.indexOf('text') !== -1) {
                    const contentText = await response.text();
                    model = {
                        ...model,
                        content: contentText,
                        format: 'text',
                        mimetype: mimetype || _tokens__WEBPACK_IMPORTED_MODULE_2__.MIME.PLAIN_TEXT,
                        size: contentText.length,
                    };
                }
                else {
                    const contentBytes = await response.arrayBuffer();
                    const contentBuffer = new Uint8Array(contentBytes);
                    model = {
                        ...model,
                        content: btoa(contentBuffer.reduce(this.reduceBytesToString, '')),
                        format: 'base64',
                        mimetype: mimetype || _tokens__WEBPACK_IMPORTED_MODULE_2__.MIME.OCTET_STREAM,
                        size: contentBuffer.length,
                    };
                }
            }
        }
        return model;
    }
    /**
     * retrieve the contents for this path from `__index__.json` in the appropriate
     * folder.
     *
     * @param newLocalPath - The new file path.
     *
     * @returns A promise which resolves with a Map of contents, keyed by local file name
     */
    async _getServerDirectory(path) {
        const content = this._serverContents.get(path) || new Map();
        if (!this._serverContents.has(path)) {
            const apiURL = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.URLExt.join(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getBaseUrl(), 'api/contents', path, 'all.json');
            try {
                const response = await fetch(apiURL);
                const json = JSON.parse(await response.text());
                for (const file of json['content']) {
                    content.set(file.name, file);
                }
            }
            catch (err) {
                console.warn(`don't worry, about ${err}... nothing's broken. If there had been a
          file at ${apiURL}, you might see some more files.`);
            }
            this._serverContents.set(path, content);
        }
        return content;
    }
    /**
     * Increment the counter for a given file type.
     * Used to avoid collisions when creating new untitled files.
     *
     * @param type The file type to increment the counter for.
     */
    async _incrementCounter(type) {
        var _a;
        const counters = await this.counters;
        const current = (_a = (await counters.getItem(type))) !== null && _a !== void 0 ? _a : -1;
        const counter = current + 1;
        await counters.setItem(type, counter);
        return counter;
    }
}
/**
 * A namespace for private data.
 */
var Private;
(function (Private) {
    /**
     * The content for an empty notebook.
     */
    Private.EMPTY_NB = {
        metadata: {
            orig_nbformat: 4,
        },
        nbformat_minor: 4,
        nbformat: 4,
        cells: [],
    };
})(Private || (Private = {}));
//# sourceMappingURL=contents.js.map

/***/ }),

/***/ "./node_modules/@jupyterlite/contents/lib/drivefs.js":
/*!***********************************************************!*\
  !*** ./node_modules/@jupyterlite/contents/lib/drivefs.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BLOCK_SIZE": () => (/* binding */ BLOCK_SIZE),
/* harmony export */   "ContentsAPI": () => (/* binding */ ContentsAPI),
/* harmony export */   "DRIVE_API_PATH": () => (/* binding */ DRIVE_API_PATH),
/* harmony export */   "DRIVE_SEPARATOR": () => (/* binding */ DRIVE_SEPARATOR),
/* harmony export */   "DriveFS": () => (/* binding */ DriveFS),
/* harmony export */   "DriveFSEmscriptenNodeOps": () => (/* binding */ DriveFSEmscriptenNodeOps),
/* harmony export */   "DriveFSEmscriptenStreamOps": () => (/* binding */ DriveFSEmscriptenStreamOps)
/* harmony export */ });
/* harmony import */ var _emscripten__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./emscripten */ "./node_modules/@jupyterlite/contents/lib/emscripten.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
// Types and implementation inspired from https://github.com/jvilk/BrowserFS
// LICENSE: https://github.com/jvilk/BrowserFS/blob/8977a704ea469d05daf857e4818bef1f4f498326/LICENSE
// And from https://github.com/gzuidhof/starboard-notebook
// LICENSE: https://github.com/gzuidhof/starboard-notebook/blob/cd8d3fc30af4bd29cdd8f6b8c207df8138f5d5dd/LICENSE

const DRIVE_SEPARATOR = ':';
const DRIVE_API_PATH = '/api/drive.v1';
const BLOCK_SIZE = 4096;
const encoder = new TextEncoder();
const decoder = new TextDecoder('utf-8');
// Mapping flag -> do we need to overwrite the file upon closing it
const flagNeedsWrite = {
    0 /*O_RDONLY*/: false,
    1 /*O_WRONLY*/: true,
    2 /*O_RDWR*/: true,
    64 /*O_CREAT*/: true,
    65 /*O_WRONLY|O_CREAT*/: true,
    66 /*O_RDWR|O_CREAT*/: true,
    129 /*O_WRONLY|O_EXCL*/: true,
    193 /*O_WRONLY|O_CREAT|O_EXCL*/: true,
    514 /*O_RDWR|O_TRUNC*/: true,
    577 /*O_WRONLY|O_CREAT|O_TRUNC*/: true,
    578 /*O_CREAT|O_RDWR|O_TRUNC*/: true,
    705 /*O_WRONLY|O_CREAT|O_EXCL|O_TRUNC*/: true,
    706 /*O_RDWR|O_CREAT|O_EXCL|O_TRUNC*/: true,
    1024 /*O_APPEND*/: true,
    1025 /*O_WRONLY|O_APPEND*/: true,
    1026 /*O_RDWR|O_APPEND*/: true,
    1089 /*O_WRONLY|O_CREAT|O_APPEND*/: true,
    1090 /*O_RDWR|O_CREAT|O_APPEND*/: true,
    1153 /*O_WRONLY|O_EXCL|O_APPEND*/: true,
    1154 /*O_RDWR|O_EXCL|O_APPEND*/: true,
    1217 /*O_WRONLY|O_CREAT|O_EXCL|O_APPEND*/: true,
    1218 /*O_RDWR|O_CREAT|O_EXCL|O_APPEND*/: true,
    4096 /*O_RDONLY|O_DSYNC*/: true,
    4098 /*O_RDWR|O_DSYNC*/: true,
};
class DriveFSEmscriptenStreamOps {
    constructor(fs) {
        this.fs = fs;
    }
    open(stream) {
        const path = this.fs.realPath(stream.node);
        if (this.fs.FS.isFile(stream.node.mode)) {
            stream.file = this.fs.API.get(path);
        }
    }
    close(stream) {
        if (!this.fs.FS.isFile(stream.node.mode) || !stream.file) {
            return;
        }
        const path = this.fs.realPath(stream.node);
        const flags = stream.flags;
        let parsedFlags = typeof flags === 'string' ? parseInt(flags, 10) : flags;
        parsedFlags &= 0x1fff;
        let needsWrite = true;
        if (parsedFlags in flagNeedsWrite) {
            needsWrite = flagNeedsWrite[parsedFlags];
        }
        if (needsWrite) {
            this.fs.API.put(path, stream.file);
        }
        stream.file = undefined;
    }
    read(stream, buffer, offset, length, position) {
        if (length <= 0 ||
            stream.file === undefined ||
            position >= (stream.file.data.length || 0)) {
            return 0;
        }
        const size = Math.min(stream.file.data.length - position, length);
        buffer.set(stream.file.data.subarray(position, position + size), offset);
        return size;
    }
    write(stream, buffer, offset, length, position) {
        var _a;
        if (length <= 0 || stream.file === undefined) {
            return 0;
        }
        stream.node.timestamp = Date.now();
        if (position + length > (((_a = stream.file) === null || _a === void 0 ? void 0 : _a.data.length) || 0)) {
            const oldData = stream.file.data ? stream.file.data : new Uint8Array();
            stream.file.data = new Uint8Array(position + length);
            stream.file.data.set(oldData);
        }
        stream.file.data.set(buffer.subarray(offset, offset + length), position);
        return length;
    }
    llseek(stream, offset, whence) {
        let position = offset;
        if (whence === _emscripten__WEBPACK_IMPORTED_MODULE_0__.SEEK_CUR) {
            position += stream.position;
        }
        else if (whence === _emscripten__WEBPACK_IMPORTED_MODULE_0__.SEEK_END) {
            if (this.fs.FS.isFile(stream.node.mode)) {
                if (stream.file !== undefined) {
                    position += stream.file.data.length;
                }
                else {
                    throw new this.fs.FS.ErrnoError(this.fs.ERRNO_CODES.EPERM);
                }
            }
        }
        if (position < 0) {
            throw new this.fs.FS.ErrnoError(this.fs.ERRNO_CODES.EINVAL);
        }
        return position;
    }
}
class DriveFSEmscriptenNodeOps {
    constructor(fs) {
        this.fs = fs;
    }
    getattr(node) {
        return {
            ...this.fs.API.getattr(this.fs.realPath(node)),
            mode: node.mode,
            ino: node.id,
        };
    }
    setattr(node, attr) {
        for (const [key, value] of Object.entries(attr)) {
            switch (key) {
                case 'mode':
                    node.mode = value;
                    break;
                case 'timestamp':
                    node.timestamp = value;
                    break;
                default:
                    console.warn('setattr', key, 'of', value, 'on', node, 'not yet implemented');
                    break;
            }
        }
    }
    lookup(parent, name) {
        const path = this.fs.PATH.join2(this.fs.realPath(parent), name);
        const result = this.fs.API.lookup(path);
        if (!result.ok) {
            throw this.fs.FS.genericErrors[this.fs.ERRNO_CODES['ENOENT']];
        }
        return this.fs.createNode(parent, name, result.mode, 0);
    }
    mknod(parent, name, mode, dev) {
        const path = this.fs.PATH.join2(this.fs.realPath(parent), name);
        this.fs.API.mknod(path, mode);
        return this.fs.createNode(parent, name, mode, dev);
    }
    rename(oldNode, newDir, newName) {
        this.fs.API.rename(oldNode.parent
            ? this.fs.PATH.join2(this.fs.realPath(oldNode.parent), oldNode.name)
            : oldNode.name, this.fs.PATH.join2(this.fs.realPath(newDir), newName));
        // Updating the in-memory node
        oldNode.name = newName;
        oldNode.parent = newDir;
    }
    unlink(parent, name) {
        this.fs.API.rmdir(this.fs.PATH.join2(this.fs.realPath(parent), name));
    }
    rmdir(parent, name) {
        this.fs.API.rmdir(this.fs.PATH.join2(this.fs.realPath(parent), name));
    }
    readdir(node) {
        return this.fs.API.readdir(this.fs.realPath(node));
    }
    symlink(parent, newName, oldPath) {
        throw new this.fs.FS.ErrnoError(this.fs.ERRNO_CODES['EPERM']);
    }
    readlink(node) {
        throw new this.fs.FS.ErrnoError(this.fs.ERRNO_CODES['EPERM']);
    }
}
/**
 * Wrap ServiceWorker requests for an Emscripten-compatible synchronous API.
 */
class ContentsAPI {
    constructor(baseUrl, driveName, mountpoint, FS, ERRNO_CODES) {
        this._baseUrl = baseUrl;
        this._driveName = driveName;
        this._mountpoint = mountpoint;
        this.FS = FS;
        this.ERRNO_CODES = ERRNO_CODES;
    }
    request(data) {
        const xhr = new XMLHttpRequest();
        xhr.open('POST', encodeURI(this.endpoint), false);
        try {
            xhr.send(JSON.stringify(data));
        }
        catch (e) {
            console.error(e);
        }
        if (xhr.status >= 400) {
            throw new this.FS.ErrnoError(this.ERRNO_CODES['EINVAL']);
        }
        return JSON.parse(xhr.responseText);
    }
    lookup(path) {
        return this.request({ method: 'lookup', path: this.normalizePath(path) });
    }
    getmode(path) {
        return Number.parseInt(this.request({ method: 'getmode', path: this.normalizePath(path) }));
    }
    mknod(path, mode) {
        return this.request({
            method: 'mknod',
            path: this.normalizePath(path),
            data: { mode },
        });
    }
    rename(oldPath, newPath) {
        return this.request({
            method: 'rename',
            path: this.normalizePath(oldPath),
            data: { newPath: this.normalizePath(newPath) },
        });
    }
    readdir(path) {
        const dirlist = this.request({
            method: 'readdir',
            path: this.normalizePath(path),
        });
        dirlist.push('.');
        dirlist.push('..');
        return dirlist;
    }
    rmdir(path) {
        return this.request({ method: 'rmdir', path: this.normalizePath(path) });
    }
    get(path) {
        const response = this.request({ method: 'get', path: this.normalizePath(path) });
        const serializedContent = response.content;
        const format = response.format;
        switch (format) {
            case 'json':
            case 'text':
                return {
                    data: encoder.encode(serializedContent),
                    format,
                };
            case 'base64': {
                const binString = atob(serializedContent);
                const len = binString.length;
                const data = new Uint8Array(len);
                for (let i = 0; i < len; i++) {
                    data[i] = binString.charCodeAt(i);
                }
                return {
                    data,
                    format,
                };
            }
            default:
                throw new this.FS.ErrnoError(this.ERRNO_CODES['ENOENT']);
        }
    }
    put(path, value) {
        switch (value.format) {
            case 'json':
            case 'text':
                return this.request({
                    method: 'put',
                    path: this.normalizePath(path),
                    data: {
                        format: value.format,
                        data: decoder.decode(value.data),
                    },
                });
            case 'base64': {
                let binary = '';
                for (let i = 0; i < value.data.byteLength; i++) {
                    binary += String.fromCharCode(value.data[i]);
                }
                return this.request({
                    method: 'put',
                    path: this.normalizePath(path),
                    data: {
                        format: value.format,
                        data: btoa(binary),
                    },
                });
            }
        }
    }
    getattr(path) {
        const stats = this.request({
            method: 'getattr',
            path: this.normalizePath(path),
        });
        // Turn datetimes into proper objects
        stats.atime = new Date(stats.atime);
        stats.mtime = new Date(stats.mtime);
        stats.ctime = new Date(stats.ctime);
        // ensure a non-undefined size (0 isn't great, though)
        stats.size = stats.size || 0;
        return stats;
    }
    /**
     * Normalize a Path by making it compliant for the content manager
     *
     * @param path: the path relatively to the Emscripten drive
     */
    normalizePath(path) {
        // Remove mountpoint prefix
        if (path.startsWith(this._mountpoint)) {
            path = path.slice(this._mountpoint.length);
        }
        // Add JupyterLab drive name
        if (this._driveName) {
            path = `${this._driveName}${DRIVE_SEPARATOR}${path}`;
        }
        return path;
    }
    /**
     * Get the api/drive endpoint
     */
    get endpoint() {
        return `${this._baseUrl}api/drive`;
    }
}
class DriveFS {
    constructor(options) {
        this.FS = options.FS;
        this.PATH = options.PATH;
        this.ERRNO_CODES = options.ERRNO_CODES;
        this.API = new ContentsAPI(options.baseUrl, options.driveName, options.mountpoint, this.FS, this.ERRNO_CODES);
        this.driveName = options.driveName;
        this.node_ops = new DriveFSEmscriptenNodeOps(this);
        this.stream_ops = new DriveFSEmscriptenStreamOps(this);
    }
    mount(mount) {
        return this.createNode(null, mount.mountpoint, _emscripten__WEBPACK_IMPORTED_MODULE_0__.DIR_MODE | 511, 0);
    }
    createNode(parent, name, mode, dev) {
        const FS = this.FS;
        if (!FS.isDir(mode) && !FS.isFile(mode)) {
            throw new FS.ErrnoError(this.ERRNO_CODES['EINVAL']);
        }
        const node = FS.createNode(parent, name, mode, dev);
        node.node_ops = this.node_ops;
        node.stream_ops = this.stream_ops;
        return node;
    }
    getMode(path) {
        return this.API.getmode(path);
    }
    realPath(node) {
        const parts = [];
        let currentNode = node;
        parts.push(currentNode.name);
        while (currentNode.parent !== currentNode) {
            currentNode = currentNode.parent;
            parts.push(currentNode.name);
        }
        parts.reverse();
        return this.PATH.join.apply(null, parts);
    }
}
//# sourceMappingURL=drivefs.js.map

/***/ }),

/***/ "./node_modules/@jupyterlite/contents/lib/emscripten.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlite/contents/lib/emscripten.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DIR_MODE": () => (/* binding */ DIR_MODE),
/* harmony export */   "FILE_MODE": () => (/* binding */ FILE_MODE),
/* harmony export */   "SEEK_CUR": () => (/* binding */ SEEK_CUR),
/* harmony export */   "SEEK_END": () => (/* binding */ SEEK_END)
/* harmony export */ });
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/// <reference path="../../../node_modules/@types/emscripten/index.d.ts" />
const DIR_MODE = 16895; // 040777
const FILE_MODE = 33206; // 100666
const SEEK_CUR = 1;
const SEEK_END = 2;
//# sourceMappingURL=emscripten.js.map

/***/ }),

/***/ "./node_modules/@jupyterlite/contents/lib/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/@jupyterlite/contents/lib/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BLOCK_SIZE": () => (/* reexport safe */ _drivefs__WEBPACK_IMPORTED_MODULE_1__.BLOCK_SIZE),
/* harmony export */   "BroadcastChannelWrapper": () => (/* reexport safe */ _broadcast__WEBPACK_IMPORTED_MODULE_3__.BroadcastChannelWrapper),
/* harmony export */   "Contents": () => (/* reexport safe */ _contents__WEBPACK_IMPORTED_MODULE_0__.Contents),
/* harmony export */   "ContentsAPI": () => (/* reexport safe */ _drivefs__WEBPACK_IMPORTED_MODULE_1__.ContentsAPI),
/* harmony export */   "DIR_MODE": () => (/* reexport safe */ _emscripten__WEBPACK_IMPORTED_MODULE_4__.DIR_MODE),
/* harmony export */   "DRIVE_API_PATH": () => (/* reexport safe */ _drivefs__WEBPACK_IMPORTED_MODULE_1__.DRIVE_API_PATH),
/* harmony export */   "DRIVE_SEPARATOR": () => (/* reexport safe */ _drivefs__WEBPACK_IMPORTED_MODULE_1__.DRIVE_SEPARATOR),
/* harmony export */   "DriveFS": () => (/* reexport safe */ _drivefs__WEBPACK_IMPORTED_MODULE_1__.DriveFS),
/* harmony export */   "DriveFSEmscriptenNodeOps": () => (/* reexport safe */ _drivefs__WEBPACK_IMPORTED_MODULE_1__.DriveFSEmscriptenNodeOps),
/* harmony export */   "DriveFSEmscriptenStreamOps": () => (/* reexport safe */ _drivefs__WEBPACK_IMPORTED_MODULE_1__.DriveFSEmscriptenStreamOps),
/* harmony export */   "FILE": () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_2__.FILE),
/* harmony export */   "FILE_MODE": () => (/* reexport safe */ _emscripten__WEBPACK_IMPORTED_MODULE_4__.FILE_MODE),
/* harmony export */   "IBroadcastChannelWrapper": () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_2__.IBroadcastChannelWrapper),
/* harmony export */   "IContents": () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_2__.IContents),
/* harmony export */   "MIME": () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_2__.MIME),
/* harmony export */   "SEEK_CUR": () => (/* reexport safe */ _emscripten__WEBPACK_IMPORTED_MODULE_4__.SEEK_CUR),
/* harmony export */   "SEEK_END": () => (/* reexport safe */ _emscripten__WEBPACK_IMPORTED_MODULE_4__.SEEK_END)
/* harmony export */ });
/* harmony import */ var _contents__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./contents */ "./node_modules/@jupyterlite/contents/lib/contents.js");
/* harmony import */ var _drivefs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./drivefs */ "./node_modules/@jupyterlite/contents/lib/drivefs.js");
/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./tokens */ "./node_modules/@jupyterlite/contents/lib/tokens.js");
/* harmony import */ var _broadcast__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./broadcast */ "./node_modules/@jupyterlite/contents/lib/broadcast.js");
/* harmony import */ var _emscripten__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./emscripten */ "./node_modules/@jupyterlite/contents/lib/emscripten.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.





//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@jupyterlite/contents/lib/tokens.js":
/*!**********************************************************!*\
  !*** ./node_modules/@jupyterlite/contents/lib/tokens.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FILE": () => (/* binding */ FILE),
/* harmony export */   "IBroadcastChannelWrapper": () => (/* binding */ IBroadcastChannelWrapper),
/* harmony export */   "IContents": () => (/* binding */ IContents),
/* harmony export */   "MIME": () => (/* binding */ MIME)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var mime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! mime */ "./node_modules/mime/index.js");
/* harmony import */ var mime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(mime__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__);



/**
 * The token for the settings service.
 */
const IContents = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.Token('@jupyterlite/contents:IContents');
/**
 * Commonly-used mimetypes
 */
var MIME;
(function (MIME) {
    MIME.JSON = 'application/json';
    MIME.PLAIN_TEXT = 'text/plain';
    MIME.OCTET_STREAM = 'octet/stream';
})(MIME || (MIME = {}));
/**
 * A namespace for file constructs.
 */
var FILE;
(function (FILE) {
    /**
     * Build-time configured file types.
     */
    const TYPES = JSON.parse(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.PageConfig.getOption('fileTypes') || '{}');
    /**
     * Get a mimetype (or fallback).
     */
    function getType(ext, defaultType = null) {
        ext = ext.toLowerCase();
        for (const fileType of Object.values(TYPES)) {
            for (const fileExt of fileType.extensions || []) {
                if (fileExt === ext && fileType.mimeTypes && fileType.mimeTypes.length) {
                    return fileType.mimeTypes[0];
                }
            }
        }
        return mime__WEBPACK_IMPORTED_MODULE_1___default().getType(ext) || defaultType || MIME.OCTET_STREAM;
    }
    FILE.getType = getType;
    /**
     * Determine whether the given extension matches a given fileFormat.
     */
    function hasFormat(ext, fileFormat) {
        ext = ext.toLowerCase();
        for (const fileType of Object.values(TYPES)) {
            if (fileType.fileFormat !== fileFormat) {
                continue;
            }
            for (const fileExt of fileType.extensions || []) {
                if (fileExt === ext) {
                    return true;
                }
            }
        }
        return false;
    }
    FILE.hasFormat = hasFormat;
})(FILE || (FILE = {}));
/**
 * The token for the BroadcastChannel broadcaster.
 */
const IBroadcastChannelWrapper = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.Token('@jupyterlite/contents:IBroadcastChannelWrapper');
//# sourceMappingURL=tokens.js.map

/***/ }),

/***/ "./node_modules/mime/Mime.js":
/*!***********************************!*\
  !*** ./node_modules/mime/Mime.js ***!
  \***********************************/
/***/ ((module) => {

"use strict";


/**
 * @param typeMap [Object] Map of MIME type -> Array[extensions]
 * @param ...
 */
function Mime() {
  this._types = Object.create(null);
  this._extensions = Object.create(null);

  for (let i = 0; i < arguments.length; i++) {
    this.define(arguments[i]);
  }

  this.define = this.define.bind(this);
  this.getType = this.getType.bind(this);
  this.getExtension = this.getExtension.bind(this);
}

/**
 * Define mimetype -> extension mappings.  Each key is a mime-type that maps
 * to an array of extensions associated with the type.  The first extension is
 * used as the default extension for the type.
 *
 * e.g. mime.define({'audio/ogg', ['oga', 'ogg', 'spx']});
 *
 * If a type declares an extension that has already been defined, an error will
 * be thrown.  To suppress this error and force the extension to be associated
 * with the new type, pass `force`=true.  Alternatively, you may prefix the
 * extension with "*" to map the type to extension, without mapping the
 * extension to the type.
 *
 * e.g. mime.define({'audio/wav', ['wav']}, {'audio/x-wav', ['*wav']});
 *
 *
 * @param map (Object) type definitions
 * @param force (Boolean) if true, force overriding of existing definitions
 */
Mime.prototype.define = function(typeMap, force) {
  for (let type in typeMap) {
    let extensions = typeMap[type].map(function(t) {
      return t.toLowerCase();
    });
    type = type.toLowerCase();

    for (let i = 0; i < extensions.length; i++) {
      const ext = extensions[i];

      // '*' prefix = not the preferred type for this extension.  So fixup the
      // extension, and skip it.
      if (ext[0] === '*') {
        continue;
      }

      if (!force && (ext in this._types)) {
        throw new Error(
          'Attempt to change mapping for "' + ext +
          '" extension from "' + this._types[ext] + '" to "' + type +
          '". Pass `force=true` to allow this, otherwise remove "' + ext +
          '" from the list of extensions for "' + type + '".'
        );
      }

      this._types[ext] = type;
    }

    // Use first extension as default
    if (force || !this._extensions[type]) {
      const ext = extensions[0];
      this._extensions[type] = (ext[0] !== '*') ? ext : ext.substr(1);
    }
  }
};

/**
 * Lookup a mime type based on extension
 */
Mime.prototype.getType = function(path) {
  path = String(path);
  let last = path.replace(/^.*[/\\]/, '').toLowerCase();
  let ext = last.replace(/^.*\./, '').toLowerCase();

  let hasPath = last.length < path.length;
  let hasDot = ext.length < last.length - 1;

  return (hasDot || !hasPath) && this._types[ext] || null;
};

/**
 * Return file extension associated with a mime type
 */
Mime.prototype.getExtension = function(type) {
  type = /^\s*([^;\s]*)/.test(type) && RegExp.$1;
  return type && this._extensions[type.toLowerCase()] || null;
};

module.exports = Mime;


/***/ }),

/***/ "./node_modules/mime/index.js":
/*!************************************!*\
  !*** ./node_modules/mime/index.js ***!
  \************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Mime = __webpack_require__(/*! ./Mime */ "./node_modules/mime/Mime.js");
module.exports = new Mime(__webpack_require__(/*! ./types/standard */ "./node_modules/mime/types/standard.js"), __webpack_require__(/*! ./types/other */ "./node_modules/mime/types/other.js"));


/***/ }),

/***/ "./node_modules/mime/types/other.js":
/*!******************************************!*\
  !*** ./node_modules/mime/types/other.js ***!
  \******************************************/
/***/ ((module) => {

module.exports = {"application/prs.cww":["cww"],"application/vnd.1000minds.decision-model+xml":["1km"],"application/vnd.3gpp.pic-bw-large":["plb"],"application/vnd.3gpp.pic-bw-small":["psb"],"application/vnd.3gpp.pic-bw-var":["pvb"],"application/vnd.3gpp2.tcap":["tcap"],"application/vnd.3m.post-it-notes":["pwn"],"application/vnd.accpac.simply.aso":["aso"],"application/vnd.accpac.simply.imp":["imp"],"application/vnd.acucobol":["acu"],"application/vnd.acucorp":["atc","acutc"],"application/vnd.adobe.air-application-installer-package+zip":["air"],"application/vnd.adobe.formscentral.fcdt":["fcdt"],"application/vnd.adobe.fxp":["fxp","fxpl"],"application/vnd.adobe.xdp+xml":["xdp"],"application/vnd.adobe.xfdf":["xfdf"],"application/vnd.ahead.space":["ahead"],"application/vnd.airzip.filesecure.azf":["azf"],"application/vnd.airzip.filesecure.azs":["azs"],"application/vnd.amazon.ebook":["azw"],"application/vnd.americandynamics.acc":["acc"],"application/vnd.amiga.ami":["ami"],"application/vnd.android.package-archive":["apk"],"application/vnd.anser-web-certificate-issue-initiation":["cii"],"application/vnd.anser-web-funds-transfer-initiation":["fti"],"application/vnd.antix.game-component":["atx"],"application/vnd.apple.installer+xml":["mpkg"],"application/vnd.apple.keynote":["key"],"application/vnd.apple.mpegurl":["m3u8"],"application/vnd.apple.numbers":["numbers"],"application/vnd.apple.pages":["pages"],"application/vnd.apple.pkpass":["pkpass"],"application/vnd.aristanetworks.swi":["swi"],"application/vnd.astraea-software.iota":["iota"],"application/vnd.audiograph":["aep"],"application/vnd.balsamiq.bmml+xml":["bmml"],"application/vnd.blueice.multipass":["mpm"],"application/vnd.bmi":["bmi"],"application/vnd.businessobjects":["rep"],"application/vnd.chemdraw+xml":["cdxml"],"application/vnd.chipnuts.karaoke-mmd":["mmd"],"application/vnd.cinderella":["cdy"],"application/vnd.citationstyles.style+xml":["csl"],"application/vnd.claymore":["cla"],"application/vnd.cloanto.rp9":["rp9"],"application/vnd.clonk.c4group":["c4g","c4d","c4f","c4p","c4u"],"application/vnd.cluetrust.cartomobile-config":["c11amc"],"application/vnd.cluetrust.cartomobile-config-pkg":["c11amz"],"application/vnd.commonspace":["csp"],"application/vnd.contact.cmsg":["cdbcmsg"],"application/vnd.cosmocaller":["cmc"],"application/vnd.crick.clicker":["clkx"],"application/vnd.crick.clicker.keyboard":["clkk"],"application/vnd.crick.clicker.palette":["clkp"],"application/vnd.crick.clicker.template":["clkt"],"application/vnd.crick.clicker.wordbank":["clkw"],"application/vnd.criticaltools.wbs+xml":["wbs"],"application/vnd.ctc-posml":["pml"],"application/vnd.cups-ppd":["ppd"],"application/vnd.curl.car":["car"],"application/vnd.curl.pcurl":["pcurl"],"application/vnd.dart":["dart"],"application/vnd.data-vision.rdz":["rdz"],"application/vnd.dbf":["dbf"],"application/vnd.dece.data":["uvf","uvvf","uvd","uvvd"],"application/vnd.dece.ttml+xml":["uvt","uvvt"],"application/vnd.dece.unspecified":["uvx","uvvx"],"application/vnd.dece.zip":["uvz","uvvz"],"application/vnd.denovo.fcselayout-link":["fe_launch"],"application/vnd.dna":["dna"],"application/vnd.dolby.mlp":["mlp"],"application/vnd.dpgraph":["dpg"],"application/vnd.dreamfactory":["dfac"],"application/vnd.ds-keypoint":["kpxx"],"application/vnd.dvb.ait":["ait"],"application/vnd.dvb.service":["svc"],"application/vnd.dynageo":["geo"],"application/vnd.ecowin.chart":["mag"],"application/vnd.enliven":["nml"],"application/vnd.epson.esf":["esf"],"application/vnd.epson.msf":["msf"],"application/vnd.epson.quickanime":["qam"],"application/vnd.epson.salt":["slt"],"application/vnd.epson.ssf":["ssf"],"application/vnd.eszigno3+xml":["es3","et3"],"application/vnd.ezpix-album":["ez2"],"application/vnd.ezpix-package":["ez3"],"application/vnd.fdf":["fdf"],"application/vnd.fdsn.mseed":["mseed"],"application/vnd.fdsn.seed":["seed","dataless"],"application/vnd.flographit":["gph"],"application/vnd.fluxtime.clip":["ftc"],"application/vnd.framemaker":["fm","frame","maker","book"],"application/vnd.frogans.fnc":["fnc"],"application/vnd.frogans.ltf":["ltf"],"application/vnd.fsc.weblaunch":["fsc"],"application/vnd.fujitsu.oasys":["oas"],"application/vnd.fujitsu.oasys2":["oa2"],"application/vnd.fujitsu.oasys3":["oa3"],"application/vnd.fujitsu.oasysgp":["fg5"],"application/vnd.fujitsu.oasysprs":["bh2"],"application/vnd.fujixerox.ddd":["ddd"],"application/vnd.fujixerox.docuworks":["xdw"],"application/vnd.fujixerox.docuworks.binder":["xbd"],"application/vnd.fuzzysheet":["fzs"],"application/vnd.genomatix.tuxedo":["txd"],"application/vnd.geogebra.file":["ggb"],"application/vnd.geogebra.tool":["ggt"],"application/vnd.geometry-explorer":["gex","gre"],"application/vnd.geonext":["gxt"],"application/vnd.geoplan":["g2w"],"application/vnd.geospace":["g3w"],"application/vnd.gmx":["gmx"],"application/vnd.google-apps.document":["gdoc"],"application/vnd.google-apps.presentation":["gslides"],"application/vnd.google-apps.spreadsheet":["gsheet"],"application/vnd.google-earth.kml+xml":["kml"],"application/vnd.google-earth.kmz":["kmz"],"application/vnd.grafeq":["gqf","gqs"],"application/vnd.groove-account":["gac"],"application/vnd.groove-help":["ghf"],"application/vnd.groove-identity-message":["gim"],"application/vnd.groove-injector":["grv"],"application/vnd.groove-tool-message":["gtm"],"application/vnd.groove-tool-template":["tpl"],"application/vnd.groove-vcard":["vcg"],"application/vnd.hal+xml":["hal"],"application/vnd.handheld-entertainment+xml":["zmm"],"application/vnd.hbci":["hbci"],"application/vnd.hhe.lesson-player":["les"],"application/vnd.hp-hpgl":["hpgl"],"application/vnd.hp-hpid":["hpid"],"application/vnd.hp-hps":["hps"],"application/vnd.hp-jlyt":["jlt"],"application/vnd.hp-pcl":["pcl"],"application/vnd.hp-pclxl":["pclxl"],"application/vnd.hydrostatix.sof-data":["sfd-hdstx"],"application/vnd.ibm.minipay":["mpy"],"application/vnd.ibm.modcap":["afp","listafp","list3820"],"application/vnd.ibm.rights-management":["irm"],"application/vnd.ibm.secure-container":["sc"],"application/vnd.iccprofile":["icc","icm"],"application/vnd.igloader":["igl"],"application/vnd.immervision-ivp":["ivp"],"application/vnd.immervision-ivu":["ivu"],"application/vnd.insors.igm":["igm"],"application/vnd.intercon.formnet":["xpw","xpx"],"application/vnd.intergeo":["i2g"],"application/vnd.intu.qbo":["qbo"],"application/vnd.intu.qfx":["qfx"],"application/vnd.ipunplugged.rcprofile":["rcprofile"],"application/vnd.irepository.package+xml":["irp"],"application/vnd.is-xpr":["xpr"],"application/vnd.isac.fcs":["fcs"],"application/vnd.jam":["jam"],"application/vnd.jcp.javame.midlet-rms":["rms"],"application/vnd.jisp":["jisp"],"application/vnd.joost.joda-archive":["joda"],"application/vnd.kahootz":["ktz","ktr"],"application/vnd.kde.karbon":["karbon"],"application/vnd.kde.kchart":["chrt"],"application/vnd.kde.kformula":["kfo"],"application/vnd.kde.kivio":["flw"],"application/vnd.kde.kontour":["kon"],"application/vnd.kde.kpresenter":["kpr","kpt"],"application/vnd.kde.kspread":["ksp"],"application/vnd.kde.kword":["kwd","kwt"],"application/vnd.kenameaapp":["htke"],"application/vnd.kidspiration":["kia"],"application/vnd.kinar":["kne","knp"],"application/vnd.koan":["skp","skd","skt","skm"],"application/vnd.kodak-descriptor":["sse"],"application/vnd.las.las+xml":["lasxml"],"application/vnd.llamagraphics.life-balance.desktop":["lbd"],"application/vnd.llamagraphics.life-balance.exchange+xml":["lbe"],"application/vnd.lotus-1-2-3":["123"],"application/vnd.lotus-approach":["apr"],"application/vnd.lotus-freelance":["pre"],"application/vnd.lotus-notes":["nsf"],"application/vnd.lotus-organizer":["org"],"application/vnd.lotus-screencam":["scm"],"application/vnd.lotus-wordpro":["lwp"],"application/vnd.macports.portpkg":["portpkg"],"application/vnd.mapbox-vector-tile":["mvt"],"application/vnd.mcd":["mcd"],"application/vnd.medcalcdata":["mc1"],"application/vnd.mediastation.cdkey":["cdkey"],"application/vnd.mfer":["mwf"],"application/vnd.mfmp":["mfm"],"application/vnd.micrografx.flo":["flo"],"application/vnd.micrografx.igx":["igx"],"application/vnd.mif":["mif"],"application/vnd.mobius.daf":["daf"],"application/vnd.mobius.dis":["dis"],"application/vnd.mobius.mbk":["mbk"],"application/vnd.mobius.mqy":["mqy"],"application/vnd.mobius.msl":["msl"],"application/vnd.mobius.plc":["plc"],"application/vnd.mobius.txf":["txf"],"application/vnd.mophun.application":["mpn"],"application/vnd.mophun.certificate":["mpc"],"application/vnd.mozilla.xul+xml":["xul"],"application/vnd.ms-artgalry":["cil"],"application/vnd.ms-cab-compressed":["cab"],"application/vnd.ms-excel":["xls","xlm","xla","xlc","xlt","xlw"],"application/vnd.ms-excel.addin.macroenabled.12":["xlam"],"application/vnd.ms-excel.sheet.binary.macroenabled.12":["xlsb"],"application/vnd.ms-excel.sheet.macroenabled.12":["xlsm"],"application/vnd.ms-excel.template.macroenabled.12":["xltm"],"application/vnd.ms-fontobject":["eot"],"application/vnd.ms-htmlhelp":["chm"],"application/vnd.ms-ims":["ims"],"application/vnd.ms-lrm":["lrm"],"application/vnd.ms-officetheme":["thmx"],"application/vnd.ms-outlook":["msg"],"application/vnd.ms-pki.seccat":["cat"],"application/vnd.ms-pki.stl":["*stl"],"application/vnd.ms-powerpoint":["ppt","pps","pot"],"application/vnd.ms-powerpoint.addin.macroenabled.12":["ppam"],"application/vnd.ms-powerpoint.presentation.macroenabled.12":["pptm"],"application/vnd.ms-powerpoint.slide.macroenabled.12":["sldm"],"application/vnd.ms-powerpoint.slideshow.macroenabled.12":["ppsm"],"application/vnd.ms-powerpoint.template.macroenabled.12":["potm"],"application/vnd.ms-project":["mpp","mpt"],"application/vnd.ms-word.document.macroenabled.12":["docm"],"application/vnd.ms-word.template.macroenabled.12":["dotm"],"application/vnd.ms-works":["wps","wks","wcm","wdb"],"application/vnd.ms-wpl":["wpl"],"application/vnd.ms-xpsdocument":["xps"],"application/vnd.mseq":["mseq"],"application/vnd.musician":["mus"],"application/vnd.muvee.style":["msty"],"application/vnd.mynfc":["taglet"],"application/vnd.neurolanguage.nlu":["nlu"],"application/vnd.nitf":["ntf","nitf"],"application/vnd.noblenet-directory":["nnd"],"application/vnd.noblenet-sealer":["nns"],"application/vnd.noblenet-web":["nnw"],"application/vnd.nokia.n-gage.ac+xml":["*ac"],"application/vnd.nokia.n-gage.data":["ngdat"],"application/vnd.nokia.n-gage.symbian.install":["n-gage"],"application/vnd.nokia.radio-preset":["rpst"],"application/vnd.nokia.radio-presets":["rpss"],"application/vnd.novadigm.edm":["edm"],"application/vnd.novadigm.edx":["edx"],"application/vnd.novadigm.ext":["ext"],"application/vnd.oasis.opendocument.chart":["odc"],"application/vnd.oasis.opendocument.chart-template":["otc"],"application/vnd.oasis.opendocument.database":["odb"],"application/vnd.oasis.opendocument.formula":["odf"],"application/vnd.oasis.opendocument.formula-template":["odft"],"application/vnd.oasis.opendocument.graphics":["odg"],"application/vnd.oasis.opendocument.graphics-template":["otg"],"application/vnd.oasis.opendocument.image":["odi"],"application/vnd.oasis.opendocument.image-template":["oti"],"application/vnd.oasis.opendocument.presentation":["odp"],"application/vnd.oasis.opendocument.presentation-template":["otp"],"application/vnd.oasis.opendocument.spreadsheet":["ods"],"application/vnd.oasis.opendocument.spreadsheet-template":["ots"],"application/vnd.oasis.opendocument.text":["odt"],"application/vnd.oasis.opendocument.text-master":["odm"],"application/vnd.oasis.opendocument.text-template":["ott"],"application/vnd.oasis.opendocument.text-web":["oth"],"application/vnd.olpc-sugar":["xo"],"application/vnd.oma.dd2+xml":["dd2"],"application/vnd.openblox.game+xml":["obgx"],"application/vnd.openofficeorg.extension":["oxt"],"application/vnd.openstreetmap.data+xml":["osm"],"application/vnd.openxmlformats-officedocument.presentationml.presentation":["pptx"],"application/vnd.openxmlformats-officedocument.presentationml.slide":["sldx"],"application/vnd.openxmlformats-officedocument.presentationml.slideshow":["ppsx"],"application/vnd.openxmlformats-officedocument.presentationml.template":["potx"],"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":["xlsx"],"application/vnd.openxmlformats-officedocument.spreadsheetml.template":["xltx"],"application/vnd.openxmlformats-officedocument.wordprocessingml.document":["docx"],"application/vnd.openxmlformats-officedocument.wordprocessingml.template":["dotx"],"application/vnd.osgeo.mapguide.package":["mgp"],"application/vnd.osgi.dp":["dp"],"application/vnd.osgi.subsystem":["esa"],"application/vnd.palm":["pdb","pqa","oprc"],"application/vnd.pawaafile":["paw"],"application/vnd.pg.format":["str"],"application/vnd.pg.osasli":["ei6"],"application/vnd.picsel":["efif"],"application/vnd.pmi.widget":["wg"],"application/vnd.pocketlearn":["plf"],"application/vnd.powerbuilder6":["pbd"],"application/vnd.previewsystems.box":["box"],"application/vnd.proteus.magazine":["mgz"],"application/vnd.publishare-delta-tree":["qps"],"application/vnd.pvi.ptid1":["ptid"],"application/vnd.quark.quarkxpress":["qxd","qxt","qwd","qwt","qxl","qxb"],"application/vnd.rar":["rar"],"application/vnd.realvnc.bed":["bed"],"application/vnd.recordare.musicxml":["mxl"],"application/vnd.recordare.musicxml+xml":["musicxml"],"application/vnd.rig.cryptonote":["cryptonote"],"application/vnd.rim.cod":["cod"],"application/vnd.rn-realmedia":["rm"],"application/vnd.rn-realmedia-vbr":["rmvb"],"application/vnd.route66.link66+xml":["link66"],"application/vnd.sailingtracker.track":["st"],"application/vnd.seemail":["see"],"application/vnd.sema":["sema"],"application/vnd.semd":["semd"],"application/vnd.semf":["semf"],"application/vnd.shana.informed.formdata":["ifm"],"application/vnd.shana.informed.formtemplate":["itp"],"application/vnd.shana.informed.interchange":["iif"],"application/vnd.shana.informed.package":["ipk"],"application/vnd.simtech-mindmapper":["twd","twds"],"application/vnd.smaf":["mmf"],"application/vnd.smart.teacher":["teacher"],"application/vnd.software602.filler.form+xml":["fo"],"application/vnd.solent.sdkm+xml":["sdkm","sdkd"],"application/vnd.spotfire.dxp":["dxp"],"application/vnd.spotfire.sfs":["sfs"],"application/vnd.stardivision.calc":["sdc"],"application/vnd.stardivision.draw":["sda"],"application/vnd.stardivision.impress":["sdd"],"application/vnd.stardivision.math":["smf"],"application/vnd.stardivision.writer":["sdw","vor"],"application/vnd.stardivision.writer-global":["sgl"],"application/vnd.stepmania.package":["smzip"],"application/vnd.stepmania.stepchart":["sm"],"application/vnd.sun.wadl+xml":["wadl"],"application/vnd.sun.xml.calc":["sxc"],"application/vnd.sun.xml.calc.template":["stc"],"application/vnd.sun.xml.draw":["sxd"],"application/vnd.sun.xml.draw.template":["std"],"application/vnd.sun.xml.impress":["sxi"],"application/vnd.sun.xml.impress.template":["sti"],"application/vnd.sun.xml.math":["sxm"],"application/vnd.sun.xml.writer":["sxw"],"application/vnd.sun.xml.writer.global":["sxg"],"application/vnd.sun.xml.writer.template":["stw"],"application/vnd.sus-calendar":["sus","susp"],"application/vnd.svd":["svd"],"application/vnd.symbian.install":["sis","sisx"],"application/vnd.syncml+xml":["xsm"],"application/vnd.syncml.dm+wbxml":["bdm"],"application/vnd.syncml.dm+xml":["xdm"],"application/vnd.syncml.dmddf+xml":["ddf"],"application/vnd.tao.intent-module-archive":["tao"],"application/vnd.tcpdump.pcap":["pcap","cap","dmp"],"application/vnd.tmobile-livetv":["tmo"],"application/vnd.trid.tpt":["tpt"],"application/vnd.triscape.mxs":["mxs"],"application/vnd.trueapp":["tra"],"application/vnd.ufdl":["ufd","ufdl"],"application/vnd.uiq.theme":["utz"],"application/vnd.umajin":["umj"],"application/vnd.unity":["unityweb"],"application/vnd.uoml+xml":["uoml"],"application/vnd.vcx":["vcx"],"application/vnd.visio":["vsd","vst","vss","vsw"],"application/vnd.visionary":["vis"],"application/vnd.vsf":["vsf"],"application/vnd.wap.wbxml":["wbxml"],"application/vnd.wap.wmlc":["wmlc"],"application/vnd.wap.wmlscriptc":["wmlsc"],"application/vnd.webturbo":["wtb"],"application/vnd.wolfram.player":["nbp"],"application/vnd.wordperfect":["wpd"],"application/vnd.wqd":["wqd"],"application/vnd.wt.stf":["stf"],"application/vnd.xara":["xar"],"application/vnd.xfdl":["xfdl"],"application/vnd.yamaha.hv-dic":["hvd"],"application/vnd.yamaha.hv-script":["hvs"],"application/vnd.yamaha.hv-voice":["hvp"],"application/vnd.yamaha.openscoreformat":["osf"],"application/vnd.yamaha.openscoreformat.osfpvg+xml":["osfpvg"],"application/vnd.yamaha.smaf-audio":["saf"],"application/vnd.yamaha.smaf-phrase":["spf"],"application/vnd.yellowriver-custom-menu":["cmp"],"application/vnd.zul":["zir","zirz"],"application/vnd.zzazz.deck+xml":["zaz"],"application/x-7z-compressed":["7z"],"application/x-abiword":["abw"],"application/x-ace-compressed":["ace"],"application/x-apple-diskimage":["*dmg"],"application/x-arj":["arj"],"application/x-authorware-bin":["aab","x32","u32","vox"],"application/x-authorware-map":["aam"],"application/x-authorware-seg":["aas"],"application/x-bcpio":["bcpio"],"application/x-bdoc":["*bdoc"],"application/x-bittorrent":["torrent"],"application/x-blorb":["blb","blorb"],"application/x-bzip":["bz"],"application/x-bzip2":["bz2","boz"],"application/x-cbr":["cbr","cba","cbt","cbz","cb7"],"application/x-cdlink":["vcd"],"application/x-cfs-compressed":["cfs"],"application/x-chat":["chat"],"application/x-chess-pgn":["pgn"],"application/x-chrome-extension":["crx"],"application/x-cocoa":["cco"],"application/x-conference":["nsc"],"application/x-cpio":["cpio"],"application/x-csh":["csh"],"application/x-debian-package":["*deb","udeb"],"application/x-dgc-compressed":["dgc"],"application/x-director":["dir","dcr","dxr","cst","cct","cxt","w3d","fgd","swa"],"application/x-doom":["wad"],"application/x-dtbncx+xml":["ncx"],"application/x-dtbook+xml":["dtb"],"application/x-dtbresource+xml":["res"],"application/x-dvi":["dvi"],"application/x-envoy":["evy"],"application/x-eva":["eva"],"application/x-font-bdf":["bdf"],"application/x-font-ghostscript":["gsf"],"application/x-font-linux-psf":["psf"],"application/x-font-pcf":["pcf"],"application/x-font-snf":["snf"],"application/x-font-type1":["pfa","pfb","pfm","afm"],"application/x-freearc":["arc"],"application/x-futuresplash":["spl"],"application/x-gca-compressed":["gca"],"application/x-glulx":["ulx"],"application/x-gnumeric":["gnumeric"],"application/x-gramps-xml":["gramps"],"application/x-gtar":["gtar"],"application/x-hdf":["hdf"],"application/x-httpd-php":["php"],"application/x-install-instructions":["install"],"application/x-iso9660-image":["*iso"],"application/x-iwork-keynote-sffkey":["*key"],"application/x-iwork-numbers-sffnumbers":["*numbers"],"application/x-iwork-pages-sffpages":["*pages"],"application/x-java-archive-diff":["jardiff"],"application/x-java-jnlp-file":["jnlp"],"application/x-keepass2":["kdbx"],"application/x-latex":["latex"],"application/x-lua-bytecode":["luac"],"application/x-lzh-compressed":["lzh","lha"],"application/x-makeself":["run"],"application/x-mie":["mie"],"application/x-mobipocket-ebook":["prc","mobi"],"application/x-ms-application":["application"],"application/x-ms-shortcut":["lnk"],"application/x-ms-wmd":["wmd"],"application/x-ms-wmz":["wmz"],"application/x-ms-xbap":["xbap"],"application/x-msaccess":["mdb"],"application/x-msbinder":["obd"],"application/x-mscardfile":["crd"],"application/x-msclip":["clp"],"application/x-msdos-program":["*exe"],"application/x-msdownload":["*exe","*dll","com","bat","*msi"],"application/x-msmediaview":["mvb","m13","m14"],"application/x-msmetafile":["*wmf","*wmz","*emf","emz"],"application/x-msmoney":["mny"],"application/x-mspublisher":["pub"],"application/x-msschedule":["scd"],"application/x-msterminal":["trm"],"application/x-mswrite":["wri"],"application/x-netcdf":["nc","cdf"],"application/x-ns-proxy-autoconfig":["pac"],"application/x-nzb":["nzb"],"application/x-perl":["pl","pm"],"application/x-pilot":["*prc","*pdb"],"application/x-pkcs12":["p12","pfx"],"application/x-pkcs7-certificates":["p7b","spc"],"application/x-pkcs7-certreqresp":["p7r"],"application/x-rar-compressed":["*rar"],"application/x-redhat-package-manager":["rpm"],"application/x-research-info-systems":["ris"],"application/x-sea":["sea"],"application/x-sh":["sh"],"application/x-shar":["shar"],"application/x-shockwave-flash":["swf"],"application/x-silverlight-app":["xap"],"application/x-sql":["sql"],"application/x-stuffit":["sit"],"application/x-stuffitx":["sitx"],"application/x-subrip":["srt"],"application/x-sv4cpio":["sv4cpio"],"application/x-sv4crc":["sv4crc"],"application/x-t3vm-image":["t3"],"application/x-tads":["gam"],"application/x-tar":["tar"],"application/x-tcl":["tcl","tk"],"application/x-tex":["tex"],"application/x-tex-tfm":["tfm"],"application/x-texinfo":["texinfo","texi"],"application/x-tgif":["*obj"],"application/x-ustar":["ustar"],"application/x-virtualbox-hdd":["hdd"],"application/x-virtualbox-ova":["ova"],"application/x-virtualbox-ovf":["ovf"],"application/x-virtualbox-vbox":["vbox"],"application/x-virtualbox-vbox-extpack":["vbox-extpack"],"application/x-virtualbox-vdi":["vdi"],"application/x-virtualbox-vhd":["vhd"],"application/x-virtualbox-vmdk":["vmdk"],"application/x-wais-source":["src"],"application/x-web-app-manifest+json":["webapp"],"application/x-x509-ca-cert":["der","crt","pem"],"application/x-xfig":["fig"],"application/x-xliff+xml":["*xlf"],"application/x-xpinstall":["xpi"],"application/x-xz":["xz"],"application/x-zmachine":["z1","z2","z3","z4","z5","z6","z7","z8"],"audio/vnd.dece.audio":["uva","uvva"],"audio/vnd.digital-winds":["eol"],"audio/vnd.dra":["dra"],"audio/vnd.dts":["dts"],"audio/vnd.dts.hd":["dtshd"],"audio/vnd.lucent.voice":["lvp"],"audio/vnd.ms-playready.media.pya":["pya"],"audio/vnd.nuera.ecelp4800":["ecelp4800"],"audio/vnd.nuera.ecelp7470":["ecelp7470"],"audio/vnd.nuera.ecelp9600":["ecelp9600"],"audio/vnd.rip":["rip"],"audio/x-aac":["aac"],"audio/x-aiff":["aif","aiff","aifc"],"audio/x-caf":["caf"],"audio/x-flac":["flac"],"audio/x-m4a":["*m4a"],"audio/x-matroska":["mka"],"audio/x-mpegurl":["m3u"],"audio/x-ms-wax":["wax"],"audio/x-ms-wma":["wma"],"audio/x-pn-realaudio":["ram","ra"],"audio/x-pn-realaudio-plugin":["rmp"],"audio/x-realaudio":["*ra"],"audio/x-wav":["*wav"],"chemical/x-cdx":["cdx"],"chemical/x-cif":["cif"],"chemical/x-cmdf":["cmdf"],"chemical/x-cml":["cml"],"chemical/x-csml":["csml"],"chemical/x-xyz":["xyz"],"image/prs.btif":["btif"],"image/prs.pti":["pti"],"image/vnd.adobe.photoshop":["psd"],"image/vnd.airzip.accelerator.azv":["azv"],"image/vnd.dece.graphic":["uvi","uvvi","uvg","uvvg"],"image/vnd.djvu":["djvu","djv"],"image/vnd.dvb.subtitle":["*sub"],"image/vnd.dwg":["dwg"],"image/vnd.dxf":["dxf"],"image/vnd.fastbidsheet":["fbs"],"image/vnd.fpx":["fpx"],"image/vnd.fst":["fst"],"image/vnd.fujixerox.edmics-mmr":["mmr"],"image/vnd.fujixerox.edmics-rlc":["rlc"],"image/vnd.microsoft.icon":["ico"],"image/vnd.ms-dds":["dds"],"image/vnd.ms-modi":["mdi"],"image/vnd.ms-photo":["wdp"],"image/vnd.net-fpx":["npx"],"image/vnd.pco.b16":["b16"],"image/vnd.tencent.tap":["tap"],"image/vnd.valve.source.texture":["vtf"],"image/vnd.wap.wbmp":["wbmp"],"image/vnd.xiff":["xif"],"image/vnd.zbrush.pcx":["pcx"],"image/x-3ds":["3ds"],"image/x-cmu-raster":["ras"],"image/x-cmx":["cmx"],"image/x-freehand":["fh","fhc","fh4","fh5","fh7"],"image/x-icon":["*ico"],"image/x-jng":["jng"],"image/x-mrsid-image":["sid"],"image/x-ms-bmp":["*bmp"],"image/x-pcx":["*pcx"],"image/x-pict":["pic","pct"],"image/x-portable-anymap":["pnm"],"image/x-portable-bitmap":["pbm"],"image/x-portable-graymap":["pgm"],"image/x-portable-pixmap":["ppm"],"image/x-rgb":["rgb"],"image/x-tga":["tga"],"image/x-xbitmap":["xbm"],"image/x-xpixmap":["xpm"],"image/x-xwindowdump":["xwd"],"message/vnd.wfa.wsc":["wsc"],"model/vnd.collada+xml":["dae"],"model/vnd.dwf":["dwf"],"model/vnd.gdl":["gdl"],"model/vnd.gtw":["gtw"],"model/vnd.mts":["mts"],"model/vnd.opengex":["ogex"],"model/vnd.parasolid.transmit.binary":["x_b"],"model/vnd.parasolid.transmit.text":["x_t"],"model/vnd.sap.vds":["vds"],"model/vnd.usdz+zip":["usdz"],"model/vnd.valve.source.compiled-map":["bsp"],"model/vnd.vtu":["vtu"],"text/prs.lines.tag":["dsc"],"text/vnd.curl":["curl"],"text/vnd.curl.dcurl":["dcurl"],"text/vnd.curl.mcurl":["mcurl"],"text/vnd.curl.scurl":["scurl"],"text/vnd.dvb.subtitle":["sub"],"text/vnd.fly":["fly"],"text/vnd.fmi.flexstor":["flx"],"text/vnd.graphviz":["gv"],"text/vnd.in3d.3dml":["3dml"],"text/vnd.in3d.spot":["spot"],"text/vnd.sun.j2me.app-descriptor":["jad"],"text/vnd.wap.wml":["wml"],"text/vnd.wap.wmlscript":["wmls"],"text/x-asm":["s","asm"],"text/x-c":["c","cc","cxx","cpp","h","hh","dic"],"text/x-component":["htc"],"text/x-fortran":["f","for","f77","f90"],"text/x-handlebars-template":["hbs"],"text/x-java-source":["java"],"text/x-lua":["lua"],"text/x-markdown":["mkd"],"text/x-nfo":["nfo"],"text/x-opml":["opml"],"text/x-org":["*org"],"text/x-pascal":["p","pas"],"text/x-processing":["pde"],"text/x-sass":["sass"],"text/x-scss":["scss"],"text/x-setext":["etx"],"text/x-sfv":["sfv"],"text/x-suse-ymp":["ymp"],"text/x-uuencode":["uu"],"text/x-vcalendar":["vcs"],"text/x-vcard":["vcf"],"video/vnd.dece.hd":["uvh","uvvh"],"video/vnd.dece.mobile":["uvm","uvvm"],"video/vnd.dece.pd":["uvp","uvvp"],"video/vnd.dece.sd":["uvs","uvvs"],"video/vnd.dece.video":["uvv","uvvv"],"video/vnd.dvb.file":["dvb"],"video/vnd.fvt":["fvt"],"video/vnd.mpegurl":["mxu","m4u"],"video/vnd.ms-playready.media.pyv":["pyv"],"video/vnd.uvvu.mp4":["uvu","uvvu"],"video/vnd.vivo":["viv"],"video/x-f4v":["f4v"],"video/x-fli":["fli"],"video/x-flv":["flv"],"video/x-m4v":["m4v"],"video/x-matroska":["mkv","mk3d","mks"],"video/x-mng":["mng"],"video/x-ms-asf":["asf","asx"],"video/x-ms-vob":["vob"],"video/x-ms-wm":["wm"],"video/x-ms-wmv":["wmv"],"video/x-ms-wmx":["wmx"],"video/x-ms-wvx":["wvx"],"video/x-msvideo":["avi"],"video/x-sgi-movie":["movie"],"video/x-smv":["smv"],"x-conference/x-cooltalk":["ice"]};

/***/ }),

/***/ "./node_modules/mime/types/standard.js":
/*!*********************************************!*\
  !*** ./node_modules/mime/types/standard.js ***!
  \*********************************************/
/***/ ((module) => {

module.exports = {"application/andrew-inset":["ez"],"application/applixware":["aw"],"application/atom+xml":["atom"],"application/atomcat+xml":["atomcat"],"application/atomdeleted+xml":["atomdeleted"],"application/atomsvc+xml":["atomsvc"],"application/atsc-dwd+xml":["dwd"],"application/atsc-held+xml":["held"],"application/atsc-rsat+xml":["rsat"],"application/bdoc":["bdoc"],"application/calendar+xml":["xcs"],"application/ccxml+xml":["ccxml"],"application/cdfx+xml":["cdfx"],"application/cdmi-capability":["cdmia"],"application/cdmi-container":["cdmic"],"application/cdmi-domain":["cdmid"],"application/cdmi-object":["cdmio"],"application/cdmi-queue":["cdmiq"],"application/cu-seeme":["cu"],"application/dash+xml":["mpd"],"application/davmount+xml":["davmount"],"application/docbook+xml":["dbk"],"application/dssc+der":["dssc"],"application/dssc+xml":["xdssc"],"application/ecmascript":["es","ecma"],"application/emma+xml":["emma"],"application/emotionml+xml":["emotionml"],"application/epub+zip":["epub"],"application/exi":["exi"],"application/express":["exp"],"application/fdt+xml":["fdt"],"application/font-tdpfr":["pfr"],"application/geo+json":["geojson"],"application/gml+xml":["gml"],"application/gpx+xml":["gpx"],"application/gxf":["gxf"],"application/gzip":["gz"],"application/hjson":["hjson"],"application/hyperstudio":["stk"],"application/inkml+xml":["ink","inkml"],"application/ipfix":["ipfix"],"application/its+xml":["its"],"application/java-archive":["jar","war","ear"],"application/java-serialized-object":["ser"],"application/java-vm":["class"],"application/javascript":["js","mjs"],"application/json":["json","map"],"application/json5":["json5"],"application/jsonml+json":["jsonml"],"application/ld+json":["jsonld"],"application/lgr+xml":["lgr"],"application/lost+xml":["lostxml"],"application/mac-binhex40":["hqx"],"application/mac-compactpro":["cpt"],"application/mads+xml":["mads"],"application/manifest+json":["webmanifest"],"application/marc":["mrc"],"application/marcxml+xml":["mrcx"],"application/mathematica":["ma","nb","mb"],"application/mathml+xml":["mathml"],"application/mbox":["mbox"],"application/mediaservercontrol+xml":["mscml"],"application/metalink+xml":["metalink"],"application/metalink4+xml":["meta4"],"application/mets+xml":["mets"],"application/mmt-aei+xml":["maei"],"application/mmt-usd+xml":["musd"],"application/mods+xml":["mods"],"application/mp21":["m21","mp21"],"application/mp4":["mp4s","m4p"],"application/msword":["doc","dot"],"application/mxf":["mxf"],"application/n-quads":["nq"],"application/n-triples":["nt"],"application/node":["cjs"],"application/octet-stream":["bin","dms","lrf","mar","so","dist","distz","pkg","bpk","dump","elc","deploy","exe","dll","deb","dmg","iso","img","msi","msp","msm","buffer"],"application/oda":["oda"],"application/oebps-package+xml":["opf"],"application/ogg":["ogx"],"application/omdoc+xml":["omdoc"],"application/onenote":["onetoc","onetoc2","onetmp","onepkg"],"application/oxps":["oxps"],"application/p2p-overlay+xml":["relo"],"application/patch-ops-error+xml":["xer"],"application/pdf":["pdf"],"application/pgp-encrypted":["pgp"],"application/pgp-signature":["asc","sig"],"application/pics-rules":["prf"],"application/pkcs10":["p10"],"application/pkcs7-mime":["p7m","p7c"],"application/pkcs7-signature":["p7s"],"application/pkcs8":["p8"],"application/pkix-attr-cert":["ac"],"application/pkix-cert":["cer"],"application/pkix-crl":["crl"],"application/pkix-pkipath":["pkipath"],"application/pkixcmp":["pki"],"application/pls+xml":["pls"],"application/postscript":["ai","eps","ps"],"application/provenance+xml":["provx"],"application/pskc+xml":["pskcxml"],"application/raml+yaml":["raml"],"application/rdf+xml":["rdf","owl"],"application/reginfo+xml":["rif"],"application/relax-ng-compact-syntax":["rnc"],"application/resource-lists+xml":["rl"],"application/resource-lists-diff+xml":["rld"],"application/rls-services+xml":["rs"],"application/route-apd+xml":["rapd"],"application/route-s-tsid+xml":["sls"],"application/route-usd+xml":["rusd"],"application/rpki-ghostbusters":["gbr"],"application/rpki-manifest":["mft"],"application/rpki-roa":["roa"],"application/rsd+xml":["rsd"],"application/rss+xml":["rss"],"application/rtf":["rtf"],"application/sbml+xml":["sbml"],"application/scvp-cv-request":["scq"],"application/scvp-cv-response":["scs"],"application/scvp-vp-request":["spq"],"application/scvp-vp-response":["spp"],"application/sdp":["sdp"],"application/senml+xml":["senmlx"],"application/sensml+xml":["sensmlx"],"application/set-payment-initiation":["setpay"],"application/set-registration-initiation":["setreg"],"application/shf+xml":["shf"],"application/sieve":["siv","sieve"],"application/smil+xml":["smi","smil"],"application/sparql-query":["rq"],"application/sparql-results+xml":["srx"],"application/srgs":["gram"],"application/srgs+xml":["grxml"],"application/sru+xml":["sru"],"application/ssdl+xml":["ssdl"],"application/ssml+xml":["ssml"],"application/swid+xml":["swidtag"],"application/tei+xml":["tei","teicorpus"],"application/thraud+xml":["tfi"],"application/timestamped-data":["tsd"],"application/toml":["toml"],"application/trig":["trig"],"application/ttml+xml":["ttml"],"application/ubjson":["ubj"],"application/urc-ressheet+xml":["rsheet"],"application/urc-targetdesc+xml":["td"],"application/voicexml+xml":["vxml"],"application/wasm":["wasm"],"application/widget":["wgt"],"application/winhlp":["hlp"],"application/wsdl+xml":["wsdl"],"application/wspolicy+xml":["wspolicy"],"application/xaml+xml":["xaml"],"application/xcap-att+xml":["xav"],"application/xcap-caps+xml":["xca"],"application/xcap-diff+xml":["xdf"],"application/xcap-el+xml":["xel"],"application/xcap-ns+xml":["xns"],"application/xenc+xml":["xenc"],"application/xhtml+xml":["xhtml","xht"],"application/xliff+xml":["xlf"],"application/xml":["xml","xsl","xsd","rng"],"application/xml-dtd":["dtd"],"application/xop+xml":["xop"],"application/xproc+xml":["xpl"],"application/xslt+xml":["*xsl","xslt"],"application/xspf+xml":["xspf"],"application/xv+xml":["mxml","xhvml","xvml","xvm"],"application/yang":["yang"],"application/yin+xml":["yin"],"application/zip":["zip"],"audio/3gpp":["*3gpp"],"audio/adpcm":["adp"],"audio/amr":["amr"],"audio/basic":["au","snd"],"audio/midi":["mid","midi","kar","rmi"],"audio/mobile-xmf":["mxmf"],"audio/mp3":["*mp3"],"audio/mp4":["m4a","mp4a"],"audio/mpeg":["mpga","mp2","mp2a","mp3","m2a","m3a"],"audio/ogg":["oga","ogg","spx","opus"],"audio/s3m":["s3m"],"audio/silk":["sil"],"audio/wav":["wav"],"audio/wave":["*wav"],"audio/webm":["weba"],"audio/xm":["xm"],"font/collection":["ttc"],"font/otf":["otf"],"font/ttf":["ttf"],"font/woff":["woff"],"font/woff2":["woff2"],"image/aces":["exr"],"image/apng":["apng"],"image/avif":["avif"],"image/bmp":["bmp"],"image/cgm":["cgm"],"image/dicom-rle":["drle"],"image/emf":["emf"],"image/fits":["fits"],"image/g3fax":["g3"],"image/gif":["gif"],"image/heic":["heic"],"image/heic-sequence":["heics"],"image/heif":["heif"],"image/heif-sequence":["heifs"],"image/hej2k":["hej2"],"image/hsj2":["hsj2"],"image/ief":["ief"],"image/jls":["jls"],"image/jp2":["jp2","jpg2"],"image/jpeg":["jpeg","jpg","jpe"],"image/jph":["jph"],"image/jphc":["jhc"],"image/jpm":["jpm"],"image/jpx":["jpx","jpf"],"image/jxr":["jxr"],"image/jxra":["jxra"],"image/jxrs":["jxrs"],"image/jxs":["jxs"],"image/jxsc":["jxsc"],"image/jxsi":["jxsi"],"image/jxss":["jxss"],"image/ktx":["ktx"],"image/ktx2":["ktx2"],"image/png":["png"],"image/sgi":["sgi"],"image/svg+xml":["svg","svgz"],"image/t38":["t38"],"image/tiff":["tif","tiff"],"image/tiff-fx":["tfx"],"image/webp":["webp"],"image/wmf":["wmf"],"message/disposition-notification":["disposition-notification"],"message/global":["u8msg"],"message/global-delivery-status":["u8dsn"],"message/global-disposition-notification":["u8mdn"],"message/global-headers":["u8hdr"],"message/rfc822":["eml","mime"],"model/3mf":["3mf"],"model/gltf+json":["gltf"],"model/gltf-binary":["glb"],"model/iges":["igs","iges"],"model/mesh":["msh","mesh","silo"],"model/mtl":["mtl"],"model/obj":["obj"],"model/step+xml":["stpx"],"model/step+zip":["stpz"],"model/step-xml+zip":["stpxz"],"model/stl":["stl"],"model/vrml":["wrl","vrml"],"model/x3d+binary":["*x3db","x3dbz"],"model/x3d+fastinfoset":["x3db"],"model/x3d+vrml":["*x3dv","x3dvz"],"model/x3d+xml":["x3d","x3dz"],"model/x3d-vrml":["x3dv"],"text/cache-manifest":["appcache","manifest"],"text/calendar":["ics","ifb"],"text/coffeescript":["coffee","litcoffee"],"text/css":["css"],"text/csv":["csv"],"text/html":["html","htm","shtml"],"text/jade":["jade"],"text/jsx":["jsx"],"text/less":["less"],"text/markdown":["markdown","md"],"text/mathml":["mml"],"text/mdx":["mdx"],"text/n3":["n3"],"text/plain":["txt","text","conf","def","list","log","in","ini"],"text/richtext":["rtx"],"text/rtf":["*rtf"],"text/sgml":["sgml","sgm"],"text/shex":["shex"],"text/slim":["slim","slm"],"text/spdx":["spdx"],"text/stylus":["stylus","styl"],"text/tab-separated-values":["tsv"],"text/troff":["t","tr","roff","man","me","ms"],"text/turtle":["ttl"],"text/uri-list":["uri","uris","urls"],"text/vcard":["vcard"],"text/vtt":["vtt"],"text/xml":["*xml"],"text/yaml":["yaml","yml"],"video/3gpp":["3gp","3gpp"],"video/3gpp2":["3g2"],"video/h261":["h261"],"video/h263":["h263"],"video/h264":["h264"],"video/iso.segment":["m4s"],"video/jpeg":["jpgv"],"video/jpm":["*jpm","jpgm"],"video/mj2":["mj2","mjp2"],"video/mp2t":["ts"],"video/mp4":["mp4","mp4v","mpg4"],"video/mpeg":["mpeg","mpg","mpe","m1v","m2v"],"video/ogg":["ogv"],"video/quicktime":["qt","mov"],"video/webm":["webm"]};

/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_jupyterlite_contents_lib_index_js.4f8c5efe8f97d253068f.js.map